/***************************************************************************
                          dcclient.h  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCLIENT_H
#define DCCLIENT_H

/**
  *@author Mathias Kster
  */

#include <qtimer.h>
#include <qworkspace.h>
#include <qlistview.h>
#include <qstringlist.h>

#include <DCDialogClient.h>

#include <dclib/dcobject.h>
#include <dclib/cclient.h>
#include <dclib/core/cstringlist.h>
#include <dclib/cmessagehandler.h>

#include <dctransferview.h>
#include <dcwidget.h>
#include <dcconfig.h>
#include <DCDialogOptions.h>

/** */
class DCUserItem : public CObject {
public:
	/** construtor */
	DCUserItem() {};
	/** destructor */
	virtual ~DCUserItem() {};

	/** */
	DC_UserListItem * pItem;
	/** */
	CMessageMyInfo MyInfo;
};

class DCChat;
class QListViewItem;
class QListBoxItem;

class DCClient : public DCDialogClient, public CClient {
Q_OBJECT

public:
	/** construtor */
	DCClient(QWidget* parent, const char *name, int wflags);
	/** destructor */
	virtual ~DCClient();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** chat */
	void DC_Chat( CMessageChat * MessageChat );
	/** myinfo */
	void DC_MyInfo( CMessageMyInfo * MessageMyInfo );
	/** nicklist */
	void DC_NickList( CMessageNickList * MessageNickList );
	/** oplist */
	void DC_OpList( CMessageNickList * MessageOpList );
	/** hello */
	void DC_Hello( CMessageHello * MessageHello );
	/** quit */        	
	void DC_Quit( CMessageQuit * MessageQuit );
	/** */
	void DC_PrivateChat( CMessagePrivateChat * msg, bool bLocal = FALSE );
	/** */
	void DC_PrivateChat( QString nick, QString fromnick, QString message, bool bLocal = FALSE );

	/** */
	static bool GetOPKickMessage( QString & message );
	/** */
	static bool GetOPForceMoveMessage( QString & message, QString & host );

	/** */
	bool OPKick( QString nick, QString message );
	/** */
	bool OPForceMove( QString nick, QString message, QString host );

	/** */
	void SetNickColor( QString nick, QColor color );
	/** */
	void UpdateStatusBar();

	/** */
	void CloseChat( DCChat * chat );
	/** */
	void CloseAllChats();

	/** callback function */
	virtual int DC_CallBack( CObject * Object );
	/** overridden so that the columns are resized on show() */
	virtual void show();

	/** */
	QString findNick( QString part, uint which );

private:
	/** */
	int selectedItems( QListView * list, CList<CString> * lst );
	/** */
	void addCompleteNick( QString nick );
	/** */
	void removeCompleteNick( QString nick );
	/** */
	void UpdateCaption();
	/** */
	void SetCrypt( bool b );
	/** */
	void UpdateClientColumn( bool enabled, int index, int width );
	
	/** the private chat widgets */
	CStringList * m_pChatList;
	/** */
	CMessageChat m_ChatFloodMessage;
	/** */
	long m_nChatFloodCounter;
	/** */
	bool m_bUserPassword;
	/** the hubchat widget */
	DCChat * m_pHubChat;
	/** */
	bool m_bUseTabWidget;

protected:
	/** */
	QWorkspace * m_pWorkspace;
	/** */
	CThread m_Thread;
	/** */
	QTimer m_Timer;
	/** */
	CList<CObject> * m_pMessageList;
	/** */
	CStringList * m_pUserViewList;
	/** */
	QStringList m_completeNicks;

	/** resize the ListView columns */
	void ResizeListViewColumn();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	// virtual void closeEvent( QCloseEvent * ) {};
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );

private slots:
	/** */
	void timerDone();
	/** */
	void slotDoubleClickedUserList( QListViewItem * item );
	/** */
	void slotDoubleClickedChatUserList( QListViewItem * item );
	/** */
	void slotRightButtonClickedUserList( QListViewItem *, const QPoint &, int );
	/** */
	void slotDoubleClickedUserChat( QListBoxItem * item );
	/** */
	void slotHubConnect();
	/** */
	void slotSSLInfo();
	/** current tab widget change slot */
	void slotTabWidgetChatCurrentChange(QWidget*);
};

#endif
