/*************************************************************************
 *
 * $Id: trio.h,v 1.1.1.1 2000/11/13 02:42:50 holsta dancer.c $
 *
 * Copyright (C) 1998 Bjorn Reese and Daniel Stenberg.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE AUTHORS AND
 * CONTRIBUTORS ACCEPT NO RESPONSIBILITY IN ANY CONCEIVABLE MANNER.
 *
 ************************************************************************/

#ifndef H_TRIO
#define H_TRIO

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

/*
 * Error codes.
 *
 * Remember to add a textual description to trio_strerror.
 */
enum {
  TRIO_EOF = 1,
  TRIO_EINVAL = 2,
  TRIO_ETOOMANY = 3,
  TRIO_EDBLREF = 4,
  TRIO_EGAP = 5,
};

/* Error macros */
#define TRIO_ERROR_CODE(x) ((-(x)) & 0x00FF)
#define TRIO_ERROR_POSITION(x) ((-(x)) >> 8)
#define TRIO_ERROR_NAME(x) trio_strerror(x)

/*
 * trio_sprintf(target, format, ...)
 * trio_snprintf(target, maxsize, format, ...)
 *
 *   Build 'target' according to 'format' and succesive
 *   arguments. This is equal to the sprintf() and
 *   snprintf() functions.
 */

int trio_printf(const char *format, ...);
int trio_vprintf(const char *format, va_list args);
int trio_fprintf(FILE *fd, const char *format, ...);
int trio_vfprintf(FILE *fd, const char *format, va_list args);
int trio_sprintf(char *buffer, const char *format, ...);
int trio_snprintf(char *buffer, size_t max, const char *format, ...);
int trio_snprintfcat(char *buffer, size_t max, const char *format, ...);
int trio_vsprintf(char *buffer, const char *format, va_list args);
int trio_vsnprintf(char *buffer, size_t bufferSize, const char *format,
		   va_list args);
char *trio_aprintf(const char *format, ...);
char *trio_vaprintf(const char *format, va_list args);

int trio_sscanf(char *buffer, const char *format, ...);

const char *trio_strerror(int);


/* Replace the <stdio.h> functions */
#define printf trio_printf
#define vprintf trio_vprintf
#define fprintf trio_fprintf
#define vfprintf trio_vfprintf
#define sprintf trio_sprintf
#define snprintf trio_snprintf
#define vsprintf trio_vsprintf
#define vsnprintf trio_vsnprintf

/* There aren't stdio functions, but we make them look similar */
#define aprintf trio_aprintf
#define vaprintf trio_vaprintf

/* strio compatible names */
#define StrScan sscanf /* FIXME: must be trio_sscanf */
#define StrFormat trio_sprintf
#define StrFormatMax trio_snprintf
#define StrFormatAlloc trio_aprintf
#define StrFormatAppendMax trio_snprintfcat

#endif /* H_TRIO */
