/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/transfer.h,v $
 * $Revision: 1.2 $
 * $Date: 2002/07/30 16:21:59 $
 * $Author: elho $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef TRANSFER_H
#define TRANSFER_H

#include "dancer.h"
#include "user.h"

/* See logtypes in code */
enum {
  LOG = 0,
  LOGJOIN, LOGPART, LOGQUIT,
  LOGNICK, LOGMODE, LOGKICK,
  LOGCMD, LOGPCMD, LOGMSG,
  LOGCTCP, LOGCLIENT, LOGWARN,
  LOGSPLIT, LOGNJOIN, LOGNHEAL,
  LOGDEBUG, LOGDBUG,
  LOGINIT, LOGPUB,
  LOGKILL, LOGTOPIC,
  LOGNONE /* Must be the last one */
};

#define LOGALLMASK ((1<<LOGNONE)-1)

typedef struct Execstruct {
  struct Header h;
  itemclient *client;  /* non-NULL if dcc chat */
  char *nick;  /* Use nick if no dcc chat (or it has been removed) */
  pid_t pid;
  int socket;
  FILE *pipe;
  bool notify; /* we'd like a file transfer (client) for this nick to get
                  notified when this execution is done */
} itemexec;


itemexec *Execute(char *, char *, char *, char *, ...);
void FreeExec(void *);
void GotExec(itemexec *);
void Send(char *, char *);
void Sendf(char *, const char *, ...);
void SendMulti(char *, const char *, ...);
inline void SendNick(char *, char *);
void SendNickf(char *, const char *, ...);
void SendCtcp(char *, char *);
void SendCtcpf(char *, const char *, ...);
void ReplyCtcp(char *, char *);
void ReplyCtcpf(char *, const char *, ...);
void MulticastLocal(int, char *);
void MulticastLocalf(int, const char *, ...);
void Multicast(int, char *);
void Multicastf(int, const char *, ...);
void Wall(char *, char *);
void SnoopCommand(char *, char *, char *);
void MessageQueue(void);
void MessageReaper(char *);
void FreeMessage(void *);
void FlushMessages(void);
void Action(char *);
void Actionf(const char *, ...);
void Mode(const char *, ...);
void Kick(char *, char *);
void StickyKick(itemguest *, char *msg);
void Log(int, char *);
void Logf(int, const char *, ...);
void LogInit(void);
void LogSnapshots(void);
void Quit(char *, char *);
void Invite(char *who);
void Debug(const char *, ...);
void Say(char *);

#endif /* TRANSFER_H */
