/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/setup.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:49 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef SETUP_H
#define SETUP_H

struct Config {
  char *label;
  void *value;   /* pointer to the real storage */
  void *def;     /* default value */
  char flags;    /* specifies the kind of config setting, see defines below */
  char setting;  /* value will be saved in setfile */
  char *verbose; /* detailed description of the label */
  bool changed;  /* read from .config or .set file */
};

#define CFG_SWITCH   0 /* TRUE / FALSE */
#define CFG_INTEGER  1 /* 0 - 2G */
#define CFG_STRING   2 /* regular string, pointing to a static string area */
#define CFG_LIST     3 /* comma seperated list, uses itemlist */
#define CFG_FUNCTION 4 /* function */
#define CFG_COMMENT  5 /* Simply prints a comment to config file */

#define BTRUE  (void *)1
#define BFALSE (void *)0


bool ConfigInit(void);
void ConfigCleanup(void);

/******************************************************************************
 * The following piece of source is the new SET functions.
 *****************************************************************************/

struct SetItem {
  char *name;
  long level;   /* if non-zero, different level required to access than for
		   rest of group */
  long flags;   /* see below */
  void *value;  /* pointer to the variable holding the info */
  long ID;      /* for special ones */
  char **help;  /* for localized strings, describe item */
};

#define SET_ONOFF  1 /* just a toggle switch */
#define SET_NUM    2 /* integer */
#define SET_TIME   3 /* contains a time integer */
#define SET_SPEC   4 /* treat special */
#define SET_STRING 5 /* new in 4.7 */

struct SetGroup {
  char *name; /* name of group */
  long level; /* level required to access (if different than 'SET') */
  struct SetItem *group;
  char **help; /* description of the group */
};


int SetSet(char *from, char *line);
int HelpSet(char *from, char *token);
void ShowSetAll(char *from);
void InitSets(void);
void MakeConfig(void);
void ChgCmdLev(char *, char *);

#endif /* SETUP_H */
