/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/server_gperf.c,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:48 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -apt -k 1-3 -N FindServerKey -H ServerHash server.gperf  */
struct Servercmds 
{
  char *name;
  void (*function)(char *a, char *b);
};

#define TOTAL_KEYWORDS 13
#define MIN_WORD_LENGTH 4
#define MAX_WORD_LENGTH 7
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 34
/* maximum key range = 31, duplicates = 0 */

static unsigned int
ServerHash (register const char *str, register int len)
{
  static unsigned char asso_values[] =
    {
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35,  4, 35, 15, 10,  0,
     35, 35, 35,  0,  5, 15, 35,  0,  0,  9,
      0,  5,  0, 35,  0,  0,  5, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
     35, 35, 35, 35, 35, 35, 35, 35,
    };
  return len + asso_values[str[2]] + asso_values[str[1]] + asso_values[str[0]];
}

struct Servercmds *
FindServerKey (register const char *str, register int len)
{
  static struct Servercmds wordlist[] =
    {
      {"",}, {"",}, {"",}, {"",}, 
      {"PING",  OnPing},
      {"ERROR",  OnError},
      {"",}, 
      {"PRIVMSG",  OnPrivmsg},
      {"PART",  OnPart},
      {"QUIT",  OnQuit},
      {"",}, 
      {"INVITE",  OnInvite},
      {"",}, 
      {"PONG",  OnPong},
      {"TOPIC",  OnTopic},
      {"NOTICE",  OnNotice},
      {"",}, {"",}, 
      {"JOIN",  OnJoin},
      {"NICK",  OnNick},
      {"",}, {"",}, {"",}, 
      {"MODE",  OnMode},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, 
      {"KICK",  OnKick},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = ServerHash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}

