#ifndef IBCP_H
#define IBCP_H

#define MTUSIZE 576 /* Maximum Transmission Unit */

/*
  Realm of breese - enter at own risk.

  Two level protocol.

  Level 1: ack, ping/pong, negotiation, sync time
           (SOCK_RDM++, RDP (RFC 908 + 1151))
	   Has its own stack, timer, etc.
	   rdm_recv(), rdm_send(), rdm_update()

	   BYTE type
	   SHORT size
	   SHORT ack-window

  Level 2: multicast, data exchange, etc.
           (IBCP)
	   while (rdm_read() ok) parse();
 */

enum {
  IBCP_LOW_ACK         = 1,
  IBCP_LOW_PAYLOAD     = 2,
  IBCP_LOW_SYN         = 3,
  IBCP_LOW_PING        = 4,
  IBCP_LOW_PONG        = 5,

  /* Protocol version */
  IBCP_VERSION = 1,
  /* Bot types */
  IBCP_BOT_DANCER = 1,

  /* Message types */
  IBCP_ACK             =  0, /* Acknowledge message */
  IBCP_ERROR           =  1, /* Error occured */
  IBCP_HELLO           =  2, /* Introduction */
  IBCP_HELLO_REPLY     =  3,
  IBCP_QUIT            =  4, /* I quit */
  IBCP_ACCEPT          =  5, /* Accept a link */
  IBCP_REJECT          =  6, /* Reject a link */
  IBCP_SYNC            =  7, /* Synchronize common time */
  IBCP_PING            = 10, /* Are you there? */
  IBCP_PONG            = 11, /* Yes I am */
  IBCP_TIME            = 12,
  IBCP_WILL        = 251,
  IBCP_WONT        = 252,
  IBCP_DO          = 253,
  IBCP_DONT        = 254,
  IBCP_END         = 255,


  IBCP_NICKNAME        = 20, /* New nickname */
  IBCP_MULTICAST       = 21, /* Multicasting messages */
  IBCP_REMOTE_CMD      = 22,
  IBCP_REMOTE_ANSWER   = 23,
  /* Authentication of link (list of existing links) */
  IBCP_AUTH            = 30,
  IBCP_AUTH_LIST       = 31,
  IBCP_AUTH_END        = 32,
  /* Sharing userlist */
  IBCP_USERS_REQUEST   = 40,
  IBCP_USERS_UPDATE    = 41,
  IBCP_USERS_LIST      = 42,
  IBCP_USERS_END       = 43,
  /* User interaction */
  IBCP_REMOTE_JOIN     = 402,
  IBCP_REMOTE_LEAVE    = 403,
  IBCP_REMOTE_PRIVMSG  = 404,
  /* Coordination */
  IBCP_COORD_ACTION    = 500,
  IBCP_COORD_INTENTION = 501,
  IBCP_COORD_OBJECTION = 502,
  IBCP_COORD_COOPERATE = 503,
  IBCP_COORD_BACKUP    = 504,


  /* Negotiation options */
  IBCP_NEGOTIATE_ENCRYPT = 10,
  IBCP_ENCRYPT_NONE      = 0,
  IBCP_ENCRYPT_DES       = 1,
  IBCP_ENCRYPT_BLOWFLY   = 2,

  /* Errors */
  IBCP_ERROR_NO_PRIVILEGES  = 1,
  IBCP_ERROR_ILLEGAL_TARGET = 2,
  IBCP_ERROR_ILLEGAL_ID     = 3,
};

#endif /* IBCP_H */
