/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/fplrun.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:42 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef FPLRUN_H
#define FPLRUN_H

#ifndef HAVE_LIBFPL
#define runfpl(x,y,z)
#define fTimerCheck()
#else

#include "list.h"
#include "command.h"

#define BIGONE 1024
#define MAX_ARGS 64 /* maximum amount of %-codes in one line */

typedef struct fplstruct {
  struct Header h;
  char *prog;
  char *regex;
  long flags;
} itemfpl;

typedef enum {
  RUN_INIT,
  RUN_PUBLIC,
  RUN_MSG,
  RUN_OFFMSG, /* received from out of channel */
  RUN_DCC,
  RUN_ACTION,
  RUN_INPUT,
  RUN_CTCPPUB,
  RUN_CTCPPRIV,
  RUN_TOPIC,
  RUN_KICK,
  RUN_KICKBOT,
  RUN_MODE,
  RUN_JOIN,
  RUN_QUIT,
  RUN_LEAVE,
  RUN_NICK,
  RUN_INVITE,
  RUN_NUMERIC,

  RUN_SEND_ACTION,
  RUN_SEND_DCC_CHAT,
  RUN_SEND_MSG,
  RUN_SEND_NOTICE,
  RUN_SEND_PUBLIC,

  RUN_CONNECT,
  RUN_DISCONNECT,
  RUN_ERROR,

  RUN_ALERTMODE,
  RUN_ALERT,
  RUN_FLOOD,
  
  RUN_NETHACK,
  RUN_NETSPLIT,
  RUN_NETHEAD,
  RUN_NETLEAVE,
  RUN_NETJOIN,
  
  RUN_LAST /* LAST ITEM IN LIST */
} runitem;

typedef enum {
  FPR_NOTHING,
  FPR_ACTION,
  FPR_BAN,
  FPR_BANINFO,
  FPR_BOTINFO,
  FPR_CHANINFO,
  FPR_CMDADD,
  FPR_CTIME,
  FPR_DO,
  FPR_GETUSER,
  FPR_HOOK,
  FPR_JOIN,
  FPR_KICK,
  FPR_LABDEFINE,
  FPR_LABREAD,
  FPR_LABSET,
  FPR_LEAVE,
  FPR_MATCH,
  FPR_OUTPUT,
  FPR_REGEX,
  FPR_RANDOM,
  FPR_RUNFILE,
  FPR_SAY,
  FPR_SEND,
  FPR_TOPIC,
  FPR_UNBAN,
  FPR_USERINFO,
  FPR_WARNADD,
  FPR_WARNINFO,

  FPR_CANCEL,
  FPR_TIMERADD,
  FPR_TIMERKILL,

  FPR_TIME2SECS,

  FPR_MODE,
  
  FPR_LASTONE/* LAST ITEM IN LIST */
} fplfunction;

#define FPLRUN_PRE 0
#define FPLRUN_POST 1

typedef struct fpladdcmd {
  struct Header h;
  struct Command command;
  char *fpl;
  char *help;
} itemfplcmd;

typedef struct fpladdtime {
  struct Header h;
  char *fpl;
  int timeout;
} itemtimefpl;

typedef struct fpllabel {
  struct Header h;
  char *name;
  int flags; /* see below */
  union { /* default value/string */
    char *str;
    int val;
  } def;
} itemlabel;

typedef struct fpluserlabel {
  struct Header h;
  itemlabel *label;
  char *name; /* used when setting a label before it is defined */
  union { /* contents value/string */
    char *str;
    int val;
  } cont;
} itemuserlabel;

#define LAB_DEFINED (1<<0) /* actually defined an valid */
#define LAB_SAVE    (1<<1) /* save in user-data */
#define LAB_SOLO    (1<<2) /* not user attached */
#define LAB_STRING  (1<<3) /* if not, it is an integer */

bool runfpl(runitem item, char *line, char which);
int fplrunner(char *fpl, char *input);
void FPLInit(void);
void FPLCleanup(void);
itemfplcmd *fCmdFind(char *name);

int fTimerCheck(void);
void UserlabelSet(char *name, void *set, int flags, itemuserlabel **ulabel);
void FreeUserlabel(void *);

#endif /* HAVE_LIBFPL */
#endif /* FPLRUN_H */
