/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/debugmem.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:41 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef DEBUGMEM_H
#define DEBUGMEM_H

/* Prototype the memory functions: */
void 	DBG_free		( void *, char *, int );
void *	DBG_malloc		( int, char *, int );
void *	DBG_realloc		( void *, int, char *, int );
void *	DBG_calloc		( int, int, char *, int );
void 	DBG_MemList		( );
int 	DBG_UsedMem	    ( );
long 	DBG__CheckMem	( void *, char *, int );
char *  DBG_Strdup      (char *, char *, int);
int     DBG_NewFunc     ( );
void    DBG_Verbose     ( char );

/* This function checks a memory block allocated using
   the DBG_malloc() for overwritten cookies.
   Returns TRUE if any error was found.
   NOTE: any failure in this check will invoke the same
   actions as if a regular DBG_free() failed. */
#define DBG_CheckMem(mem) DBG__CheckMem(mem, __FILE__, __LINE__)

/* replace malloc() with the new routine */
#define malloc(x) DBG_malloc(x, __FILE__, __LINE__)

/* replace calloc() with the new routine */
#define calloc(x, y) DBG_calloc(x, y, __FILE__, __LINE__)

/* replace realloc() with the new routine */
#define realloc(p, x) DBG_realloc(p, x, __FILE__, __LINE__)

/* replace free() with the new routine */
#define free(x) DBG_free(x, __FILE__, __LINE__)

/* replace strdup() with the new routine */
#define strdup(x) DBG_Strdup(x, __FILE__, __LINE__)

/* store source code information on malloc */
#define SOURCE_INFO

/* number of bytes to allocate before every block */
#define PRE_COOKIE_SIZE 8

/* number of bytes to allocate after every block */
#define POST_COOKIE_SIZE 8

/* byte to fill pre cookie with */
#define PRE_COOKIE_FILL_BYTE 0xbb

/* byte to fill post cookie with */
#define POST_COOKIE_FILL_BYTE 0xdd

/* Actions to perform when any error has been discovered in the
   cookies. The parameters to these macros are:
   
   Number_I   - Number of overwritten bytes
   FSource_PC - Source file of the free()
   FLine_I    - Line number of the free()
   MSource_PC - Source file of the malloc()
   MLine_I    - Line number of the malloc()
   */

#define PRE_COOKIE_ACTION(Number_I, FSource_PC, FLine_I, MSource_PC, MLine_I) \
	Logf("DEBUG", "PRE COOKIE %d bytes (free: %s/%d malloc: %s/%d)!",\
		   Number_I, FSource_PC, FLine_I, MSource_PC, MLine_I)

#define POST_COOKIE_ACTION(Number_I, FSource_PC, FLine_I, MSource_PC, MLine_I)\
	Logf("DEBUG", "POST COOKIE %d bytes (free: %s/%d malloc: %s/%d)!",\
		   Number_I, FSource_PC, FLine_I, MSource_PC, MLine_I)

#define MALLOCED(size,source,lyne)\
	Logf("DEBUG", ">>> allocated %d bytes in %s line %d\n",\
        size, source, lyne)

#define FREED(size,source,lyne)\
	Logf("DEBUG", "<<< freed %d bytes in %s line %d\n", size, source, lyne)

#define CHECKMEMED(size,source,lyne)\
	Logf("DEBUG", "### checked %d bytes in %s line %d\n",\
        size, source, lyne)

#define FREE_2ND(source,lyne)\
        Logf("DEBUG", "FREED MEMORY TWICE at %s %d\n", source, lyne)

#endif /* DEBUGMEM_H */
