/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/dancer.h,v $
 * $Revision: 1.2 $
 * $Date: 2001/06/10 23:05:09 $
 * $Author: holsta $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef DANCER_H
#define DANCER_H

#ifdef HAVE_CONFIG_H
# include "config.h"
#else
# error Not properly configured
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <sys/types.h>
#include <ctype.h>

#include "language.h"
#include "servfunc.h"
#include "version.h"

/* ---------------------------------------------------------------- */

/* Max length of nicknames. Some IRC networks (like Dalnet) use
   wider nicknames. Change here if you run on one of those nets */
#define NICKLEN 9
#define NICKLENTXT "9" /*QUOTE(NICKLEN)*/

#define USERLEN 10
#define USERLENTXT "10"

/* Background processes should be nice'd. See 'man 1 nice' for further
   info */
#define NICE 5

/* Number of seconds between pinging the server. Don't make this too
   small */
#define PINGDELAY 30


/* ---------------------------------------------------------------- */
/* - - - - - - - - No need to change anything below!  - - - - - - - */

/* This defines the current version of the bot */
#define VERSIONMSG "Dancer V" VERSION
#define CTCPVERSION VERSIONMSG

/* Default IRC port (not necessary to change as you can specify
   port number in server list) */
#define IRCPORT "6667"

/* HASHSIZE should be a prime far from 2^n */
#define HASHSIZE 701

/* Every X second (select timeout). TimeEvents() */
#define TIMER 2

/* Each TIMER * TIMERCHK second. SloppyEvents() */
#define TIMERCHK 4

/* Timer stuff */
#define MILLION 1000000L
#define RTIMER (TIMER * MILLION) /* select timeout in usecs */

/* Buffers */
#define MAXLINE 512
#define MINIBUFFER 128
#define MINIBUFFERTXT "127"
#define MIDBUFFER 256
#define MIDBUFFERTXT "255"
#define BIGBUFFER 512
#define BIGBUFFERTXT "511"
#define KILOBUFFER 1024
#define KILOBUFFERTXT "1023"

/* This kind of buffer is ideal for scanned text from an IRC line, that is
   later presented back on IRC (with some extra blurb around). */
#define SEMIBUFFER 472
#define SEMIBUFFERTXT "471"

/* This buffer should be only used when creating a string where
   strings of BIGBUFFER size may be part of it */
#define BIGGERBUFFER 768

#ifdef WANT_VALUES_FROM_THE_IRCD_SOURCE
/*
   dast 961205
   I stole some information from the ircd2.9.2/include/struct.h file
   to show some real-life default values for a few buffers: */

#define HOSTLEN         63      /* Length of hostname.  Updated to         */
                                /* comply with RFC1123                     */
 
#define NICKLEN         9       /* Necessary to put 9 here instead of 10
                                ** if s_msg.c/m_nick has been corrected.
                                ** This preserves compatibility with old
                                ** servers --msa
                                */
#define USERLEN         10
#define REALLEN         50
#define TOPICLEN        80
#define CHANNELLEN      50
#define PASSWDLEN       20
#define KEYLEN          23
#define BUFSIZE         512             /* WARNING: *DONT* CHANGE THIS!!!! */
#define MAXRECIPIENTS   20
#define MAXBANS         20
#define MAXBANLENGTH    1024
#define BANLEN          (USERLEN + NICKLEN + HOSTLEN + 3)

#endif /* WANT_VALUES_FROM_THE_IRCD_SOURCE */


/* Levels */
#define LEVELOWNER levels[LEVEL_OWNER]
#define LEVELBOT levels[LEVEL_BOT]
#define LEVELEXPERT levels[LEVEL_EXPERT]
#define LEVELTRUST levels[LEVEL_TRUST]
#define LEVELCHANOP levels[LEVEL_CHANOP]
#define LEVELRECOG levels[LEVEL_RECOG]
#define LEVELANYBODY levels[LEVEL_ANYBODY]

#define LEVEL_OWNER 6
#define LEVEL_BOT 5
#define LEVEL_EXPERT 4
#define LEVEL_TRUST 3
#define LEVEL_CHANOP 2
#define LEVEL_RECOG 1
#define LEVEL_ANYBODY 0

/* Thresholds */
#define LEVELPUB LEVELCHANOP     /* Level for public commands */
#define LEVELPUBX LEVELRECOG     /* Level for public commands if chanop */
#define FLOODLOWMID LEVELRECOG   /* Level that gets warnings */
#define FLOODMIDHIGH LEVELCHANOP /* Level that are allowed to misbehave */

/* Number of misbehaves before kicking a user with the right level */
#define WARNLOW 0       /*              -> FLOODLOWMID  */
#define WARNMID 3       /* FLOODLOWMID  -> FLOODMIDHIGH */

#define DEFPASSWDTXT "pass"

#define UNKNOWN  GetText(msg_unknown)   /*"<UNKNOWN>"  */
#define NOREASON GetText(msg_no_reason) /*"<No reason>"*/

/* Timings */
#define SECINMIN   60
#define SECINHOUR  (SECINMIN*60)
#define SECINDAY   (SECINHOUR*24)
#define SECINMONTH (SECINDAY*30) /* ~30 days in a month! ;) */

/* Timeout, then the server ain't considered split anymore but all
   users are counted as true QUITs */
#define SPLITTIMEOUT (30*SECINMIN)

/* Period after a netsplit where FLOOD is off, to prevent kicking
   people because of an sudden exchange of data between the servers.
   (Usually called a netburp) */
#define NETBURPTIME (3*SECINMIN)


/* ---------------------------------------------------------------- */

/* My ubiquitous #defines */
#undef NULL
#define NULL 0
#undef NIL
#define NIL ((char)0)
#undef FALSE
#define FALSE (1 == 0)
#undef TRUE
#define TRUE (1 == 1)

typedef int bool;

#if defined(hpux) || defined(__hpux)
typedef unsigned long ulong;
#endif

#define ULONG_BIT (CHAR_BIT * sizeof(ulong))

#if !defined(HAVE_SOCKLEN_T)
typedef unsigned int socklen_t;
#endif


/* ---------------------------------------------------------------- */

extern int errno;
#ifndef SYS_ERRLIST_DECLARED
extern int sys_nerr;
extern char *sys_errlist[];
#endif

/* "Borrowed" from the ircII client source */
#ifndef HAVE_STRERROR
# define strerror(e) ((e) < 0 || (e) >= sys_nerr ? "(unknown)" : sys_errlist[e])
#endif

#ifdef DEBUG
void MakeSnapshot(char *, int); /* This should've been in transfer.h */
#define snapshot MakeSnapshot(__FILE__, __LINE__)
#else
#define snapshot
#endif

#ifndef HAVE_ATOL
# ifdef HAVE_STRTOUL
#   define atol(x) (StrToUnsignedLong(x, (char **)NULL, 10))
# else
#   define atol(x) (StrToLong(x, (char **)NULL, 10))
# endif
#endif

#ifdef HAVE_STRTOUL
# define atoul(x) (StrToUnsignedLong(x, (char **)NULL, 10))
#else
# define atoul(x) atol(x)
#endif

#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif

#define iswhite(c) (isascii(c) && isspace(c))
#define isvalid(c) ((('A' <= (c)) && ('~' >= (c))) || \
                    (('0' <= (c)) && ('9' >= (c))) || \
                     ('-' == (c)))

/* ---------------------------------------------------------------- */

void TimeEvents(void);
void Hello(itemserv *);
void Cleanup(void);

#endif /* DANCER_H */
