/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/command.h,v $
 * $Revision: 1.2 $
 * $Date: 2001/03/13 05:04:47 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef COMMAND_H
#define COMMAND_H

#include "user.h"

struct Command {
  char *name;
  void (*function)(char *a, char *b);
  int level;
  bool showable;  /* Output can be redirected to another person */
  bool needpass;  /* Password protected */
  bool needcomma; /* Comma is part of argument, not argument seperator */
  bool aliases;   /* Aliases exist for this command */
  bool public;    /* Command can be used in public */
  bool hide;      /* Don't show the command line in the logfile or spylink */
  bool remote;    /* Can be executed by remote link */
  char *syntax;
  char **help;
  long flags;

  /* end of struct statically inited in command.c */

  long counter;
  long orglevel; /* Built-in level, never change, needed for internal use */
};

#define CMD_NONE 0 /* startup-flags */

#define CMD_CHANGED  (1<<0) /* command is changed */
#define CMD_IDENT    (1<<1) /* hide if IDENTPROTECT is enabled */
#define CMD_CONF     (1<<2) /* conference mode command */
#define CMD_CONFOPER ((1<<3)|CMD_CONF) /* CONFOPER command */
#define CMD_VICTIM   (1<<4) /* VICTIM command */

char *_crypt(char *key, char *salt);

void CommandInit(void);
struct Command *FindCommand(char *name);
bool Warning(itemguest *, char *, char *);
void UpperCheck(itemguest *, char *);
void FloodCheck(itemguest *);
bool NickToPattern(char *nick, char *buffer, bool siteban);

void Command(char *, char *, char *);
void DccCommand(char *);
void PubCommand(char *, char *, char *);

void CmdAlias(char *, char *);
void CmdBan(char *, char *);
void CmdBacklog(char *, char *);
void CmdBanlist(char *, char *);
void CmdBotop(char *, char *);
void CmdXop(char *, char *);
void CmdCalc(char *, char *);
void CmdChat(char *, char *);
void CmdChban(char *, char *);
void CmdChgCmdLev(char *, char *);
void CmdCkey(char *, char *);
void CmdClient(char *, char *);
void CmdClientlist(char *, char *);
void CmdCmd(char *, char *);
void CmdCmode(char *, char *);
void CmdComment(char *, char *);
void CmdConf(char *, char *);
void CmdConvert(char *, char *);
void CmdCountry(char *, char *);
void CmdCut(char *, char *);
void CmdDebugadd(char *, char *);
void CmdDebugdel(char *, char *);
void CmdDefPass(char *, char *);
void CmdDeVoice(char *, char *);
void CmdDo(char *, char *);
void CmdEmail(char *, char *);
void CmdExchange(char *, char *);
void CmdExpAdd(char *, char *);
void CmdExpDel(char *, char *);
void CmdExplain(char *, char *);
void CmdFileGet(char *, char *);
void CmdFind(char *, char *);
void CmdFinger(char *, char *);
void CmdHelp(char *, char *);
void CmdHost(char *, char *);
void CmdIdent(char *, char *);
void CmdIdentify(char *, char *);
void CmdInvite(char *, char *);
void CmdJoin(char *, char *);
void CmdKick(char *, char *);
void CmdKicklist(char *, char *);
void CmdLag(char *, char *);
void CmdLanguage(char *, char *);
void CmdLeave(char *, char *);
void CmdLink(char *, char *);
void CmdLinklist(char *, char *);
void CmdLog(char *, char *);
void CmdMe(char *, char *);
void CmdModerate(char *, char *);
void CmdMute(char *, char *);
void CmdNames(char *, char *);
void CmdNewPass(char *, char *);
void CmdNewsRead(char *, char *);
void CmdNewsDel(char *, char *);
void CmdNewsAdd(char *, char *);
void CmdNewsList(char *, char *);
void CmdNick(char *, char *);
void CmdNone(char *, char *);
void CmdOp(char *, char *);
void CmdPass(char *, char *);
void CmdQuiet(char *, char *);
void CmdQuit(char *, char *);
void CmdRegister(char *, char *);
void CmdReload(char *, char *);
void CmdRemote(char *, char *);
void CmdReportadd(char *, char *);
void CmdReportdel(char *, char *);
void CmdRules(char *, char *);
void CmdSay(char *, char *);
void CmdSay(char *, char *);
void CmdSeen(char *, char *);
void CmdServer(char *, char *);
void CmdServerAdd(char *, char *);
void CmdServerDel(char *, char *);
void CmdServerList(char *, char *);
void CmdServerStat(char *, char *);
void CmdSet(char *, char *);
void CmdSetEmail(char *, char *);
void CmdShutdown(char *, char *);
void CmdSpell(char *, char *);
void CmdSplit(char *, char *);
void CmdSpyadd(char *, char *);
void CmdSpyadd(char *, char *);
void CmdSpydel(char *, char *);
void CmdSpydel(char *, char *);
void CmdSpylist(char *, char *);
void CmdStatus(char *, char *);
void CmdSview(char *, char *);
void CmdSyntax(char *, char *);
void CmdTalk(char *, char *);
void CmdTelladd(char *, char *);
void CmdTelldel(char *, char *);
void CmdTelllist(char *, char *);
void CmdTellme(char *, char *);
void CmdTopic(char *, char *);
void CmdToplist(char *, char *);
void CmdTz(char *, char *);
void CmdUnban(char *, char *);
void CmdUptime(char *, char *);
void CmdUsed(char *, char *);
void CmdUserAdd(char *, char *);
void CmdUserDel(char *, char *);
void CmdUserMod(char *, char *);
void CmdUserlist(char *, char *);
void CmdVoice(char *, char *);
void CmdVrfy(char *, char *);
void CmdWall(char *, char *);
void CmdWarnadd(char *, char *);
void CmdWarndel(char *, char *);
void CmdWarnlist(char *, char *);
void CmdWebster(char *, char *);
void CmdWhois(char *, char *);
void CmdWholeft(char *, char *);

void DispComment(itemguest *g);

char *VarInfo(int arg);

#ifdef FUNCS_HACK
void CmdFuncAdd(char *, char *);
void CmdFuncDel(char *, char *);
void CmdFuncList(char *, char *);
#endif

#endif /* COMMAND_H */
