/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/bans.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:38 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef BANS_H
#define BANS_H

typedef struct KickStruct {
  struct Header h;
  char *pattern;    /* user account */
  char *nick;       /* last used nick name */
  char *kickmsg;    /* reason */
  long kicks;       /* counter of kicks within KICK_PERIOD */
  long botkicks;    /* kicks by the bot */
  long trustkicks;  /* kicks when trusted user */
  long totkicks;    /* total count of kicks */
  time_t lastkick;  /* time of last kick */
  char *kicker;     /* last kicker */
  bool norecurse;   /* to prevent recursion of the same pattern in
		       the AddKick() function */
} itemkick;

extern itemkick* kickHead;

void BanKick(char *nick, char *banthis, char *message, char *remove);
void BanTimeout(void);

int AddToBanList(int flags, char *who, char *nick, char *pattern,
                  int secs, char *reason);
bool ChangeInBanList(char *who, char *bannick, int newsecs,
                     char *pattern, char flag, char *reason);
bool UnBan(char *from, char *nick);
void Unbanned(char *from, char *pattern, bool bot);
void BanInit(void);
bool IsUnban(char *pattern);
bool IsBanListed(char *pattern);
bool IsBan(char *pattern);
char *IsMatchBan(char *checkthis, int *);
void BanDisable(void);
bool IllegalBan(char *);
void BanSave(void);
void BanCleanup(void);
bool UnbanLoprio(char *from);

bool AddKick(itemident *, char *, char *, int);
void FreeKick(void *v);
void KickAll(char *pattern, char *msg);
void KickInit(void);
void KickCleanup(void);
void KickList(char *, char *);
bool KickFromQueue(time_t *);
itemkick *KickMatch(char *pattern);

void WarnInit(void);
void WarnCleanup(void);
bool WarnAdd(char *, char *, char *, char *, char *, int);
void WarnSave(void);
bool WarnDel(char *, char *);
bool WarnList(char *, char *, int);
bool WarnCheck(char *, char *);
int CountWarns(int);

#define BANLIST_ALERTSIZE 18 /* warn in public when we have this many, or
                                more, bans in the list */
#define REFRESH_TIMEOUT (30*SECINMIN)
#define SERVERBANTIMEOUT 30 /* give 30 secs to complete server bans */
#define BAN_ENFTIMEOUT (1<<0) /* timeouted enforced ban */
#define BAN_ENFORCE (1<<1) /* make this always present */
#define BAN_ACTUAL  (1<<2) /* this is guaranteed to be a valid channel-
                              ban == we got this from the banlist or from a
                              mode change within the channel */
#define BAN_UNBAN   (1<<3) /* this is unbanned */
#define BAN_UNSET   (1<<4) /* this is read from the file when bottie was
                              started and not yet set */
#define BAN_SENTUNBAN (1<<5) /* unban sent to server */
#define BAN_SENTBAN   (1<<6) /* ban sent to server */
#define BAN_GUESSNICK (1<<7) /* guessed the nick, may be wrong */
#define BAN_ALL     ~0     /* all flags */

/*
 * An easy-to-use define to see if the ban is there or about to pop up soon:
 */
#define BANISTHERE (BAN_ACTUAL|BAN_SENTBAN)

/* required level that unbans enforced bans just like any other ban */
#define BAN_ENFORCELEVEL LEVELBOT

#define BANRETRY_ENFORCE 30  /* number of minutes to wait until an enforced
                                ban is rebanned after unbanned twice rapidly
                              */

/* We don't save warnings to the warn file that were set and not warned for
   during this period of time: */
#define WARN_TIMEOUT_REMOVAL (SECINMONTH*3)

#define CHBAN_ENFORCE    1
#define CHBAN_UNENFORCE  2
#define CHBAN_REASON     3

#define KICK_TRUSTEDUSER 2
#define KICK_BOT         1
#define KICK_COMMON      0

#define WARNF_KICKBAN 1    /* kick user and ban pattern on sight */
#define WARNF_ALL     0xff /* all warn flags ORed */

#define WLIST_ALL 1 /* list all info */
#define WLIST_BAN 2 /* list only bans */

#define BLIST_ACTUAL 1   /* present and ACTUAL in the list */
#define BLIST_PRESENT -1 /* present in list, but not ACTUAL */
#define BLIST_NOTHERE 0  /* unbanned or not existing before */

#endif /* BANS_H */
