#!/usr/bin/awk -f
BEGIN {
  good = good2 = bad = bad2 = 0;
  unres = "";
  root = "";
}
{
  if ($1 == "&") {
    printf("Alternative(s): %s\n", $0);
    bad++;
  }
  else if ($1 == "#") {
    unres = sprintf("%s %s", unres, $2);
#    printf("Unresolved: %s\n", $2);
    bad2++;
  }
  else if ($1 == "*")
    good++;
  else if ($1 == "+") {
    root = sprintf("%s %s", root, $2);
    good2++;
  }
  else if ($1 == "-")
    good++;
}
END {
  if (bad2 != 0)
    printf("Unresolved:%s\n", unres);
  else if ((bad+bad2) == 0) {
    if (good2 != 0)
      printf("Spelling is correct, from:%s\n", root);
    else if (good != 0)
      print "Spelling is correct";
  }
}
