<?php
/**
 * Class to handle all the admin functions.
 *
 * daCode http://www.dacode.org/
 * src/phplib/admin.php3
 * $Id: admin.php3,v 1.192.2.31 2002/09/15 17:25:39 ruffy Exp $
 *
 * Depends: Config Db User Utils Html Poll News Redirect Webcam
 */

Class Admin {

	/**
	 * Db abstraction layer instance
	 *@var object Db
	 */
	var $db;

	/**
	 * Session instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Utils instance
	 *@var object utils
	 */
	var $utils;

	/**
	 * HTML subclass instance
	 *@var object HTML
	 */
	var $html;

	/**
	 * Poll instance (hmm, dirty)
	 *@var object Poll 
	 */
	var $poll;

	/**
	 * News instance
	 *@var object News
	 */
	var $news;

	/**
	 * Redirect class instance
	 *@var object Redirect
	 */
	var $redirect;

	/**
	 * Webcam class instance
	 *@var object Webcam
	 */
	var$webcam;

	/**
	 * Tips instance
	 *@var object Tips
	 */
	var $tips;

	/**
	 * Array, the keys are the IDs of the comments the user has already scored
	 *@var array
	 */
	var $comments_scored;

	/**
	 * Class constructor
	 */
	Function Admin() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->cache = LoadClass('Cache');
		$this->html  = LoadClass('Html');
		$this->poll  = LoadClass('Poll');
		$this->news  = LoadClass('News');
		$this->webcam = LoadClass('Webcam');
		$this->redirect = LoadClass('Redirect');
		$this->tar   = LoadClass('Tar');
		$this->tips  = LoadClass('Tips');
		$this->utils = LoadClass('Utils');
		$this->utils->debug("Admin:".__LINE__." Init: All classes loaded".
			"sucessfully\n");
	}

	/**
	 * This print the admin box on the homepage is user as admin or
	 * moderator rights
	 *@access public
	 *@return mixed string the adminbox or integer  -1 if SQL failed.
	 */
	Function adminbox() {
		global $config;
		$this->utils->debug("Admin:".__LINE__." adminbox: init\n");

		// Just to return fast in case the user doesn't interest us.
		if (!$this->session->is_moderator) {
			return '<!-- ADMIN --><!-- /ADMIN -->';
		}

		$tmp = '';

		if ($this->session->is_admin) {
			$tmp .= '<div style="text-align: center; color: red;">'.
				lecho("You are a super user!")."</div><br />\n";
			if (!empty($config->cachedir)) {
				$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
					$config->adminfile."?action=clear_cache\">".
					lecho("Clear Cache")."</a><br />\n";
			}
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_users\">".
				lecho("Edit Users")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_topics\">".
				lecho("Edit Topics")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_topics\">".
				lecho("Add Topics")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_section\">".
				lecho("Edit Sections")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_section\">".
				lecho("Add Sections")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=edit_theme\">".
				lecho("Themes")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=list_polls\">".
				lecho("Edit Polls")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=add_tip_section\">".
				lecho("Add Tip Sections")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=gen_rdf\">".
				lecho("Generate RDF backend")."</a><br />\n";
			$tmp .= "&nbsp;-&nbsp;<a href=\"".$config->basehref.
				$config->adminfile."?action=gen_sidebar\">".
				lecho("Generate Sidebar")."</a><br />\n";
		}


		//We build the SELECT command to fetch news

		$sqlc_q = 'SELECT '.
			$config->tables['news'].'.id,' .
			$config->tables['news'].'.title,'.
			$config->tables['news'].'.state FROM '.
			$config->tables['news'].','.
			$config->tables['news_body'].','.
			$config->tables['topics'].','.
			$config->tables['sections'].','.
			$config->tables['author'].' WHERE '.
			$config->tables['news'].'.id='.
			$config->tables['news_body'].'.id AND '.
			$config->tables['news'].'.author_id='.
			$config->tables['author'].'.id AND '.
			$config->tables['news'].'.topic_id='.
			$config->tables['topics'].'.id AND '.
			$config->tables['news'].'.section_id='.
			$config->tables['sections'].'.id AND ('.
			$config->tables['news'].".state='0' OR ".
			$config->tables['news'].".state='2' OR ".
			$config->tables['news'].".state='3' ) ORDER BY ".
			$config->tables['news'].'.timestamp DESC '.$this->db->compat_limit(100);
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." adminbox: ".
				lecho("SQL Failed: ").
				$this->db->error()." SQL: ".$sqlc_q."\n");
			return -1;
		}

		$i=0;

		while ($row = $this->db->fetch_array()) {
			if (empty($row['title'])) {
				$row['title'] = $config->newstitledefault;
			}

			if ($row['state'] == "0") {
				$tmp .= '&nbsp;-&nbsp;';
				$tmp .= '['.lecho("to moderate").'] ';
				$tmp .= '<a href="' .$config->basehref.
					$config->adminfile.
					'?action=edit_news&amp;news_id='.$row['id'].'">'.htmlentities($row['title']).
					"</a><br />\n";
			} elseif ($row['state'] == "2") {
				$tmp .= '&nbsp;-&nbsp;';
				$tmp .= '['.lecho("wait state").'] ';
				$tmp .= '<a href="'. $config->basehref.
					$config->adminfile.
					'?action=edit_news&amp;news_id='.$row['id'].'">'.htmlentities($row['title']).
					"</a><br />\n";
			} elseif($row['state'] == "3" && $i <= 5) {
				$tmp .= '&nbsp;-&nbsp;';
				$tmp .= '['.lecho("deleted").'] ';
				$tmp .= '<a href="'. $config->basehref.
					$config->adminfile.
					'?action=edit_news&amp;news_id='.$row['id'].'">'.htmlentities($row['title']).
					"</a><br />\n";
				$i++;
			}
		}

		$this->db->free();

		// Show poll to be moderated !
		$tmp .= '<br />'.$this->poll->poll_to_moderate();

		// Show webcam to be moderated
		$tmp .= '<br />'.$this->webcam->webcam_to_moderate();

		// Show tips to be moderated
		$tmp .= '<br />'.$this->tips->tips_to_moderate();

		return '<!-- ADMIN -->'.
			$this->html->sidebox(lecho("Administration"),$tmp."<br />").
			'<!-- /ADMIN -->';
	}

	/**
	 * We print the news which is being moderated
	 *@access private
	 *@param integer the ID of the news beeing moderated
	 *@return string the formatted news.
	 */
	Function show_news($id) {
		global $config;
		$this->utils->debug("Admin:".__LINE__." show_news: init; id=".$id.";\n");
		$out = '';

		// Just to return fast in case the user doesn't interest us.
		if (!$this->session->is_moderator) {
			return;
		}

		/* We build the SELECT command - Damned long ! :-) */
		$sqlc_q = "SELECT ".
			$config->tables['news'].'.id as news_id,' .
			$config->tables['news'].'.timestamp,'.
			$config->tables['news'].'.title,'.
			$config->tables['news'].'.departement,'.
			$config->tables['news_body'].'.body,'.
			$config->tables['topics'].'.topic,'.
			$config->tables['sections']. '.section,'.
			$config->tables['author'].'.name,'.
			$config->tables['author'].'.contact,'.
			$config->tables['news'].'.main_page,'.
			$config->tables['author'].'.id as aut_id,'.
			$config->tables['news_body'].'.content_type,'.
			$config->tables['users'].'.email,'.
			$config->tables['users'].'.login,'.
			$config->tables['news'].'.user_id,'.
			$config->tables['news'].'.state FROM '.
			$config->tables['news'].','.
			$config->tables['news_body'].','.
			$config->tables['topics'].','.
			$config->tables['sections'].','.
			$config->tables['users'].','.
			$config->tables['author'].' WHERE '.
			$config->tables['news'].'.id='.
			$config->tables['news_body'].'.id AND '.
			$config->tables['news'].'.author_id='.
			$config->tables['author'].'.id AND '.
			$config->tables['news'].'.topic_id='.
			$config->tables['topics'].'.id AND '.
			$config->tables['news'].'.section_id='.
			$config->tables['sections'].'.id AND '.
			$config->tables['users'].'.id='.
			$config->tables['news'].'.user_id AND '.
			$config->tables['news'].'.id='.addslashes($id).
			' ORDER BY '.
			$config->tables['news'].'.timestamp DESC '.$this->db->compat_limit(1);
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_news: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}

		$row = $this->db->fetch_array();
		$row['id'] = $id;

		$this->db->free();

		$tempo_attach =  (array) $this->news->get_attach($id);
		reset($tempo_attach);
		$j=1;
		$tempo = array();
		while($cur2=current($tempo_attach)) {
			if ($cur2['news_id'] == $id) {
				$tempo[$j] = $cur2;
			}
			$j++;
			next($tempo_attach);
		}
		$row['attach'] = $tempo;

		$out .= '<form method="post" action="'.$config->basehref.
			'admin/mod.'.$config->php.'">'."\n";

		$out .= '<input type="hidden" name="table[id]" value="'.
			htmlentities($row['news_id']).'" />'."\n";

		$out .= '<input type="text" name="table[author]" value="'.
			htmlentities($row['name']).'" size="50" maxlength="100" />';

		if ($row['user_id'] > 1) {
			$out .= lecho("Real user is ").
				'<a href="'.$config->basehref.'users/?a=vu&amp;user_id='.
				$row['user_id'].'">'.htmlentities($row['login']).'</a>'."\n";
		}

		$out .= '<br /><input type="hidden" name="table[author_id]" value="'.
			htmlentities($row['aut_id']).'" />'."\n";

		$out .= '<input type="text" name="table[contact]" value="'.
			htmlentities($row['contact']).'" size="50" maxlength="100" /><br />'.
			"\n";
		$out .= '<input type="text" name="table[title]" value="'.
			htmlentities($row['title']).'" size="50" maxlength="150" /><br />'."\n";

		$out .= '<select name="table[topic_id]">'."\n";

		$sqlc_q = 'SELECT id,topic,longname FROM '.$config->tables['topics'] .
			' ORDER BY topic';
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}
		while($topics_tmp = $this->db->fetch_array()) {

			if (isset($topics_tmp['longname']) && $topics_tmp['longname'] != "") {
				$topic = htmlentities($topics_tmp['longname']);
			} else {
				$topic = htmlentities($topics_tmp['topic']);
			}

			if (htmlentities($row['topic']) == htmlentities($topics_tmp['topic'])) {
				$out .= '<option value="'.$topics_tmp['id'].'" selected="selected">'.
					$topic.'</option>'."\n";
			} else {
				$out .= '<option value="'.$topics_tmp['id'].'">'.$topic.
					'</option>'."\n";
			}
		}
		$this->db->free();

		$out .= '</select>'."\n";

		$out .= '<select name="table[section_id]">'."\n";

		$sqlc_q = "SELECT id,section FROM ".$config->tables['sections'] .
			" ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_news: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}
		while($sections_tmp = $this->db->fetch_array()) {

			$sections_tmp['section'] = htmlentities($sections_tmp['section']);

			if (htmlentities($row['section']) == $sections_tmp['section']) {
				$out .= '<option value="'.$sections_tmp['id'].
					'" selected="selected">'.$sections_tmp['section'].'</option>'."\n";
			} else {
				$out .= '<option value="'.$sections_tmp['id'].'">'.
					$sections_tmp['section'].'</option>'."\n";
			}
		}
		$this->db->free();

		// So we don't have warnings.
		$row['departement'] = (isset($row['departement']))?$row['departement']:'';


		$out .= '</select>'."\n";

		$out .= '<input type="text" name="table[departement]" value="'.
			htmlentities($row['departement']).'" size="30" maxlength="100" /><br />'.
			"\n";

		$out .= '<input type="text" name="table[timestamp]" value="'.
			htmlentities($row['timestamp']).'" size="14" />'."\n&nbsp;";
		// We keep the old timestamp and old state just in case ...
		$out .= '<input type="hidden" name="table[old_timestamp]" value="'.
			htmlentities($row['timestamp']).'" />'."\n";
		$out .= '<input type="hidden" name="table[old_state]" value="'.
			htmlentities($row['state']).'" />'."\n";

		$out .= lecho("Change for now: ").
			'<input type="checkbox" name="table[timeon]" ';

		if ($row['state'] != 1) {
			$out .= 'checked="checked" ';
		}
		$out .= '/>&nbsp; ';


		$out .= '<select name="table[content_type]">'.
			'<option value="text/plain"';
			if($row['content_type'] == "text/plain") {
				$out .= ' selected="selected"';
			}
		$out .= '>'.lecho("text").
			'</option>'.
			'<option value="text/html"';
			if($row['content_type'] == "text/html") {
				$out .= ' selected="selected"';
			}
		$out .= '>'.lecho("html").
			'</option></select><br />'."\n";

		$out .= '<textarea name="table[body]" rows="10" cols="70">'.
			htmlentities($row['body']).'</textarea><br />'."\n";

		/*
		 * For Links
		 */
		$sqlc_q = "SELECT id,lang FROM ".$config->tables['lang'] ." ORDER BY lang";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_news: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}
		while($lang_tmp = $this->db->fetch_array()) {
			$lang_id = $lang_tmp['id'];
			$lang_lan   = $lang_tmp['lang'];
			$lan[$lang_id] = $lang_lan;
		}
		$this->db->free();

		$links = array();

		$links = $this->news->get_urls($row['news_id']);
		$row['links'] = $links;

		$out .= '<table>'."\n";
		for ($k=0;$k<$config->numberoflinks;$k++) {

			$out .= '<tr><td><input type="text" name="table[nom'.$k.
				']" size="20" ';
			if (!empty($links[($k+1)]['name'])) {
				$out .= 'value="'.htmlentities($links[($k+1)]['name']).'"';
			}
			$out .= ' /></td>';
			$out .= '<td><input type="text" name="table[url'.$k.']" size="50"';
			if (!empty($links[($k+1)]['url'])) {
				$out .= ' value="'.$links[($k+1)]['url'].'"';
			}
			$out .= ' /></td><td>';

			$out .= '<select name="table[lang'.$k.']">';
			$out .= '<option value="no">'.lecho("Language").'</option>'."\n";
			reset($lan);
			while (current($lan)) {
				if (!empty($links[($k+1)]['lang'])
						&& $links[($k+1)]['lang'] == current($lan)) {
					$out .= '<option value="'. key($lan) .'" selected="selected">'.
						current($lan).'</option>'."\n";
				} else {
					$out .= '<option value="'. key($lan) .'">'.
						current($lan).'</option>'."\n";
				}
				next($lan);
			}

			$out .= '</select>';
			if (isset ($links[($k+1)]['id'])) {
				$out .= '<input type="hidden" name="table[newsurlid'.$k.']" '.
					'value="'.$links[($k+1)]['id'].'" />'."\n";
			}
			if (isset ($links[($k+1)]['urls_id'])) {
				$out .= '<input type="hidden" name="table[urlsid'.$k.']" '.
					'value="'.$links[($k+1)]['urls_id'].'" />'."\n";
			}
			$out .= '</td></tr>'."\n";
		}
		$out .= '</table>'."\n";
		/*
		 * Finished links !
		 */

		$out .= lecho("action").': <select name="table[action]">'."\n";
		$out .= '<option value="1">'.lecho("ok").'</option>'."\n";
		$out .= '<option value="2">'.lecho("wait").'</option>'."\n";
		$out .= '<option value="3">'.lecho("del").'</option>'."\n";
		$out .= '<option value="4">'.lecho("really del").'</option>'."\n";
		$out .= '</select>'."\n";

		$out .= lecho("Put on homepage:").
			' <input type="checkbox" name="table[view]" value="1" ';
		if ($row['main_page'] == 1 || $row['state'] == 0) {
			$out .= 'checked="checked" ';
		}
		$out .= '/>&nbsp;';

		$out .= '<input type="submit" value="'. lecho("send") .'" />'."\n";

		$out .= '<br /><br />'."\n";

		$out .= $this->html->newsbox($row);

		/*
		 * We print a textarea so moderator can send a mail to 
		 * the contributor to keep him informed about the reason 
		 * why the news has been rejected, accepted, etc.
		 */
		$out .= '<input type="text" name="table[contact_to]" value="';

		if ($row['user_id'] > 1) {
			$out .= htmlentities($row['email']);
		} elseif (preg_match('/^[\w_\-\.]+@[\w_\-\.]+$/',$row['contact'])) {
			$out .= htmlentities($row['contact']);
		}
		$out .=	'" size="50" maxlength="100" /> ';

		$out .= '<select name="table[reason_to]">';
		$out .= '<option value="" selected="selected">'. lecho("Choose a reason").
			'</option>'."\n";
		while(list($short,$long) = each($config->moderation_text)) {
			$out .= '<option value="'.htmlentities($short).'">'.
				htmlentities($short).'</option>'."\n";
		}
		$out .= '</select><br />';
		$out .= '<textarea name="table[body_to]" rows="10" cols="70">';
		$out .= '</textarea><br />';

		$out .= "</form>\n";

		return $out;
	}

	/**
	 * We do moderate the news
	 *@access private
	 *@param array FIXME can one describe the contents? 
	 */
	Function mod_news($row) {
		global $config;
		$this->utils->debug("Admin:".__LINE__." mod_news: init; row=\n");
		$this->utils->debug_dump($row);
		$this->utils->debug(";\n");

		if (!$this->session->is_moderator) {
			return $this->utils->no_access_msg();
		}

		//  Erase main index file
		if (!empty($config->htmldir)) {
			$this->cache->delete_htmlfiles('section',0,0,0,'.');
			$this->cache->delete_htmlfiles('topic',0,0,0,'.');
			$this->cache->delete_htmlfiles('.',0,0,0,'^index');
		}
		//  ... and archive boxes
		if (!empty($config->cachedir)) {
			$this->cache->delete_boxfiles('news_show_archive',0,0,0, '^#');
		}

		// We ignore STOP from user ...
		ignore_user_abort(true);

		/*
		 * We check if the news has been modified by someone else
		 */
		$tmp = '';
		$sqlc_q = 'SELECT title FROM '.$config->tables['news'].' WHERE '.
			"timestamp='".
			addslashes($this->db->timestamp14_to_dbms_stamp($row['old_timestamp'])).
			"' AND state='".addslashes($row['old_state'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." mod_news: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}
		if ($this->db->num_rows() == 0) {
			$tmp .= "<span class=\"newstext\">".
				lecho("News has been modified by someone else ").
				lecho("while you were editing it!<br />").
				lecho("Please go back, reload, and try again.<br />")."</span>\n";
			return $tmp;
		}
		//============ OK ===============/

		// if action = delete , delete the news from the database
		if ($row['action']== 4 && $this->db->num_rows() != 0) {
			$tmp .= "-&nbsp;".lecho("body table...");
			$sqlc_q = "DELETE FROM ".$config->tables['news_body'].
				" WHERE id='".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".$sqlc_q.
					"\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br />\n";

			// we check if the author is used in another news
			// if not, we delete the author from the database
			$sqlc_q = "SELECT A.author_id".
				" FROM ".$config->tables['news']." A, ".
				$config->tables['news']." B".
				" WHERE A.id <> '".addslashes($row['id']).
				"' AND A.author_id=B.author_id".
				" AND B.id = '".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".$sqlc_q.
					"\n");
				return -1;
			}
			if ($this->db->num_rows() == 0) {
				$tmp .= "-&nbsp;".lecho("Author table...");
				$sqlc_q = "SELECT author_id".
					" FROM ".$config->tables['news'].
					" WHERE id ='".addslashes($row['id'])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__."	mod_news: ".
						lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				$linetemp = $this->db->fetch_array();
				$sqlc_q = "DELETE FROM ".$config->tables['news_author'].
					" WHERE id ='".addslashes($linetemp['author_id'])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__."	mod_news: ".
						lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				$tmp .= lecho(" done!")."<br />\n";
			}

			$tmp = "<span class=\"newstext\">".lecho("Modifying:")."<br />\n-&nbsp;".
				lecho("news table...");
			$sqlc_q = "DELETE FROM ".$config->tables['news'].
				" WHERE id='".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".$sqlc_q.
					"\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br />\n";


			$tmp .= "-&nbsp;".lecho("URL table...");
			for ($k=0;$k<$config->numberoflinks;$k++) {
				$nomk = "nom".$k;
				$urlk = "url".$k;
				$urlsidk = "urlsid".$k;
				$newsurlidk = "newsurlid".$k;
				$lank = "lang".$k;

				if (!isset($row[$urlsidk])) {
					break;
				}

				// we check if the url is used in another news
				// if not, we delete the url from the database
				$sqlc_q = "SELECT id FROM ".$config->tables['news_urls'].
					" WHERE news_id <> '".addslashes($row['id']).
					"' AND urls_id='".addslashes($row[$urlsidk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__." mod_news: ".
						lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				if ($this->db->num_rows() == 0) {
					$sqlc_q = "DELETE FROM ".$config->tables['urls'].
						" WHERE id ='".addslashes($row[$urlsidk])."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$this->utils->debug("Admin:".
						__LINE__." mod_news: ".lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
						return -1;
					}
				}
				$sqlc_q = "DELETE FROM ".$config->tables['news_urls'].
					" WHERE id ='".addslashes($row[$newsurlidk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__.
						" mod_news: ".lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				$sqlc_q = "DELETE FROM ".$config->tables['urls_hits'].
					" WHERE news_urls_id ='".addslashes($row[$newsurlidk])."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__.
						" mod_news: ".lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
			}
			$tmp .= lecho(" done!")."<br />\n";

			$tmp .= "-&nbsp;".lecho("News attachements table...");
			$sqlc_q = "DELETE FROM ".$config->tables['attach'].
				" WHERE news_id ='".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br /><br />\n";
			
			$tmp .= "-&nbsp;".lecho("Adding entry in moderated table...");
			$sqlc_q = "DELETE FROM ".$config->tables['news_moderated'].
				" WHERE news_id ='".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br /><br />\n";
			//Compute the ressource ID for news
			//FIXME: GRUIK . Reveersing the shall only be done once.
			// At startup, if needed.
			$this->utils->debug_dump($config->resources);
			reset($config->resources);
			while (list($res_idx, $res_name) = each($config->resources)) {
				if ($res_name == 'News') {
					$res_type = $res_idx;
					break;
				}
			}
			$sqlc_q = "SELECT id FROM ".$config->tables['comments'].
				" WHERE news_id ='".addslashes($row['id'])."' AND res_type = $res_type";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$linetemp = $this->db->fetch_array();
			$tabtemp = array();
			while ($linetemp) {
				$tabtemp[] = $linetemp['id'];
				$linetemp = $this->db->fetch_array();
			}
			$this->db->free();
			reset($tabtemp);
			while (list($key, $val) = each($tabtemp)) {
				$tmp .= "-&nbsp;".lecho("Comments scored table...");
				$sqlc_c = "DELETE FROM ".$config->tables['comments_scored'].
					" WHERE comments_id='".addslashes($val)."'";
				$ret = $this->db->query($sqlc_c);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__."	mod_news: ".
						lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				$tmp .= lecho(" done!")."<br /><br />\n";
				$tmp .= "-&nbsp;".lecho("Comments scored user table...");
				$sqlc_c = "DELETE FROM ".$config->tables['comments_scored_user'].
					" WHERE comments_id='".addslashes($val)."'";
				$ret = $this->db->query($sqlc_c);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__."	mod_news: ".
						lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
				$tmp .= lecho(" done!")."<br /><br />\n";
			}
			$tmp .= "-&nbsp;".lecho("Comments table...");
			$sqlc_q = "DELETE FROM ".$config->tables['comments'].
				" WHERE news_id ='".addslashes($row['id'])."' AND res_type = $res_type";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br /><br />\n";

			// end of case deleting news.
		} else {

			// We do get the main_page function //
			if (isset($row['main_page'])) {
				$row['main_page'] = $row['main_page'] || 0;
			}

			$tmp = "<span class=\"newstext\">".lecho("Modifying:")."<br />\n-&nbsp;".
				lecho("news table...");

			$sqlc_t = ((isset($row['timeon']) && $row['timeon'] == "on") ? "" :
				"timestamp='".addslashes($row['timestamp'])."',");
			$sqlc_q = "UPDATE ".$config->tables['news']." SET ".
				"topic_id='".addslashes($row['topic_id'])."',".
				"section_id='".addslashes($row['section_id'])."',".
				"main_page='".addslashes($row['view'])."',".
				((isset($row['timeon']) && $row['timeon'] == "on") ? "" :
					"timestamp='".
					addslashes($this->db->timestamp14_to_dbms_stamp($row['timestamp'])).
					"',").
				"title='".addslashes($row['title'])."',".
				"departement='".addslashes($row['departement'])."',".
				"state='".addslashes($row['action'])."'".
				" WHERE id='".addslashes($row['id'])."'";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br />\n";

			$tmp .= "-&nbsp;".lecho("body table...");

			$sqlc_q = "UPDATE ".$config->tables['news_body'].
				" SET body='".addslashes($row['body'])."',".
				"content_type='".addslashes($row['content_type'])."'".
				" WHERE id='".addslashes($row['id'])."'";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__."	mod_news: ".
					lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br />\n";

			$tmp .= "-&nbsp;".lecho("Author table...");

			$sqlc_q = "UPDATE ".$config->tables['author']." SET ".
				"name='".addslashes($row['author'])."',".
				"contact='".addslashes($row['contact'])."'".
				" WHERE id='".addslashes($row['author_id'])."'";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$this->utils->debug("Admin:".__LINE__.
					" mod_news: ".lecho("SQL Failed: ").
					$this->db->error()." SQL: ".
					$sqlc_q."\n");
				return -1;
			}
			$tmp .= lecho(" done!")."<br />\n";

			$tmp .= "-&nbsp;".lecho("URL table...");
			for ($k=0;$k<$config->numberoflinks;$k++) {
				$nomk = "nom".$k;
				$urlk = "url".$k;
				$urlsidk = "urlsid".$k;
				$newsurlidk = "newsurlid".$k;
				$lank = "lang".$k;

				if ($row[$lank] == 'no' && empty($row[$newsurlidk])) continue;
				if (empty($row[$nomk]) && !empty($row[$newsurlidk])) {
					$sqlc_q = "DELETE FROM ".$config->tables['news_urls'].
						" WHERE id='".addslashes($row[$newsurlidk])."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$this->utils->debug("Admin:".__LINE__.
							" mod_news: ".lecho("SQL Failed: ").
							$this->db->error()." SQL: ".
							$sqlc_q."\n");
						return $tmp;
					}
					continue;
				} elseif (!empty($row[$nomk]) && empty($row[$newsurlidk])) {
					$sqlc_q = "SELECT id FROM ".$config->tables['urls'].
						" WHERE	url='".addslashes($row[$urlk])."'";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$this->utils->debug("Admin:".__LINE__.
							" mod_news: ".lecho("SQL Failed: ").
							$this->db->error()." SQL: ".
							$sqlc_q."\n");
						return -1;
					}
					$tempo = $this->db->fetch_array();
					if (empty($tempo['id'])) {
						$sqlc_q = "INSERT INTO ".$config->tables['urls'].
							" (url) VALUES ('".addslashes($row[$urlk])."')";
						$ret = $this->db->query($sqlc_q);
						if (!$ret) {
							$this->utils->debug("Admin:".__LINE__.
								" mod_news: ".lecho("SQL Failed: ").
								$this->db->error()." SQL: ".
								$sqlc_q."\n");
							return -1;
						}
						$tempourlid = $this->db->last_insert_id();
					} else {
						$tempourlid = $tempo['id'];
					}

					$sqlc_q = "INSERT INTO ".$config->tables['news_urls'].
						" (news_id,lang_id,urls_id,name) VALUES ('".
						addslashes($row['id'])."','".
						addslashes($row[$lank])."','".
						addslashes($tempourlid)."','".
						addslashes($row[$nomk])."')";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$this->utils->debug("Admin:".__LINE__.
							" mod_news: ".lecho("SQL Failed: ").
							$this->db->error()." SQL: ".
							$sqlc_q."\n");
						return -1;
					}
					$tempourlid = $this->db->last_insert_id();

					$sqlc_q = "INSERT INTO ".$config->tables['urls_hits'].
						" (news_urls_id,hits) VALUES ('".
						addslashes($tempourlid)."','0')";
					$ret = $this->db->query($sqlc_q);
					if (!$ret) {
						$this->utils->debug("Admin:".__LINE__.
							" mod_news: ".lecho("SQL Failed: ").
							$this->db->error()." SQL: ".
							$sqlc_q."\n");
						return -1;
					}
					continue;
				} elseif (!empty($row[$nomk]) && !empty($row[$newsurlidk])) {
					// allright, it's not a new url, it's not a deleted one .. it must be a modification ..

					$sqlc_q = "SELECT ".
						$config->tables['urls'].".url, ".
						$config->tables['news_urls'].".lang_id, ".
						$config->tables['news_urls'].".name ".
						"FROM ".$config->tables['urls'].
						",".$config->tables['news_urls'].
						" WHERE ".$config->tables['urls'].".id='".addslashes($row[$urlsidk])."'".
						" AND ".$config->tables['news_urls'].".urls_id='".addslashes($row[$urlsidk])."'";
					$ret = $this->db->query($sqlc_q);

					if (!$ret) {
						$this->utils->debug("Admin:".__LINE__.
							" mod_news: ".lecho("SQL Failed: ").
							$this->db->error()." SQL: ".
							$sqlc_q."\n");
						return -1;
					}
					$res = $this->db->fetch_array();

					if($row[$urlk] != $res['url'] || !$row[$nomk] != $res['name'] ||
						$row[$lank] != $res['lang_id']) {
						// Ok .. we have to update it ..

						$sqlc_q = "UPDATE ".$config->tables['urls'].
							" SET url='".addslashes($row[$urlk])."' ".
							"WHERE id='".addslashes($row[$urlsidk])."'";

						$ret = $this->db->query($sqlc_q);

						if (!$ret) {
							$this->utils->debug("Admin:".__LINE__.
								" mod_news: ".lecho("SQL Failed: ").
								$this->db->error()." SQL: ".
								$sqlc_q."\n");
							return -1;
						}

						$sqlc_r = "UPDATE ".$config->tables['news_urls'].
							" SET lang_id='".addslashes($row[$lank])."', ".
							"name='".addslashes($row[$nomk])."' ".
							"WHERE urls_id='".addslashes($row[$urlsidk])."'".
							" AND id='".addslashes($row[$newsurlidk])."'";

						$ret = $this->db->query($sqlc_r);

						if (!$ret) {
							$this->utils->debug("Admin:".__LINE__.
								" mod_news: ".lecho("SQL Failed: ").
								$this->db->error()." SQL: ".
								$sqlc_q."\n");
							return -1;
						}
					}
					// we've done it .. let's continue in the loop
					continue;
				} // end big if
			} // end URL for loop
			$tmp .= lecho(" done!")."<br /><br />\n";

			$tmp .= "-&nbsp;".lecho("Adding entry in moderated table...");

			$sqlc_q = "SELECT state FROM ".$config->tables['news_moderated'].
				" WHERE news_id='".addslashes($row['id'])."' AND ".
				"user_id='".addslashes($this->session->user_id)."'";
			$ret = $this->db->query($sqlc_q);
			if ($this->db->num_rows() == 0) {
				$sqlc_q = "INSERT INTO ".$config->tables['news_moderated'].
					" (news_id,user_id,state) VALUES ('".
					addslashes($row['id'])."','".
					addslashes($this->session->user_id)."','".
					addslashes($row['action'])."')";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__.
						" mod_news: ".lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
			} else {
				$sqlc_q = "UPDATE ".$config->tables['news_moderated'].
					" SET state='".addslashes($row['action'])."' WHERE ".
					"news_id='".addslashes($row['id'])."' AND ".
					"user_id='".addslashes($this->session->user_id)."'";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__.
						" mod_news: ".lecho("SQL Failed: ").
						$this->db->error()." SQL: ".
						$sqlc_q."\n");
					return -1;
				}
			}

			$tmp .= lecho(" done!")."<br /><br />\n";
		}

		$tmp .= "-&nbsp;".lecho("Generating RDF backend...");
		$tmp .= $this->gen_rdf()."<br />\n";
		$tmp .= "-&nbsp;".lecho("Generating Sidebar...");
		$tmp .= $this->gen_sidebar()."<br />\n";

		if (($row['reason_to'] != "" || $row['body_to'] != "") &&
				$row['contact_to'] != "") {
			$tmp .= "-&nbsp;".lecho("Sending E-Mail...");

			if ($row['reason_to'] != "") {
				$reason = $config->moderation_text[$row['reason_to']];
			} else {
				$reason = $row['body_to'];
			}
			if ($this->utils->send_email($row['contact_to'],
										empty($row['title'])?$config->newstitledefault:$row['title'],
										$reason,
										$config->moderation_from)) {
				$tmp .= lecho(" done!");
			} else {
				$tmp .= lecho(" failed!");
			}

		}

		$tmp .= "</span>\n";
		
		$this->utils->debug("Admin:".__LINE__." mod_news: end; returning".
		"tmp=".$tmp.";\n");
		return $tmp;
	}

	/**
	 * Function for sysadmin to show list of present users
	 *@access private
	 *@return string
	 */
	Function show_users() {
		global $config;

		$this->utils->debug("Admin:".__LINE__." show_users: init;");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,lname,fname,login,email,level FROM ".
			$config->tables['users']." ORDER BY created DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_users: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}

		$tmp .= "<table width=\"100%\" border=\"1\">";

		$tmp .= "<tr><td class=\"newstext\">m</td><td class=\"newstext\">s</td>".
			"<td class=\"newstext\">score</td>".
			"<td class=\"newstext\">id</td>".
			"<td class=\"newstext\">".lecho("Last Name")."</td>".
			"<td class=\"newstext\">".lecho("First Name")."</td>".
			"<td class=\"newstext\">".lecho("Login")."</td>".
			"<td class=\"newstext\">".lecho("E-Mail")."</td>".
			"</tr>";

		while($row=$this->db->fetch_array()) {

			$tmp .= "<tr>";

			if ($row['level'] & pow(2,21)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			if ($row['level'] & pow(2,22)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			if ($row['level'] & pow(2,23)) {
				$tmp .= "<td><b>x</b></td>";
			} else {
				$tmp .= "<td>&nbsp;</td>";
			}

			$tmp .= "<td class=\"newstext\">&nbsp;<a href=\"".
				$config->basehref.$config->adminfile.
				"?action=edit_users&amp;user_id=".$row['id']."\">".
				htmlentities($row['id'])."</a></td>".
				"<td class=\"newstext\">".htmlentities($row['lname'])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row['fname'])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row['login'])."</td>".
				"<td class=\"newstext\">&nbsp;".htmlentities($row['email'])."</td></tr>\n";
		}
		$tmp .= "</table>";

		$tmp .= '<br /><div align="center"><table width="5%" border="0"><tr><td>'."\n";
		$tmp .= ' <form method="post" action="'.$config->baseurl.'users/?a=na">'."\n";
		$tmp .= '  <input type="submit" Value="'.lecho("New Account").'" />'."\n";
		$tmp .= ' </td></tr></form></table></div><br />'."\n";
		$this->utils->debug("Admin:".__LINE__." show_users: ".
		"exiting;\n");

		return $this->html->simplebox($tmp);
	}

	/**
	 * Function for sysadmin to show form to modify a user
	 *@access private
	 *@param integer the ID of the user to edit
	 *@return string the HTML form
	 */
	Function show_edit_user($id) {
		global $config;

		$this->utils->debug("Admin:".__LINE__." show_edit_user: init; ".
			"id=".$id.";\n");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,lname,fname,login,email,homesite,theme,level,".
			"score,param FROM ".
			$config->tables['users']." WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_edit_user: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q.";\n");
			return -1;
		}
		$row=$this->db->fetch_array();

		$tmp .= "<form method=\"post\" action=\"".
			$config->basehref."admin/modusers.".$config->php."\">\n";
		$tmp .= "<table width=\"100%\" border=\"0\">";

		$tmp .= "<tr><td class=\"sboxtext\">id</td><td>".htmlentities($row['id'])."".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Login").
			"</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[login]\" value=\"".htmlentities($row['login'])."\" />".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Last Name").
		"</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[lname]\" value=\"".htmlentities($row['lname'])."\" />".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("First Name").
		"</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[fname]\" value=\"".htmlentities($row['fname'])."\" />".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("E-Mail").
		"</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[email]\" value=\"".htmlentities($row['email'])."\" />".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Homesite").
		"</td><td><input type=\"text\" size=\"30\" ".
			"name=\"table[homesite]\" value=\"".htmlentities($row['homesite'])."\" />".
			"</td></tr>\n";
		$tmp .= "<tr><td class=\"sboxtext\">".lecho("Theme").
			"</td><td><select name=\"table[theme]\">\n";
		reset ($config->listofthemes);
		while (list($i, $theme) = each ($config->listofthemes)) {
			$tmp .= '<option value="'.$i.'"';
			if ($i == $row['theme']) {
				$tmp .= " selected=\"selected\"";
			}
			$tmp .= ">".$theme."</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$tmp .= "<tr><td class=\"sboxtext\">".lecho("score").
			"</td><td><select name=\"table[score]\">\n";
		for ($i=-1;$i<=5;$i++) {
			$tmp .= '<option value="'.$i.'"'.
				((isset($row['scope']) && $i == $row['scope']) ? ' selected="selected"' : '').
				">".$i."</option>\n";
		}
		$tmp .= "</select></td></tr>\n";

		$hide_sig = ($row['param'] & pow(2,2) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Hide signatures").
			"</td><td><select name=\"table[hide_sig]\">\n".
			"<option value=\"0\"".($hide_sig==0 ? ' selected="selected"' : '').
			">".lecho("No")."</option>\n".
			"<option value=\"1\"".($hide_sig==1 ? ' selected="selected"' : '').
			">".lecho("Yes")."</option>\n".
			"</select></td></tr>\n";

		$identity = ($row['param'] & pow(2,0) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Display").
			"</td><td><select name=\"table[identity]\">\n".
			"<option value=\"1\"".($identity ? ' selected="selected"' : '').
			">".lecho("First Name")." ".lecho("Last Name")."</option>\n".
			"<option value=\"0\"".($identity ? '' : ' selected="selected"').
			">".lecho("Login")."</option>\n".
			"</select></td></tr>\n";

		$skip_referer = ($row['param'] & pow(2,3) ? 1 : 0);
		$tmp .= "<tr><td class=\"newstext\">".lecho("Skip referer").
		"</td><td><select name=\"table[skip_referer]\">\n".
			"<option value=\"0\"".($skip_referer==0 ? ' selected="selected"' : '').
			">".lecho("No")."</option>\n".
			"<option value=\"1\"".($skip_referer==1 ? ' selected="selected"' : '').
			">".lecho("Yes")."</option>\n".
			"</select></td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("moderator").
		"</td><td><input type=\"checkbox\" ".
			"name=\"table[moderator]\"";
		if ($row['level'] & pow(2,21)) {
			$tmp .= "checked=\"checked\"";
		}
		$tmp .= " />";

		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("sysadmin").
			"</td><td><input type=\"checkbox\" ".
			"name=\"table[sysadmin]\"";
		if ($row['level'] & pow(2,22)) {
			$tmp .= "checked=\"checked\"";
		}
		$tmp .= " />";

		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td class=\"newstext\">".lecho("scoror").
			"</td><td><input type=\"checkbox\" ".
			"name=\"table[scoror]\"";
		if ($row['level'] & pow(2,23)) {
			$tmp .= "checked=\"checked\"";
		}
		$tmp .= " />";

		$tmp .= "</td></tr>\n";

		$tmp .= "<tr><td colspan=\"2\" align=\"center\">".
			"<input type=\"submit\" value=\"". lecho("send") ."\" /></td></tr>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".
			htmlspecialchars($row['id'])."\" />\n";
		$tmp .= "<input type=\"hidden\" name=\"table[level]\" value=\"".
			htmlspecialchars($row['level'])."\" />\n";
		$tmp .= "<input type=\"hidden\" name=\"table[param]\" value=\"".
			htmlspecialchars($row['param'])."\" />\n";

		$tmp .= "</table></form>";

		$this->utils->debug("Admin:".__LINE__." show_edit_user: ".
			"end;\n");

		return $this->html->simplebox($tmp);
	}

	/**
	 * Function to modify user parameters by sysadmin
	 *@access private
	 *@param array a user record.
	 *@return mixed string error message if access denied, -1 if db error, void upon success.
	 */
	Function mod_user($row) {
		global $config;

		$this->utils->debug("Admin:".__LINE__." mod_user: init; row=");
		$this->utils->debug_dump($row);
		$this->utils->debug(";\n");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$hide_sig = $row['hide_sig'];
		$identity = $row['identity'];
		$skip_referer = $row['skip_referer'];
		$newlevel = $row['level'];
		if (isset($row['sysadmin']) && $row['sysadmin'] == "on") {
			$newlevel = $newlevel | pow(2,22);
		} else {
			$newlevel = $newlevel & ~ pow(2,22);
		}
		if (isset($row['moderator']) && $row['moderator'] == "on") {
			$newlevel = $newlevel | pow(2,21);
		} else {
			$newlevel = $newlevel & ~ pow(2,21);
		}
		if (isset($row['scoror']) && $row['scoror'] == "on") {
			$newlevel = $newlevel | pow(2,23);
		} else {
			$newlevel = $newlevel & ~ pow(2,23);
		}
		$row['param'] = $row['param'] | ($identity ? pow(2,0) : 0);
		$row['param'] = $row['param'] | ($hide_sig ? pow(2,2) : 0);
		$row['param'] = $row['param'] | ($skip_referer ? pow(2,3) : 0);

		$sqlc_q = "UPDATE ".$config->tables['users']." SET ".
			"lname='".addslashes($row['lname'])."',".
			"fname='".addslashes($row['fname'])."',".
			"login='".addslashes($row['login'])."',".
			"email='".addslashes($row['email'])."',".
			"theme='".addslashes($row['theme'])."',".
			"param='".addslashes($row['param'])."',".
			"score='".addslashes($row['score'])."',".
			"level='".addslashes($newlevel)."',".
			"created=created".
			" WHERE id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." mod_user: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q.";\n");
			return -1;
		}
	}

	/**
	 * Function to show topics for admin
	 *@access private
	 *@return string
	 */
	Function show_topics() {
		global $config;

		$this->utils->debug("Admin:".__LINE__." show_topics: init;\n");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,topic,state FROM ".$config->tables['topics'].
			" ORDER BY topic,id";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_topics: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q.";\n");
			return -1;
		}
		$tmp .= "<table><tr>";
		$i= (int) 0;
		while($row=$this->db->fetch_array()) {
			if ($i>=5) {
				$tmp .= "</tr><tr>";
			}
			$tmp .= "<td class=\"newstext\">";

			$tempo_link = "<img src=\"".
				$this->session->imgurl("section/".htmlentities($row['topic'])).
				"\" alt=\"\" border=\"0\" />";

			$tmp .= "<table><tr><td class=\"newstext\"><center>".
				$this->redirect->make($tempo_link,
									$config->basehref.$config->newsfile."/topic/".
									urlencode($row['topic'])).
				"</center></td></tr><tr><td class=\"newstext\"><center>";

			if ($row['state'] == 0) {
				$tempo_link = "<font color=\"red\">".htmlentities($row['topic'])."</font>\n";
			} else {
				$tempo_link = htmlentities($row['topic']);
			}

			$tmp .= "<a href=\"".$config->basehref.$config->adminfile.
				"?action=edit_topics&amp;topic_id=".
				urlencode($row['id'])."\">".$tempo_link."</a>";

			$tmp .= "</center></td></tr>".
				"</table>";
			$tmp .= "</td>\n";

			if ($i>=5) {
				$i=0;
			}
			$i++;
		}
		$tmp .= "</tr></table>\n";
		$this->db->free();

		$this->utils->debug("Admin:".__LINE__." show_topics: end; \n");

		return $this->html->simplebox($tmp);
	}

	/**
	 * Show modify topic
	 *@access private
	 *@param integer topic ID
	 *@return mixed string the HTML form, error msg if no access, int -1 if SQL error.
	 */
	Function show_edit_topic($id) {
		global $config;

		$this->utils->debug("Admin:".__LINE__." show_edit_topic: init;".
			" id=".$id.";\n");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,topic,state,longname FROM ".$config->tables['topics'].
			" WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_edit_topic: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		$row=$this->db->fetch_array();
		$tmp .= "<form method=\"post\" action=\"".$config->basehref.
			"admin/topics_edit.".$config->php."\">\n";
		$tmp .= "<table cellpadding=\"3\" cellspacing=\"3\">\n";
		$tmp .= "<tr><td class=\"newstext\">".
			lecho("Picture name (.png)")."</td><td class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[topic]\" value=\"".
			htmlentities($row['topic'])."\" /></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("Long name")."</td><td ".
			"class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[longname]\" value=\"".
			htmlentities($row['longname'])."\" /></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("State").
			"</td><td class=\"newstext\">\n";
		$tmp .= "<input type=\"checkbox\" name=\"table[state]\"";
		if ($row['state'] == 1) {
			$tmp .= " checked=\"checked\"";
		}
		$tmp .= " /></td></tr>\n";
		$tmp .= "<tr><td>&nbsp;</td></tr>\n";
		$tmp .= "<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\" /></center></td></tr></table>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".$row['id'].
			"\" />\n";

		$tmp .= "</form>\n";

		$this->utils->debug("Admin:".__LINE__." show_edit_topic: end;\n");

		return $this->html->simplebox($tmp);
	}

	/**
	 * Do edit topic
	 *@access private
	 *@param array a row of topic table
	 *@return mixed string error message if no access integer -1 if SQL failed, 1 if success
	 */
	Function do_edit_topic($row) {
		global $config;

		$this->utils->debug("Admin:".__LINE__." do_edit_topic: init;".
			" row=");
		$this->utils->debug_dump($row);
		$this->utils->debug(";\n");

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$row['state'] = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "UPDATE ".$config->tables['topics']." SET ".
			"topic='".addslashes($row['topic'])."',".
			"longname='".addslashes($row['longname'])."',".
			"state='".addslashes($row['state'])."'".
			" WHERE id='".addslashes($row['id'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." do_edit_topic: ".
				lecho("SQL Failed: ").$this->db->error().
				" SQL: ".$sqlc_q."\n");
			return -1;
		}
		return 1;
	}

	/**
	 * Show form to add topic
	 *@return string the form to add topic
	 *@access private
	 */
	Function show_add_topic() {
		global $config;

		$tmp = "<table><tr><td><form method=\"post\" action=\"".
			$config->basehref."admin/topics_add.".$config->php."\">\n".
			"<table cellpadding=\"3\" cellspacing=\"3\">\n".
			"<tr><td class=\"newstext\">".lecho("Picture name (.png)")."</td>".
			"<td class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[topic]\" /></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("Long name")."</td><td ".
			"class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[longname]\" /></td></tr>\n".
			"<tr><td class=\"newstext\">".lecho("State").
			"</td><td class=\"newstext\">\n".
			"<input type=\"checkbox\" name=\"table[state]\" ".
			"checked=\"checked\" /></td></tr><tr><td>&nbsp;</td></tr>\n".
			"<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".lecho("Submit").
			"\" /></center></td></tr></table>\n".
			"</form></td>\n";
		$tmp .= "<td valign=\"top\" class=\"newstext\">".
			lecho("Add your png file in images/section/ then ").
			lecho("put the same name as short name and activate or not the topic.").
			"</td></tr></table>\n";

		return $this->html->simplebox($tmp);
	}

	/**
	 * Do add topic
	 *@access private
	 *@param array a row of the topics table
	 *@return mixed string error message if no access, integer -1 if SQL failed, 1 if success.
	 */
	Function do_add_topic($row) {
		global $config;

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$row['state'] = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "INSERT INTO ".$config->tables['topics'].
			" (topic,longname,state) VALUES ('".
			addslashes($row['topic'])."','".
			addslashes($row['longname'])."','".
			addslashes($row['state'])."')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." do_add_topic: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		return 1;
	}

	
	/**
	 * Show form to add section
	 *@return string the form to add section
	 *@access private
	 */
	Function show_add_section() {
		global $config;
		$tmp = "<table><tr><td><form method=\"post\" action=\"".
			$config->basehref."admin/section_add.".$config->php."\">\n".
			"<table cellpadding=\"3\" cellspacing=\"3\">\n".
			"<td class=\"newstext\">".lecho("Name")."</td>\n".
			"<td class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[section]\" /></td></tr>\n".
			"<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\" /></center></td></tr></table>\n".
			"</form></td></table>\n";
		return $this->html->simplebox($tmp);
	}

	/**
	 * Performs the SQL query to add a section
	 *@access private
	 *@param array  FIXME: ?????
	 *@return mixed string error message if no access, integer -1 if SQL failed, 1 if success.
	 */	 
	Function do_add_section($row) {
		global $config;
		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$sqlc_q = "INSERT INTO ".$config->tables['sections'].
			" (section,state) VALUES ('".
			addslashes($row['section'])."', '1')";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." do_add_section:	".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		return 1;
	}

	/**
	 *  Creates the list of sections with links to edit them 
	 *@access private
	 *@return string the HTML
	 */
	Function show_sections() {
		global $config;

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,section,state FROM ".$config->tables['sections'].
			" ORDER BY section,id";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." show_sections: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		$tmp .= "<table><tr>";
		$i= (int) 0;
		while($row=$this->db->fetch_array()) {
			if ($i>=5) {
				$tmp .= "</tr><tr>";
			}
			$tmp .= "<td class=\"newstext\">";

			$tempo_link = "<img src=\"".$this->session->imgurl("section/".$row['section']).
				"\" alt=\"\" />";

			$tmp .= "<table><tr><td class=\"newstext\"><center>";

			if ($row['state'] == 0) {
				$tempo_link = "<font color=\"red\">".htmlentities($row['section'])."</font>\n";
			} else {
				$tempo_link = htmlentities($row['section']);
			}

			$tmp .= "<a href=\"".$config->basehref.$config->adminfile.
				"?action=edit_section&amp;section_id=".
				urlencode($row['id'])."\">".$tempo_link."</a>";

			$tmp .= "</center></td></tr>".
				"</table>";
			$tmp .= "</td>\n";

			if ($i>=5) {
				$i=0;
			}
			$i++;
		}
		$tmp .= "</tr></table>\n";
		$this->db->free();

		return $this->html->simplebox($tmp);
	}
	/**
	 * Creates the HTML form to edit a section
	 *@param integer the id of the section to edit
	 *@access private
	 *@return mixed string error message if access denied, integer -1 on failure, 1 on success
	 */
	Function show_edit_section($id) {
		global $config;

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$tmp = "";
		$sqlc_q = "SELECT id,section,state FROM ".$config->tables['sections'].
			" WHERE id='".addslashes($id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__."	show_edit_section: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		$row=$this->db->fetch_array();
		$tmp .= "<form method=\"post\" action=\"".$config->basehref.
			"admin/section_edit.".$config->php."\">\n";
		$tmp .= "<table cellpadding=\"3\" cellspacing=\"3\">\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("Name")."</td><td ".
			"class=\"newstext\">\n";
		$tmp .= "<input type=\"text\" name=\"table[section]\" value=\"".
			htmlentities($row['section'])."\" /></td></tr>\n";
		$tmp .= "<tr><td class=\"newstext\">".lecho("State").
			"</td><td class=\"newstext\">\n";
		$tmp .= "<input type=\"checkbox\" name=\"table[state]\"";
		if ($row['state'] == 1)
			$tmp .= " checked=\"checked\"";
		$tmp .= " /></td></tr>\n";
		$tmp .= "<tr><td>&nbsp;</td></tr>\n";
		$tmp .= "<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\" /></center></td></tr></table>\n";
		$tmp .= "<input type=\"hidden\" name=\"table[id]\" value=\"".$row['id'].
			"\" />\n";

		$tmp .= "</form>\n";

		return $this->html->simplebox($tmp);
	}

	/**
	 * Do edit section
	 *@param array 'section' => string, 'state' => integer, 'id' =>integer
	 *@access private
	 *@return mixed string error message if access denied, integer -1 on failure, 1 on success
	 */
	Function do_edit_section($row) {
		global $config;

		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$row['state']   = ($row['state'] == "on") ?  1 : 0 ;
		$sqlc_q = "UPDATE ".$config->tables['sections']." SET ".
			"section='".addslashes($row['section'])."',".
			"state='".addslashes($row['state'])."' WHERE ".
			"id='".addslashes($row['id'])."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__."	do_edit_section: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		return 1;
	}

	/**
	 * Creates the form to add a new tip section0
	 *@access private
	 *@return string the HTML form
	 */
	Function show_add_tip_section() {
		global $config;
		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$out = "<select name=\"table[tip_section_id]\">\n";
		$sqlc_q = "SELECT id,tip_section FROM ".$config->tables['tips_sections'] .
			" ORDER BY tip_section";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__."	show_add_tips_section: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}

		$out .= "<option value=\"0\" selected=\"selected\"></option>\n";
		while ($sections_tmp=$this->db->fetch_array()) {
			$out .= "<option value=\"".$sections_tmp['id']."\">".
				$sections_tmp['tip_section']."</option>\n";
		}
		$this->db->free();

		$out .= "</select>\n";

		$tmp = "<table><tr><td><form method=\"post\" action=\"".
			$config->basehref."admin/tip_section_add.".$config->php."\">\n".
			"<table cellpadding=\"3\" cellspacing=\"3\">\n".
			"<td class=\"newstext\">".lecho("Section")."</td>\n".
			"<td class=\"newstext\">".$out."</td>\n".
			"</tr><tr>\n".
			"<td class=\"newstext\">".lecho("Name")."</td>\n".
			"<td class=\"newstext\">\n".
			"<input type=\"text\" name=\"table[tip_section]\" /></td></tr>\n".
			"<tr><td colspan=\"2\" class=\"newstext\"><center><input ".
			"type=\"submit\" name=\"table[submit]\" value=\"".
			lecho("Submit")."\" /></center></td></tr></table>\n".
			"</form></td></table>\n";

		return $this->html->simplebox($tmp);
	}

	/**
	 * Performs SQL query to add a tip section
	 *@access private
	 *@param array ('tip_section_id' => integer, 'tip_section' => string)
	 *@return mixed string error message if access denied, integer -1 on failure, 1 on success
	 */
	Function do_add_tip_section($row) {
		global $config;
		if (!$this->session->checked || !$this->session->level&pow(2,22)) {
			return $this->utils->no_access_msg();
		}

		$sqlc_q = "INSERT INTO ".$config->tables['tips_sections'].
			" (tip_section_referer_id,tip_section,state) VALUES ('".
			addslashes($row['tip_section_id'])."','".
			addslashes($row['tip_section'])."', '1')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$this->utils->debug("Admin:".__LINE__." do_add_tips_section: ".
				lecho("SQL Failed: ").$this->db->error()." SQL: ".
				$sqlc_q."\n");
			return -1;
		}
		return 1;
	}

	/**
	 * Clears the cache
	 *@return mixed void on success, error message if access denied
	 */
	Function clear_cache() {
		if (!$this->session->is_admin) {
			return $this->utils->no_access_msg();
		}

		$this->cache->delete_files('.',1,1,0,1,'^[0-9]|index,','.');
		$this->cache->delete_files('section',1,1,1,1,'.','.');
		$this->cache->delete_files('topic',1,1,1,1,'.','.');
		$this->cache->delete_files('.',0,1,1,1,'^#','.');
	}

	/**
	 * Switch function
	 * May call exit
	 * Possible actions are:
	 * - edit_news
	 * - mod_news
	 * - edit_users
	 * - edit_topics
	 * - add_topics
	 * - mod_poll
	 * - edit_section
	 * - add_section
	 * - add_tip_section
	 * - list polls
	 * - clear_cache
	 * - edit_theme
	 * - view_theme
	 * - extract_theme
	 * - delete_theme
	 * - gen_rdf
	 * - gen_sidebar
	 *@param string action the action to perform
	 *@param array the HTTP variable table[].
	 *@access public
	 *@global array $HTTP_GET_VARS
	 *@return string the result of the operation
	 */
	Function perform_action ($action,$table) {
		global $HTTP_GET_VARS;

		if ($action == 'edit_news') {
			if (!$this->session->is_moderator) {
				echo $this->utils->no_access_msg();
				exit;
			}

			if (empty($HTTP_GET_VARS['news_id'])) {
				echo lecho("Error");
				exit;
			} else {
				return $this->show_news($HTTP_GET_VARS['news_id']);
			}
		} elseif ($action == 'mod_news') {
			if (!$this->session->is_moderator) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->mod_news($table);
		} elseif ($action == 'edit_users') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['user_id'])) {
				return $this->show_users();
			} else {
				return $this->show_edit_user($HTTP_GET_VARS['user_id']);
			}
		} elseif ($action == 'edit_topics') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['topic_id'])) {
				return $this->show_topics();
			} else {
				return $this->show_edit_topic($HTTP_GET_VARS['topic_id']);
			}
		} elseif ($action == 'add_topics') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->show_add_topic();
		} elseif ($action == 'mod_poll') {
			if (!$this->session->is_moderator) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->poll->edit_poll($table['id']);
		} elseif ($action == 'edit_section') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['section_id'])) {
				return $this->show_sections();
			} else {
				return $this->show_edit_section($HTTP_GET_VARS['section_id']);
			}
		} elseif ($action == 'add_section') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->show_add_section();
		} elseif ($action == 'add_tip_section') {
			if (!$this->session->is_moderator) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->show_add_tip_section();
		} elseif ($action == 'list_polls') {
			if (!$this->session->is_moderator) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->poll->list_polls();
		} elseif ($action == 'clear_cache') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->clear_cache();
		} elseif ($action == 'edit_theme') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->create_theme_tar($HTTP_GET_VARS['theme']);
			}
		} elseif ($action == 'view_theme') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->extract_theme_tar($HTTP_GET_VARS['theme'],0);
			}
		} elseif ($action == 'extract_theme') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			if (empty($HTTP_GET_VARS['theme'])) {
				return $this->show_themes();
			} else {
				return $this->extract_theme_tar($HTTP_GET_VARS['theme'],1);
			}
		} elseif ($action == 'delete_theme') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->delete_theme_tar($HTTP_GET_VARS['theme']);
		} elseif ($action == 'gen_rdf') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->gen_rdf();
		} elseif ($action == 'gen_sidebar') {
			if (!$this->session->is_admin) {
				echo $this->utils->no_access_msg();
				exit;
			}
			return $this->gen_sidebar();
		} else {
			return lecho("Error");
			exit; //useful?
		}
	}

	/**
	 * Only used for moderation type 2
	 * Calls acho and exit on Db failure
	 * For each comment the user has scored, sets the Admin::comments_score[comment_id] to 1.
	 * Does not return any value
	 *@access private
	 *@gloabl integer $news_id the news we are working on -- it's bad!
	 */
	Function comments_scored_user() {
		global $news_id, $config;

		if (isset($news_id)) {
			$this->news_id = $news_id;
		} else {
			$this->news_id = $config->news_id;
		}

		if (!isset($this->comments_scored) ||
			gettype($this->comments_scored) != "array") {

			if ($this->session->user_id > 1) {

				$sqlc_q = "SELECT comments_id FROM ".
					$config->tables['comments_scored_user'].
					",".$config->tables['comments'].
					" WHERE comments_scored_user.user_id='".
					addslashes($this->session->user_id)."' AND ".
					$config->tables['comments'].".news_id='".
					addslashes($this->news_id).
					"' AND comments.id=comments_scored_user.comments_id";
				$ret = $this->db->query($sqlc_q);
				if (!$ret) {
					$this->utils->debug("Admin:".__LINE__."	comments_scored_user: ".
						lecho("SQL Failed: ").$this->db->error().
						" SQL: ".$sqlc_q."\n");
					echo lecho("It looks like admins are working on the server");
					exit;
				}

				if ($this->db->num_rows()>=1) {
					while($row = $this->db->fetch_array()) {
						$this->comments_scored[$row['comments_id']] = 1;
					}

					$this->db->free();
				}

			}
		}

	}

	/**
	 * Creates the necessary HTML for comment scoring
	 *@param integer the user ID unused ????
	 *@param integer the ID of the comment to score
	 *@param string the username
	 *@param string the mail of the user
	 *@param integer the ID of the user
	 *@param string timestamp??? unknow
	 *@param mixed the XP of the user (integer or default empty string)
	 *@param string the homepage of the user
	 *@return string the HTML to score comments
	 *@access private
	 *@todo fix strange code in there, remove global $news_id
	 *@global object Config $config global daCode config
	 *@gloabl integer $news_id the news we are working on -- it's bad!
	 */
	Function comments_showscore($user_id_tmp,$comments_id_tmp,$username_tmp,
					$usermail_tmp,$userid_tmp,$timestamp,$user_xp="",
					$userhomesite_tmp="") {
		global $config,$news_id;

		if ($config->moderation_type == 1) {
			if ($this->session->is_scoror &&
				$this->session->user_id != $userid_tmp) {


				$tmp = "&nbsp; <b>[</b> ";

				for ($i=-1;$i<=5;$i++) {
					$tmp .= '<a href="'.$config->basehref.
						"comments/score.".$config->php."?news_id=".$news_id.
						"&amp;id=".$comments_id_tmp."&amp;score=".$i.
						"\" OnClick=\"window.open('".$config->basehref.
						"comments/score.".$config->php."?news_id=".$news_id.
						"&amp;id=".$comments_id_tmp."&amp;score=".$i."','M',".
						"'toolbar=no,location=no,directories=no,status=no,".
						"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
						"resizable=no,width=100,height=50'); return false\" ".
						"onmouseout=\"javascript: window.status=''; return true;\" ".
						"onmouseover=\"javascript: window.status='".lecho("Score ").$i.
						"'; return true;\">".$i."</a> ";
				}
				$tmp .= "<b>]</b>";
			} else {
				$tmp = '';
			}

			$tmp .= "<br />".lecho("Added by")." " ;
			if ($userid_tmp > 1) {
				$tmp .= '<a href="mailto:'.$usermail_tmp.'">'.$username_tmp.'</a> ';
				$tmp .= "( <a href=\"".$config->basehref."users/?a=vu&amp;user_id=".
					$userid_tmp."\">#".$userid_tmp."</a> ) ";
			} else {
				$tmp .= $username_tmp . ' ';
			}

			if ($this->session->checked && $userid_tmp != 1) {
				$tmp .= '<a href="'.$config->basehref.
					'messages/post.'.$config->php.
					'?user_id_dest='.$userid_tmp.
					'"><img alt="message" border="0" src="'.
					$this->session->imgurl('mail').'" valign="bottom" /></a>';
			}

			if ($userid_tmp > 1 && !$config->disable_view_comments) {

				$tmp .= '<a href="'.$config->basehref.
					'users/posts.'.$config->php.
					'?user_id='.$userid_tmp.'&order=id"><img alt="'.
					lecho("View comments").
					'" border="0" src="'.$this->session->imgurl('view').
					'" /></a>';
			}

			if (!empty($userhomesite_tmp)) {
				$tmp .= '<br /><a href="'.$userhomesite_tmp.'">'.
				$userhomesite_tmp.'</a><br /><br />'."\n";
			} else {
				$tmp .= '<br /><br />';
			}

		} elseif ($config->moderation_type == 2) {

			if (!isset($this->scored_user_launched) ||
					$this->scored_user_launched != 1) {
				$this->comments_scored_user();
				$this->scored_user_launched = 1;
			}


			$tmp = '';
			$actual_time = time();

			if ($this->session->user_id != $userid_tmp &&
				$this->session->vote_nb > 0 &&
				(!isset($this->comments_scored[$comments_id_tmp]) ||
					$this->comments_scored[$comments_id_tmp] != 1) &&
				$timestamp + 2678400 > $actual_time) {


				$tmp .= "&nbsp; <b>[ ";

				$tmp .= '<a href="'.$config->basehref."comments/score.".$config->php.
					'?news_id='.$news_id.'&amp;id='.$comments_id_tmp.
					'&amp;score=-1&amp;localuserid='.$this->session->user_id.
					"\" OnClick=\"window.open('".$config->basehref.
					'comments/score.'.$config->php.
					'?news_id='.$news_id.'&amp;id='.$comments_id_tmp.
					'&amp;score=-1&amp;localuserid='.$this->session->user_id."','M',".
					"'toolbar=no,location=no,directories=no,status=no,".
					"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
					"resizable=no,width=10,height=10'); return false\" ".
					"onmouseout=\"javascript: window.status=''; return true;\" ".
					"onmouseover=\"javascript: window.status='".lecho("Score ")."-'; ".
					"return true;\">-</a>" . lecho(" or ");

				$tmp .= '<a href="'.$config->basehref."comments/score.".$config->php.
					'?news_id='.$news_id.'&amp;id='.$comments_id_tmp.
					'&amp;score=+1&amp;localuserid='.$this->session->user_id.
					"\" OnClick=\"window.open('".$config->basehref.
					'comments/score.'.$config->php.
					'?news_id='.$news_id.'&amp;id='.$comments_id_tmp.
					'&amp;score=+1&amp;localuserid='.$this->session->user_id."','M',".
					"'toolbar=no,location=no,directories=no,status=no,".
					"alwaysRaised=yes,dependant=no,menubar=no,scrollbars=no,".
					"resizable=no,width=10,height=10'); return false\" ".
					"onmouseout=\"javascript: window.status=''; return true;\" ".
					"onmouseover=\"javascript: window.status='".lecho("Score ")."+'; ".
					"return true;\">+</a>";

				$tmp .= " ]</b> ";
			}

			if (isset($this->comments_scored) &&
					isset($this->comments_scored[$comments_id_tmp]) &&
					$this->comments_scored[$comments_id_tmp] == 1 ||
				$userid_tmp == $this->session->user_id ||
				$this->session->checked == 0 ||
				$this->session->vote_nb <= 0 ||
				$timestamp + 2678400 <= $actual_time) {

				$tmp .= "<br />".lecho("Added by")." " ;
				if ($userid_tmp > 1) {
					$tmp .= '<a href="mailto:'.$usermail_tmp.'">'.$username_tmp.'</a> ';
					$tmp .= "( <a href=\"".$config->basehref."users/?a=vu&amp;user_id=".
					$userid_tmp.
							"\">#".$userid_tmp." / ".$user_xp." XP</a> ) ";
				} else {
					$tmp .= $username_tmp . " ( ".$user_xp." XP )";
				}

				if ($this->session->checked && $userid_tmp != 1) {
					$tmp .= ' <a href="'.$config->basehref.
						'messages/post.'.$config->php.
						'?user_id_dest='.$userid_tmp.
						'"><img alt="message" border="0" src="'.
						$this->session->imgurl('mail').'" valign="bottom" /></a> ';
				}

				if (!empty($userhomesite_tmp)) {
					$tmp .= '<br /><a href="'.$userhomesite_tmp.
					'">'.$userhomesite_tmp.'</a><br /><br />';
				} else {
					$tmp .= '<br /><br />';
				}

			} else {
				$tmp .= "<br />".lecho("Must vote to see who posted").'<br /><br />';
			}

		}

		return $tmp;
	}

	/**
	 * Shows the title of a news box
	 * Adds links to edition page if user is admin
	 * FIXME: only called in cache????
	 *@param integer the id of the news (used only for the edit link)
	 *@access public
	 *@return string the HTML formatted title
	 */

	Function news_showedit($news_id) {
		global $config;
		$tmp = "";
		if ($this->session->is_moderator) {
			$tmp .= " - <b><a href=\"".$config->basehref.$config->adminfile.
				"?action=edit_news&amp;news_id=".$news_id."\">".lecho("Edit!").
				"</a></b>";
		}
		return $tmp;
	}

	/**
	 * Shows the title of a webcam sidebox
	 * Adds links to edition page if user is admin
	 * FIXME: only called in cache????
	 *@param integer the id of the webcam (used only for the edit link)
	 *@access public
	 *@return string the HTML formatted title
	 */
	Function webcam_showtitle($webcam_id) {
		global $config;
		$tmp = "";
		if ($this->session->is_moderator || $this->session->is_admin) {
			$tmp .= 'Webcam ... - <a href="'.$config->basehref.
				'webcam/'.$config->webcamadminfile.
				'?webcam_id='.$webcam_id.'">'.lecho("Edit!")."</a>\n";
		} else {
			$tmp .= lecho("Webcam...");
		}

		return $tmp;
	}

	/**
	 * Shows the title of a tip sidebox
	 * Adds links to edition page if user is admin
	 * FIXME: only called in cache????
	 *@param integer the id of the tip (used only for the edit link)
	 *@access public
	 *@return string the HTML formatted title
	 */
	Function tips_showtitle($tip_id) {
		global $config;
		$tmp = "";
		if ($this->session->checked &&
			($this->session->is_moderator || $this->session->is_admin)) {

			$tmp .= '<a href="'.$config->basehref.'tips/">'.lecho("Tip").
				'</a> - <a href="'.$config->basehref.
				'tips/'.$config->tipsadminfile.
				'?tip_id='.$tip_id.'">'.lecho("Edit!")."</a>\n";
		} else {
			$tmp .= '<a href="'.$config->basehref.'tips/">'.lecho("Tip").'</a>';
		}

		return $tmp;
	}

	/**
	 * List all installed themes
	 * FIXME: only called in cache????
	 *@access public
	 *@return mixed array list of themes names or empty string if themes dir not found.
	 */
	Function list_installed_themes() {
		global $config;

		$themes = '';
		$handle=opendir($config->libdir.'themes');
		if (!$handle) {
			return $themes;
		}
		while ($file = readdir($handle)) {
			if ($file == '.' || $file == '..' || $file == 'CVS' ||
					$file.'/' == $config->theme_subdir) {
				continue;
			}
			if (is_dir($config->libdir.'themes/'.$file)) {
				$themes[] = $file;
			}
		}
		closedir($handle);
		if ($config->theme_subdir) {
			$handle=opendir($config->libdir.'themes/'.
				ereg_replace('/$', '', $config->theme_subdir));
			if (!$handle) {
				return $themes;
			}
			while ($file = readdir($handle)) {
				if ($file == '.' || $file == '..' || $file == 'CVS') {
					continue;
				}
				if (is_dir($config->libdir.'themes/'.$config->theme_subdir.$file)) {
					$themes[] = $file;
				}
			}
		}
		closedir($handle);
		return $themes;
	}
	
	/**
	 * List uploaded theme tarballs
	 * Returns void if disabled (upload_tar_dir parameter empty).
	 *@access private
	 *@return mixed void if disabled, array list of tarball otherwise.
	 */
	Function list_uploaded_themes() {
		global $config;

		if (!$config->upload_tar_dir) {
			return;
		}
		$handle=opendir($config->upload_tar_dir);
		if (!$handle) {
			return;
		}
		$themes = '';
		while ($file = readdir($handle)) {
			if (ereg('(.*)-([0-9.]+)\.tar(\.gz)?$', $file, $regs)) {
				$themes[] = $regs[0];
			}
		}
		closedir($handle);
		return $themes;
	}


	/**
	 * Shows the list of themes, with links to create an archive from them, or install uploaded tars
	 *@access private
	 *@return string the HTML formated list of themes.
	 */
	Function show_themes() {
		global $config;

		$tmp = '';
		$themes = $this->list_installed_themes();
		if (is_array($themes)) {
			$tmp .= '<div class="bgtext"><h2>'.
				lecho("Create archive of existing theme")."</h2>\n";
			$tmp .= "<ul>\n";
			while ($theme = each($themes)) {
				$tmp .= '  <li><a href="'.
					$config->basehref.$config->adminfile.
					'?action=edit_theme&amp;theme='.
					$theme[1].'">'.$theme[1]."</a></li>\n";
			}
			$tmp .= '</ul>';
		}

		$themes = $this->list_uploaded_themes();
		if (is_array($themes)) {
			$tmp .= '<h2>'.lecho("Install new theme")."</h2>\n";
			$tmp .= "<ul>\n";
			while ($theme = each($themes)) {
				$tmp .= '  <li><a href="'.
					$config->basehref.$config->adminfile.
					'?action=view_theme&amp;theme='.
					$theme[1].'">'.$theme[1]."</a></li>\n";
			}
			$tmp .= '</ul></div>';
		}
		return $tmp;
	}


	/**
	 * Create an archive out of an installed theme
	 * Calls exit if user not admin
	 *@param string name of the theme
	 *@param string version version number of the theme
	 *@access private
	 *@return string status message
	 */ 
	Function create_theme_tar($theme,$version='0.1') {
		global $config,$topdir,$libdir;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo $this->utils->no_access_msg();
			exit;
		}
		if (!$config->create_tar_dir) {
			return lecho("Variable config->create_tar_dir is empty, function disabled");
		}
		if (is_dir($libdir.'themes/'.$theme)) {
			$theme_dir = 'themes/'.$theme;
		} elseif (is_dir($libdir.'themes/'.$config->theme_subdir.$theme)) {
			$theme_dir = 'themes/'.$config->theme_subdir.$theme;
		} else {
			return lecho("Theme not found -&gt; ").$theme;
		}

		if (!file_exists($libdir.$theme_dir.'/VERSION')) {
			return lecho("Error: file not found -&gt; ").
				$libdir.$theme_dir."/VERSION <br />\n";
		}

		$text = file ($libdir.$theme_dir.'/VERSION');
		//   Check for theme format.
		//   This is currently useless, but may be used later
		if (ereg('^[0-9]+$',$text[0])) {
			$theme_name = trim($text[1]);
			$version = trim($text[2]);
		} else {
			$theme_name = trim($text[0]);
			$version = trim($text[1]);
		}
		if ($theme != $theme_name) {
			return lecho("Error: incorrect theme name in ").
				$libdir.$theme_dir."/VERSION <br />\n";
		}

		//   We will chdir to $config->topdir when creating tarfile,
		//   so we must set $libdir according to this fact.
		$save_topdir = $config->topdir;
		$topdir = './';
		include $config->topdir.'dacode.'.$config->php;

		$contents = array($libdir.$theme_dir);
		if (file_exists($save_topdir.$theme_dir)) {
			$contents[] = $topdir.$theme_dir;
		}
		$excl = array(
			'(.*/)?CVS', '(.*/)?.cvsignore',
			//   For security reasons, we forbid inclusion of
			//   config.* files
			'config\.'
		);
		$id = 'daCode-'.$theme.'-'.$version;
		$subs = array(
			'^', $id.'/',
			"^$id/".$libdir.$theme_dir, "$id/templates",
			"^$id/".$topdir.$theme_dir, "$id/html"
		);
		if (function_exists('gzopen')) {
			$tarfile = $config->create_tar_dir.$id.'.tar.gz';
			$gz = 1;
		} else {
			$tarfile = $config->create_tar_dir.$id.'.tar';
			$gz = 0;
		}
		if ($this->tar->create($tarfile, $contents,
				$gz, $excl, $subs, $save_topdir)) {
			return  lecho("Archive file created -&gt; ")."$tarfile<br />\n";
		} else {
			return lecho("Unable to create archive")."<br />\n";
		}
	}

	/**
	 * Unpacks a theme tarball
	 * Calls exit if user is not admin
	 *@param string the name of the tar file
	 *@param integer the action to do: 1 extract, 2 show content of $file, else list content (sure??)
	 *@param string file name of the file to display (only useful if action == 2 ?)
	 *@access private
	 *@return string result or error message
	 */
	Function extract_theme_tar($tarfile,$action,$file="") {
		global $config;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo $this->utils->no_access_msg();
			exit;
		}

		if (!$config->upload_tar_dir) {
			return lecho("Variable config->create_tar_dir is empty, function disabled");
		}
		$tarpath = $config->upload_tar_dir.$tarfile;

		//   Retrieve informations from the VERSION file
		ereg('(.*-[0-9.]+)\.tar(\.gz)?$', $tarfile, $regs);
		$id = $regs[1];
		$gz = (isset($regs[2]) && $regs[2] ? 1 : 0);
		$infos = split("\n",
			$this->tar->file_content($tarpath,$gz,$id.'/templates/VERSION'));
		if (!is_array($infos)) {
			return lecho("Error: This doesn't look to be a valid theme's archive.");
		}

		$out = '';
		//   Check for theme format.
		//   This is currently useless, but may be used later
		if (ereg('^[0-9]+$',$infos[0])) {
			if ($infos[0] > 1) {
				$out .= '<p>'.
					lecho("<b>Warning</b>: theme created with a previous version ").
					lecho("of daCode. It may generate errors").
					'</p>';
			}
			$theme = trim($infos[1]);
			$version = trim($infos[2]);
		} else {
			$theme = trim($infos[0]);
			$version = trim($infos[1]);
		}
		$id = 'daCode-'.$theme.'-'.$version;

		$subs = array(
			"^$id/html", "$id/".$config->topdir.'themes/'.
				$config->theme_subdir.$theme,
			"^$id/templates", "$id/".$config->libdir.'themes/'.
				$config->theme_subdir.$theme,
			"^$id/", ''
		);
		if ($action == 1) {
			if ($this->tar->extract($tarpath, $gz, $subs)) {
				$out .= lecho("Theme correctly installed -&gt; ")."<br />\n";
			}
		} elseif ($action == 2) {
			$out .= $this->tar->file_content($tarpath,$gz,$file,$subs);
		} else {
			$list = $this->tar->files($tarpath, $gz, $subs);
			$out .= '<h2>'.lecho("Content of archive")." $tarpath</h2>\n";
			$out .= "<ul>\n";
			while ($f = each($list)) {
				$out .= '  <li><a href="'.
					$config->basehref.'admin/viewfile.'.$config->php.
					'?theme='.$tarfile.'&amp;file='.
					urlencode($f[1]).
					'">'.$f[1]."</a>\n";
			}
			$out .= "</ul>\n";
			$out .= '<br /><a href="'.
				$config->basehref.$config->adminfile.'?action=extract_theme'.
				'&amp;theme='.$tarfile.
				'">'.lecho("Install")."</a>\n";
			$out .= '<br /><a href="'.
				$config->basehref.$config->adminfile.'?action=delete_theme'.
				'&amp;theme='.$tarfile.
				'">'.lecho("Delete")."</a>\n";
		}
		return $out;
	}

	/**
	 * Deletes a tarball for a theme
	 * Calls exit in case the user is not admin.
	 *@param string name of the theme
	 *@access private
	 *@return mixed void if upload_tar_dir not configured, string ?? on success, error msg on failure.
	 */
	Function delete_theme_tar($theme) {
		global $config;

		//   Must be run by admin only for security reason
		if (!$this->session->is_admin) {
			echo $this->utils->no_access_msg();
			exit;
		}

		if (!$config->upload_tar_dir) {
			return;
		}

		if (unlink($config->upload_tar_dir.$theme)) {
			return $this->show_themes();
		} else {
			return lecho("Error: unable to remove the theme ").
				$config->upload_tar_dir.$theme."<br />\n";
		}
	}

	/**
	 * Function that generates a RDF backend file called backend.rss
	 * Writes the RDF file.
	 *@access private
	 *@return string a message about operations
	 */
	Function gen_rdf() {
		global $config,$topdir;
		$backendfile = $topdir . $config->backendfile;

		if (file_exists($backendfile)) {
			@unlink($backendfile);
		}

		$tmp = '';
		$out = '';

		$tmp .= '<?xml version="1.0" encoding="'.$config->encodingcharset.'" ?>'.
			"\n";
		$tmp .= '<rdf:RDF'."\n".
			' xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns"'."\n".
			' xmlns="http://my.netscape.com/publish/formats/rss-0.91.dtd"'."\n".'>';
		$tmp .= "\n".'  <channel>'."\n".
			'    <title>'.$config->titledefault.'</title>'."\n".
			'    <link>'.$config->baseurl.'</link>'."\n".
			'    <description>'.$config->description.'</description>'."\n".
			'    <language>'.$config->defaultlang.'</language>'."\n".
			'  </channel>'."\n";

		$newstempo = $this->news->get_news(20,0,0,1,1,0,0);

		if (gettype($newstempo) == 'array') {
			reset($newstempo);
			while (list($key, $cur) = each($newstempo)) {
				$this->utils->debug("Call to newsurl");
				ereg('^([0-9]{4})([0-9]{2})([0-9]{2})', $cur['timestamp'], $res);
				$tmp .= '  <item>'."\n";
				$tmp .= '    <title>'.$cur['title'].'</title>'."\n";
				$tmp .= '    <link>'.
					$this->session->newsurls($cur['id'],0,0,$res[1],$res[2],$res[3], -2, 1, 1).
					'</link>'."\n";
				$tmp .= '  </item>'."\n";
			}
		}

		$tmp .= '</rdf:RDF>';

		$this->utils->write_file($backendfile, $tmp);

		if (file_exists($backendfile)) {
			$out .= lecho(" done!");
		} else {
			$out .= lecho(" failed!");
		}

		return $out;
	}

	/**
	 * Function that generates a Mozilla/Netscape 6 Sidebar.
	 *@access private
	 *@return string message about progress
	 */
	Function gen_sidebar() {
		global $config,$topdir;
		$sidebarfile = $topdir.'sidebar/'.$config->sidebarfile;

		if (file_exists($sidebarfile)) {
			@unlink($sidebarfile);
		}

		$tmp = '';
		$out = '';

		$tmp .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"'.
			' "DTD/xhtml1-transitional.dtd">';
		$tmp .= '<html>'."\n";
		$tmp .= '  <head>'."\n";
		$tmp .= '    <title>'.$config->name.'</title>'."\n";
		$tmp .= '    <meta http-equiv="Content-Type" content="text/html; '.
			'charset='.$config->encodingcharset.'" />'."\n";
		if (!empty($config->sidebarrefresh)) {
			$tmp .= '    <meta http-equiv="refresh" content="'.
				$config->sidebarrefresh.'; url='.$config->basehref.'sidebar/'.
				$config->sidebarfile.'" />'."\n";
		}
		$tmp .= '  </head>'."\n";
		$tmp .= '  <body>'."\n";
		$tmp .= '    <a href="'.$config->basehref.'" target="_content">'."\n";
		$tmp .= '      <img src="'.$this->session->imgurl($config->minilogo,"jpg").
			'" alt="'.$config->titledefault.'" border="0" />';
		$tmp .= '    </a>'."\n";
		$tmp .= '    <br /><br />'."\n";
		$tmp .= '    '.lecho("Latest news:")."\n";
		$tmp .= '    <br />'."\n";
		$tmp .= '    <ul>'."\n";

		$newstempo = $this->news->get_news(8,0,0,1,1,0,0);

		if (gettype($newstempo) == "array") {
			reset($newstempo);
			while (list($key, $cur) = each($newstempo)) {
				ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $cur['timestamp'], $res);
				$tmp .= '      <li>'."\n";
				$tmp .= '        <a href="'.
					$this->session->newsurls($cur['id'],0,0,$res[1],$res[2],$res[3]).
					'" target="_content">'."\n";
				$tmp .= '          '.htmlentities($cur['title'])."\n";
				$tmp .= '        </a>'."\n";
				$tmp .= '      </li>'."\n";
			}
		}
		$tmp .= '    </ul>'."\n";
		$tmp .= '    <br />'."\n";
		$tmp .= '    <hr />'."\n";
		$tmp .= '    <br />'."\n";
		$tmp .= '    '.lecho("Last modified at ").date("H:i:s");
		if (!empty($config->sidebarrefresh)) {
			$tmp .= '    <br />'."\n";
			$tmp .= lecho("Refresh itself every ").$config->sidebarrefresh.
				lecho(" seconds");
		}
		$tmp .= '  </body>'."\n";
		$tmp .= '</html>';

		$this->utils->write_file($sidebarfile, $tmp);

		if (file_exists($sidebarfile)) {
			$out .= lecho(" done!");
		} else {
			$out .= lecho(" failed!");
		}

		return $out;
	}

}

?>
