#!/usr/bin/perl -w
#
# $Id: daily.pl,v 1.1.2.1 2001/12/18 08:12:30 netsabes Exp $
#
# This is a script you might want to run daily.
# A Cron module will replace this script, later...
#
use strict;
my $login_sql = "dacode";
my $passwd_sql = "XXXXXXXX";
my $database = "dacode";

my($TIME) = time;
$TIME = $TIME - 86400;

my ($lmday_today,$lmon_today,$lyear_today,$lwday_today) = 
        (localtime($TIME))[3,4,5,6];

$lmon_today+=1;
$lyear_today+=1900;
if ($lmday_today <= 9) { $lmday_today = "0$lmday_today"; }
if ($lmon_today <= 9) { $lmon_today = "0$lmon_today"; }

use DBI;

my $dbh = DBI->connect("DBI:mysql:$database:localhost:3306", $login_sql, 
	$passwd_sql, { RaiseError => 1}) or die "connecting : $DBI::errstr\n";



##############################################################################################
# We erase old sessions
########
my $q = "DELETE FROM sessions WHERE expire < \"$lyear_today$lmon_today$lmday_today"."000000\"";
my $sth = $dbh->prepare($q);
my $rc=$sth->execute;
if (!defined($rc)) {
	print "$dbh->errstr<-\n";
	exit 0;
}
$sth->finish;
##############################################################################################

##############################################################################################
# We erase old board
##############################################################################################
$q = "DELETE FROM board WHERE timestamp < \"$lyear_today$lmon_today$lmday_today"."000000\" AND section='1'";
$sth = $dbh->prepare($q);
$rc=$sth->execute;
if (!defined($rc)) {
	print "$dbh->errstr<-\n";
	exit 0;
}
$sth->finish;
##############################################################################################

##############################################################################################
# We generate votes
##############################################################################################
my @array_vote = (
	{'name'=>'initiate',   'xp'  =>'0',  'vote'=>'0'},
	{'name'=>'novice',     'xp'=>'20',   'vote'=>'5'},
	{'name'=>'acolyte',    'xp'=>'50',   'vote'=>'8'},
	{'name'=>'scribe',     'xp'=>'100',  'vote'=>'12'},
	{'name'=>'monk',       'xp'=>'200',  'vote'=>'16'},
	{'name'=>'friar',      'xp'=>'500',  'vote'=>'20'},
	{'name'=>'abbot',      'xp'=>'1000', 'vote'=>'25'},
	{'name'=>'bishop',     'xp'=>'1600', 'vote'=>'30'},
	{'name'=>'pontiff',    'xp'=>'2300', 'vote'=>'35'},
	{'name'=>'saint',      'xp'=>'3000', 'vote'=>'40'},
	{'name'=>'god',        'xp'=>'5000', 'vote'=>'100'}
);

# We get sessions which are from yesterday
$q = "SELECT user_id FROM sessions WHERE lastseen > \"$lyear_today$lmon_today$lmday_today"."000000\" GROUP BY user_id";
$sth = $dbh->prepare($q);
$rc=$sth->execute;
if (!defined($rc)) {
	print "$dbh->errstr<-\n";
	exit 0;
}
my %sessions;
while (my (@row) = $sth->fetchrow) {
	$sessions{$row[0]} = 1;
}
$sth->finish;

# We looks at votes then
$q = "SELECT vote_nb,vote_nb_orig,experience,user_id FROM karma_user";
my @users;
$sth = $dbh->prepare($q);
$rc=$sth->execute;
if (!defined($rc)) {
	print "$dbh->errstr<-\n";
	exit 0;
}
while (my (@row) = $sth->fetchrow) {
	push @users,  \@row  ;
}
$sth->finish;

srand ( time() ^ ($$ + ($$ << 15)) );
my %changed;
foreach my $user (@users) {
	if (exists($sessions{$user->[3]}) &&
		$sessions{$user->[3]} == 1) {
		my $X=1;
		my $Y = 4;
		my $random = int ( rand( $Y - $X+1 ) ) + $X;
		if ($random == 1) {
			# print $user->[3] . "'s XP was: ". $user->[2] ." and now it is ". ($user->[2] + 2) . "\n";
			$user->[2] += 2;
			$changed{$user->[3]} = 1;
		} else {
			# print $user->[3] . " didn't win! XP is still ". $user->[2] ."\n";
		}
	}
	my $vote_tmp; my $i=0;
	foreach my $vote (@array_vote) {
		if ($user->[2] >= $vote->{xp}) {
			$vote_tmp = $vote->{vote};
			$i++;
			next;
		} else {
			if ($user->[1] <= $vote_tmp) {
				$user->[1] = $vote_tmp;
				$changed{$user->[3]} = 1;
			}

			if ($user->[0] <= 0 &&
				$i <= 5) {
				$user->[1] += int ( $user->[1] / 6 );
				$changed{$user->[3]} = 1;
			}

			if ($user->[0] != $user->[1]) {
				$user->[0] = $user->[1];
				$changed{$user->[3]} = 1;
			}
				
			last;
		}
	}

	if (exists($changed{$user->[3]}) &&
		$changed{$user->[3]} == 1) {

		$q = "UPDATE karma_user set vote_nb='".$user->[0]."',vote_nb_orig='".$user->[1]."',experience='".$user->[2].
			"' WHERE user_id='".$user->[3]."'";
		$sth = $dbh->prepare($q);
		$rc=$sth->execute;
		if (!defined($rc)) {
			print "$dbh->errstr<-\n";
			exit 0;
		}
		$sth->finish;
	}
	
}
##############################################################################################


##############################################################################################
# We remove old comments_user_scored entries (don't need it as we don't allow to vote if comments is one month old
##############################################################################################
$TIME = time;
$TIME = $TIME - 2678400;

($lmday_today,$lmon_today,$lyear_today,$lwday_today) = 
        (localtime($TIME))[3,4,5,6];

$lmon_today+=1;
$lyear_today+=1900;
if ($lmday_today <= 9) { $lmday_today = "0$lmday_today"; }
if ($lmon_today <= 9) { $lmon_today = "0$lmon_today"; }
$q = "SELECT comments_scored_user.user_id,comments_scored_user.comments_id from comments_scored_user,comments WHERE comments.id=comments_scored_user.comments_id AND comments.timestamp < \"$lyear_today$lmon_today$lmday_today"."000000\"";
$sth = $dbh->prepare($q);
$rc=$sth->execute;
if (!defined($rc)) {
	print "$dbh->errstr<-\n";
	exit 0;
}
my @old = ();
while (my (@row) = $sth->fetchrow) {
	push @old, \@row;
}
$sth->finish;

foreach my $old (@old) {
	print $old->[0] . ":" . $old->[1] . "\n";

	$q = "DELETE FROM comments_scored_user WHERE user_id='".$old->[0]."' AND comments_id='".$old->[1]."'";
	$sth = $dbh->prepare($q);
	$rc=$sth->execute;
	if (!defined($rc)) {
		print "$dbh->errstr<-\n";
		exit 0;
	}
	$sth->finish;
}

$dbh->disconnect();
