/* utils.m - this file is part of Cynthiune
 *
 * Copyright (C) 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <Wolfgang@Contre.COM>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>

NSString *
timeStringFromSeconds (unsigned int seconds)
{
  NSString *timeString;
  unsigned int hours, minutes;

  if (seconds)
    {
      hours = seconds / 3600;
      if (hours)
	seconds = seconds % (hours * 3600);
      minutes = seconds / 60;
      if (minutes)
	seconds = seconds % (minutes * 60);
    }
  else
    {
      hours = 0;
      minutes = 0;
    }

  timeString = (hours)
    ? [NSString stringWithFormat: @"%d:%.2d:%.2d", hours, minutes, seconds]
    : [NSString stringWithFormat: @"%d:%.2d", minutes, seconds];

  return timeString;
}

static NSArray *
_linesFromContent (NSData *content)
{
  NSMutableArray *fileLines;
  NSString *currentNSLine;
  const char *currentLine, *bytePtr, *maxByte;

  fileLines = [[NSMutableArray alloc] init];

  currentLine = [content bytes];
  maxByte = currentLine + [content length];
  bytePtr = currentLine;

  while (bytePtr < maxByte)
    {
      if (*bytePtr == '\n' || *bytePtr == '\r')
        {
          currentNSLine = [NSString stringWithCString: currentLine
                                    length: (bytePtr - currentLine)];
          [fileLines addObject: currentNSLine];
          if (*bytePtr == '\r')
            bytePtr++;
          currentLine = bytePtr + 1;
        }
      bytePtr++;
    }

  if (currentLine < bytePtr)
    {
      currentNSLine = [NSString stringWithCString: currentLine
                                length: (bytePtr - currentLine)];
      [fileLines addObject: currentNSLine];
    }

  return fileLines;
}

NSArray *
linesOfFile (NSString *aFile)
{
  NSFileHandle *fileHandle;
  NSData *fileContent;
  NSArray *fileLines;

  fileHandle = [NSFileHandle fileHandleForReadingAtPath: aFile];
  fileContent = [fileHandle readDataToEndOfFile];
  fileLines = _linesFromContent (fileContent);
  [fileHandle closeFile];

  return fileLines;
}

void
logRect (NSRect *rect)
{
  NSLog (@"rect = (%f, %f, %f, %f);",
         rect->origin.x, rect->origin.y,
         rect->size.width, rect->size.height); 
}
