/* PreferencesController.m - this file is part of Cynthiune
 *
 * Copyright (C) 2003 Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <Wolfgang@Contre.COM>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <AppKit/AppKit.h>

#import "GeneralPreference.h"
#import "MainController.h"
#import "Preference.h"
#import "PreferencesController.h"

#if defined (NeXT_PDO) || defined (__APPLE__)
#define _(X) NSLocalizedString (X, nil)
#define NSDebugLog
#endif

@implementation PreferencesController : NSObject

+ (PreferencesController *) preferencesController
{
  static PreferencesController *singleton = nil;

  if (!singleton)
    singleton = [[self alloc] _init];

  return singleton;
}

- (PreferencesController *) _init
{
  if ((self = [super init]))
    {
      currentView = nil;
      preferenceList = [[NSMutableArray alloc] init];
      [preferenceList addObject: [GeneralPreference class]];
    }

  return self;
}

- (void) registerPreferenceClass: (Class) aClass
{
  if ([aClass conformsToProtocol: @protocol(Preference)]
      && ![preferenceList containsObject: aClass])
    [preferenceList addObject: aClass];
  else
    NSLog (@"Class '%@' not conform to 'Preference' protocol...\n",
           NSStringFromClass (aClass));
}

- (void) _setupMenuEntries
{
  Class currentClass;
  id <Preference> instance;
  int count, max;

  [bundleSelector removeAllItems];
  max = [preferenceList count];

  for (count = 0; count < max; count++)
    {
      currentClass = [preferenceList objectAtIndex: count];
      instance = [currentClass instance];
      [bundleSelector addItemWithTitle: [instance preferenceTitle]];
    }
}

- (void) loadPreferencesWindow
{
  Class bundleClass;

  [NSBundle loadNibNamed: @"Preferences" owner: self];
  [self _setupMenuEntries];

  bundleClass = [preferenceList objectAtIndex: 0];
  [self setBundleClass: bundleClass];

#ifndef NeXT_PDO
  [prefsWindow setLevel: NSModalPanelWindowLevel];
#endif
  [prefsWindow setTitle: _(@"Preferences")];
  [prefsWindow center];
  [prefsWindow orderWindow: NSWindowAbove
               relativeTo: [[NSApp mainWindow] windowNumber]];
  [prefsWindow makeKeyAndOrderFront: self];
  [prefsWindow setDelegate: self];
}

- (void) windowWillClose: (NSNotification *) aNotif
{
  id <Preference> instance;

  instance = [currentBundleClass instance];
  [instance save];
}

- (NSWindow *) window
{
  return prefsWindow;
}

- (void) setBundleClass: (Class) aClass
{
  NSView *prefsView;
  id <Preference> instance;

  instance = [aClass instance];
  prefsView = [instance preferenceSheet];
  [self setBundleView: prefsView];

  currentBundleClass = aClass;
}

- (void) bundleChanged: (id)sender
{
  NSString *newTitle;
  Class bundleClass;
  id <Preference> instance;

  newTitle = [sender titleOfSelectedItem];
  [sender setTitle: newTitle];
  [sender synchronizeTitleAndSelectedItem];
  bundleClass = [preferenceList objectAtIndex: [sender indexOfSelectedItem]];
  if (currentBundleClass != bundleClass)
    {
      instance = [currentBundleClass instance];
      [instance save];
      [self setBundleClass: bundleClass];
    }
}

- (void) setBundleView: (id) bundlePrefsView
{
  NSRect boxViewFrame, viewFrame;
  NSArray *subviews;
  NSView *contentView;

  contentView = [bundleViewBox contentView];
  subviews = [contentView subviews];
  if ([subviews count])
    [[subviews objectAtIndex: 0] removeFromSuperview];

  if (bundlePrefsView)
    {
      boxViewFrame = [contentView bounds];
      viewFrame = [bundlePrefsView frame];
      viewFrame.origin.x = (boxViewFrame.size.width
                            - viewFrame.size.width) / 2;
//       viewFrame.origin.y = (boxViewFrame.size.height
//                             - viewFrame.size.height) / 2 + 10.0;
      viewFrame.origin.y = (boxViewFrame.size.height
                            - viewFrame.size.height) / 2;

      [bundlePrefsView setFrame: viewFrame];
      [contentView addSubview: bundlePrefsView];
      [bundlePrefsView release];
    }
}

@end
