/* Player.h - this file is part of Cynthiune
 *
 * Copyright (C) 2002-2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef Player_H
#define Player_H

@class NSNotification;
@class NSString;

@class Song;

#ifdef PLAYER_M
NSString *PlayerPlayingNotification;
NSString *PlayerStoppedNotification;
NSString *PlayerPausedNotification;
NSString *PlayerResumedNotification;
NSString *PlayerSongEndedNotification;
NSString *PlayerUpdateTimerNotification;
#else
extern NSString *PlayerPlayingNotification;
extern NSString *PlayerStoppedNotification;
extern NSString *PlayerPausedNotification;
extern NSString *PlayerResumedNotification;
extern NSString *PlayerSongEndedNotification;
extern NSString *PlayerUpdateTimerNotification;
#endif

@interface PlayerBase : NSObject
{
  id _delegate;
}

- (id) init;

- (id) delegate;
- (void) setDelegate: (id) anObject;

- (void) postPlayingNotification;
- (void) postStoppedNotification;
- (void) postPausedNotification;
- (void) postResumedNotification;
- (void) postSongEndedNotification;

@end

@interface NSObject (PlayerBaseDelegate)

- (void) playerPlayingNotification: (NSNotification*) aNotification;
- (void) playerStoppedNotification: (NSNotification*) aNotification;
- (void) playerPausedNotification: (NSNotification*) aNotification;
- (void) playerResumedNotification: (NSNotification*) aNotification;
- (void) playerSongEndedNotification: (NSNotification*) aNotification;

@end

@protocol Player <NSObject>

- (id) initWithSong: (Song *) aSong;

- (Song *) song;
- (void) setSong: (Song *) aSong;

- (void) audioInit;

- (int) timer;

- (BOOL) isRunning;

- (void) startPlayLoop;
- (void) stopPlayLoop;

- (void) setPaused: (BOOL) paused;
- (BOOL) paused;
- (void) setMuted: (BOOL) muted;
- (BOOL) muted;

- (void) seek: (unsigned int) aPos;

@end

#endif /* Player_H */
