/*
-------------------------------------------------------------------------
 CxxTest: A lightweight C++ unit testing library.
 Copyright (c) 2008 Sandia Corporation.
 This software is distributed under the LGPL License v3
 For more information, see the COPYING file in the top CxxTest directory.
 Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
 the U.S. Government retains certain rights in this software.
-------------------------------------------------------------------------
*/

#ifndef __cxxtest__MSVCErrorPrinter_h__
#define __cxxtest__MSVCErrorPrinter_h__

//
// The MSVCErrorPrinter is identical to the ErrorPrinter, except it
// prints the line number and error/warning strings in a format
// consistent with that generated by Microsoft's compiler.
//
// Strict error parsers (e.g. QtCreator's) expect each error to be
// followed by a proper-looking error code, so give them one to make
// them work. Same for warnings.
//
// C2999 : "Unknown error" from Visual Studio 6, no longer used.
// C4999 : "Unknown warning" from Visual Studio 6, no longer used.
//

#include <cxxtest/ErrorPrinter.h>

namespace CxxTest {
class MSVCErrorPrinter : public ErrorPrinter {
public:
    MSVCErrorPrinter(CXXTEST_STD(ostream) &o = CXXTEST_STD(cout))
        : ErrorPrinter(o, "(", ") ", "error C2999", "warning C4999") {}
};
}

#endif // __cxxtest__MSVCErrorPrinter_h__
