#!/usr/bin/ruby -w
# -*- ruby -*-

require './file'
require './log'
require './cvsaddset'

# Executes CVS commands.

class CVSExecute

  attr_accessor :confirm, :diagnose
  
  def initialize(added, deleted)
    @added = if added.kind_of?(Hash) then added.keys else added end
    @deleted = if deleted.kind_of?(Hash) then deleted.keys else deleted end
    @confirm = false
    @diagnose = false
  end
  
  def run
    print "\nEXECUTING COMMANDS\n"
    
    print "\n    ADDs\n"

    if @added.length > 0
      addset = CVSAddSet.new(@added)
      addset.addlists.each do |list|
        names = list.collect { |entry| entry.name }
        execute_command(names, "add")
      end
    end

    if @confirm
      dels = @deleted.reject do |name|
        print "delete " + name + "? "
        ans = $stdin.readline
        ans.upcase[0, 1] != 'Y'
      end
    else
      dels = @deleted
    end

    print "\n    DELETEs\n"
    execute_command(dels, "remove")
  end

  def execute_command(names, command)
    if names.size > 0
      # Quote file names, so that spaces are essentially escaped.
      # TODO: Handle file names that have doublequotes in them.
      cmd = "cvs " + command + ' ' + names.collect { |n| '"' + n + '"' }.join(" ")
      print "        ", cmd, "\n"
      unless diagnose
        system(cmd)
      end
    else
      Log.log "no files to " + command
    end
  end

end


if __FILE__ == $0
  Log.verbose = true
#   exec = CVSExecute.new([ "foo/bar.bog", "foo/biz/foog.oqz", "foo/biz/foog.flt", "bhai/spork.ext", "bhai/foon.ext" ],
#                         [ "goner.bog" ])
#   exec.diagnose = true
#   exec.run

  exec = CVSExecute.new(%w{abc/zyz.bog
                           boo.txt
                           t/test_nonexistent.rb
                         },
                         %w{})
  exec.run
end
