%define cvsd_homedir /var/lib/cvsd

Name: cvsd
Summary: Chroot wrapper to run `cvs pserver' more securely
Version: 1.0.4
Release: 1
URL: http://tiefighter.et.tudelft.nl/~arthur/cvsd/
Source: http://tiefighter.et.tudelft.nl/~arthur/cvsd/cvsd-%{version}.tar.gz
License: GPL
Group: Network/Daemons
Requires: cvs chkconfig
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

%description
cvsd is a wrapper program for cvs in pserver mode. it will run 'cvs pserver'
under a special uid/gid in a chroot jail. cvsd is run as a daemon and is
controlled through a configuration file. It is relatively easy to configure
and provides tools for setting up a rootjail.

This server can be useful if you want to run a public cvs pserver. You
should however be aware of the security limitations of running a cvs
pserver. If you want any kind of authentication you should really consider
using secure shell as a secure authentication mechanism and transport.
Passwords used with cvs pserver are transmitted in plaintext.

%prep
%setup -q

%build
./configure --prefix=%{_prefix} --mandir=%{_mandir} --sysconfdir=%{_sysconfdir}
make

%install
[ "$RPM_BUILD_ROOT" = "/" ] || rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install-strip
rm $RPM_BUILD_ROOT/%{_sysconfdir}/init.d/cvsd
rmdir $RPM_BUILD_ROOT%{_sysconfdir}/init.d/
install -d $RPM_BUILD_ROOT%{_initrddir}
install -m755 cvsd.init.redhat71 $RPM_BUILD_ROOT%{_initrddir}/cvsd
[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress

%clean
[ "$RPM_BUILD_ROOT" = "/" ] || rm -rf $RPM_BUILD_ROOT

%files
%doc README TODO AUTHORS ChangeLog NEWS FAQ COPYING
%defattr(644,root,root,755)

%config(noreplace) %{_sysconfdir}/cvsd/cvsd.conf
%{_mandir}/*/*
%attr(755,root,root)    %{_sbindir}/*
%attr(755,root,root)    %{_initrddir}/cvsd

%pre
getent group cvsd > /dev/null || \
  groupadd cvsd
getent passwd cvsd > /dev/null || \
  useradd -r -M -d %{cvsd_homedir} -s /bin/false \
  -c "cvs pserver daemon" -g cvsd cvsd
[ -e %{cvsd_homedir} ] || \
  mkdir -m755 %{cvsd_homedir}

%post
cvsd-buildroot %{cvsd_homedir}
/sbin/chkconfig --add cvsd

%postun
if [ "$1" = 0 ]; then
  userdel -r cvsd 2>/dev/null || :
  groupdel cvsd 2>/dev/null || :
  rmdir %{cvsd_homedir} 2>/dev/null || :
fi
