#!/bin/sh
src=`pwd`
tmp=$src/tests-tmp
rm -rf $tmp
mkdir -p $tmp
PATH="$src:/bin:/usr/bin:/usr/local/bin"
tests_failed=0
tests_count=0
_UID=`id -u`
_GID=`id -g`
CVM_PWFILE_PATH=$tmp/pwfile
export CVM_PWFILE_PATH
make_pwfile()
{
  (
    echo 'pwfuser:testpass:123:456:Gecos,xyz:/home/ftp:/bin/false'
    echo 'cryptuser:tpzv1IkcX9.fE:234:567:Crypt:/home/crypt:/bin/true'
  ) >$CVM_PWFILE_PATH
}
testc() { ./cvm-testclient ./cvm-vmailmgr "$@"; }
testl() { CVM_LOOKUP_SECRET=secret ./cvm-testclient ./cvm-vmailmgr "$@"; }
testq() { CVM_LOOKUP_SECRET=secret ./cvm-testclient ./cvm-qmail "$@"; }

QMAIL_ROOT=$tmp
export QMAIL_ROOT

mkdir $tmp/users
(
  uid=`id -u`
  gid=`id -g`
  len=`echo $tmp $uid $gid | wc -c`
  printf "+6,%d:!user\0->user\0000$uid\0000$gid\0000$tmp\0\0\n" $(($len+6))
  printf "+6,%d:!user-->user\0000$uid\0000$gid\0000$tmp\0-\0\n" $(($len+7))
  printf "+1,%d:!->alias\0000$uid\0000$gid\0000$tmp/alias\0-\0\n" $((len+14))
  echo
) | cdbmake $tmp/users/cdb $tmp/users/tmp

mkdir $tmp/control
echo local.dom >$tmp/control/locals
echo test.tld:user >$tmp/control/virtualdomains
mkdir $tmp/alias
echo \# >$tmp/.qmail-wild-default
echo \# >$tmp/.qmail-addr
echo \# >$tmp/alias/.qmail-alias
echo \# >$tmp/alias/.qmail-awild-default

(
  printf '+4,69:virt->\x2\x8\x1\0$1$aSoIrl/J$TmAwoxKzrPJ0IaW5UvX4A0\0./virt\0\0\0-\0-\0-\0-\00001016731358\0-\0\n'
  echo
) | cdbmake $tmp/passwd.cdb $tmp/passwd.tmp

run_compare_test() {
  local name=$1
  shift
  sed -e "s:@SOURCE@:$src:g"   	-e "s:@TMPDIR@:$tmp:g"   	-e "s:@UID@:$_UID:" 	-e "s:@GID@:$_GID:" 	>$tmp/expected
  ( runtest "$@" ) 2>&1 >$tmp/actual-raw
  cat -v $tmp/actual-raw >$tmp/actual
  if ! cmp $tmp/expected $tmp/actual >/dev/null 2>&1
  then
    echo "Test $name $@ failed:"
	( cd $tmp; diff -u9999 expected actual | tail -n +3; echo; )
	let tests_failed=tests_failed+1
  fi
  rm -f $tmp/expected $tmp/actual
  let tests_count=tests_count+1
}

##### Test tests/command-prefix #####

runtest() {
make_pwfile
./cvm-testclient cvm-command:./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/command-prefix  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/vmlookup-upper-domain #####

runtest() {
testl virt Test.TLD secret
}
run_compare_test tests/vmlookup-upper-domain  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/command-no-prefix #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/command-no-prefix  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/command-bad-username #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pxfuser '' testpass
}
run_compare_test tests/command-bad-username  <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS


##### Test tests/pwfile-crypt #####

runtest() {
make_pwfile
CVM_PWFILE_PWCMP=crypt export CVM_PWFILE_PWCMP
./cvm-testclient ./cvm-pwfile cryptuser '' testpass
}
run_compare_test tests/pwfile-crypt  <<END_OF_TEST_RESULTS
user name:        cryptuser
user ID:          234
group ID:         567
real name:        Crypt
directory:        /home/crypt
shell:            /bin/true
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/vmlookup-normal #####

runtest() {
testl virt test.tld secret
}
run_compare_test tests/vmlookup-normal  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/vmailmgr-normal #####

runtest() {
testc virt test.tld pass
}
run_compare_test tests/vmailmgr-normal  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/vmlookup-pass #####

runtest() {
testl virt test.tld secret
}
run_compare_test tests/vmlookup-pass  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/vmailmgr-upper-pass #####

runtest() {
testc virt test.tld Pass
}
run_compare_test tests/vmailmgr-upper-pass  <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS


##### Test tests/vmailmgr-upper-virt #####

runtest() {
testc Virt test.tld pass
}
run_compare_test tests/vmailmgr-upper-virt  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/vmailmgr-upper-domain #####

runtest() {
testc virt Test.TLD pass
}
run_compare_test tests/vmailmgr-upper-domain  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/qmail-lookup #####

runtest() {
local addr="$1"
local domain="$2"

testq $addr $domain secret
}
run_compare_test tests/qmail-lookup 'user' 'local.dom' <<END_OF_TEST_RESULTS
user name:        user
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           local.dom
mailbox path:     @TMPDIR@
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'user-addr' 'local.dom' <<END_OF_TEST_RESULTS
user name:        user
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           local.dom
mailbox path:     @TMPDIR@
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'user-addr-x' 'local.dom' <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'user-wild' 'local.dom' <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'user-wild-x' 'local.dom' <<END_OF_TEST_RESULTS
user name:        user
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           local.dom
mailbox path:     @TMPDIR@
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'user-wild-x-y-z' 'local.dom' <<END_OF_TEST_RESULTS
user name:        user
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           local.dom
mailbox path:     @TMPDIR@
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'alias' 'local.dom' <<END_OF_TEST_RESULTS
user name:        alias
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/alias
shell:            (null)
group name:       (null)
system user name: alias
system directory: @TMPDIR@/alias
domain:           local.dom
mailbox path:     @TMPDIR@/alias
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'alias-x' 'local.dom' <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'awild' 'local.dom' <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS

run_compare_test tests/qmail-lookup 'awild-x' 'local.dom' <<END_OF_TEST_RESULTS
user name:        alias
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/alias
shell:            (null)
group name:       (null)
system user name: alias
system directory: @TMPDIR@/alias
domain:           local.dom
mailbox path:     @TMPDIR@/alias
END_OF_TEST_RESULTS


##### Test tests/vmlookup-upper-virt #####

runtest() {
testl Virt test.tld secret
}
run_compare_test tests/vmlookup-upper-virt  <<END_OF_TEST_RESULTS
user name:        virt
user ID:          @UID@
group ID:         @GID@
real name:        (null)
directory:        @TMPDIR@/virt
shell:            (null)
group name:       (null)
system user name: user
system directory: @TMPDIR@
domain:           test.tld
mailbox path:     @TMPDIR@/virt
END_OF_TEST_RESULTS


##### Test tests/lookup #####

runtest() {
local secret="$1"

make_pwfile
env CVM_LOOKUP_SECRET=$secret ./cvm-testclient ./cvm-pwfile pwfuser ''
env CVM_LOOKUP_SECRET=$secret ./cvm-testclient ./cvm-pwfile pwfuser '' ''
env CVM_LOOKUP_SECRET=$secret ./cvm-testclient ./cvm-pwfile pwfuser '' 'secret'
}
run_compare_test tests/lookup '' <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
Authentication failed, error #2
Authentication failed, error #2
END_OF_TEST_RESULTS

run_compare_test tests/lookup 'secret' <<END_OF_TEST_RESULTS
Authentication failed, error #2
Authentication failed, error #7
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/vmlookup-badpass #####

runtest() {
testl virt test.tld 'xpass'
}
run_compare_test tests/vmlookup-badpass  <<END_OF_TEST_RESULTS
Authentication failed, error #7
END_OF_TEST_RESULTS


##### Test tests/pwfile #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpass
}
run_compare_test tests/pwfile  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/command-bad-password #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile pwfuser '' testpassx
}
run_compare_test tests/command-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
END_OF_TEST_RESULTS


##### Test tests/sql-substitution #####

runtest() {
sqt() { env - var1=1 var_2=2 $src/sql-query-test "$@"; }
sqt 'one two' act dom
sqt '$account $domain one two' act dom
sqt 'one $account two' act dom
sqt 'one two $account' act dom
sqt '$var1 one two' act dom
sqt 'one $var1 two' act dom
sqt 'one two $var1' act dom
sqt '$var_2 one two' act dom
sqt 'one $var_2 two' act dom
sqt 'one two $var_2' act dom
sqt '$var1one two' act dom
sqt 'one $var1two' act dom
sqt '${var1} one two' act dom
sqt 'one ${var1} two' act dom
sqt 'one two ${var1}' act dom
}
run_compare_test tests/sql-substitution  <<END_OF_TEST_RESULTS
one two
'act' 'dom' one two
one 'act' two
one two 'act'
'1' one two
one '1' two
one two '1'
'2' one two
one '2' two
one two '2'
 two
one 
'1' one two
one '1' two
one two '1'
END_OF_TEST_RESULTS


##### Test tests/command-case #####

runtest() {
make_pwfile
./cvm-testclient ./cvm-pwfile PWFUser '' testpass
}
run_compare_test tests/command-case  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
END_OF_TEST_RESULTS


##### Test tests/start-pwfile-udp #####

runtest() {
./cvm-pwfile cvm-udp:127.1.2.3:12345 >$tmp/log &
echo $! >$tmp/pid
sleep 1
cat $tmp/log
}
run_compare_test tests/start-pwfile-udp  <<END_OF_TEST_RESULTS
Starting.
END_OF_TEST_RESULTS


##### Test tests/pwfile-udp-bad-password #####

runtest() {
make_pwfile
./cvm-testclient cvm-udp:127.1.2.3:12345 pwfuser '' testpaxx
tail -n 1 $tmp/log
}
run_compare_test tests/pwfile-udp-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
- pwfuser@
END_OF_TEST_RESULTS


##### Test tests/pwfile-udp #####

runtest() {
make_pwfile
./cvm-testclient cvm-udp:127.1.2.3:12345 pwfuser '' testpass
tail -n 1 $tmp/log
}
run_compare_test tests/pwfile-udp  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
+ pwfuser@
END_OF_TEST_RESULTS


##### Test tests/stop-pwfile-udp #####

runtest() {
kill `cat $tmp/pid`
rm -f $tmp/pid
sleep 1
tail -n 1 $tmp/log
echo `cat $tmp/log | wc`
rm -f $tmp/log
}
run_compare_test tests/stop-pwfile-udp  <<END_OF_TEST_RESULTS
Stopping.
4 6 42
END_OF_TEST_RESULTS


##### Test tests/start-pwfile-local #####

runtest() {
./cvm-pwfile cvm-local:$tmp/socket >$tmp/log &
echo $! >$tmp/pid
sleep 1
cat $tmp/log
}
run_compare_test tests/start-pwfile-local  <<END_OF_TEST_RESULTS
Starting.
END_OF_TEST_RESULTS


##### Test tests/pwfile-local-bad-password #####

runtest() {
make_pwfile
./cvm-testclient cvm-local:$tmp/socket pwfuser '' testpaxx
tail -n 1 $tmp/log
}
run_compare_test tests/pwfile-local-bad-password  <<END_OF_TEST_RESULTS
Authentication failed, error #100
- pwfuser@
END_OF_TEST_RESULTS


##### Test tests/pwfile-local #####

runtest() {
make_pwfile
./cvm-testclient cvm-local:$tmp/socket pwfuser '' testpass
tail -n 1 $tmp/log
}
run_compare_test tests/pwfile-local  <<END_OF_TEST_RESULTS
user name:        pwfuser
user ID:          123
group ID:         456
real name:        Gecos
directory:        /home/ftp
shell:            /bin/false
group name:       (null)
system user name: (null)
system directory: (null)
domain:           (null)
mailbox path:     (null)
+ pwfuser@
END_OF_TEST_RESULTS


##### Test tests/stop-pwfile-local #####

runtest() {
kill `cat $tmp/pid`
rm -f $tmp/pid
sleep 1
tail -n 1 $tmp/log
echo `cat $tmp/log | wc`
rm -f $tmp/log
test -e $tmp/socket || echo Socket was removed.
}
run_compare_test tests/stop-pwfile-local  <<END_OF_TEST_RESULTS
Stopping.
4 6 42
Socket was removed.
END_OF_TEST_RESULTS


rm -rf $tmp
echo $tests_count tests executed, $tests_failed failures
if [ $tests_failed != 0 ]; then exit 1; fi
