
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: process.m,v 1.7 2002/06/15 19:19:31 stes Exp $
 */

#include <assert.h>
#include <stdlib.h>
#include <curses.h>
#include <signal.h>
#include <limits.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include <ordcltn.h>
#include <ocstring.h>
#include "cursel.h"
#include "doubleq.h"
#include "singleq.h"
#include "redirect.h"
#include "process.h"

@implementation Process

- makepipe:(BOOL)flag
{
  /* request a pipe - safes file descriptors, by closing fds bottom up */
  makepipe = flag;
  return self;
}

- background:(BOOL)flag
{
  background = flag;
  return self;
}

- (int)srcfd
{
  return srcfd;
}

- (int)dstfd
{
  return dstfd;
}

- dstbuf
{
  return dstbuf;
}

- errbuf
{
  return errbuf;
}

void sigchldhandler(int signo)
{
  int pid;
  int status;
  do {
    pid = waitpid(0,&status,WNOHANG);
  } while (pid > 0);
}

- setsigchldhandler
{
  int ok;
  struct sigaction na,oa;

  na.sa_handler = sigchldhandler;
  sigemptyset(&na.sa_mask);
  na.sa_flags = SA_RESTART;
  ok = sigaction(SIGCHLD,&na,&oa);
  assert(ok == 0);
}

- (int)pid
{
  return pid;
}

- (int)exitcode
{
  if (pid) {
    int ok;
    int status;
    ok = waitpid(pid,&status,0);
    assert(ok == pid);
    if (WIFEXITED(status)) exitcode = WEXITSTATUS(status); 
    pid = 0;
  }

  return exitcode;
}

- (int)pipefd
{
  return pipefd;
}

- (int)errfd
{
  return errfd;
}

- setsrcfd:(int)fd
{
  srcfd = fd;return self;
}

- setdstfd:(int)fd
{
  dstfd = fd;
  dstbuf = nil;
  return self;
}

- seterrfd:(int)fd
{
  errfd = fd;
  errbuf = nil;
  return self;
}

- redir:x
{
  if (!redirs) redirs=[OrdCltn new];
  [redirs add:x];
  return self;
}
  
- openredirs
{
  int i,n;

  for(i=0,n=[redirs size];i<n;i++) {
    id r = [[redirs at:i] openproc:self];
  }

  return self;
}

- closeredirs
{
  int i,n;
  for(i=0,n=[redirs size];i<n;i++) {
    [[redirs at:i] close];
  }
  return self;
}

- go
{
  return [self subclassResponsibility];
}

- setdstbuf:x
{
  dstbuf = x;
  return self;
}

- seterrbuf:x
{
  errbuf = x;
  return self;
}

- dstwrite:(char*)s
{
  if (dstbuf) {
    [dstbuf concatSTR:s];
  } else {
    int ok,n;
    n = strlen(s);
    ok = write(dstfd,s,n);
    assert(ok == n);
  }
  return self;
}

- errwrite:(char*)s
{
  if (errbuf) {
    [errbuf concatSTR:s];
  } else {
    int ok,n;
    n = strlen(s);
    ok = write(errfd,s,n);
    assert(ok == n);
  }
  return self;
}

@end

