
/*
 * Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: item.h,v 1.18 2002/06/15 19:19:31 stes Exp $
 */

extern id mkitem(id name,id action,id description,id itemmsg);

@interface Item : Object
{
  /* item descriptors */

  id action;
  id description;
  id inactive;
  id interrupt;
  id itemmsg;
  id lininfo;
  id name;
  id e_name;
  id oninterrupt;
  id selected;
  id show;

  int width;
  ITEM *eti_item;
}

- (unsigned)hash;
- (BOOL)isEqual:x;
- (int)compare:x;
- (int)width;

- mark;
- eval;

- action:a;
- name:a;
- description:a;
- itemmsg:a;
- interrupt:a;
- oninterrupt:a;
- show:a;
- selected:a;
- setupselected;
- setselected;
- lininfo:a;
- setlininfo;
- inactive:a;

- itemmsg;
- create;
- destroy;
- e_name;

- (BOOL)hasdescription;
- (BOOL)showing;
- (BOOL)isnop;
- (BOOL)isselected;
- (BOOL)isselectable;
- (ITEM *)eti_item;

@end
 
