/*
    entry1.c:

    Copyright (C) 1991 Barry Vercoe, John ffitch

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "entry1.h"             /*                      ENTRY1.C        */

/* thread vals, where isub=1, ksub=2, asub=4:
                0 =     1  OR   2  (B out only)
                1 =     1
                2 =             2
                3 =     1  AND  2
                4 =                     4
                5 =     1  AND          4
                7 =     1  AND (2  OR   4)                              */

/* inarg types include the following:

                i       irate scalar
                k       krate scalar
                a       arate vector
                f       fregency variable
                w       spectral variable
                x       krate scalar or arate vector
                S       String
                T       String or i-rate
                U       String or i/k-rate
                B       Boolean
                l       Label
     and codes
                m       begins an indef list of iargs (any count)
                M       begins an indef list of args (any count/rate i,k,a)
                N       begins an indef list of args (any count/rate i,k,a,S)
                n       begins an indef list of iargs (nargs odd)
                o       optional i-rate, defaulting to  0
                p              "             "          1
                q              "             "         10
                v              "             "          .5
                j              "             "         -1
                h              "             "        127
                O       optional k-rate, defaulting to  0
                V              "             "          .5
                P              "             "          1
                y       begins indef list of aargs (any count)
                z       begins indef list of kargs (any count)
                Z       begins alternating kakaka...list (any count)    */

/* outarg types include:
                m       multiple out aargs
                z       multiple out kargs
                I       multiple out irate (not implemented yet)
                s       arate or krate scalar
                X       multiple args (a, k, or i-rate)     IV - Sep 1 2002
                N       multiple args (a, k, i, or S-rate)
   (these types must agree with rdorch.c)                               */

/* If dsblksize is 0xffff then translate on output arg
                   0xfffe then translate two (oscil)
                   0xfffd then translate on first input arg (peak)
                   0xfffc then translate two (divz)
                   0xfffb then translate on first input arg (loop_l)    */

OENTRY opcodlst_1[] = {
/* opcode   dspace      thread  outarg  inargs  isub    ksub    asub    */
{ ""                                                                    },
{ "instr",  0,          0,      "",     ""                              },
{ "endin",  0,          0,      "",     ""                              },
/* IV - Sep 8 2002 */
{ "opcode", 0,          0,      "",     "",     NULL, NULL, NULL        },
{ "endop",  0,          0,      "",     "",     NULL, NULL, NULL        },
{ "$label", S(LBLBLK),  0,      "",     ""                              },
{ "pset",   S(PVSET),   0,      "",     "m"                             },
{ "ctrlinit",S(CTLINIT),1,      "",     "im",   ctrlinit                },
{ "massign",S(MASSIGN), 1,      "",     "iTp",  massign                 },
{ "turnon", S(TURNON),  1,      "",     "To",   turnon                  },
{ "remoteport", S(REMOTEPORT), 1, "",   "i",    remoteport              },
{ "insremot",S(INSREMOT),1,     "",     "SSm",  insremot                },
{ "midremot",S(MIDREMOT),1,     "",     "SSm",  midremot                },
{ "insglobal",S(INSGLOBAL),1,   "",     "Sm",   insglobal               },
{ "midglobal",S(MIDGLOBAL),1,   "",     "Sm",   midglobal               },
{ "=",      0,          0,      "",     ""                              },
{ "init",   0xffff      /* base names for later prefixes,suffixes */    },
{ "betarand", 0xffff                                                    },
{ "bexprnd", 0xffff                                                     },
{ "cauchy",  0xffff                                                     },
{ "chanctrl",0xffff                                                     },
{ "cpsmidib",0xffff                                                     },
{ "exprand", 0xffff                                                     },
{ "gauss" ,  0xffff                                                     },
{ "limit", 0xffff,                                                      },
{ "linrand", 0xffff                                                     },
{ "midictrl",0xffff                                                     },
{ "polyaft",0xffff                                                      },
{ "ntrpol", 0xffff                                                      },
{ "octmidib",0xffff                                                     },
{ "pcauchy", 0xffff                                                     },
{ "pchbend",0xffff                                                      },
{ "pchmidib",0xffff                                                     },
{ "poisson", 0xffff                                                     },
{ "pow",    0xffff,                                                     },
{ "tableng", 0xffff,                                                    },
{ "taninv2", 0xffff                                                     },
{ "timek", 0xffff,                                                      },
{ "times", 0xffff,                                                      },
{ "trirand", 0xffff                                                     },
{ "unirand",0xffff,                                                     },
{ "weibull", 0xffff                                                     },
{ "oscil",  0xfffe                                                      },
{ "oscil3", 0xfffe                                                      },
{ "oscili", 0xfffe                                                      },
{ "peak", 0xfffd                                                        },
{ "rtclock", 0xffff                                                     },
{ "tablew",  0xfffe                                                     },
{ "tablewkt",  0xfffe                                                   },
{ "ihold",  S(LINK),    1,      "",     "",     ihold                   },
{ "turnoff",S(LINK),    2,      "",     "",     NULL,   turnoff         },
{ "=.r",    S(ASSIGN),  1,      "r",    "i",    rassign                 },
{ "=.i",    S(ASSIGN),  1,      "i",    "i",    assign                  },
{ "=.k",    S(ASSIGN),  2,      "k",    "k",    NULL,   assign          },
{ "=.a",    S(ASSIGN),  4,      "a",    "x",    NULL,   NULL,   aassign },
{ "init.i",  S(ASSIGN), 1,      "i",    "i",    init                    },
{ "init.k",  S(ASSIGN), 1,      "k",    "i",    init                    },
{ "init.a",  S(ASSIGN), 1,      "a",    "i",    ainit                   },
{ ">",      S(RELAT),   0,      "B",    "kk",   gt,     gt              },
{ ">=",     S(RELAT),   0,      "B",    "kk",   ge,     ge              },
{ "<",      S(RELAT),   0,      "B",    "kk",   lt,     lt              },
{ "<=",     S(RELAT),   0,      "B",    "kk",   le,     le              },
{ "==",     S(RELAT),   0,      "B",    "kk",   eq,     eq              },
{ "!=",     S(RELAT),   0,      "B",    "kk",   ne,     ne              },
{ "&&",     S(LOGCL),   0,      "B",    "BB",   and,    and             },
{ "||",     S(LOGCL),   0,      "B",    "BB",   or,     or              },
{ ":i",     S(CONVAL),  1,      "i",    "bii",  conval                  },
{ ":k",     S(CONVAL),  2,      "k",    "Bkk",  NULL,   conval          },
{ ":a",     S(CONVAL),  4,      "a",    "Bxx",  NULL,   NULL,   aconval },
{ "add.ii",  S(AOP),    1,      "i",    "ii",   addkk                   },
{ "sub.ii",  S(AOP),    1,      "i",    "ii",   subkk                   },
{ "mul.ii",  S(AOP),    1,      "i",    "ii",   mulkk                   },
{ "div.ii",  S(AOP),    1,      "i",    "ii",   divkk                   },
{ "mod.ii",  S(AOP),    1,      "i",    "ii",   modkk                   },
{ "add.kk",  S(AOP),    2,      "k",    "kk",   NULL,   addkk           },
{ "sub.kk",  S(AOP),    2,      "k",    "kk",   NULL,   subkk           },
{ "mul.kk",  S(AOP),    2,      "k",    "kk",   NULL,   mulkk           },
{ "div.kk",  S(AOP),    2,      "k",    "kk",   NULL,   divkk           },
{ "mod.kk",  S(AOP),    2,      "k",    "kk",   NULL,   modkk           },
{ "add.ka",  S(AOP),    4,      "a",    "ka",   NULL,   NULL,   addka   },
{ "sub.ka",  S(AOP),    4,      "a",    "ka",   NULL,   NULL,   subka   },
{ "mul.ka",  S(AOP),    4,      "a",    "ka",   NULL,   NULL,   mulka   },
{ "div.ka",  S(AOP),    4,      "a",    "ka",   NULL,   NULL,   divka   },
{ "mod.ka",  S(AOP),    4,      "a",    "ka",   NULL,   NULL,   modka   },
{ "add.ak",  S(AOP),    4,      "a",    "ak",   NULL,   NULL,   addak   },
{ "sub.ak",  S(AOP),    4,      "a",    "ak",   NULL,   NULL,   subak   },
{ "mul.ak",  S(AOP),    4,      "a",    "ak",   NULL,   NULL,   mulak   },
{ "div.ak",  S(AOP),    4,      "a",    "ak",   NULL,   NULL,   divak   },
{ "mod.ak",  S(AOP),    4,      "a",    "ak",   NULL,   NULL,   modak   },
{ "add.aa",  S(AOP),    4,      "a",    "aa",   NULL,   NULL,   addaa   },
{ "sub.aa",  S(AOP),    4,      "a",    "aa",   NULL,   NULL,   subaa   },
{ "mul.aa",  S(AOP),    4,      "a",    "aa",   NULL,   NULL,   mulaa   },
{ "div.aa",  S(AOP),    4,      "a",    "aa",   NULL,   NULL,   divaa   },
{ "mod.aa",  S(AOP),    4,      "a",    "aa",   NULL,   NULL,   modaa   },
{ "divz",   0xfffc                                                      },
{ "divz.ii", S(DIVZ),   1,      "i",    "iii",  divzkk, NULL,   NULL    },
{ "divz.kk", S(DIVZ),   2,      "k",    "kkk",  NULL,   divzkk, NULL    },
{ "divz.ak", S(DIVZ),   4,      "a",    "akk",  NULL,   NULL,   divzak  },
{ "divz.ka", S(DIVZ),   4,      "a",    "kak",  NULL,   NULL,   divzka  },
{ "divz.aa", S(DIVZ),   4,      "a",    "aak",  NULL,   NULL,   divzaa  },
{ "int.i",  S(EVAL),    1,      "i",    "i",    int1                    },
{ "frac.i", S(EVAL),    1,      "i",    "i",    frac1                   },
{ "round.i",S(EVAL),    1,      "i",    "i",    int1_round              },
{ "floor.i",S(EVAL),    1,      "i",    "i",    int1_floor              },
{ "ceil.i", S(EVAL),    1,      "i",    "i",    int1_ceil               },
{ "rnd.i",  S(EVAL),    1,      "i",    "i",    rnd1                    },
{ "birnd.i",S(EVAL),    1,      "i",    "i",    birnd1                  },
{ "abs.i",  S(EVAL),    1,      "i",    "i",    abs1                    },
{ "exp.i",  S(EVAL),    1,      "i",    "i",    exp01                   },
{ "log.i",  S(EVAL),    1,      "i",    "i",    log01                   },
{ "sqrt.i", S(EVAL),    1,      "i",    "i",    sqrt1                   },
{ "sin.i",  S(EVAL),    1,      "i",    "i",    sin1                    },
{ "cos.i",  S(EVAL),    1,      "i",    "i",    cos1                    },
{ "tan.i",  S(EVAL),    1,      "i",    "i",    tan1                    },
{ "sininv.i", S(EVAL),  1,      "i",    "i",    asin1                   },
{ "cosinv.i", S(EVAL),  1,      "i",    "i",    acos1                   },
{ "taninv.i", S(EVAL),  1,      "i",    "i",    atan1                   },
{ "taninv2.i",S(AOP),   1,      "i",    "ii",   atan21                  },
{ "log10.i",S(EVAL),    1,      "i",    "i",    log101                  },
{ "sinh.i", S(EVAL),    1,      "i",    "i",    sinh1                   },
{ "cosh.i", S(EVAL),    1,      "i",    "i",    cosh1                   },
{ "tanh.i", S(EVAL),    1,      "i",    "i",    tanh1                   },
{ "int.k",  S(EVAL),    2,      "k",    "k",    NULL,   int1            },
{ "frac.k", S(EVAL),    2,      "k",    "k",    NULL,   frac1           },
{ "round.k",S(EVAL),    2,      "k",    "k",    NULL,   int1_round      },
{ "floor.k",S(EVAL),    2,      "k",    "k",    NULL,   int1_floor      },
{ "ceil.k", S(EVAL),    2,      "k",    "k",    NULL,   int1_ceil       },
{ "rnd.k",  S(EVAL),    2,      "k",    "k",    NULL,   rnd1            },
{ "birnd.k",S(EVAL),    2,      "k",    "k",    NULL,   birnd1          },
{ "abs.k",  S(EVAL),    2,      "k",    "k",    NULL,   abs1            },
{ "exp.k",  S(EVAL),    2,      "k",    "k",    NULL,   exp01           },
{ "log.k",  S(EVAL),    2,      "k",    "k",    NULL,   log01           },
{ "sqrt.k", S(EVAL),    2,      "k",    "k",    NULL,   sqrt1           },
{ "sin.k",  S(EVAL),    2,      "k",    "k",    NULL,   sin1            },
{ "cos.k",  S(EVAL),    2,      "k",    "k",    NULL,   cos1            },
{ "tan.k",  S(EVAL),    2,      "k",    "k",    NULL,   tan1            },
{ "sininv.k", S(EVAL),  2,      "k",    "k",    NULL,   asin1           },
{ "cosinv.k", S(EVAL),  2,      "k",    "k",    NULL,   acos1           },
{ "taninv.k", S(EVAL),  2,      "k",    "k",    NULL,   atan1           },
{ "taninv2.k",S(AOP),   2,      "k",    "kk",   NULL,   atan21          },
{ "sinh.k", S(EVAL),    2,      "k",    "k",    NULL,   sinh1           },
{ "cosh.k", S(EVAL),    2,      "k",    "k",    NULL,   cosh1           },
{ "tanh.k", S(EVAL),    2,      "k",    "k",    NULL,   tanh1           },
{ "log10.k",S(EVAL),    2,      "k",    "k",    NULL,   log101          },
{ "int.a",  S(EVAL),    4,      "a",    "a",    NULL, NULL, int1a       },
{ "frac.a", S(EVAL),    4,      "a",    "a",    NULL, NULL, frac1a      },
{ "round.a",S(EVAL),    4,      "a",    "a",    NULL, NULL, int1a_round },
{ "floor.a",S(EVAL),    4,      "a",    "a",    NULL, NULL, int1a_floor },
{ "ceil.a", S(EVAL),    4,      "a",    "a",    NULL, NULL, int1a_ceil  },
{ "abs.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   absa    },
{ "exp.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   expa    },
{ "log.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   loga    },
{ "sqrt.a", S(EVAL),    4,      "a",    "a",    NULL,   NULL,   sqrta   },
{ "sin.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   sina    },
{ "cos.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   cosa    },
{ "tan.a",  S(EVAL),    4,      "a",    "a",    NULL,   NULL,   tana    },
{ "sininv.a", S(EVAL),  4,      "a",    "a",    NULL,   NULL,   asina   },
{ "cosinv.a", S(EVAL),  4,      "a",    "a",    NULL,   NULL,   acosa   },
{ "taninv.a", S(EVAL),  4,      "a",    "a",    NULL,   NULL,   atana   },
{ "taninv2.a",S(AOP),   4,      "a",    "aa",   NULL,   NULL,   atan2aa },
{ "sinh.a", S(EVAL),    4,      "a",    "a",    NULL,   NULL,   sinha   },
{ "cosh.a", S(EVAL),    4,      "a",    "a",    NULL,   NULL,   cosha   },
{ "tanh.a", S(EVAL),    4,      "a",    "a",    NULL,   NULL,   tanha   },
{ "log10.a",S(EVAL),    4,      "a",    "a",    NULL,   NULL,   log10a  },
{ "ampdb.a",S(EVAL),    4,      "a",    "a",    NULL,   NULL,   aampdb  },
{ "ampdb.i",S(EVAL),    1,      "i",    "i",    ampdb                   },
{ "ampdb.k",S(EVAL),    2,      "k",    "k",    NULL,   ampdb           },
{ "ampdbfs.a",S(EVAL),  4,      "a",    "a",    NULL,   NULL,   aampdbfs },
{ "ampdbfs.i",S(EVAL),  1,      "i",    "i",    ampdbfs                 },
{ "ampdbfs.k",S(EVAL),  2,      "k",    "k",    NULL,   ampdbfs         },
{ "dbamp.i",S(EVAL),    1,      "i",    "i",    dbamp                   },
{ "dbamp.k",S(EVAL),    2,      "k",    "k",    NULL,   dbamp           },
{ "dbfsamp.i",S(EVAL),  1,      "i",    "i",    dbfsamp                 },
{ "dbfsamp.k",S(EVAL),  2,      "k",    "k",    NULL,   dbfsamp         },
{ "rtclock.i",S(EVAL),  1,      "i",    "",     rtclock                 },
{ "rtclock.k",S(EVAL),  2,      "k",    "",     NULL,   rtclock         },
{ "ftlen.i",S(EVAL),    1,      "i",    "i",    ftlen                   },
{ "ftsr.i",S(EVAL),     1,      "i",    "i",    ftsr                    },
{ "ftlptim.i",S(EVAL),  1,      "i",    "i",    ftlptim                 },
{ "ftchnls.i",S(EVAL),  1,      "i",    "i",    ftchnls                 },
{ "i.k",   S(ASSIGN),   1,      "i",    "k",    init                    },
{ "k.i",   S(ASSIGN),   1,      "k",    "i",    init                    },
{ "cpsoct.i",S(EVAL),   1,      "i",    "i",    cpsoct                  },
{ "octpch.i",S(EVAL),   1,      "i",    "i",    octpch                  },
{ "cpspch.i",S(EVAL),   1,      "i",    "i",    cpspch                  },
{ "pchoct.i",S(EVAL),   1,      "i",    "i",    pchoct                  },
{ "octcps.i",S(EVAL),   1,      "i",    "i",    octcps                  },
{ "cpsoct.k",S(EVAL),   2,      "k",    "k",    NULL,   cpsoct          },
{ "octpch.k",S(EVAL),   2,      "k",    "k",    NULL,   octpch          },
{ "cpspch.k",S(EVAL),   2,      "k",    "k",    NULL,   cpspch          },
{ "pchoct.k",S(EVAL),   2,      "k",    "k",    NULL,   pchoct          },
{ "octcps.k",S(EVAL),   2,      "k",    "k",    NULL,   octcps          },
{ "cpsoct.a",S(EVAL),   4,      "a",    "a",    NULL,   NULL,   acpsoct },
{ "cpsmidinn.i",S(EVAL),1,      "i",    "i",    cpsmidinn               },
{ "octmidinn.i",S(EVAL),1,      "i",    "i",    octmidinn               },
{ "pchmidinn.i",S(EVAL),1,      "i",    "i",    pchmidinn               },
{ "cpsmidinn.k",S(EVAL),2,      "k",    "k",    NULL,   cpsmidinn       },
{ "octmidinn.k",S(EVAL),2,      "k",    "k",    NULL,   octmidinn       },
{ "pchmidinn.k",S(EVAL),2,      "k",    "k",    NULL,   pchmidinn       },
{ "notnum", S(MIDIKMB), 1,      "i",    "",     notnum                  },
{ "veloc",  S(MIDIMAP), 1,      "i",    "oh",   veloc                   },
{ "pchmidi",S(MIDIKMB), 1,      "i",    "",     pchmidi                 },
{ "octmidi",S(MIDIKMB), 1,      "i",    "",     octmidi                 },
{ "cpsmidi",S(MIDIKMB), 1,      "i",    "",     cpsmidi                 },
{ "pchmidib.i",S(MIDIKMB),1,    "i",    "o",    pchmidib_i              },
{ "octmidib.i",S(MIDIKMB),1,    "i",    "o",    octmidib_i              },
{ "cpsmidib.i",S(MIDIKMB),1,    "i",    "o",    icpsmidib_i             },
{ "pchmidib.k",S(MIDIKMB),3,    "k",    "o",    midibset, pchmidib      },
{ "octmidib.k",S(MIDIKMB),3,    "k",    "o",    midibset, octmidib      },
{ "cpsmidib.k",S(MIDIKMB),3,    "k",    "o",    midibset, icpsmidib     },
{ "ampmidi",S(MIDIAMP), 1,      "i",    "io",   ampmidi                 },
{ "aftouch",S(MIDIKMAP), 3,     "k",    "oh",   aftset, aftouch         },
{ "pchbend.i",S(MIDIMAP),0x21,  "i",    "jp",   ipchbend                },
{ "pchbend.k",S(MIDIKMAP),0x23, "k",    "jp",   kbndset,kpchbend        },
{ "midictrl.i",S(MIDICTL),1,    "i",    "ioh",  imidictl                },
{ "midictrl.k",S(MIDICTL),3,    "k",    "ioh",  mctlset, midictl        },
{ "polyaft.i",S(MIDICTL),1,     "i",    "ioh",  imidiaft                },
{ "polyaft.k",S(MIDICTL),3,     "k",    "ioh",  maftset, midiaft        },
{ "chanctrl.i",S(CHANCTL),1,    "i",    "iioh", ichanctl                },
{ "chanctrl.k",S(CHANCTL),3,    "k",    "iioh", chctlset,chanctl        },
{ "line",   S(LINE),    7,      "s",    "iii",  linset, kline,  aline   },
{ "expon",  S(EXPON),   7,      "s",    "iii",  expset, kexpon, expon   },
{ "linseg", S(LINSEG),  7,      "s",    "iin",  lsgset, klnseg, linseg  },
{ "linsegr",S(LINSEG),  7,      "s",    "iin",  lsgrset,klnsegr,linsegr },
{ "expseg", S(EXXPSEG),  7,     "s",    "iin",  xsgset, kxpseg, expseg  },
{ "expsega",S(EXPSEG2),  7,     "a",    "iin",  xsgset2, NULL, expseg2  },
{ "expsegr",S(EXPSEG),  7,      "s",    "iin",  xsgrset,kxpsegr,expsegr },
{ "linen",  S(LINEN),   7,      "s",    "xiii", lnnset, klinen, linen   },
{ "linenr", S(LINENR),  7,      "s",    "xiii", lnrset, klinenr,linenr  },
{ "envlpx", S(ENVLPX),  7,      "s","xiiiiiio", evxset, knvlpx, envlpx  },
{ "envlpxr", S(ENVLPR), 7,      "s","xiiiiioo", evrset, knvlpxr,envlpxr },
{ "phasor", S(PHSOR),   7,      "s",    "xo",   phsset, kphsor, phsor   },
{ "ephasor", S(EPHSOR),   5,    "ss",    "xko",  ephsset, NULL, ephsor   },
{ "table",  0xffff                                                      },
{ "tablei", 0xffff                                                      },
{ "table3", 0xffff                                                      },
{ "table.i",  S(TABLE), 1,      "i",    "iiooo",itable                  },
{ "table.k",  S(TABLE), 3,      "k",    "xiooo",tblset, ktable          },
{ "table.a",  S(TABLE), 5,      "a",    "xiooo",tblset, NULL, tablefn   },
{ "tablei.i", S(TABLE), 1,      "i",    "iiooo",itabli                  },
{ "tablei.k", S(TABLE), 3,      "k",    "xiooo",tblset, ktabli          },
{ "tablei.a", S(TABLE), 5,      "a",    "xiooo",tblset, NULL, tabli     },
{ "table3.i", S(TABLE), 1,      "i",    "iiooo",itabl3                  },
{ "table3.k", S(TABLE), 3,      "k",    "xiooo",tblset, ktabl3          },
{ "table3.a", S(TABLE), 5,      "a",    "xiooo",tblset, NULL, tabl3     },
{ "oscil1", S(OSCIL1),  3,      "k",    "ikii", ko1set, kosc1           },
{ "oscil1i",S(OSCIL1),  3,      "k",    "ikii", ko1set, kosc1i          },
{ "osciln", S(OSCILN),  5,      "a",    "kiii", oscnset,NULL,   osciln  },
{ "oscil.kk",S(OSC),    7,      "s",    "kkio", oscset, koscil, osckk   },
{ "oscil.ka",S(OSC),    5,      "a",    "kaio", oscset, NULL,   oscka   },
{ "oscil.ak",S(OSC),    5,      "a",    "akio", oscset, NULL,   oscak   },
{ "oscil.aa",S(OSC),    5,      "a",    "aaio", oscset, NULL,   oscaa   },
{ "oscili.kk",S(OSC),   7,      "s",    "kkio", oscset, koscli, osckki  },
{ "oscili.ka",S(OSC),   5,      "a",    "kaio", oscset, NULL,   osckai  },
{ "oscili.ak",S(OSC),   5,      "a",    "akio", oscset, NULL,   oscaki  },
{ "oscili.aa",S(OSC),   5,      "a",    "aaio", oscset, NULL,   oscaai  },
{ "oscil3.kk",S(OSC),   7,      "s",    "kkio", oscset, koscl3, osckk3  },
{ "oscil3.ka",S(OSC),   5,      "a",    "kaio", oscset, NULL,   oscka3  },
{ "oscil3.ak",S(OSC),   5,      "a",    "akio", oscset, NULL,   oscak3  },
{ "oscil3.aa",S(OSC),   5,      "a",    "aaio", oscset, NULL,   oscaa3  },
{ "foscil", S(FOSC),    5,      "a",  "xkxxkio",foscset,NULL,   foscil  },
{ "foscili",S(FOSC),    5,      "a",  "xkxxkio",foscset,NULL,   foscili },
{ "loscil", S(LOSC),    5,      "mm","xkiojoojoo",losset,NULL, loscil   },
{ "loscil3", S(LOSC),   5,      "mm","xkiojoojoo",losset,NULL, loscil3  },
{ "adsyn",  S(ADSYN),   5,      "a",    "kkkTo", adset, NULL,   adsyn   },
{ "buzz",   S(BUZZ),    5,      "a",  "xxkio",  bzzset, NULL,   buzz    },
{ "gbuzz",  S(GBUZZ),   5,      "a",  "xxkkkio",gbzset, NULL,   gbuzz   },
{ "pluck",  S(PLUCK),   5,      "a",  "kkiiioo",plukset,NULL,   pluck   },
{ "rand",   S(RAND),    7,      "s",    "xvoo", rndset, krand,  arand   },
{ "randh",  S(RANDH),   7,      "s",    "xxvoo", rhset, krandh, randh   },
{ "randi",  S(RANDI),   7,      "s",    "xxvoo", riset, krandi, randi   },
{ "port",   S(PORT),    3,      "k",    "kio",  porset, port            },
{ "tone",   S(TONE),    5,      "a",    "ako",  tonset, NULL,   tone    },
{ "tonex",  S(TONEX),   5,      "a",    "akoo", tonsetx, NULL,  tonex   },
{ "atone",  S(TONE),    5,      "a",    "ako",  tonset, NULL,   atone   },
{ "atonex", S(TONEX),   5,      "a",    "akoo", tonsetx, NULL,  atonex  },
{ "reson",  S(RESON),   5,      "a",    "akkoo",rsnset, NULL,   reson   },
{ "resonx", S(RESONX),  5,      "a",    "akkooo", rsnsetx, NULL, resonx },
{ "areson", S(RESON),   5,      "a",    "akkoo",rsnset, NULL,   areson  },
{ "lpread", S(LPREAD),  3,      "kkkk", "kToo", lprdset,lpread          },
{ "lpform", S(LPFORM),  3,      "kk", "k",     lpformantset,lpformant   },
{ "lpreson",S(LPRESON), 5,      "a",    "a",    lprsnset,NULL,  lpreson },
{ "lpfreson",S(LPFRESON),5,     "a",    "ak",   lpfrsnset,NULL, lpfreson},
{ "lpslot"  ,  S(LPSLOT),  1,   "",     "i",    lpslotset, NULL, NULL   },
{ "lpinterp", S(LPINTERPOL), 3, "",     "iik",  lpitpset, lpinterpol, NULL},
{ "rms",    S(RMS),     3,      "k",    "aqo",  rmsset, rms             },
{ "gain",   S(GAIN),    5,      "a",    "akqo", gainset,NULL,   gain    },
{ "balance",S(BALANCE), 5,      "a",    "aaqo", balnset,NULL,   balance },
{ "pan",    S(PAN),   5, "aaaa", "akkioo",(SUBR)panset,NULL,   (SUBR)pan     },
{ "soundin",S(SOUNDIN_),5,"mmmmmmmmmmmmmmmmmmmmmmmm","Toooo",
                                                sndinset, NULL, soundin   },
{ "soundout",S(SNDOUT), 5,      "",     "aTo",  sndo1set, NULL, soundout  },
{ "soundouts",S(SNDOUTS),5,     "",     "aaTo", sndo1set, NULL, soundouts },
{ "in",     S(INM),     4,      "a",    "",     NULL,   NULL,   in      },
{ "ins",    S(INS),     4,      "aa",   "",     NULL,   NULL,   ins     },
#ifndef OLPC
{ "inq",    S(INQ),     4,      "aaaa", "",     NULL,   NULL,   inq     },
#endif
  /* Note that there is code in rdorch.c that assumes that opcodes starting
     with the charcters out followed by a s, q, h, o or x are in this group
     ***BEWARE***
   */
{ "out",    S(OUTM),    4,      "",     "a",    NULL,   NULL,   out     },
{ "outs",   S(OUTS),    4,      "",     "aa",   NULL,   NULL,   outs    },
{ "outs1",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outs1   },
{ "outs2",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outs2   },
#ifndef OLPC
{ "outq",   S(OUTQ),    4,      "",     "aaaa", NULL,   NULL,   outq    },
{ "outq1",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outq1   },
{ "outq2",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outq2   },
{ "outq3",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outq3   },
{ "outq4",  S(OUTM),    4,      "",     "a",    NULL,   NULL,   outq4   },
#endif
{ "igoto",  S(GOTO),    1,      "",     "l",    igoto                   },
{ "kgoto",  S(GOTO),    2,      "",     "l",    NULL,   kgoto           },
{ "goto",   S(GOTO),    3,      "",     "l",    igoto,  kgoto           },
{ "cigoto", S(CGOTO),   1,      "",     "Bl",   icgoto                  },
{ "ckgoto", S(CGOTO),   2,      "",     "Bl",   NULL,   kcgoto          },
{ "cggoto", S(CGOTO),   3,      "",     "Bl",   icgoto, kcgoto          },
{ "timout", S(TIMOUT),  3,      "",     "iil",  timset, timout          },
{ "reinit", S(GOTO),    2,      "",     "l",    NULL,   reinit          },
{ "rigoto", S(GOTO),    1,      "",     "l",    rigoto                  },
{ "rireturn",S(LINK),   1,      "",     "",     rireturn                },
{ "tigoto", S(GOTO),    1,      "",     "l",    tigoto                  },
{ "tival",  S(EVAL),    1,      "i",    "",     tival                   },
{ "print",  S(PRINTV),  1,      "",     "m",    printv                  },
{ "display",S(DSPLAY),  7,      "",     "sioo", dspset, kdsplay,dsplay  },
{ "pvsdisp",S(FSIGDISP),  3,      "",     "foo", fdspset, fdsplay,NULL },
{ "dispfft",S(DSPFFT),  7,      "",     "siiooo",fftset,kdspfft,dspfft  },
{ "dumpk",  S(KDUMP),   3,      "",     "kTii", kdmpset,kdump           },
{ "dumpk2", S(KDUMP2),  3,      "",     "kkTii",kdmp2set,kdump2         },
{ "dumpk3", S(KDUMP3),  3,      "",     "kkkTii",kdmp3set,kdump3        },
{ "dumpk4", S(KDUMP4),  3,      "",     "kkkkTii",kdmp4set,kdump4       },
{ "readk",  S(KREAD),   3,      "k",    "Tii",   krdset, kread          },
{ "readk2", S(KREAD2),  3,      "kk",   "Tii",   krd2set, kread2        },
{ "readk3", S(KREAD3),  3,      "kkk",  "Tii",   krd3set, kread3        },
{ "readk4", S(KREAD4),  3,      "kkkk", "Tii",   krd4set, kread4        },
{ "xyin",     S(XYIN),    3,    "kk",   "iiiiioo",xyinset,xyin          },
{ "tempest",  S(TEMPEST), 5,    "k","kiiiiiiiiiop",tempeset,NULL,tempest},
{ "tempo",    S(TEMPO),   3,    "",     "ki",   tempset,tempo           },
{ "pow.i",    S(POW),   1,      "i",    "iip",  ipow,    NULL,  NULL    },
{ "pow.k",    S(POW),   2,      "k",    "kkp",  NULL,    ipow,  NULL    },
{ "pow.a",    S(POW),   4,      "a",    "akp",  NULL,    NULL,  apow    },
{ "oscilx",   S(OSCILN),5,      "a",    "kiii", oscnset,NULL,   osciln  },
{ "linrand.i",S(PRAND), 1,      "i",    "k",    iklinear, NULL, NULL    },
{ "linrand.k",S(PRAND), 2,      "k",    "k",    NULL, iklinear, NULL    },
{ "linrand.a",S(PRAND), 4,      "a",    "k",    NULL, NULL,     alinear },
{ "trirand.i",S(PRAND), 1,      "i",    "k",    iktrian, NULL,  NULL    },
{ "trirand.k",S(PRAND), 2,      "k",    "k",    NULL, iktrian,  NULL    },
{ "trirand.a",S(PRAND), 4,      "a",    "k",    NULL, NULL,     atrian  },
{ "exprand.i",S(PRAND), 1,      "i",    "k",    ikexp, NULL,    NULL    },
{ "exprand.k",S(PRAND), 2,      "k",    "k",    NULL,    ikexp, NULL    },
{ "exprand.a",S(PRAND), 4,      "a",    "k",    NULL, NULL,     aexp    },
{ "bexprnd.i",S(PRAND), 1,      "i",    "k",    ikbiexp, NULL,  NULL    },
{ "bexprnd.k",S(PRAND), 2,      "k",    "k",    NULL, ikbiexp,  NULL    },
{ "bexprnd.a",S(PRAND), 4,      "a",    "k",    NULL, NULL,     abiexp  },
{ "cauchy.i", S(PRAND), 1,      "i",    "k",    ikcauchy, NULL, NULL    },
{ "cauchy.k", S(PRAND), 2,      "k",    "k",    NULL, ikcauchy, NULL    },
{ "cauchy.a", S(PRAND), 4,      "a",    "k",    NULL,    NULL,  acauchy },
{ "pcauchy.i",S(PRAND), 1,      "i",    "k",    ikpcauchy, NULL,NULL    },
{ "pcauchy.k",S(PRAND), 2,      "k",    "k",    NULL, ikpcauchy,NULL    },
{ "pcauchy.a",S(PRAND), 4,      "a",    "k",    NULL,    NULL,  apcauchy},
{ "poisson.i",S(PRAND), 1,      "i",    "k",    ikpoiss, NULL,  NULL    },
{ "poisson.k",S(PRAND), 2,      "k",    "k",    NULL, ikpoiss,  NULL    },
{ "poisson.a",S(PRAND), 4,      "a",    "k",    NULL,    NULL,  apoiss  },
{ "gauss.i" , S(PRAND), 1,      "i",    "k",    ikgaus,  NULL,  NULL    },
{ "gauss.k" , S(PRAND), 2,      "k",    "k",    NULL, ikgaus,   NULL    },
{ "gauss.a" , S(PRAND), 4,      "a",    "k",    NULL,    NULL,  agaus   },
{ "weibull.i",S(PRAND), 1,      "i",    "kk",   ikweib,  NULL,  NULL    },
{ "weibull.k",S(PRAND), 2,      "k",    "kk",   NULL, ikweib,   NULL    },
{ "weibull.a",S(PRAND), 4,      "a",    "kk",   NULL,    NULL,  aweib   },
{ "betarand.i",S(PRAND),1,      "i",    "kkk",  ikbeta, NULL,  NULL     },
{ "betarand.k",S(PRAND),2,      "k",    "kkk",  NULL,   ikbeta,NULL     },
{ "betarand.a",S(PRAND),4,      "a",    "kkk",  NULL,   NULL,  abeta    },
{ "seed",     S(PRAND), 1,      "",     "i",    seedrand, NULL, NULL    },
{ "unirand.i",S(PRAND), 1,     "i",     "k",    ikuniform, NULL,  NULL  },
{ "unirand.k",S(PRAND), 2,     "k",     "k",    NULL,    ikuniform, NULL},
{ "unirand.a",S(PRAND), 4,     "a",     "k",    NULL,    NULL, auniform },
{ "diskin",S(SOUNDINEW),5,  "mmmmmmmmmmmmmmmmmmmmmmmm", "Tkooooo",
                            (SUBR) newsndinset, NULL, (SUBR) soundinew  },
{ "diskin2",S(DISKIN2), 5,  "mmmmmmmmmmmmmmmmmmmmmmmm", "Tkoooooo",
                            (SUBR) diskin2_init, (SUBR) NULL,
                            (SUBR) diskin2_perf                         },
{ "noteon", S(OUT_ON),  1,      "",     "iii",  iout_on, NULL,   NULL   },
{ "noteoff", S(OUT_ON), 1,      "",     "iii",  iout_off, NULL,    NULL },
{ "noteondur",S(OUT_ON_DUR),3,  "", "iiii", iout_on_dur_set,iout_on_dur,NULL},
{ "noteondur2",S(OUT_ON_DUR),3, "", "iiii", iout_on_dur_set,iout_on_dur2,NULL},
{ "moscil",S(MOSCIL),   3,      "",     "kkkkk",moscil_set, moscil, NULL},
{ "midion",S(KOUT_ON),  3,      "", "kkk", kvar_out_on_set,kvar_out_on,NULL},
{ "outic",S(OUT_CONTR), 1,      "",     "iiiii", out_controller, NULL, NULL},
{ "outkc",S(OUT_CONTR), 2,      "",     "kkkkk", NULL, out_controller, NULL},
{ "outic14",S(OUT_CONTR14),1,   "",     "iiiiii",out_controller14, NULL,NULL},
{ "outkc14",S(OUT_CONTR14),2,   "",     "kkkkkk",NULL, out_controller14, NULL},
{ "outipb",S(OUT_PB),   1,      "",     "iiii", out_pitch_bend, NULL , NULL},
{ "outkpb",S(OUT_PB),   2,      "",     "kkkk", NULL,  out_pitch_bend, NULL},
{ "outiat",S(OUT_ATOUCH),1,     "",     "iiii", out_aftertouch, NULL , NULL},
{ "outkat",S(OUT_ATOUCH),2,     "",     "kkkk", NULL,  out_aftertouch, NULL},
{ "outipc",S(OUT_PCHG), 1,      "",     "iiii", out_progchange, NULL , NULL},
{ "outkpc",S(OUT_PCHG), 2,      "",     "kkkk", NULL,  out_progchange, NULL},
{ "outipat",S(OUT_POLYATOUCH),1,"",    "iiiii", out_poly_aftertouch, NULL,NULL},
{ "outkpat",S(OUT_POLYATOUCH),2,"",    "kkkkk", NULL, out_poly_aftertouch,NULL},
{ "release",S(REL),     3,      "k",    "",     release_set, release , NULL },
{ "xtratim",S(XTRADUR), 1,      "",     "i",    xtratim,    NULL,     NULL },
{ "mclock", S(MCLOCK),  3,      "",     "i",    mclock_set, mclock,   NULL },
{ "mrtmsg", S(XTRADUR), 1,      "",     "i",    mrtmsg,     NULL,     NULL },
{ "midiout",S(MIDIOUT),  2,     "",     "kkkk", NULL, midiout,   NULL      },
{ "midion2", S(KON2),    3,     "",     "kkkk", kon2_set, kon2,   NULL     },
{ "nrpn",   S(NRPN),     2,     "",     "kkk",  NULL,  nrpn ,NULL          },
{ "mdelay", S(MDELAY),   3,     "",     "kkkkk",mdelay_set, mdelay,   NULL },
{ "nsamp.i", S(EVAL),    1,     "i",    "i",    numsamp                    },
{ "powoftwo.i",S(EVAL),  1,     "i",    "i",    powoftwo                   },
{ "powoftwo.k",S(EVAL),  2,     "k",    "k",    NULL, powoftwo             },
{ "powoftwo.a",S(EVAL),  4,     "a",    "a",    NULL, NULL, powoftwoa      },
{ "logbtwo.i",S(EVAL),   1,     "i",    "i",    ilogbasetwo                },
{ "logbtwo.k",S(EVAL),   3,     "k",    "k",    logbasetwo_set, logbasetwo },
{ "logbtwo.a",S(EVAL),   5,     "a",    "a", logbasetwo_set, NULL, logbasetwoa },
{ "filelen", S(SNDINFO), 1,     "i",    "Tp",   filelen, NULL, NULL        },
{ "filenchnls", S(SNDINFO), 1,  "i",    "Tp",   filenchnls, NULL, NULL     },
{ "filesr", S(SNDINFO),  1,     "i",    "Tp",   filesr, NULL, NULL         },
{ "filebit", S(SNDINFO),  1,     "i",    "Tp",   filebit, NULL, NULL         },
{ "filepeak", S(SNDINFOPEAK), 1, "i",   "To",   filepeak, NULL, NULL       },
/*  { "nlalp", S(NLALP),     5,     "a",    "akkoo", nlalp_set, NULL, nlalp }, */
/* Robin Whittle */
{ "tableiw",  S(TABLEW),1,     "",      "iiiooo", (SUBR)itablew, NULL, NULL},
{ "tablew.kk", S(TABLEW),3,    "", "kkiooo",(SUBR)tblsetw,(SUBR)ktablew, NULL},
{ "tablew.aa", S(TABLEW),5,    "", "aaiooo",(SUBR)tblsetw, NULL, (SUBR)tablew},
{ "tablewkt.kk", S(TABLEW),3, "",  "kkkooo",(SUBR)tblsetwkt,(SUBR)ktablewkt,NULL},
{ "tablewkt.aa", S(TABLEW),5, "",  "aakooo",(SUBR)tblsetwkt,NULL,(SUBR)tablewkt},
{ "tableng.i", S(TABLENG),1,  "i",     "i",    (SUBR)itableng, NULL,  NULL},
{ "tableng.k",  S(TABLENG),2, "k",     "k",    NULL,   (SUBR)tableng, NULL},
{ "tableigpw",S(TABLENG),1,   "",  "i",    (SUBR)itablegpw, NULL,  NULL},
{ "tablegpw", S(TABLENG),2,   "",  "k",    NULL,   (SUBR)tablegpw, NULL},
{ "tableimix",S(TABLEMIX),1,  "",  "iiiiiiiii", (SUBR)itablemix, NULL, NULL},
{ "tablemix", S(TABLEMIX),2,  "",  "kkkkkkkkk",
                                   (SUBR)tablemixset, (SUBR)tablemix, NULL},
{ "tableicopy",S(TABLECOPY),1, "", "ii",   (SUBR)itablecopy, NULL, NULL},
{ "tablecopy", S(TABLECOPY),2, "", "kk",
                                      (SUBR)tablecopyset, (SUBR)tablecopy, NULL},
{ "tablera", S(TABLERA),5,   "a",  "kkk",  (SUBR)tableraset, NULL, (SUBR)tablera},
{ "tablewa", S(TABLEWA),5,   "k",  "kak",  (SUBR)tablewaset, NULL, (SUBR)tablewa},
{ "tablekt",  S(TABLE), 7,     "s",  "xkooo",tblsetkt,  ktablekt, tablekt },
{ "tableikt", S(TABLE), 7,     "s",  "xkooo",tblsetkt,  ktablikt, tablikt },
{ "zakinit", S(ZAKINIT), 1,  "",   "ii",   (SUBR)zakinit, NULL,  NULL},
{ "zir",    S(ZKR),     1,   "i",  "i",    (SUBR)zir,     NULL,  NULL},
{ "zkr",    S(ZKR),     3,   "k",  "k",    (SUBR)zkset,   (SUBR)zkr,   NULL},
{ "ziw",    S(ZKW),     1,   "",   "ii",   (SUBR)ziw,     NULL,  NULL},
{ "zkw",    S(ZKW),     3,   "",   "kk",   (SUBR)zkset,   (SUBR)zkw,   NULL},
{ "ziwm",   S(ZKWM),    1,   "",   "iip",  (SUBR)ziwm,    NULL,  NULL},
{ "zkwm",   S(ZKWM),    3,   "",   "kkp",  (SUBR)zkset,   (SUBR)zkwm,  NULL},
{ "zkmod",  S(ZKMOD),   2,   "k",  "kk",   NULL,    (SUBR)zkmod, NULL},
{ "zkcl",   S(ZKCL),    3,   "",  "kk",   (SUBR)zkset,   (SUBR)zkcl,  NULL},
{ "zar",    S(ZAR),     5,   "a", "k",    (SUBR)zaset,   NULL,  (SUBR)zar},
{ "zarg",   S(ZARG),    5,   "a", "kk",   (SUBR)zaset,   NULL,  (SUBR)zarg},
{ "zaw",    S(ZAW),     5,   "",  "ak",   (SUBR)zaset,   NULL,  (SUBR)zaw},
{ "zawm",   S(ZAWM),    5,   "",  "akp",  (SUBR)zaset,   NULL,  (SUBR)zawm},
{ "zamod",  S(ZAMOD),   4,   "a", "ak",   NULL,    NULL,  (SUBR)zamod},
{ "zacl",   S(ZACL),    5,   "",  "kk",   (SUBR)zaset,   NULL,  (SUBR)zacl},
{ "inz",    S(IOZ),     4,   "",   "k",    (SUBR)zaset,  NULL,   (SUBR)inz  },
{ "outz",   S(IOZ),     4,   "",   "k",    (SUBR)zaset,  NULL,   (SUBR)outz },
{ "timek.i", S(RDTIME), 1,   "i",  "",     (SUBR)timek,   NULL,  NULL },
{ "times.i", S(RDTIME), 1,   "i",  "",     (SUBR)timesr,  NULL,  NULL },
{ "timek.k",  S(RDTIME), 2,  "k",  "",     NULL,    (SUBR)timek, NULL },
{ "times.k",  S(RDTIME), 2,  "k",  "",     NULL,    (SUBR)timesr,NULL },
{ "timeinstk", S(RDTIME), 3, "k",  "",     (SUBR)instimset, (SUBR)instimek, NULL },
{ "timeinsts", S(RDTIME), 3, "k",  "",     (SUBR)instimset, (SUBR)instimes, NULL },
{ "peak.k",  S(PEAK),   2,   "k",  "k",    NULL,    (SUBR)peakk,    NULL },
{ "peak.a",   S(PEAK),  4,   "k",  "a",    NULL,    NULL,     (SUBR)peaka },
{ "printk", S(PRINTK),  3,   "",   "iko",  (SUBR)printkset, (SUBR)printk, NULL },
{ "printks",S(PRINTKS), 3,   "",   "TiM",  (SUBR)printksset,(SUBR)printks, NULL },
{ "prints",S(PRINTS),   1,   "",   "TM",   (SUBR)printsset, NULL, NULL },
{ "printk2", S(PRINTK2),3,   "",   "ko",   (SUBR)printk2set, (SUBR)printk2, NULL },
{ "portk",  S(KPORT),   3, "k",     "kko",  (SUBR)kporset, (SUBR)kport, NULL   },
{ "tonek",  S(KTONE),   3, "k",     "kko",  (SUBR)ktonset, (SUBR)ktone, NULL   },
{ "atonek", S(KTONE),   3, "k",     "kko",  (SUBR)ktonset, (SUBR)katone, NULL  },
{ "resonk", S(KRESON),  3, "k",     "kkkpo",(SUBR)krsnset, (SUBR)kreson, NULL  },
{ "aresonk",S(KRESON),  3, "k",     "kkkpo",(SUBR)krsnset, (SUBR)kareson, NULL },
{ "limit.i", S(LIMIT),  1, "i",     "iii",  (SUBR)klimit,  NULL,    NULL       },
{ "limit.k",  S(LIMIT), 3, "k",     "xkk",  (SUBR)limitset, (SUBR)klimit, NULL },
{ "limit.a",  S(LIMIT), 5, "a",     "xkk",  (SUBR)limitset, NULL,  (SUBR)limit },
{ "prealloc", S(AOP),   1, "",      "Tio",  (SUBR)prealloc, NULL, NULL  },
/* opcode   dspace      thread  outarg  inargs  isub    ksub    asub    */
#ifndef OLPC
{ "inh",    S(INH),     4,      "aaaaaa","",    NULL,   NULL,   inh     },
{ "ino",    S(INO),     4,      "aaaaaaaa","",  NULL,   NULL,   ino     },
{ "inx",    S(INALL),   4,      "aaaaaaaaaaaaaaaa","",  NULL,   NULL,   in16 },
{ "in32",   S(INALL),   4,      "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                                        "",     NULL,   NULL,   in32 },
#endif
{ "inch",   S(INCH),    4,      "a",    "k",    NULL,   NULL,   inch_opcode },
#ifndef OLPC
{ "_in",    S(INALL),   4,      "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm",
                                        "",     NULL,   NULL,   inall_opcode },
  /* Note that there is code in rdorch.c that assumes that opcodes starting
     with the charcters out followed by a s, q, h, o or x are in this group
     ***BEWARE***
   */
{ "outh",   S(OUTH),    4,      "",     "aaaaaa",NULL,  NULL,   outh    },
{ "outo",   S(OUTO),    4,      "",     "aaaaaaaa",NULL,NULL,   outo    },
{ "outx",   S(OUTX),    4,      "",     "aaaaaaaaaaaaaaaa",NULL,NULL, outx },
{ "out32",  S(OUTX),    4,      "",     "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                                                NULL,   NULL,   outX    },
#endif
{ "outch",  S(OUTCH),   4,      "",     "Z",    NULL,   NULL,   outch   },
{ "outc",   S(OUTX),    4,      "",     "y",    NULL,   NULL,   outall  },
{ "cpsxpch", S(XENH),   1,      "i",    "iiii", cpsxpch, NULL,  NULL    },
{ "cps2pch", S(XENH),   1,      "i",    "ii",   cps2pch, NULL,  NULL    },
{ "cpstun", S(CPSTUN),  2,      "k",    "kkk",   NULL,   cpstun         },
{ "cpstuni",S(CPSTUNI), 1,      "i",    "ii",   cpstun_i,               },
{ "cpstmid", S(CPSTABLE), 1, "i", "i",    (SUBR)cpstmid                    },
{ "adsr", S(LINSEG),     7,     "s",    "iiiio",adsrset,klnseg, linseg     },
{ "madsr", S(LINSEG),    7,     "s",    "iiiioj", madsrset,klnsegr, linsegr },
{ "xadsr", S(EXXPSEG),   7,     "s",    "iiiio", xdsrset, kxpseg, expseg    },
{ "mxadsr", S(EXPSEG),   7,     "s",    "iiiioj", mxdsrset, kxpsegr, expsegr },
{ "schedule", S(SCHED),  1,     "",     "Tiim", schedule, schedwatch, NULL },
{ "schedwhen", S(WSCHED),3,     "",     "kkkkm",ifschedule, kschedule, NULL },
{ "schedkwhen", S(TRIGINSTR), 3,"",     "kkkUkz",triginset, ktriginstr, NULL },
{ "schedkwhennamed", S(TRIGINSTR), 3,"", "kkkUkz",triginset, ktriginstr, NULL },
{ "trigseq", S(TRIGSEQ), 3,     "",     "kkkkkz", trigseq_set, trigseq, NULL },
{ "event", S(LINEVENT),  2,     "",     "SUz",  NULL, eventOpcode, NULL   },
{ "event_i", S(LINEVENT),1,     "",     "STm",  eventOpcodeI, NULL, NULL  },
{ "lfo", S(LFO),         7,     "s",    "kko",  lfoset,   lfok,   lfoa    },
{ "oscils",   S(OSCILS), 5,     "a", "iiio",     (SUBR)oscils_set, NULL, (SUBR)oscils       },
{ "lphasor",  S(LPHASOR),5,     "a", "xooooooo" ,(SUBR)lphasor_set, NULL, (SUBR)lphasor     },
{ "tablexkt", S(TABLEXKT),5,    "a", "xkkiooo",  (SUBR)tablexkt_set, NULL, (SUBR)tablexkt   },
{ "reverb2",  S(NREV2),  5,     "a",    "akkoojoj", (SUBR)reverbx_set,NULL,(SUBR)reverbx    },
{ "nreverb",  S(NREV2),  5,     "a",    "akkoojoj", (SUBR)reverbx_set,NULL,(SUBR) reverbx    },
{ "=.f",      S(FASSIGN), 2,    "f",   "f",      NULL, fassign, NULL    },
{ "init.f",   S(FASSIGN), 2,    "f",   "f",      fassign, NULL, NULL    },
{ "pvsanal",  S(PVSANAL), 5,    "f",   "aiiiioo",  pvsanalset, NULL, pvsanal  },
{ "pvsynth",  S(PVSYNTH), 5,    "a",   "fo",     pvsynthset, NULL, pvsynth  },
{ "pvsadsyn", S(PVADS),   7,    "a",   "fikopo", pvadsynset, pvadsyn, pvadsyn },
{ "pvscross", S(PVSCROSS),3,    "f",   "ffkk",   pvscrosset, pvscross, NULL },
{ "pvsfread", S(PVSFREAD),3,    "f",   "kTo",    pvsfreadset, pvsfread, NULL  },
{ "pvsmaska", S(PVSMASKA),3,    "f",   "fik",    pvsmaskaset, pvsmaska, NULL  },
{ "pvsftw",   S(PVSFTW),  3,    "k",   "fio",    pvsftwset, pvsftw, NULL  },
{ "pvsftr",   S(PVSFTR),  3,    "",    "fio",    pvsftrset, pvsftr, NULL  },
{ "pvsinfo",  S(PVSINFO), 1,    "iiii","f",      pvsinfo, NULL, NULL    },
{ "octave",   0xffff                                                    },
{ "semitone", 0xffff                                                    },
{ "cent",     0xffff                                                    },
{ "octave.i", S(EVAL),    1,    "i",    "i",     powoftwo               },
{ "octave.k", S(EVAL),    2,    "k",    "k",     NULL,  powoftwo        },
{ "octave.a", S(EVAL),    4,    "a",    "a",     NULL, NULL, powoftwoa  },
{ "semitone.i",S(EVAL),   1,    "i",    "i",     semitone               },
{ "semitone.k",S(EVAL),   2,    "k",    "k",     NULL,  semitone        },
{ "semitone.a",S(EVAL),   4,    "a",    "a",     NULL, NULL, asemitone  },
{ "cent.i",   S(EVAL),    1,    "i",    "i",     cent                   },
{ "cent.k",   S(EVAL),    2,    "k",    "k",     NULL,  cent            },
{ "cent.a",   S(EVAL),    4,    "a",    "a",     NULL, NULL, acent      },
{ "db",       0xffff                                                    },
{ "db.i",     S(EVAL),    1,    "i",    "i",     db                     },
{ "db.k",     S(EVAL),    2,    "k",    "k",     NULL, db               },
{ "db.a",     S(EVAL),    4,    "a",    "a",     NULL, NULL, dba        },
{ "midichn",  S(MIDICHN), 1,    "i",    "",      midichn, NULL, NULL    },
{ "pgmassign",S(PGMASSIGN), 1,  "",     "iTo",   pgmassign, NULL, NULL  },
{ "midiin",   S(MIDIIN),  3,    "kkkk", "",      midiin_set, midiin, NULL },
{ "pgmchn",   S(PGMIN),  3,     "kk",   "o",     pgmin_set, pgmin, NULL },
{ "ctlchn",   S(CTLIN),  3,     "kkk",  "oo",    ctlin_set, ctlin, NULL },
{ "miditempo", S(MIDITEMPO), 3, "k",    "",
                (SUBR) midiTempoOpcode, (SUBR) midiTempoOpcode, NULL    },
{ "midinoteoff", S(MIDINOTEON),3,"",    "xx",   midinoteoff, midinoteoff, },
{ "midinoteonkey", S(MIDINOTEON),3, "", "xx",   midinoteonkey, midinoteonkey },
{ "midinoteoncps", S(MIDINOTEON), 3, "", "xx",  midinoteoncps,midinoteoncps },
{ "midinoteonoct", S(MIDINOTEON), 3, "", "xx",  midinoteonoct,midinoteonoct },
{ "midinoteonpch", S(MIDINOTEON), 3, "", "xx",  midinoteonpch, midinoteonpch },
{ "midipolyaftertouch", S(MIDIPOLYAFTERTOUCH),
                   3,   "", "xxoh", midipolyaftertouch, midipolyaftertouch},
{ "midicontrolchange", S(MIDICONTROLCHANGE),
                   3, "", "xxoh",midicontrolchange, midicontrolchange    },
{ "midiprogramchange", S(MIDIPROGRAMCHANGE),
                   3, "", "x", midiprogramchange, midiprogramchange      },
{ "midichannelaftertouch", S(MIDICHANNELAFTERTOUCH),
                   3, "", "xoh",midichannelaftertouch, midichannelaftertouch },
{ "midipitchbend", S(MIDIPITCHBEND),3, "", "xoh", midipitchbend, midipitchbend },
{ "mididefault", S(MIDIDEFAULT), 3, "", "xx",   mididefault, mididefault },
{ "invalue",   0xFFFF,   0,     NULL,   NULL,   NULL, NULL, NULL            },
{ "invalue.k", S(INVAL), 3,     "k",    "T",    invalset, kinval, NULL      },
{ "invalue.S", S(INVAL), 3,     "S",    "T",    invalset_S, kinval_S, NULL  },
{ "outvalue", S(OUTVAL), 3,     "",     "TU",   outvalset, koutval, NULL    },
/* IV - Oct 20 2002 */
{ "subinstr", S(SUBINST), 5, "mmmmmmmm", "Tm",  subinstrset, NULL, subinstr },
{ "subinstrinit", S(SUBINST), 1, "",    "Tm",   subinstrset, NULL, NULL  },
{ "nstrnum", S(NSTRNUM), 1,     "i",    "T",    nstrnumset, NULL, NULL   },
{ "turnoff2",S(TURNOFF2),2,     "",     "kkk",  NULL, turnoff2, NULL     },
{ "cngoto", S(CGOTO),   3,      "",     "Bl",   ingoto, kngoto, NULL     },
{ "cogoto", S(CGOTO),   3,      "",     "bl",   iingoto, kingoto, NULL   },
/* IV - Sep 8 2002 - added entries for user defined opcodes, xin, xout */
/* and setksmps */
{ ".userOpcode", S(UOPCODE), 7, "", "", useropcdset, useropcd, useropcd },
/* IV - Sep 10 2002: removed perf time routines of xin and xout */
{ "xin",      S(XIN_LOW),   1,  "NNNNNNNNNNNNNNNN", "",  xinset,  NULL, NULL },
{ ".xin64",   S(XIN_HIGH),  1,
    "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN", "",
    xinset,  NULL, NULL },
{ ".xin256",  S(XIN_MAX),   1,
    "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
    "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
    "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN"
    "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN", "",
    xinset,  NULL, NULL },
{ "xout",     S(XOUT_LOW),  1,  "",                 "N", xoutset, NULL, NULL },
{ ".xout64",  S(XOUT_HIGH), 1,  "",                 "N", xoutset, NULL, NULL },
{ ".xout256", S(XOUT_MAX),  1,  "",                 "N", xoutset, NULL, NULL },
{ "setksmps", S(SETKSMPS),  1,  "",     "i",    setksmpsset, NULL, NULL  },
{ "tempoval", S(GTEMPO), 2,  "k", "",      NULL, (SUBR)gettempo, NULL    },
{ "downsamp",S(DOWNSAMP),3, "k", "ao",   (SUBR)downset,(SUBR)downsamp        },
{ "upsamp", S(UPSAMP),  4,  "a", "k",    NULL,   NULL,   (SUBR)upsamp        },
/* IV - Sep 5 2002 */
{ "interp", S(INTERP),  5,  "a", "koo",  (SUBR)interpset,NULL, (SUBR)interp  },
{ "a.k",    S(INTERP),  5,  "a", "k",    (SUBR)a_k_set,NULL,   (SUBR)interp  },
{ "integ", S(INDIFF), 7, "s", "xo", (SUBR)indfset,(SUBR)kntegrate,(SUBR)integrate},
{ "diff",   S(INDIFF),  7,  "s", "xo",   (SUBR)indfset,(SUBR)kdiff, (SUBR)diff },
{ "samphold",S(SAMPHOLD),7, "s", "xxoo", (SUBR)samphset,(SUBR)ksmphold,(SUBR)samphold},
{ "delay",  S(DELAY),   5,  "a", "aio",  (SUBR)delset, NULL,   (SUBR)delay   },
{ "delayr", S(DELAYR),  5,  "aX","io",   (SUBR)delrset,NULL,   (SUBR)delayr  },
{ "delayw", S(DELAYW),  5,  "",  "a",    (SUBR)delwset,NULL,   (SUBR)delayw  },
{ "delay1", S(DELAY1),  5,  "a", "ao",   (SUBR)del1set,NULL,   (SUBR)delay1  },
{ "deltap", S(DELTAP),  5,  "a", "ko",   (SUBR)tapset, NULL,   (SUBR)deltap  },
{ "deltapi",S(DELTAP),  5,  "a", "xo",   (SUBR)tapset, NULL,   (SUBR)deltapi },
{ "deltapn",S(DELTAP),  5,  "a", "xo",   (SUBR)tapset, NULL,   (SUBR)deltapn },
{ "deltap3",S(DELTAP),  5,  "a", "xo",   (SUBR)tapset, NULL,   (SUBR)deltap3 },
{ "reverb", S(REVERB),  5,  "a", "ako",  (SUBR)rvbset, NULL,   (SUBR)reverb  },
{ "vdelay",   S(VDEL),  5,  "a", "axio", (SUBR)vdelset, NULL,  (SUBR)vdelay  },
{ "vdelay3",  S(VDEL),  5,  "a", "axio", (SUBR)vdelset, NULL,  (SUBR)vdelay3 },
{ "vdelayxwq",S(VDELXQ),5,  "aaaa", "aaaaaiio", (SUBR)vdelxqset, NULL, (SUBR)vdelayxwq},
{ "vdelayxws",S(VDELXS),5,  "aa", "aaaiio", (SUBR)vdelxsset, NULL, (SUBR)vdelayxws},
{ "vdelayxw", S(VDELX), 5,  "a",  "aaiio", (SUBR)vdelxset, NULL, (SUBR)vdelayxw},
{ "vdelayxq", S(VDELXQ),5,  "aaaa", "aaaaaiio", (SUBR)vdelxqset, NULL, (SUBR)vdelayxq},
{ "vdelayxs", S(VDELXS),5,  "aa", "aaaiio", (SUBR)vdelxsset, NULL, (SUBR)vdelayxs},
{ "vdelayx",  S(VDELX), 5,  "a",  "aaiio", (SUBR)vdelxset, NULL, (SUBR)vdelayx},
{ "deltapx",  S(DELTAPX),5, "a",  "aio",  (SUBR)tapxset, NULL,  (SUBR)deltapx },
{ "deltapxw", S(DELTAPX),5,  "",  "aaio", (SUBR)tapxset, NULL, (SUBR)deltapxw },
{ "multitap", S(MDEL),  5,   "a", "am",   (SUBR)multitap_set,NULL,(SUBR)multitap_play},
{ "comb",   S(COMB),    5,  "a",  "akioo", (SUBR)cmbset,NULL,   (SUBR)comb    },
{ "alpass", S(COMB),    5,  "a",  "akioo", (SUBR)cmbset,NULL,   (SUBR)alpass  },
{  "strset",   S(STRSET_OP),   1,  "",     "iS",
   (SUBR) strset_init, (SUBR) NULL, (SUBR) NULL                        },
{  "strget",   S(STRGET_OP),   1,  "S",    "i",
   (SUBR) strget_init, (SUBR) NULL, (SUBR) NULL                        },
{  "strcpy",   S(STRCPY_OP),   1,  "S",    "T",
   (SUBR) strcpy_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strcpyk",  S(STRCPY_OP),   3,  "S",    "T",
   (SUBR) strcpy_opcode, (SUBR) strcpy_opcode, (SUBR) NULL             },
{  "strcat",   S(STRCAT_OP),   1,  "S",    "SS",
   (SUBR) strcat_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strcatk",  S(STRCAT_OP),   3,  "S",    "SS",
   (SUBR) strcat_opcode, (SUBR) strcat_opcode, (SUBR) NULL             },
{  "strcmp",   S(STRCAT_OP),   1,  "i",    "SS",
   (SUBR) strcmp_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strcmpk",  S(STRCAT_OP),   3,  "k",    "SS",
   (SUBR) strcmp_opcode, (SUBR) strcmp_opcode, (SUBR) NULL             },
{  "sprintf",  S(SPRINTF_OP),  1,  "S",    "STN",
   (SUBR) sprintf_opcode, (SUBR) NULL, (SUBR) NULL                     },
{  "sprintfk", S(SPRINTF_OP),  3,  "S",    "SUN",
   (SUBR) sprintf_opcode, (SUBR) sprintf_opcode, (SUBR) NULL           },
{  "printf_i", S(PRINTF_OP),   1,  "",     "SiTN",
   (SUBR) printf_opcode_init, (SUBR) NULL, (SUBR) NULL                 },
{  "printf",   S(PRINTF_OP),   3,  "",     "SkUN",
   (SUBR) printf_opcode_set, (SUBR) printf_opcode_perf, (SUBR) NULL    },
{  "puts",     S(PUTS_OP),     3,  "",     "Sko",
   (SUBR) puts_opcode_init, (SUBR) puts_opcode_perf, (SUBR) NULL       },
{  "strtod",   S(STRSET_OP),   1,  "i",    "T",
   (SUBR) strtod_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strtodk",  S(STRSET_OP),   3,  "k",    "U",
   (SUBR) strtod_opcode, (SUBR) strtod_opcode, (SUBR) NULL             },
{  "strtol",   S(STRSET_OP),   1,  "i",    "T",
   (SUBR) strtol_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strtolk",  S(STRSET_OP),   3,  "k",    "U",
   (SUBR) strtol_opcode, (SUBR) strtol_opcode, (SUBR) NULL             },
{  "strsub",   S(STRSUB_OP),   1,  "S",    "Soj",
   (SUBR) strsub_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strsubk",  S(STRSUB_OP),   3,  "S",    "Skk",
   (SUBR) strsub_opcode, (SUBR) strsub_opcode, (SUBR) NULL             },
{  "strchar",  S(STRCHAR_OP),  1,  "i",    "So",
   (SUBR) strchar_opcode, (SUBR) NULL, (SUBR) NULL                     },
{  "strchark", S(STRCHAR_OP),  3,  "k",    "SO",
   (SUBR) strchar_opcode, (SUBR) strchar_opcode, (SUBR) NULL           },
{  "strlen",   S(STRLEN_OP),   1,  "i",    "S",
   (SUBR) strlen_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strlenk",  S(STRLEN_OP),   3,  "k",    "S",
   (SUBR) strlen_opcode, (SUBR) strlen_opcode, (SUBR) NULL             },
{  "strupper", S(STRUPPER_OP), 1,  "S",    "S",
   (SUBR) strupper_opcode, (SUBR) NULL, (SUBR) NULL                    },
{  "strupperk", S(STRUPPER_OP), 3, "S",    "S",
   (SUBR) strupper_opcode, (SUBR) strupper_opcode, (SUBR) NULL         },
{  "strlower", S(STRUPPER_OP), 1,  "S",    "S",
   (SUBR) strlower_opcode, (SUBR) NULL, (SUBR) NULL                    },
{  "strlowerk", S(STRUPPER_OP), 3, "S",    "S",
   (SUBR) strlower_opcode, (SUBR) strlower_opcode, (SUBR) NULL         },
{  "getcfg",   S(GETCFG_OP),   1,  "S",    "i",
   (SUBR) getcfg_opcode, (SUBR) NULL, (SUBR) NULL                      },
{  "strindex", S(STRINDEX_OP), 1,  "i",    "SS",
   (SUBR) strindex_opcode, (SUBR) NULL, (SUBR) NULL                    },
{  "strindexk", S(STRINDEX_OP), 3, "k",    "SS",
   (SUBR) strindex_opcode, (SUBR) strindex_opcode, (SUBR) NULL         },
{  "strrindex", S(STRINDEX_OP), 1, "i",    "SS",
   (SUBR) strrindex_opcode, (SUBR) NULL, (SUBR) NULL                   },
{  "strrindexk", S(STRINDEX_OP), 3, "k",   "SS",
   (SUBR) strrindex_opcode, (SUBR) strrindex_opcode, (SUBR) NULL       },
{ "loop_lt",   0xfffb                                                  },
{ "loop_le",   0xfffb                                                  },
{ "loop_gt",   0xfffb                                                  },
{ "loop_ge",   0xfffb                                                  },
{ "loop_lt.i", S(LOOP_OPS),  1,  "", "iiil", (SUBR) loop_l_i, NULL, NULL   },
{ "loop_le.i", S(LOOP_OPS),  1,  "", "iiil", (SUBR) loop_le_i, NULL, NULL  },
{ "loop_gt.i", S(LOOP_OPS),  1,  "", "iiil", (SUBR) loop_g_i, NULL, NULL   },
{ "loop_ge.i", S(LOOP_OPS),  1,  "", "iiil", (SUBR) loop_ge_i, NULL, NULL  },
{ "loop_lt.k", S(LOOP_OPS),  2,  "", "kkkl", NULL, (SUBR) loop_l_p, NULL   },
{ "loop_le.k", S(LOOP_OPS),  2,  "", "kkkl", NULL, (SUBR) loop_le_p, NULL  },
{ "loop_gt.k", S(LOOP_OPS),  2,  "", "kkkl", NULL, (SUBR) loop_g_p, NULL   },
{ "loop_ge.k", S(LOOP_OPS),  2,  "", "kkkl", NULL, (SUBR) loop_ge_p, NULL  },
{ "chnget",      0xFFFF,              0,      NULL,           NULL,
   (SUBR) NULL, (SUBR) NULL, (SUBR) NULL                               },
{ "chnget.i",    S(CHNGET),           1,      "i",            "S",
   (SUBR) chnget_opcode_init_i, (SUBR) NULL, (SUBR) NULL               },
{ "chnget.k",    S(CHNGET),           3,      "k",            "S",
   (SUBR) chnget_opcode_init_k, (SUBR) notinit_opcode_stub, (SUBR) NULL },
{ "chnget.a",    S(CHNGET),           5,      "a",            "S",
   (SUBR) chnget_opcode_init_a, (SUBR) NULL, (SUBR) notinit_opcode_stub },
{ "chnget.S",    S(CHNGET),           1,      "S",            "S",
   (SUBR) chnget_opcode_init_S, (SUBR) NULL, (SUBR) NULL               },
{ "chnset",      0xFFFB,              0,      NULL,           NULL,
   (SUBR) NULL, (SUBR) NULL, (SUBR) NULL                               },
{ "chnset.i",    S(CHNGET),           1,      "",             "iS",
   (SUBR) chnset_opcode_init_i, (SUBR) NULL, (SUBR) NULL               },
{ "chnset.r",    S(CHNGET),           1,      "",             "iS",
   (SUBR) chnset_opcode_init_i, (SUBR) NULL, (SUBR) NULL               },
{ "chnset.c",    S(CHNGET),           1,      "",             "iS",
   (SUBR) chnset_opcode_init_i, (SUBR) NULL, (SUBR) NULL               },
{ "chnset.k",    S(CHNGET),           3,      "",             "kS",
   (SUBR) chnset_opcode_init_k, (SUBR) notinit_opcode_stub, (SUBR) NULL },
{ "chnset.a",    S(CHNGET),           5,      "",             "aS",
   (SUBR) chnset_opcode_init_a, (SUBR) NULL, (SUBR) notinit_opcode_stub },
{ "chnset.S",    S(CHNGET),           1,      "",             "SS",
   (SUBR) chnset_opcode_init_S, (SUBR) NULL, (SUBR) NULL               },
{ "chnmix",      S(CHNGET),           5,      "",             "aS",
   (SUBR) chnmix_opcode_init, (SUBR) NULL, (SUBR) notinit_opcode_stub  },
{ "chnclear",    S(CHNCLEAR),         5,      "",             "S",
   (SUBR) chnclear_opcode_init, (SUBR) NULL, (SUBR) notinit_opcode_stub },
{ "chn_k",       S(CHN_OPCODE_K),     1,      "",             "Sioooo",
   (SUBR) chn_k_opcode_init, (SUBR) NULL, (SUBR) NULL                  },
{ "chn_a",       S(CHN_OPCODE),       1,      "",             "Si",
   (SUBR) chn_a_opcode_init, (SUBR) NULL, (SUBR) NULL                  },
{ "chn_S",       S(CHN_OPCODE),       1,      "",             "Si",
   (SUBR) chn_S_opcode_init, (SUBR) NULL, (SUBR) NULL                  },
{ "chnexport",   0xFFFF,              0,      NULL,           NULL,
   (SUBR) NULL, (SUBR) NULL, (SUBR) NULL                               },
{ "chnexport.i", S(CHNEXPORT_OPCODE), 1,      "i",            "Sioooo",
   (SUBR) chnexport_opcode_init, (SUBR) NULL, (SUBR) NULL              },
{ "chnexport.k", S(CHNEXPORT_OPCODE), 1,      "k",            "Sioooo",
   (SUBR) chnexport_opcode_init, (SUBR) NULL, (SUBR) NULL              },
{ "chnexport.a", S(CHNEXPORT_OPCODE), 1,      "a",            "Si",
   (SUBR) chnexport_opcode_init, (SUBR) NULL, (SUBR) NULL              },
{ "chnexport.S", S(CHNEXPORT_OPCODE), 1,      "S",            "Si",
   (SUBR) chnexport_opcode_init, (SUBR) NULL, (SUBR) NULL              },
{ "chnparams",   S(CHNPARAMS_OPCODE), 1,      "iiiiii",       "S",
   (SUBR) chnparams_opcode_init, (SUBR) NULL, (SUBR) NULL              },
{ "chnrecv",     S(CHNSEND),          3,      "",             "So",
   (SUBR) chnrecv_opcode_init, (SUBR) notinit_opcode_stub, (SUBR) NULL },
{ "chnsend",     S(CHNSEND),          3,      "",             "So",
   (SUBR) chnsend_opcode_init, (SUBR) notinit_opcode_stub, (SUBR) NULL },
{ "chano",       0xFFFD,              0,      NULL,           NULL,
   (SUBR) NULL, (SUBR) NULL, (SUBR) NULL                               },
{ "chano.k",     S(ASSIGN),           2,      "",             "kk",
   (SUBR) NULL, (SUBR) chano_opcode_perf_k, (SUBR) NULL                },
{ "chano.a",     S(ASSIGN),           4,      "",             "ak",
   (SUBR) NULL, (SUBR) NULL, (SUBR) chano_opcode_perf_a                },
{ "pvsout",     S(FCHAN),           2,      "",             "fk",
   (SUBR) NULL, (SUBR) pvsout_perf, (SUBR) NULL                        },
{ "chani",       0xFFFF,              0,      NULL,           NULL,
   (SUBR) NULL, (SUBR) NULL, (SUBR) NULL                               },
{ "chani.k",     S(ASSIGN),           2,      "k",            "k",
   (SUBR) NULL, (SUBR) chani_opcode_perf_k, (SUBR) NULL                },
{ "chani.a",     S(ASSIGN),           4,      "a",            "k",
   (SUBR) NULL, (SUBR) NULL, (SUBR) chani_opcode_perf_a                },
{ "pvsin",     S(FCHAN),           3,      "f",            "kooopo",
   (SUBR)  pvsin_init, (SUBR) pvsin_perf, (SUBR) NULL                  },
{ "sense",       S(KSENSE),           2,      "kz",           "",
   (SUBR) NULL, (SUBR) sensekey_perf, (SUBR) NULL                      },
{ "sensekey",    S(KSENSE),           2,      "kz",           "",
   (SUBR) NULL, (SUBR) sensekey_perf, (SUBR) NULL                      },
{ "remove",      S(DELETEIN),         1,      "",             "T",
   (SUBR) delete_instr, (SUBR) NULL, (SUBR) NULL                       },
/* terminate list */
{  NULL, 0, 0, NULL, NULL, (SUBR) NULL, (SUBR) NULL, (SUBR) NULL       }
};

