import Parser
import re

_re_remote_root = re.compile(r'^(?::(?P<method>[^:]+):)?(?:(?P<user>[^@]+)@)?(?P<host>[^:]+):(?P<path>.*)$')

def time(seconds):
	import time
	return time.strftime("%Y/%m/%d %H:%M:%S", time.gmtime(seconds))

class Usage: pass

class catalogStoredProperty(property):
    def __init__(self, name, docstr):
        def getter(inst):
	    if inst.catalog is not None:
	    	return inst.catalog.getConfigItem(name)
	    raise RuntimeError, 'Catalog-stored property request while catalog is unavailable'
        def setter(inst, val):
	    if inst.catalog is not None:
	    	return inst.catalog.setConfigItem(name, val)
	    raise RuntimeError, 'Catalog-stored property request while catalog is unavailable'
        property.__init__(self, getter, setter, None, docstr)

class Config(object):
	def __init__(self):
		import os

		self.catalog = None	# filled in by catalog constructor - catalog *should* be a singleton
		self.topdir = os.path.abspath(os.curdir)
		self.root = ''
		self.cmd = ''
		self.args = []
		self.verbosity = ''
		self.read_only = ''
		self.dry_run = ''
		self.compress = ''
		self.variables = {}
		self.tmpdir = ''
		self.ignorerc = ''
		self.history = ''
		self.profile = False
		self.profileFile = ''
		self.prefix = ''	# where we are inside the repository
		self.cat_path = None
		self.readOnly = True
		self.usable = True
		self.use_rlog = False	# off by default to avoid bugs
		self.fuzzhours = 168	# 1 week

		try:
			while os.path.exists(os.path.join(os.path.dirname(self.topdir), 'CVS/Root')):
				self.topdir = os.path.dirname(self.topdir)

			self.prefix = open(os.path.join(self.topdir, 'CVS/Repository')).read().strip()

			if not self.root:
				if os.path.exists(os.path.join(self.topdir, 'CVS/Root')):
					self.root = open(os.path.join(self.topdir, 'CVS/Root')).readline().strip()
				elif os.environ.has_key('CVSROOT'):
					self.root = os.environ['CVSROOT']
		except IOError:
			self.usable = False
	fuzztime = property(lambda self: self.fuzzhours * 60 * 60)
	reposloc = catalogStoredProperty('reposloc', 'Base path to repository within the server')
