/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _CRYPTONIT_KEY_STORE_HH_
#define _CRYPTONIT_KEY_STORE_HH_

#include "PasswordManager.hh"
#include "KeyStore.hh"
#include "pkcs12.hh"
#include "User.hh"

#define PREFERENCES_FILENAME "Preferences.conf"
#define P12_PATH "P12"
#define KEY_DEFAULT_EXT "p12"
#define CERT_DEFAULT_EXT "der"
#define CERTIFICATES_PATH "Certificates"

#define GETKEY_SUCCESS 0
#define GETKEY_CANCELED 1
#define GETKEY_INVALID  2
#define GETKEY_BAD_PASSWD 3


namespace Cryptonit {
    /***
     * Software KeyStore for Cryptonit
     */
    class SoftKeyStore : public KeyStore
    {
    private:
	std::vector< std::pair< Certificate , pkcs12 > > store;
	
	//path to preference file
	std::string preferenceFile;
	std::string homeDir;
	std::string login;
	PasswordManager *pm;
	User *user;

    public:
	SoftKeyStore();

	/** fill the store with keys and certificates taken from an OpenSSLConf file
	 * @param hDir base dir for config file
	 * @param login a username
 	 */
	SoftKeyStore( User *u );

	SoftKeyStore( User *u , std::string configFile );

	SoftKeyStore( const SoftKeyStore &ks);

	virtual int getType();
        
	virtual	~SoftKeyStore();
	
	/* Get the keys from the store
	 * @return a vector of EVP_PKEY
	 */
	//std::vector<pkcs12> getKeys();
	
	/* Get the store
	 * @return a vector of pair of certificate and pkcs12
	 */
	std::vector<std::pair< Certificate , pkcs12 > >getStore();

	/** add a key in the store
	 * Actually, it will :
	 * - add the key and its certificate as a pair in the vector
	 * - save key and certificate on disk
	 * - add entry in config files
	 *
	 * @param p a pkcs12 key
	 * @param password the key password.
	 *
	 * @return an error code
	 */
	int addKey ( pkcs12 &p , std::string password = "" );
	
	/** delete a key 
	 * @param index the pkcs12's index into the store vector
	 * @return true if the operation succeed
	 */
	int removeKey( const size_t index , std::string &ret, std::string password = "" );
	
	/** get all certificats from this keystore 
	 *  @return a vector of certificates
	 **/
	std::vector<Certificate> listCertificates();
	

	/** get a the key related to a given certificate **/
	int getKey(Certificate c, Key **k );

	/** set the password gui used to ask for password **/
	void setPasswordManager( PasswordManager *m);

	void addPair( Certificate& c , pkcs12& k );
	
	int count() { return store.size() ;}

	void display();
    };

   

}

#endif
