/*
 *  general declarations for cryptmount
 *  $Revision: 154 $, $Date: 2007-03-31 16:55:38 +0100 (Sat, 31 Mar 2007) $
 *  Copyright 2005-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _CRYPTMOUNT_H
#define _CRYPTMOUNT_H

#include <config.h>

#if HAVE_INTTYPES_H
#  include <inttypes.h>
#else
#  if HAVE_STDINT_H
#    include <stdint.h>
#  else
     typedef long int32_t;
     typedef unsigned long uint32_t;
     typedef long long int64_t;
     typedef unsigned long long uint64_t;
#  endif
#  define PRId64 "lld"
#  define SCNi64 "lli"
#endif

#ifdef HAVE_GETTEXT 
#  include <libintl.h>
#  include <locale.h>
#  define _(String) gettext(String)
#  define gettext_noop(String) String
#  define N_(String) gettext_noop(String)
#else
#  define _(String) (String)
#  define N_(String) String
#  define textdomain(Domain) /* empty */
#  define bindtextdomain(Package, Directory) /* empty */
#endif


enum    /* exit-codes */
{
    EXIT_OK =       0,
    EXIT_BADOPT =   1,
    EXIT_BADTGT =   2,
    EXIT_BADEXEC =  3,
    EXIT_PRIV =     100,
    EXIT_INSECURE = 101
};


enum    /* error flags */
{
    ERR_NOERROR =       0,

    WRN_UNCONFIG,
    WRN_NOPASSWD,
    WRN_LOWENTROPY,

    ERR_threshold = 0x10,       /* dividing-line between warnings & errors */

    ERR_BADKEYFORMAT,
    ERR_BADALGORITHM,
    ERR_BADFILE,
    ERR_BADDECRYPT,
    ERR_BADENCRYPT,
    ERR_MEMSPACE,
    ERR_DMSETUP,
    ERR_BADDEVICE,
    ERR_BADIOCTL,
    ERR_BADSUID,
    ERR_BADPRIV,
    ERR_BADMOUNT,
    ERR_BADFSCK,
    ERR_BADSWAP,
    ERR_INSECURE,
    ERR_BADPASSWD,
    ERR_BADPARAM,
    ERR_BADMUTEX
};


enum    /* configuration switches */
{
    FLG_USER =	    0x001,
    FLG_FSCK =	    0x002,
    FLG_MKSWAP =    0x004,

    FLG_DEFAULTS =  FLG_USER | FLG_FSCK
};


typedef struct keyinfo
{
    char *format;           /* type of key file, e.g. 'raw', 'openssl' */
    char *filename;
    char *digestalg;
    char *cipheralg;
    long maxlen;
} keyinfo_t;


typedef struct cment
{
    char *ident;            /* unique identifying name */
    unsigned flags;         /* configuration switches */

    char *dev;              /* device node or raw file */
    int64_t start, length;  /* starting sector + num of sectors (or 0, -1) */
    char *dir;              /* mount-point */
    char *fstype;           /* filesystem type */
    char *fsoptions;	    /* mount options */
    char *loopdev;	    /* loopback device to wrap around raw file */

    char *cipher;           /* cipher used on filesystem */
    int64_t ivoffset;       /* cipher initialization-vector offset */

    keyinfo_t key;          /* location/format of key */

    struct cment *nx;       /* form into linked list */
} cment_t;

#endif  /* _CRYPTMOUNT_H */

/*
 *  (C)Copyright 2005-2007, RW Penney
 */
