const char* const def_sounds[] = {
"#\n",
"# This is a reasonably heavily modified version of the sounds file from\n",
"# the server.\n",
"#\n",
"# Since the client has to load the sounds on its own, full path names\n",
"# are needed.\n",
"#\n",
"# There are two sections - one for normal sounds, and one for spell\n",
"# sounds.  They are differentiated by the header 'Standard Sounds:' and\n",
"# 'Spell Sounds:'\n",
"#\n",
"# Empty lines and lines starting with # are ignored.\n",
"#\n",
"# Format of the file:  pathname to sound, default volume (what volume gets\n",
"# played if it is centered on the player), symbolic name (not currently\n",
"# used for anything, but may be in the future for the server to communicated\n",
"# to the client), and sound number..  Symbolic name and sound number may\n",
"# be ommitted.  If sound number is missing, the sound will be assigned one\n",
"# higher than the last sound read in.\n",
"#\n",
"# the symbolic name can be DEFAULT, in which case all sounds for that section\n",
"# which are otherwise not set will be set to that value.  This can be\n",
"# especially useful for that magic section, since new spells get added\n",
"# fairly often.\n",
"#\n",
"# The volume of 100 means max volume.  Anything higher may break the sound\n",
"# handling.\n",
"#\n",
"# The server currently communicates what sound to play via the sound\n",
"# number - you should not change those.  However, you can change most\n",
"# of the other sounds without problem.\n",
"#\n",
"# If a copy of this file is in ~/.crossfire/, it will be loaded\n",
"#\n",
"Standard Sounds:\n",
"\n",
"sfx/intro.wav	 30	SOUND_NEW_PLAYER	0\n",
"sfx/bow1.wav 	 80	SOUND_FIRE_ARROW	1\n",
"sfx/learnspell.wav	100	SOUND_LEARN_SPELL	2\n",
"sfx/spell_failed.wav	 70	SOUND_FUMBLE_SPELL	3\n",
"sfx/spell_failed.wav	 70	SOUND_WAND_POOF		4\n",
"sfx/door.wav	 90	SOUND_OPEN_DOOR		5\n",
"sfx/push.wav 	 80	SOUND_PUSH_PLAYER	6\n",
"sfx/hit1.wav	 60	SOUND_PLAYER_HITS1	7\n",
"sfx/hit2.wav	 70	SOUND_PLAYER_HITS2	8\n",
"sfx/hit3.wav	 80	SOUND_PLAYER_HITS3	9\n",
"sfx/hit4.wav	 90	SOUND_PLAYER_HITS4	10\n",
"sfx/phit1.wav	 70	SOUND_PLAYER_IS_HIT1	11\n",
"sfx/phit2.wav	 80	SOUND_PLAYER_IS_HIT2	12\n",
"sfx/phit1.wav 	 90	SOUND_PLAYER_IS_HIT3	13\n",
"sfx/kill.wav 	 80	SOUND_PLAYER_KILLS	14\n",
"sfx/petdead.wav	 80	SOUND_PET_IS_KILLED	15\n",
"sfx/playerdead.wav 	150	SOUND_PLAYER_DIES	16\n",
"sfx/Whoosh.wav	100	SOUND_OB_EVAPORATE	17\n",
"sfx/Explosion.wav	100	SOUND_OB_EXPLODE	18\n",
"sfx/Clock.raw	130	SOUND_CLOCK		19\n",
"sfx/pull.wav 	 80	SOUND_TURN_HANDLE	20\n",
"sfx/fallhole.wav 	200	SOUND_FALL_HOLE		21\n",
"sfx/poison.wav 	130	SOUND_DRINK_POISON     	22\n",
"\n",
"# Spells :		SOUND_CAST_SPELL_0      23, 24, 25 ...\n",
"Spell Sounds:\n",
"\n",
"sfx/magic_default.wav	100	DEFAULT\n",
"sfx/magic_bullet1.wav	 70	\"magic bullet\" 			/* 0 */\n",
"sfx/magic_fireball1.wav	 60	\"small fireball\"\n",
"sfx/magic_fireball2.wav	 80	\"medium fireball\"\n",
"sfx/magic_fireball2.wav	100	\"large fireball\"\n",
"sfx/magic_fire.wav	100	\"burning hands\"\n",
"sfx/magic_elec.wav	 70	\"small lightning\"\n",
"sfx/magic_elec.wav	 90	\"large lightning\"\n",
"sfx/magic_missile.wav	100	\"magic missile\"\n",
"sfx/magic_create.wav	100	\"create bomb\"\n",
"sfx/magic_summon1.wav	100	\"summon golem\"\n",
"sfx/magic_summon2.wav	100	\"summon fire elemental\"		/* 10 */\n",
"sfx/magic_summon3.wav	100	\"summon earth elemental\"\n",
"sfx/magic_invoke.wav	100	\"summon water elemental\"\n",
"sfx/magic_invoke2.wav	100	\"summon air elemental\"\n",
"sfx/magic_teleport.wav	100	\"dimension door\"\n",
"sfx/magic_wall.wav	100	\"create earth wall\"\n",
"sfx/magic_paralyze.wav 	100	\"paralyze\"\n",
"sfx/magic_ice.wav	 80	\"icestorm\"\n",
"sfx/magic_mmap.wav	100	\"magic mapping\"\n",
"sfx/magic_turn.wav 	 90	\"turn undead\"\n",
"sfx/magic_fear.wav 	 90	\"fear\"				/* 20 */\n",
"sfx/magic_poison.wav	100	\"poison cloud\"\n",
"sfx/magic_default.wav	100	\"wonder\"\n",
"sfx/magic_destruction.wav	 80	\"destruction\"\n",
"sfx/magic_stat.wav	100	\"perceive self\"\n",
"sfx/magic_teleport.wav	100	\"word of recall\"\n",
"sfx/magic_invisible.wav	100	\"invisible\"\n",
"sfx/magic_invisible.wav	100	\"invisible to undead\"\n",
"sfx/magic_default.wav	100	\"probe\"\n",
"sfx/magic_bullet2.wav	100	\"large bullet\"\n",
"sfx/magic_invisible.wav	100	\"improved invisibility\"		/* 30 */\n",
"sfx/magic_hword.wav 	100	\"holy word\"\n",
"sfx/magic_default.wav	100	\"minor healing\"\n",
"sfx/magic_default.wav	100	\"medium healing\"\n",
"sfx/magic_default.wav	100	\"major healing\"\n",
"sfx/magic_default.wav	100	\"heal\"\n",
"sfx/magic_create.wav	100	\"create food\"\n",
"sfx/Explosion.wav	 60	\"earth to dust\"\n",
"sfx/magic_default.wav	100	\"armour\"\n",
"sfx/magic_stat.wav	100	\"strength\"\n",
"sfx/magic_stat.wav	100	\"dexterity\"			/* 40 */\n",
"sfx/magic_stat.wav	100	\"constitution\"\n",
"sfx/magic_stat.wav	100	\"charisma\"\n",
"sfx/magic_wall.wav	100	\"create fire wall\"\n",
"sfx/magic_wall.wav	100	\"create frost wall\"\n",
"sfx/magic_protection.wav	100	\"protection from cold\"\n",
"sfx/magic_protection.wav	100	\"protection from electricity\"\n",
"sfx/magic_protection.wav	100	\"protection from fire\"\n",
"sfx/magic_protection.wav	100	\"protection from poison\"\n",
"sfx/magic_protection.wav	100	\"protection from slow\"\n",
"sfx/magic_protection.wav	100	\"protection from paralysis\"	/* 50 */\n",
"sfx/magic_protection.wav	100	\"protection from draining\"\n",
"sfx/magic_protection.wav	100	\"protection from magic\"\n",
"sfx/magic_protection.wav	100	\"protection from attack\"\n",
"sfx/magic_default.wav	100	\"levitate\"\n",
"sfx/magic_sball.wav	100	\"small speedball\"\n",
"sfx/magic_sball.wav	130	\"large speedball\"\n",
"sfx/magic_fire.wav	150	\"hellfire\"\n",
"sfx/magic_fire.wav	170	\"dragonbreath\"\n",
"sfx/magic_ice.wav	170	\"large icestorm\"\n",
"sfx/magic_default.wav	100	\"charging\"			/* 60 */\n",
"sfx/magic_default.wav	100	\"polymorph\"\n",
"sfx/magic_cancel.wav	200	\"cancellation\"\n",
"sfx/magic_confusion.wav 	100	\"confusion\"\n",
"sfx/magic_confusion.wav 	150	\"mass confusion\"\n",
"sfx/magic_summon1.wav	100	\"summon pet monster\"\n",
"sfx/magic_slow.wav 	100	\"slow\"\n",
"sfx/magic_default.wav	100	\"regenerate spellpoints\"\n",
"sfx/magic_default.wav	100	\"cure poison\"\n",
"sfx/magic_protection.wav	100	\"protection from confusion\"\n",
"sfx/magic_protection.wav	100	\"protection from cancellation\"	/* 70 */\n",
"sfx/magic_protection.wav	100	\"protection from depletion\"\n",
"sfx/magic_default.wav	100	\"alchemy\"\n",
"sfx/magic_wound.wav	100	\"remove curse\"\n",
"sfx/magic_wound.wav	120	\"remove damnation\"\n",
"sfx/magic_default.wav	100	\"identify\"\n",
"sfx/magic_default.wav	100	\"detect magic\"\n",
"sfx/magic_default.wav	100	\"detect monster\"\n",
"sfx/magic_default.wav	100	\"detect evil\"\n",
"sfx/magic_default.wav	100	\"detect curse\"\n",
"sfx/Explosion.wav	100	\"heroism\"			/* 80 */\n",
"sfx/magic_confusion.wav	100	\"aggravation\"\n",
"sfx/magic_fire.wav	100	\"firebolt\"\n",
"sfx/magic_ice.wav	100	\"frostbolt\"\n",
"sfx/Explosion.wav	100	\"shockwave\"\n",
"sfx/magic_default.wav	100	\"color spray\"\n",
"sfx/magic_default.wav	100	\"haste\"\n",
"sfx/magic_death.wav	100	\"face of death\"\n",
"sfx/magic_elec.wav	110	\"ball lightning\"\n",
"sfx/magic_missile.wav	100	\"meteor swarm\"\n",
"sfx/magic_missile.wav	100	\"comet\"				/* 90 */\n",
"sfx/magic_default.wav	100	\"mystic fist\"\n",
"sfx/magic_animate.wav	100	\"raise dead\"\n",
"sfx/magic_animate.wav	100	\"resurrection\"\n",
"sfx/magic_animate.wav	100	\"reincarnation\"\n",
"sfx/magic_protection.wav	100	\"immune cold\"\n",
"sfx/magic_protection.wav	100	\"immune electricity\"\n",
"sfx/magic_protection.wav	100	\"immune fire\"\n",
"sfx/magic_protection.wav	100	\"immune poison\"\n",
"sfx/magic_protection.wav	100	\"immune slow\"\n",
"sfx/magic_protection.wav	100	\"immune paralysis\"		/* 100 */\n",
"sfx/magic_protection.wav	100	\"immune drain\"\n",
"sfx/magic_protection.wav	100	\"immune magic\"\n",
"sfx/magic_protection.wav	100	\"immune attack\"\n",
"sfx/magic_protection.wav	100	\"invulnerability\"\n",
"sfx/magic_protection.wav	100	\"defense\n",
"sfx/magic_rune.wav	100	\"rune fire\"\n",
"sfx/magic_rune.wav	100	\"rune frost\"\n",
"sfx/magic_rune.wav	100	\"rune shocking\"\n",
"sfx/magic_rune.wav	100	\"rune blasting\"\n",
"sfx/magic_rune.wav	100	\"rune death\"			/* 110 */\n",
"sfx/magic_rune.wav	100	\"marking rune\"\n",
"sfx/magic_rune.wav	100	\"build director\"\n",
"sfx/magic_rune.wav	100	\"pool of chaos\"\n",
"sfx/magic_sball.wav	100	\"build bullet wall\"\n",
"sfx/magic_elec.wav	100	\"build ligtning wall\"\n",
"sfx/magic_fireball1.wav	100	\"build fireball wall\"\n",
"sfx/magic_default.wav	100	\"magic \"\n",
"sfx/magic_rune.wav	100	\"rune of magic drain\"\n",
"sfx/magic_rune.wav	100	\"antimagic rune\"\n",
"sfx/magic_rune.wav	100	\"rune transferrence\"		/* 120 */\n",
"sfx/warning_statup.wav	100	\"transferrence\"\n",
"sfx/warning_drain.wav	100	\"magic drain\"\n",
"sfx/magic_cancel.wav	100	\"counterspell\"\n",
"sfx/warning_food.wav	100	\"disarm\"\n",
"sfx/magic_protection.wav	100	\"cure confusion\"\n",
"sfx/magic_protection.wav	100	\"restoration\"\n",
"sfx/magic_summon3.wav	100	\"summon evil monster\"\n",
"sfx/magic_walls.wav	100	\"counterwall\"\n",
"sfx/magic_wound.wav	100	\"cause light wounds\"\n",
"sfx/magic_wound.wav	100	\"cause medium wounds\"		/* 130 */\n",
"sfx/magic_wound.wav	100	\"cause serious wounds\"\n",
"sfx/magic_animate.wav	100	\"charm monsters\"\n",
"sfx/magic_default.wav	100	\"banishment\"\n",
"sfx/magic_mmissile.wav	100	\"create missile\"\n",
};
