//
// Copyright(C) 1993-1996 Id Software, Inc.
// Copyright(C) 2005-2014 Simon Howard
// Copyright(C) 2018 Fabian Greffrath
// Copyright(C) 2018 Julia Nechaevskaya
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// DESCRIPTION:
//	[crispy] Crispness menu tiled background
//

/*

The following array contains a seamlessly tiling 64x64 icon depicting
Crisps to use as a background texture for the Crispness menu. It has
been converted from a raw lump in Doom's flat format with the following
code. The actual artwork has been created by Julia Nechaevskaya, thank
you so incredibly much for this! - Fabian

#include <stdio.h>

int main (int argc, char **argv)
{
	FILE *file;
	int c, i = 0;

	if (argc < 2 || !(file = fopen(argv[1], "r")))
	{
		return -1;
	}

	while ((c = getc(file)) != EOF)
	{
		printf("0x%02x, ", c);
		if (!(++i % 64))
		{
			printf("\n");
		}
	}

	fclose(file);
	return 0;
}
*/

static const byte crispness_background[] =
{
0x8d, 0x8c, 0x8b, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8e, 0x8c, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x89, 0x92, 0x89, 0x89, 0x92, 0x92, 0x88, 0x89, 0x89, 0x89, 0x8a, 0x89, 0x8a, 0x8a, 0x8d, 0x8d, 0x8c, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x89, 0x89, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8a, 0x8a, 0x8b, 0x8a, 0x8a, 0x8c, 0x8c, 0x8c, 0x8c, 
0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8c, 0x8b, 0x8b, 0x8d, 0x0d, 0x8d, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8e, 0x8d, 0x8d, 0x8c, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x8a, 0x8a, 0x8a, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 
0x8b, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x8c, 0x8a, 0x88, 0x8c, 0x8e, 0x8e, 0x8d, 0x8c, 0x8b, 0x8c, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x8a, 0x93, 0x8a, 0x8a, 0x89, 0x8a, 0x89, 0x8c, 0x8f, 0x8e, 0x8c, 0x8c, 0x8b, 0x8b, 0x93, 0x89, 0x89, 0x89, 0x92, 0x89, 0x8a, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x89, 0x91, 0x88, 0x92, 0x92, 0x92, 0x89, 0x8a, 0x8a, 0x89, 0x8a, 0x8a, 0x8a, 0x8a, 
0x8a, 0x89, 0x8b, 0x8d, 0x8e, 0x8d, 0x8d, 0x8c, 0x8c, 0x8a, 0x88, 0x91, 0x87, 0x88, 0x8b, 0x8e, 0x8e, 0x8e, 0x8d, 0x8d, 0x8c, 0x8c, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8f, 0x8f, 0x8d, 0x8d, 0x8c, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x92, 0x89, 0x8a, 0x8a, 0x89, 0x8a, 0x89, 0x89, 0x8a, 0x92, 0x92, 0x8b, 0x88, 0x88, 0x89, 0x89, 0x88, 0x92, 0x92, 0x89, 0x89, 0x8a, 0x8a, 0x89, 
0x88, 0x92, 0x89, 0x8c, 0x8e, 0x8f, 0x8f, 0x0d, 0x8f, 0x8d, 0x8a, 0x88, 0x91, 0x90, 0x90, 0x88, 0x8f, 0x0e, 0x0d, 0x8f, 0x8e, 0x8d, 0x8c, 0x8b, 0x8b, 0x8a, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x92, 0x89, 0x89, 0x92, 0x89, 0x89, 0x92, 0x8a, 0x8a, 0x91, 0x87, 0x92, 0x8c, 0x92, 0x91, 0x88, 0x91, 0x87, 0x91, 0x88, 0x89, 0x92, 0x89, 0x8a, 0x92, 
0x87, 0x91, 0x92, 0x8c, 0x8f, 0x9e, 0x0e, 0x6c, 0x0e, 0x0e, 0x8e, 0x8b, 0x89, 0x92, 0x91, 0x90, 0x87, 0x8e, 0x8f, 0x9e, 0x0e, 0x8f, 0x8d, 0x8c, 0x8a, 0x93, 0x8a, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8d, 0x8c, 0x8c, 0x8b, 0x8a, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x89, 0x89, 0x8a, 0x8b, 0x8a, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x91, 0x88, 0x87, 0x91, 0x92, 0x89, 0x92, 0x92, 0x88, 0x88, 
0x91, 0x87, 0x88, 0x8a, 0x8c, 0x8e, 0x8f, 0x8e, 0x0d, 0x9e, 0x0d, 0x8d, 0x8c, 0x8c, 0x8b, 0x92, 0x91, 0x86, 0x87, 0x8a, 0x8e, 0x9f, 0x0d, 0x8e, 0x8b, 0x8a, 0x8a, 0x8a, 0x8c, 0x8d, 0x8d, 0x8d, 0x8e, 0x8e, 0x8d, 0x8c, 0x8b, 0x8b, 0x89, 0x89, 0x92, 0x8a, 0x93, 0x8a, 0x8a, 0x8a, 0x8a, 0x89, 0x88, 0x91, 0x91, 0x87, 0x92, 0x92, 0x87, 0x91, 0x88, 0x88, 0x87, 0x88, 0x87, 0x87, 0x91, 0x87, 
0x87, 0x87, 0x92, 0x89, 0x89, 0x8b, 0x8d, 0x8f, 0x0d, 0x8d, 0x8b, 0x89, 0x8b, 0x8c, 0x8b, 0x8c, 0x8d, 0x8c, 0x92, 0x87, 0x88, 0x8c, 0x0d, 0x9f, 0x8d, 0x8b, 0x8a, 0x89, 0x8c, 0x8d, 0x8c, 0x8d, 0x8e, 0x8e, 0x8c, 0x8c, 0x8b, 0x8a, 0x89, 0x89, 0x92, 0x89, 0x89, 0x89, 0x89, 0x92, 0x89, 0x92, 0x88, 0x91, 0x86, 0x91, 0x87, 0x88, 0x91, 0x88, 0x89, 0x92, 0x91, 0x91, 0x91, 0x86, 0x87, 0x91, 
0x87, 0x92, 0x8a, 0x8d, 0x8d, 0x8c, 0x8c, 0x8d, 0x8d, 0x8a, 0x8b, 0x8c, 0x8c, 0x8b, 0x89, 0x8a, 0x8b, 0x8d, 0x8c, 0x8a, 0x8b, 0x8b, 0x8c, 0x0d, 0x0d, 0x8e, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8d, 0x8c, 0x8c, 0x8a, 0x89, 0x92, 0x89, 0x92, 0x89, 0x92, 0x92, 0x89, 0x89, 0x92, 0x88, 0x91, 0x87, 0x86, 0x91, 0x90, 0x91, 0x89, 0x8a, 0x92, 0x87, 0x87, 0x86, 0x86, 0x90, 0x91, 0x87, 
0x87, 0x92, 0x8b, 0x8f, 0x0e, 0x9f, 0x0e, 0x0d, 0x8e, 0x8f, 0x8e, 0x8f, 0x0d, 0x8e, 0x8d, 0x8a, 0x89, 0x89, 0x8a, 0x8b, 0x89, 0x89, 0x8b, 0x8d, 0x8c, 0x8f, 0x0e, 0x8e, 0x8d, 0x8d, 0x8c, 0x8a, 0x8b, 0x8b, 0x8c, 0x8a, 0x88, 0x91, 0x88, 0x92, 0x89, 0x92, 0x88, 0x92, 0x92, 0x92, 0x88, 0x92, 0x87, 0x91, 0x91, 0x87, 0x87, 0x91, 0x92, 0x88, 0x91, 0x86, 0x91, 0x91, 0x91, 0x87, 0x86, 0x86, 
0x92, 0x89, 0x8c, 0x8e, 0x0e, 0x0d, 0x8e, 0x8c, 0x8e, 0x0d, 0x8e, 0x8e, 0x0e, 0x9f, 0x0e, 0x0d, 0x0d, 0x8e, 0x8d, 0x8b, 0x8a, 0x8a, 0x88, 0x92, 0x88, 0x8a, 0x9f, 0x8f, 0x8d, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x91, 0x88, 0x88, 0x91, 0x87, 0x88, 0x92, 0x92, 0x88, 0x88, 0x87, 0x88, 0x88, 0x91, 0x86, 0x91, 0x87, 0x91, 0x87, 0x87, 0x91, 0x90, 0x86, 0x91, 0x86, 0x91, 0x86, 0x91, 0x91, 
0x89, 0x8a, 0x8a, 0x88, 0x8a, 0x89, 0x89, 0x89, 0x8b, 0x8c, 0x8c, 0x8c, 0x0d, 0x6d, 0x0f, 0x6d, 0x09, 0x0f, 0x09, 0x0d, 0x8e, 0x8e, 0x8d, 0x8a, 0x89, 0x92, 0x0d, 0x8e, 0x8c, 0x8b, 0x8a, 0x8a, 0x89, 0x8b, 0x8a, 0x88, 0x92, 0x91, 0x87, 0x87, 0x91, 0x88, 0x87, 0x86, 0x91, 0x91, 0x91, 0x91, 0x87, 0x91, 0x87, 0x91, 0x86, 0x87, 0x91, 0x90, 0x86, 0x91, 0x91, 0x86, 0x86, 0x91, 0x91, 0x88, 
0x88, 0x92, 0x92, 0x92, 0x88, 0x8a, 0x8a, 0x8a, 0x8a, 0x8c, 0x8c, 0x8d, 0x0d, 0x0f, 0x6d, 0x0e, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x09, 0x0e, 0x0d, 0x8d, 0x8b, 0x0e, 0x8d, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x89, 0x91, 0x86, 0x91, 0x87, 0x91, 0x87, 0x91, 0x86, 0x91, 0x86, 0x86, 0x87, 0x87, 0x87, 0x88, 0x91, 0x87, 0x90, 0x91, 0x86, 0x91, 0x91, 0x90, 0x90, 0x91, 0x91, 0x87, 0x87, 0x92, 
0x92, 0x89, 0x8a, 0x89, 0x89, 0x8c, 0x8b, 0x8b, 0x8c, 0x8e, 0x8e, 0x9f, 0x0e, 0x6d, 0x0e, 0x0d, 0x0d, 0x0e, 0x0f, 0x6e, 0x0f, 0x0e, 0x6d, 0x0d, 0x0d, 0x9f, 0x0e, 0x8d, 0x8a, 0x8b, 0x89, 0x89, 0x92, 0x92, 0x88, 0x86, 0x90, 0x86, 0x86, 0x86, 0x86, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x86, 0x91, 0x88, 0x87, 0x91, 0x86, 0x86, 0x86, 0x91, 0x86, 0x91, 0x87, 0x87, 0x91, 0x91, 0x88, 0x89, 
0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x8d, 0x8c, 0x8d, 0x0d, 0x9e, 0x0e, 0x0e, 0x0d, 0x8f, 0x8d, 0x8e, 0x0d, 0x6c, 0x0e, 0x0f, 0x09, 0x6d, 0x0f, 0x8e, 0x8e, 0x6d, 0x0d, 0x8c, 0x89, 0x92, 0x92, 0x92, 0x88, 0x87, 0x92, 0x90, 0x90, 0x86, 0x90, 0x90, 0x91, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x90, 0x91, 0x92, 0x88, 0x91, 0x90, 0x86, 0x90, 0x86, 0x90, 0x87, 0x92, 0x86, 0x90, 0x88, 0x92, 
0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8c, 0x8d, 0x0d, 0x0e, 0x0e, 0x8f, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8e, 0x0e, 0x0e, 0x6c, 0x0e, 0x0e, 0x0f, 0x6d, 0x0e, 0x0e, 0x0e, 0x8b, 0x87, 0x88, 0x92, 0x88, 0x91, 0x86, 0x87, 0x91, 0x89, 0x8b, 0x93, 0x8a, 0x8a, 0x89, 0x92, 0x86, 0x90, 0x90, 0x86, 0x86, 0x90, 0x86, 0x88, 0x92, 0x86, 0x90, 0x91, 0x86, 0x90, 0x91, 0x86, 0x86, 0x91, 0x87, 0x92, 0x89, 
0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f, 0x0d, 0x9f, 0x0d, 0x8e, 0x8b, 0x89, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x8e, 0x9e, 0x8d, 0x8d, 0x8f, 0x6c, 0x0f, 0x09, 0x6d, 0x0e, 0x8c, 0x87, 0x92, 0x87, 0x91, 0x86, 0x92, 0x89, 0x8a, 0x8e, 0x0e, 0x0e, 0x0d, 0x0d, 0x8e, 0x8a, 0x92, 0x86, 0x90, 0x90, 0x90, 0x90, 0x91, 0x86, 0x91, 0x91, 0x91, 0x91, 0x91, 0x90, 0x91, 0x91, 0x91, 0x87, 0x89, 0x8a, 0x89, 
0x8a, 0x8d, 0x8e, 0x8f, 0x8f, 0x9f, 0x0e, 0x8d, 0x8c, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8c, 0x8d, 0x8d, 0x8d, 0x0e, 0x8e, 0x8c, 0x8c, 0x8c, 0x8e, 0x0e, 0x0f, 0x6d, 0x8f, 0x8a, 0x89, 0x92, 0x8b, 0x8d, 0x8d, 0x8d, 0x8e, 0x0e, 0x9f, 0x0e, 0x0d, 0x0d, 0x0d, 0x8d, 0x8b, 0x87, 0x90, 0x90, 0x86, 0x90, 0x86, 0x90, 0x90, 0x87, 0x88, 0x87, 0x87, 0x88, 0x91, 0x86, 0x87, 0x91, 0x8a, 0x93, 0x8a, 
0x8c, 0x8f, 0x0d, 0x9f, 0x0e, 0x0e, 0x8b, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x89, 0x8a, 0x8c, 0x8e, 0x8d, 0x8d, 0x0e, 0x6d, 0x0f, 0x09, 0x8e, 0x8b, 0x8c, 0x8d, 0x8e, 0x0e, 0x8e, 0x8b, 0x8d, 0x8f, 0x0d, 0x0e, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x6c, 0x0d, 0x0d, 0x0d, 0x8d, 0x89, 0x89, 0x92, 0x91, 0x90, 0x86, 0x86, 0x90, 0x86, 0x86, 0x91, 0x88, 0x91, 0x86, 0x86, 0x91, 0x8b, 0x8e, 0x8c, 0x8b, 
0x8e, 0x0d, 0x6d, 0x0e, 0x0d, 0x8d, 0x8a, 0x8a, 0x89, 0x92, 0x89, 0x89, 0x92, 0x89, 0x8c, 0x8d, 0x8d, 0x8d, 0x0d, 0x0e, 0x6d, 0x4f, 0x6f, 0x09, 0x0d, 0x8c, 0x8c, 0x8d, 0x8e, 0x8d, 0x8e, 0x0d, 0x6d, 0x09, 0x6d, 0x0e, 0x09, 0x0e, 0x0f, 0x09, 0x0e, 0x9e, 0x0d, 0x8f, 0x8d, 0x8d, 0x8c, 0x88, 0x90, 0x90, 0x91, 0x86, 0x90, 0x90, 0x86, 0x91, 0x86, 0x90, 0x91, 0x8d, 0x0e, 0x9f, 0x0d, 0x8e, 
0x8e, 0x8f, 0x8f, 0x8b, 0x8b, 0x8a, 0x8b, 0x8a, 0x89, 0x92, 0x89, 0x92, 0x8a, 0x8b, 0x8c, 0x8d, 0x8d, 0x8d, 0x8e, 0x0d, 0x0e, 0x0f, 0x6e, 0x4f, 0x6f, 0x6f, 0x0f, 0x8e, 0x8d, 0x8e, 0x8d, 0x8e, 0x0d, 0x0e, 0x0e, 0x0e, 0x6d, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x6d, 0x0f, 0x9f, 0x0d, 0x8e, 0x8c, 0x92, 0x91, 0x89, 0x91, 0x90, 0x90, 0x86, 0x91, 0x86, 0x89, 0x0d, 0x0f, 0x6b, 0x8f, 0x0d, 0x0d, 
0x8d, 0x8d, 0x8c, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x89, 0x8a, 0x8b, 0x89, 0x8a, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8d, 0x8f, 0x6c, 0x0f, 0x0f, 0x6e, 0xee, 0x6f, 0x6f, 0x4e, 0x6d, 0x0e, 0x8f, 0x8d, 0x8d, 0x0d, 0x6d, 0x0e, 0x0e, 0x0e, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x6d, 0x0f, 0x6d, 0x0e, 0x0e, 0x0e, 0x8d, 0x8d, 0x8c, 0x8b, 0x8b, 0x89, 0x8a, 0x8e, 0x0e, 0x6d, 0x0e, 0x0e, 0x8f, 0x8e, 0x8e, 
0x8c, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x8b, 0x93, 0x8a, 0x8a, 0x8a, 0x8d, 0x8d, 0x8c, 0x8c, 0x8d, 0x8e, 0x0d, 0x0e, 0x09, 0x0f, 0x6f, 0x4e, 0x0f, 0x6e, 0xee, 0x9e, 0x0e, 0x6d, 0x8e, 0x8d, 0x0d, 0x9f, 0x0e, 0x6d, 0x0e, 0x0e, 0x0e, 0x0f, 0x09, 0x0f, 0x0f, 0x0f, 0x09, 0x6e, 0x4e, 0x6d, 0x8e, 0x0d, 0x09, 0x0e, 0x0e, 0x0d, 0x09, 0x0e, 0x8d, 0x0d, 0x0d, 0x8e, 0x8d, 0x8e, 
0x8b, 0x8a, 0x89, 0x89, 0x8a, 0x92, 0x89, 0x8a, 0x8a, 0x8b, 0x8a, 0x89, 0x89, 0x8d, 0x8d, 0x8a, 0x8c, 0x8c, 0x8c, 0x8e, 0x0d, 0x0e, 0x6d, 0x0f, 0x6e, 0x0f, 0x6e, 0x0f, 0x0e, 0x8c, 0x0d, 0xee, 0x09, 0x8e, 0x8e, 0x0d, 0x6c, 0x0e, 0x0e, 0x6d, 0x0e, 0x6d, 0x0e, 0x0f, 0x6d, 0x6d, 0x0f, 0x0f, 0x0f, 0x6e, 0x0e, 0x0d, 0x8f, 0x6c, 0x0d, 0x0d, 0x0d, 0x0d, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d, 0x8c, 
0x8a, 0x8a, 0x8a, 0x8a, 0x92, 0x89, 0x89, 0x92, 0x89, 0x8a, 0x89, 0x89, 0x93, 0x8c, 0x8a, 0x8a, 0x8c, 0x8c, 0x8d, 0x8e, 0x8e, 0x9f, 0x0e, 0x0e, 0x0f, 0x6e, 0x0f, 0x09, 0x8e, 0x8c, 0x8e, 0x6d, 0x6f, 0xee, 0x0d, 0x8e, 0x0d, 0x0e, 0x9f, 0x0e, 0x0e, 0x0e, 0x6d, 0x0e, 0x0f, 0x0f, 0x6d, 0x0f, 0x6e, 0x4e, 0x6e, 0x0d, 0x8e, 0x8f, 0x8f, 0x0d, 0x0d, 0x6b, 0x0d, 0x8e, 0x9c, 0x8c, 0x8b, 0x8b, 
0x8b, 0x93, 0x8a, 0x92, 0x87, 0x89, 0x92, 0x92, 0x92, 0x88, 0x92, 0x89, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8d, 0x8d, 0x8e, 0x0e, 0x6d, 0x0e, 0x09, 0x0f, 0x6d, 0x0e, 0x8c, 0x89, 0x8b, 0x0e, 0x6e, 0x6e, 0x4e, 0x0e, 0x8e, 0x8f, 0x0d, 0x0d, 0x6d, 0x0e, 0x0e, 0x6d, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x0f, 0x0e, 0x8f, 0x8d, 0x8e, 0x8f, 0x9e, 0x0d, 0x0d, 0x9f, 0x8e, 0x8c, 0x8b, 0x8a, 0x8a, 
0x89, 0x8b, 0x8a, 0x87, 0x91, 0x91, 0x88, 0x88, 0x88, 0x87, 0x92, 0x92, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8c, 0x8c, 0x8c, 0x8e, 0x0e, 0x0e, 0x6d, 0x0f, 0x09, 0x0f, 0x6d, 0x8c, 0x92, 0x8a, 0x8e, 0x4e, 0x0f, 0x6e, 0x6e, 0x6d, 0x8f, 0x8f, 0x0d, 0x0d, 0x9e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0f, 0x6d, 0x09, 0x6d, 0x0d, 0x8d, 0x8e, 0x8e, 0x8f, 0x9f, 0x8f, 0x8f, 0x8d, 0x8b, 0x8b, 0x8a, 0x8a, 
0x8a, 0x8a, 0x8a, 0x91, 0x87, 0x87, 0x91, 0x87, 0x92, 0x92, 0x88, 0x89, 0x92, 0x88, 0x92, 0x89, 0x8a, 0x8b, 0x8c, 0x8c, 0x8e, 0x0e, 0x9f, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x0d, 0x8a, 0x89, 0x8a, 0x0e, 0x6f, 0x0f, 0x4e, 0xee, 0x9f, 0x8e, 0x8e, 0x8e, 0x0d, 0x0d, 0x6c, 0x0e, 0x6d, 0x0e, 0x6d, 0x0f, 0x0e, 0x0d, 0x8d, 0x8d, 0x8c, 0x8e, 0x8d, 0x8d, 0x8e, 0x8d, 0x8d, 0x8b, 0x8a, 0x8a, 0x89, 
0x89, 0x8a, 0x92, 0x87, 0x91, 0x87, 0x86, 0x91, 0x88, 0x88, 0x91, 0x92, 0x88, 0x92, 0x88, 0x92, 0x92, 0x8b, 0x8b, 0x8b, 0x8e, 0x6c, 0x8f, 0x0d, 0x0f, 0x6d, 0x0f, 0x0e, 0x09, 0x8e, 0x8b, 0x8a, 0x8c, 0x4e, 0x6f, 0x6e, 0x4e, 0x6e, 0x0e, 0x0d, 0x8e, 0x8d, 0x8f, 0x0d, 0x0d, 0x0e, 0x9f, 0x0f, 0x0e, 0x8f, 0x8d, 0x8c, 0x8c, 0x8d, 0x8f, 0x8d, 0x8c, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x89, 0x92, 
0x89, 0x89, 0x88, 0x91, 0x87, 0x91, 0x87, 0x87, 0x91, 0x88, 0x89, 0x88, 0x92, 0x87, 0x92, 0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x0d, 0x8f, 0x8d, 0x8f, 0x0e, 0x0f, 0x6d, 0x0e, 0x0e, 0x6d, 0x0d, 0x8c, 0x89, 0x8c, 0x8f, 0x0f, 0x0e, 0x0f, 0x6e, 0x6f, 0x6e, 0x0e, 0x8e, 0x8e, 0x8e, 0x8f, 0x0d, 0x6d, 0x0e, 0x8f, 0x8e, 0x8d, 0x8c, 0x8d, 0x8e, 0x8e, 0x8b, 0x8a, 0x8b, 0x8b, 0x8c, 0x8b, 0x89, 0x88, 
0x89, 0x8a, 0x92, 0x86, 0x91, 0x87, 0x91, 0x91, 0x88, 0x92, 0x88, 0x92, 0x92, 0x88, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8d, 0x8e, 0x8e, 0x6c, 0x0f, 0x0f, 0x6d, 0x0f, 0x0f, 0x09, 0x8f, 0x8c, 0x8b, 0x8a, 0x8a, 0x8b, 0x8d, 0x8e, 0x0e, 0x0e, 0x9f, 0x8f, 0x8e, 0x8e, 0x8e, 0x8f, 0x0e, 0x9f, 0x8e, 0x8e, 0x8e, 0x8d, 0x8b, 0x8b, 0x8d, 0x8e, 0x8c, 0x8b, 0x8c, 0x8c, 0x8c, 0x89, 0x89, 
0x8b, 0x8d, 0x8b, 0x91, 0x87, 0x87, 0x91, 0x87, 0x91, 0x87, 0x88, 0x88, 0x92, 0x89, 0x89, 0x92, 0x89, 0x8b, 0x8c, 0x8c, 0x8b, 0x8c, 0x8e, 0x0d, 0x0e, 0x0f, 0x6d, 0x0e, 0x0e, 0x6c, 0x0e, 0x6d, 0x8f, 0x8d, 0x8e, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x89, 0x89, 0x8b, 0x9c, 0x8e, 0x8e, 0x8e, 0x6c, 0x0f, 0x8e, 0x8b, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x8c, 0x8c, 0x8b, 0x8b, 0x8c, 0x8b, 0x8b, 0x8a, 
0x8d, 0x8e, 0x8c, 0x8a, 0x88, 0x91, 0x87, 0x87, 0x88, 0x92, 0x87, 0x92, 0x92, 0x88, 0x92, 0x8a, 0x8a, 0x8b, 0x8d, 0x8c, 0x8b, 0x8c, 0x8d, 0x9e, 0x0e, 0x6d, 0x0f, 0x0e, 0x6d, 0xec, 0x0d, 0x0e, 0x0e, 0x8f, 0x8e, 0x8c, 0x8c, 0x8b, 0x8d, 0x8d, 0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8c, 0x8f, 0x0d, 0x0e, 0x6b, 0x8c, 0x8a, 0x89, 0x88, 0x89, 0x89, 0x8b, 0x8b, 0x8a, 0x89, 0x8a, 0x8b, 0x8a, 0x8b, 
0x8b, 0x8c, 0x0e, 0x8c, 0x91, 0x87, 0x91, 0x88, 0x91, 0x88, 0x92, 0x88, 0x8b, 0x89, 0x87, 0x89, 0x93, 0x8a, 0x8c, 0x8c, 0x8b, 0x8d, 0x8e, 0x8e, 0x8e, 0x0e, 0x6d, 0x0f, 0x0e, 0x0d, 0x9f, 0x0e, 0x6d, 0x0e, 0x0d, 0x8d, 0x8c, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x8a, 0x89, 0x8a, 0x8a, 0x8d, 0x9f, 0x0d, 0x0e, 0x8e, 0x89, 0x92, 0x88, 0x92, 0x88, 0x8a, 0x8c, 0x89, 0x92, 0x89, 0x89, 0x93, 0x8b, 
0x8b, 0x8d, 0x0d, 0x8d, 0x89, 0x87, 0x87, 0x91, 0x87, 0x91, 0x88, 0x91, 0x89, 0x8b, 0x92, 0x92, 0x8b, 0x8b, 0x8a, 0x8c, 0x8c, 0x8c, 0x8d, 0x8f, 0x8f, 0x0e, 0x0f, 0x6d, 0x0d, 0x0d, 0x0d, 0x0e, 0x0e, 0x9f, 0x0e, 0x9f, 0x0d, 0x8e, 0x8d, 0x8d, 0x8d, 0x8c, 0x8c, 0x8b, 0x8a, 0x8a, 0x89, 0x8c, 0x0f, 0x09, 0x0d, 0x8a, 0x89, 0x92, 0x8a, 0x8b, 0x89, 0x8a, 0x8b, 0x8a, 0x8a, 0x89, 0x89, 0x8a, 
0x8c, 0x8c, 0x8c, 0x8b, 0x89, 0x92, 0x89, 0x92, 0x87, 0x91, 0x88, 0x88, 0x88, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8b, 0x8a, 0x8a, 0x8c, 0x8d, 0x8f, 0x0e, 0x09, 0x6d, 0x0e, 0x0e, 0x6c, 0x0d, 0x6c, 0x0f, 0x6d, 0x0f, 0x6d, 0x0e, 0x9f, 0x0d, 0x0d, 0x8e, 0x8e, 0x8d, 0x8c, 0x8b, 0x8a, 0x88, 0x87, 0x8d, 0xee, 0x6e, 0x8d, 0x92, 0x88, 0x92, 0x8a, 0x93, 0x8a, 0x89, 0x8a, 0x8b, 0x8a, 0x8a, 0x8a, 
0x8c, 0x8c, 0x8c, 0x8a, 0x89, 0x92, 0x92, 0x88, 0x88, 0x88, 0x92, 0x92, 0x92, 0x92, 0x89, 0x8b, 0x8b, 0x8a, 0x8a, 0x92, 0x89, 0x8c, 0x8b, 0x8e, 0x6d, 0x0f, 0x0e, 0x09, 0x0e, 0x09, 0x0f, 0x0d, 0x0e, 0x8e, 0x8c, 0x8d, 0x8f, 0x0e, 0x6d, 0x0e, 0x9f, 0x0d, 0x8f, 0x8d, 0x8c, 0x8b, 0x8a, 0x89, 0x88, 0x8c, 0x4e, 0x0e, 0x88, 0x88, 0x88, 0x87, 0x92, 0x8a, 0x89, 0x92, 0x8a, 0x8a, 0x93, 0x8a, 
0x8c, 0x8b, 0x8c, 0x8c, 0x92, 0x89, 0x8b, 0x8a, 0x92, 0x88, 0x92, 0x89, 0x89, 0x89, 0x92, 0x89, 0x8a, 0x91, 0x87, 0x89, 0x89, 0x8b, 0x8b, 0x8d, 0x0f, 0x6d, 0x0f, 0x6d, 0x0e, 0x8e, 0x8d, 0x8c, 0x8b, 0x89, 0x89, 0x89, 0x89, 0x8b, 0x8b, 0x8d, 0x8e, 0x8e, 0x9f, 0x0d, 0x8e, 0x8d, 0x8c, 0x8b, 0x89, 0x88, 0x8e, 0x6f, 0x8e, 0x91, 0x88, 0x92, 0x88, 0x88, 0x91, 0x89, 0x8b, 0x8b, 0x8a, 0x8a, 
0x8b, 0x8c, 0x8e, 0x8d, 0x8a, 0x8b, 0x8b, 0x89, 0x89, 0x89, 0x88, 0x92, 0x91, 0x88, 0x88, 0x89, 0x8a, 0x87, 0x88, 0x89, 0x8b, 0x8b, 0x8c, 0x8f, 0x6d, 0x0f, 0x6d, 0x0e, 0x89, 0x88, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8c, 0x8b, 0x89, 0x88, 0x88, 0x89, 0x8b, 0x8c, 0x8e, 0x8e, 0x8e, 0x8d, 0x8b, 0x8a, 0x88, 0x0d, 0x0f, 0x8b, 0x92, 0x88, 0x91, 0x88, 0x88, 0x88, 0x8a, 0x8b, 0x8a, 0x8c, 
0x8e, 0x0d, 0x9f, 0x0e, 0x8f, 0x8c, 0x8c, 0x8b, 0x8a, 0x92, 0x88, 0x87, 0x87, 0x91, 0x91, 0x89, 0x92, 0x92, 0x89, 0x92, 0x89, 0x8a, 0x8c, 0x9f, 0x0f, 0x0f, 0x0e, 0x8a, 0x91, 0x8a, 0x8a, 0x89, 0x8b, 0x8d, 0x8c, 0x8b, 0x8c, 0x8b, 0x8c, 0x8c, 0x93, 0x8a, 0x89, 0x88, 0x88, 0x89, 0x8b, 0x8d, 0x8f, 0x8e, 0x8c, 0x8b, 0x0d, 0x8e, 0x89, 0x91, 0x88, 0x87, 0x92, 0x91, 0x92, 0x8c, 0x8d, 0x8d, 
0x0e, 0x09, 0x0f, 0x6d, 0x0e, 0x0d, 0x8d, 0x8a, 0x92, 0x88, 0x91, 0x88, 0x92, 0x87, 0x88, 0x89, 0x88, 0x92, 0x8a, 0x92, 0x92, 0x8c, 0x0e, 0x0f, 0x8e, 0x8b, 0x89, 0x88, 0x8a, 0x8c, 0x92, 0x92, 0x8b, 0x8c, 0x8c, 0x8b, 0x8b, 0x8b, 0x8c, 0x8c, 0x8a, 0x89, 0x8b, 0x8a, 0x92, 0x88, 0x91, 0x8a, 0x8b, 0x8c, 0x8e, 0x8f, 0x8f, 0x0e, 0x8b, 0x87, 0x92, 0x88, 0x87, 0x88, 0x88, 0x8b, 0x8e, 0x8f, 
0x0f, 0x6d, 0x0f, 0x0f, 0x6d, 0x0f, 0x0d, 0x8b, 0x87, 0x88, 0x92, 0x88, 0x92, 0x88, 0x92, 0x89, 0x92, 0x88, 0x89, 0x87, 0x89, 0x8e, 0x0d, 0x8c, 0x89, 0x87, 0x92, 0x8a, 0x8b, 0x8a, 0x89, 0x8b, 0x8c, 0x8b, 0x8c, 0x8d, 0x8c, 0x8a, 0x8a, 0x8b, 0x92, 0x92, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x89, 0x88, 0x91, 0x88, 0x8a, 0x8c, 0x9f, 0x0d, 0x88, 0x92, 0x92, 0x91, 0x91, 0x88, 0x8a, 0x8e, 0x9f, 
0x0e, 0x0e, 0x6c, 0x0e, 0x0e, 0x6d, 0x09, 0x0d, 0x89, 0x91, 0x91, 0x87, 0x87, 0x91, 0x92, 0x8a, 0x92, 0x88, 0x92, 0x88, 0x8b, 0x0d, 0x8b, 0x89, 0x8b, 0x8a, 0x8b, 0x8a, 0x89, 0x8b, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x92, 0x89, 0x8b, 0x8b, 0x89, 0x92, 0x92, 0x89, 0x88, 0x88, 0x8e, 0x8b, 0x88, 0x92, 0x87, 0x87, 0x92, 0x8b, 0x8d, 0x0d, 
0x0d, 0x9f, 0x0e, 0x0e, 0x6d, 0x0e, 0x0e, 0x0f, 0x8c, 0x88, 0x87, 0x88, 0x91, 0x87, 0x88, 0x88, 0x88, 0x88, 0x89, 0x8c, 0x8d, 0x8d, 0x8b, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x8a, 0x8d, 0x8d, 0x8c, 0x8b, 0x8b, 0x8a, 0x8b, 0x8b, 0x8b, 0x8a, 0x8b, 0x8b, 0x8a, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x8a, 0x8a, 0x8a, 0x91, 0x8a, 0x8c, 0x92, 0x92, 0x89, 0x89, 0x89, 0x8b, 0x8c, 0x8e, 
0x8f, 0x8f, 0x0d, 0x0d, 0x0e, 0x0d, 0x9f, 0x0e, 0x0d, 0x8c, 0x92, 0x92, 0x92, 0x88, 0x91, 0x91, 0x92, 0x92, 0x8b, 0x8d, 0x8e, 0x8c, 0x8c, 0x8b, 0x8a, 0x8c, 0x8a, 0x89, 0x8b, 0x8c, 0x8e, 0x8d, 0x8c, 0x8c, 0x8c, 0x8a, 0x8a, 0x8b, 0x8a, 0x89, 0x8b, 0x8a, 0x93, 0x8b, 0x8a, 0x8b, 0x8b, 0x8b, 0x89, 0x8a, 0x8b, 0x8c, 0x8b, 0x8b, 0x89, 0x8b, 0x8a, 0x88, 0x92, 0x92, 0x89, 0x8a, 0x8b, 0x8d, 
0x8c, 0x8d, 0x8e, 0x8f, 0x8f, 0x0d, 0x8f, 0x8e, 0x0d, 0x6d, 0x8c, 0x8a, 0x8a, 0x92, 0x89, 0x89, 0x8b, 0x8d, 0x8e, 0x8e, 0x8b, 0x8a, 0x8b, 0x8b, 0x8c, 0x8e, 0x8d, 0x8d, 0x8c, 0x8d, 0x8c, 0x8d, 0x8c, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8c, 0x8a, 0x93, 0x8b, 0x89, 0x8b, 0x8a, 0x89, 0x93, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8c, 0x8b, 0x88, 0x88, 0x88, 0x92, 0x89, 0x8a, 0x8c, 
0x8b, 0x8b, 0x8c, 0x8d, 0x8c, 0x8d, 0x8e, 0x8d, 0x8d, 0x8d, 0x0d, 0x0d, 0x8d, 0x8d, 0x8d, 0x8e, 0x0e, 0x09, 0x8f, 0x8b, 0x89, 0x89, 0x8b, 0x8c, 0x8d, 0x8f, 0x8e, 0x8e, 0x8b, 0x8c, 0x8e, 0x8d, 0x8b, 0x8a, 0x8a, 0x8b, 0x8c, 0x8a, 0x8b, 0x8c, 0x8c, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x8c, 0x8d, 0x8c, 0x8a, 0x8a, 0x8b, 0x8b, 0x8c, 0x8c, 0x89, 0x92, 0x89, 0x92, 0x89, 0x8a, 0x8a, 
0x8a, 0x8a, 0x8b, 0x8a, 0x8b, 0x8d, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x0d, 0x0f, 0x09, 0x0f, 0x6d, 0x8f, 0x8c, 0x8a, 0x8a, 0x89, 0x8b, 0x8a, 0x8c, 0x8f, 0x8c, 0x8b, 0x8c, 0x8c, 0x8d, 0x8c, 0x8b, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x8b, 0x8c, 0x8b, 0x8b, 0x8c, 0x8b, 0x8b, 0x8c, 0x8c, 0x8b, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x8b, 0x8a, 0x8b, 0x8c, 0x8b, 0x88, 0x88, 0x92, 0x92, 0x89, 0x8a, 
0x89, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8b, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x8c, 0x6d, 0x0e, 0x6d, 0x0e, 0x8d, 0x8a, 0x8a, 0x89, 0x93, 0x8b, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x8c, 0x8c, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8c, 0x8b, 0x8c, 0x8d, 0x8c, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x8c, 0x8e, 0x8c, 0x8b, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x91, 0x88, 0x88, 0x89, 0x8a, 
0x89, 0x89, 0x89, 0x92, 0x88, 0x92, 0x89, 0x8a, 0x8a, 0x8b, 0x8b, 0x8a, 0x89, 0x8f, 0x0f, 0x0e, 0x0d, 0x8d, 0x89, 0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x8b, 0x8c, 0x8c, 0x8c, 0x8d, 0x8c, 0x8b, 0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8c, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8a, 0x8a, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8a, 0x92, 0x92, 0x92, 0x92, 0x89, 
0x92, 0x89, 0x92, 0x92, 0x88, 0x88, 0x88, 0x88, 0x92, 0x89, 0x88, 0x88, 0x86, 0x8a, 0x6d, 0x0d, 0x8c, 0x8a, 0x92, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8b, 0x8c, 0x8b, 0x8d, 0x8d, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x8c, 0x8b, 0x8c, 0x8c, 0x8b, 0x8a, 0x8b, 0x8b, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x89, 0x88, 0x88, 0x92, 0x89, 
0x89, 0x92, 0x88, 0x92, 0x88, 0x92, 0x87, 0x92, 0x88, 0x91, 0x86, 0x86, 0x91, 0x92, 0x0e, 0x0d, 0x8c, 0x89, 0x88, 0x89, 0x92, 0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8d, 0x8c, 0x8b, 0x8b, 0x8b, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8d, 0x8c, 0x8a, 0x8a, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8b, 0x8a, 0x8b, 0x8b, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x89, 0x91, 0x88, 0x8a, 
0x89, 0x92, 0x88, 0x88, 0x87, 0x91, 0x87, 0x87, 0x91, 0x87, 0x91, 0x92, 0x87, 0x87, 0x8e, 0x0d, 0x8a, 0x92, 0x92, 0x92, 0x89, 0x89, 0x8b, 0x8a, 0x8b, 0x8b, 0x8b, 0x8c, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8d, 0x8d, 0x8e, 0x8d, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8c, 0x88, 0x88, 0x89, 
0x89, 0x92, 0x88, 0x91, 0x88, 0x91, 0x88, 0x91, 0x87, 0x88, 0x88, 0x92, 0x92, 0x87, 0x89, 0x8d, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8b, 0x8c, 0x8b, 0x8a, 0x8b, 0x8b, 0x8b, 0x8b, 0x8d, 0x8d, 0x8e, 0x8e, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8c, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8e, 0x8e, 0x8d, 0x8e, 0x8d, 0x8d, 0x8d, 0x8c, 0x8d, 0x8d, 0x8d, 0x8e, 0x8f, 0x8e, 0x8a, 0x92, 
0x92, 0x88, 0x88, 0x91, 0x88, 0x92, 0x87, 0x92, 0x92, 0x88, 0x92, 0x88, 0x87, 0x92, 0x89, 0x8b, 0x8a, 0x89, 0x8a, 0x8a, 0x8b, 0x8c, 0x8c, 0x8b, 0x8c, 0x8c, 0x8d, 0x8c, 0x8d, 0x8f, 0x8e, 0x8f, 0x8f, 0x0d, 0x0d, 0x8e, 0x8d, 0x8c, 0x8d, 0x8d, 0x8e, 0x8d, 0x8d, 0x8e, 0x8f, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8d, 0x8e, 0x8f, 0x8f, 0x8e, 0x8e, 0x8e, 0x8d, 0x8c, 0x8d, 0x8e, 0x8c, 0x89, 
0x92, 0x88, 0x92, 0x88, 0x92, 0x88, 0x92, 0x88, 0x92, 0x89, 0x89, 0x88, 0x91, 0x89, 0x8b, 0x8b, 0x8a, 0x8b, 0x8c, 0x8d, 0x8c, 0x8c, 0x8c, 0x8a, 0x8b, 0x8c, 0x8b, 0x8b, 0x8c, 0x8c, 0x8a, 0x8a, 0x8a, 0x8b, 0x8e, 0x9f, 0x8f, 0x0d, 0x8e, 0x8e, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8f, 0x8f, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x0d, 0x0d, 0x6c, 0x0e, 0x9f, 0x0e, 0x6e, 0x6f, 0x09, 0x0d, 0x8c, 0x8b, 
0x88, 0x88, 0x88, 0x8a, 0x89, 0x89, 0x8a, 0x92, 0x88, 0x92, 0x88, 0x92, 0x92, 0x88, 0x8b, 0x8a, 0x8c, 0x8d, 0x8a, 0x8b, 0x8a, 0x89, 0x89, 0x92, 0x87, 0x87, 0x91, 0x87, 0x87, 0x87, 0x87, 0x91, 0x92, 0x89, 0x8a, 0x8e, 0x0e, 0x6c, 0x0d, 0x8f, 0x8e, 0x8d, 0x8e, 0x8d, 0x8c, 0x8e, 0x9e, 0x8e, 0x8f, 0x0d, 0x9e, 0x0e, 0x6d, 0x0e, 0x09, 0x0f, 0x6e, 0x05, 0x02, 0x00, 0x07, 0x0e, 0x8b, 0x92, 
0x92, 0x92, 0x92, 0x89, 0x89, 0x8a, 0x89, 0x89, 0x8a, 0x92, 0x88, 0x88, 0x89, 0x8a, 0x89, 0x92, 0x8c, 0x8c, 0x87, 0x87, 0x89, 0x91, 0x87, 0x92, 0x87, 0x91, 0x92, 0x89, 0x92, 0x87, 0x88, 0x87, 0x88, 0x8a, 0x8b, 0x8b, 0x8d, 0x8e, 0x0d, 0x9f, 0x8e, 0x8e, 0x8f, 0x8e, 0x8d, 0x8e, 0x0d, 0x0d, 0x9e, 0x0d, 0x6d, 0x0f, 0x09, 0x0f, 0x6d, 0x0f, 0x0f, 0x4e, 0x6f, 0x01, 0x06, 0x6d, 0x8c, 0x88, 
0x87, 0x88, 0x88, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x89, 0x92, 0x92, 0x92, 0x89, 0x8a, 0x8a, 0x92, 0x88, 0x92, 0x88, 0x91, 0x89, 0x89, 0x88, 0x87, 0x88, 0x92, 0x88, 0x92, 0x88, 0x92, 0x88, 0x92, 0x8b, 0x8a, 0x8b, 0x8c, 0x8d, 0x0d, 0x9e, 0x8e, 0x8e, 0x9e, 0x0d, 0x0d, 0x6c, 0x0d, 0x0e, 0x6d, 0x0f, 0x0e, 0x0e, 0x09, 0x0e, 0x6d, 0x0f, 0x6d, 0x0f, 0x6e, 0x0f, 0x0f, 0x0e, 0x8b, 
0x89, 0x92, 0x89, 0x8a, 0x93, 0x8a, 0x89, 0x93, 0x8a, 0x89, 0x92, 0x92, 0x89, 0x89, 0x92, 0x89, 0x93, 0x88, 0x88, 0x89, 0x92, 0x92, 0x89, 0x89, 0x92, 0x92, 0x92, 0x88, 0x92, 0x88, 0x92, 0x92, 0x92, 0x89, 0x8b, 0x8b, 0x8a, 0x8b, 0x8b, 0x8c, 0x8f, 0x8e, 0x8e, 0x8f, 0x0d, 0x9f, 0x0d, 0x0e, 0x6d, 0x0e, 0x0e, 0x8d, 0x8e, 0x0e, 0x0d, 0x0d, 0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x09, 0x6d, 0x8d, 
0x8c, 0x8b, 0x8a, 0x8a, 0x8b, 0x89, 0x8a, 0x8a, 0x92, 0x89, 0x89, 0x89, 0x8a, 0x89, 0x92, 0x89, 0x8a, 0x89, 0x89, 0x92, 0x89, 0x92, 0x89, 0x92, 0x89, 0x8a, 0x89, 0x89, 0x92, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8a, 0x8c, 0x8e, 0x8f, 0x8e, 0x0d, 0x0e, 0x0e, 0x9f, 0x0f, 0x0e, 0x8c, 0x8b, 0x8c, 0x8d, 0x0d, 0x0d, 0x0d, 0x8f, 0x6c, 0x0e, 0x6d, 0x0f, 0x0f, 0x0e, 
0x8f, 0x8c, 0x8c, 0x8b, 0x8a, 0x93, 0x8b, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x89, 0x88, 0x88, 0x92, 0x89, 0x8b, 0x8b, 0x89, 0x92, 0x88, 0x89, 0x92, 0x92, 0x92, 0x88, 0x89, 0x89, 0x8a, 0x93, 0x8a, 0x8b, 0x8c, 0x8a, 0x8a, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x8c, 0x0d, 0x9e, 0x0e, 0x6c, 0x0e, 0x0e, 0x6d, 0x0e, 0x8c, 0x8c, 0x8c, 0x8c, 0x8e, 0x8e, 0x8e, 0x8e, 0x0d, 0x0d, 0x0d, 0x6c, 0x0d, 0x0d, 
0x8d, 0x8c, 0x8c, 0x8c, 0x8b, 0x8b, 0x8a, 0x8a, 0x89, 0x8a, 0x8a, 0x92, 0x92, 0x92, 0x92, 0x89, 0x8a, 0x8b, 0x89, 0x92, 0x89, 0x92, 0x88, 0x89, 0x89, 0x8a, 0x8a, 0x89, 0x8a, 0x8a, 0x8a, 0x8b, 0x8c, 0x8b, 0x8b, 0x8a, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x8b, 0x8c, 0x8f, 0x0d, 0x8f, 0x0d, 0x0d, 0x0e, 0x0d, 0x8b, 0x8b, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8c, 0x8d, 0x8d, 0x8e, 0x8f, 0x8e, 0x8d, 
0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8c, 0x8c, 0x8b, 0x93, 0x8a, 0x8a, 0x88, 0x92, 0x88, 0x92, 0x89, 0x8a, 0x8a, 0x88, 0x92, 0x8a, 0x92, 0x92, 0x89, 0x89, 0x89, 0x8a, 0x89, 0x93, 0x8b, 0x8a, 0x8a, 0x8d, 0x8c, 0x8c, 0x93, 0x8a, 0x8a, 0x92, 0x89, 0x8a, 0x8a, 0x8b, 0x8d, 0x8c, 0x8c, 0x8c, 0x8d, 0x8f, 0x8c, 0x89, 0x8a, 0x8a, 0x8a, 0x8b, 0x8c, 0x8b, 0x8c, 0x8c, 0x8c, 0x8c, 0x8d, 0x8d, 0x8d, 
};
