// Crimson Fields -- a game of tactical warfare
// Copyright (C) 2000-2004 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

////////////////////////////////////////////////////////////////////////
// game.h
////////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_GAME_H
#define _INCLUDE_GAME_H

#include "mission.h"
#include "mapwindow.h"
#include "extwindow.h"
#include "list.h"
#include "path.h"
#include "globals.h"

#define PROGRAMNAME "Crimson Fields"

// global vars
extern class Game *Gam;
extern class Image *Images[];

#define ICON_WIDTH	32
#define ICON_HEIGHT	32
#define XP_ICON_WIDTH	12
#define XP_ICON_HEIGHT	14

#define ICON_XP_BASE	0	// XP icons are 0 through 6
#define NUM_IMAGES	7

#define DEFAULT_DELAY	(5 * ANIM_SPEED_UNIT)

class Game : public WidgetHook {
public:
  Game( View *view );
  virtual ~Game( void );

  int Load( const char *file );
  int Save( const char *file );

  void InitWindows( void );
  void InitKeys( void );
  void Quit( void ) const;
  void Shutdown( void ) const;
  GUI_Status HandleEvent( const SDL_Event &event );

  GUI_Status StartTurn( void );
  GUI_Status EndTurn( void );

  void SetCursor( const Point &cursor ) const;
  Unit *MoveUnit( Unit *u, const Point &dest );
  int MoveUnit( Unit *u, Direction dir );
  void SelectUnit( Unit *u );
  void DeselectUnit( bool update = true );

  MapWindow *GetMapWindow( void ) const { return mwin; }
  Mission *GetMission( void ) const { return mission; }
  void UnitInfo( Unit *unit );
  void ResolveBattle( Combat *com );

private:
  string CreateSaveFileName( const char *filename ) const;
  void ClearMine( Transport *sweeper, Unit *mine );
  bool HaveWinner( void );
  GUI_Status CheckEvents( void );

  void MoveCommand( int key );
  void SelectCommand( const Point &hex );
  void ScrollCommand( int key );
  void HandleLMB( const Point &hex );
  void EnterSpecialMode( unsigned char mode );
  void SelectNextUnit( void );

  bool UnitTargets( Unit *u ) const;
  bool MinesweeperTargets( Unit *u ) const;

  void ShowBriefing( void ) const;
  GUI_Status ShowDebriefing( Player &player, bool restart );
  void ShowLevelInfo( void ) const;
  void ContainerContent( UnitContainer *c );
  void GameMenu( void );
  void UnitMenu( Unit *unit );
  int SwitchMap( const char *mission );

  bool SetPlayerPassword( Player *player ) const;
  bool CheckPassword( const char *title, const char *msg, const char *pw, short retry ) const;

  GUI_Status WidgetActivated( Widget *button, Window *win );

  Mission *mission;
  MapWindow *mwin;

  Unit *unit;		// selected unit

  short keys[6];	// keyboard shortcuts

  MoveShader *shader;
  View *view;

  string last_file_name; // remember save file names
  Unit *g_tmp_prv_unit;
};

#endif	/* _INCLUDE_GAME_H */

