/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *   
 *  Copyright (C) 2003,2004 Rene Rebe <rene@rocklinux.org>
 *
 *  2003.16.08
 *  - added support for cpu monitoring, base code by Dietz Proepper and minor
 *    fixes by Mattia Dongili
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdarg.h>
#include <limits.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <syslog.h>
#include <signal.h>
#include <ctype.h>
#include <dirent.h>
#include <dlfcn.h>
#include <libgen.h>

#include "string_list.h"

#define _CPUFREQD_VERSION_ 	"1.1.2"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef CPUFREQD_CONFDIR
#define CPUFREQD_CONFDIR  "/etc/"
#endif

#ifndef CPUFREQD_LIBDIR
#define CPUFREQD_LIBDIR   ""
#endif

#ifndef CPUFREQD_STATEDIR
#define CPUFREQD_STATEDIR   "/var/"
#endif

#define CPUFREQD_CONFIG   CPUFREQD_CONFDIR"cpufreqd.conf"
#define CPUFREQD_PIDFILE  CPUFREQD_STATEDIR"run/cpufreqd.pid"
#define APM_PROC_FILE     "/proc/apm"
#define ACPI_PROC_DIR     "/proc/acpi/"
#define ACPI_BATTERY_DIR  "/proc/acpi/battery/"
#define ACPI_AC_DIR       "/proc/acpi/ac_adapter/"
#define PMU_PROC_DIR      "/proc/pmu"

#define CPUFREQ_SYSFS_INTERFACE 	      "/sys/devices/system/cpu/cpu0/cpufreq"
#define CPUFREQ_SYSFS_INTERFACE_POLICY  "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor"
#define CPUFREQ_SYSFS_INTERFACE_MAX     "/sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq"
#define CPUFREQ_SYSFS_INTERFACE_MIN     "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq"
#define CPUFREQ_PROC_INTERFACE          "/proc/cpufreq"
#define CPUFREQ_PROC_INTERFACE_SPEED    "/proc/sys/cpu/0/speed"
#define CPUFREQ_PROC_INTERFACE_MIN      "/proc/sys/cpu/0/speed-min"
#define CPUFREQ_PROC_INTERFACE_MAX      "/proc/sys/cpu/0/speed-max"

typedef struct {
  int min;
  int max;
} battery_interval;

typedef struct {
  int min;
  int max;
} cpu_interval;

typedef struct profile {
  char name[255];
  long int min_freq;
  long int max_freq;
  unsigned char sep;
  char policy_name[255];
  struct profile *next;
} profile;

/* TODO: add precedence factor for rules having he same score */
/* TODO: add a command to be executed after the rule is activated */
typedef struct rule {
  char name[255];
  unsigned int ac;        /* AC power state */
  battery_interval *bat;
  cpu_interval *cpu;  
  char profile_name[255];
  struct string_list *program_list;
  profile *prof;
  struct rule *next;
  int hits;
} rule;

typedef struct sys_info {
  int has_battery:1;
  unsigned int ac;
  int cpu_percent;
  int battery_percent;
  int battery_time;
  int temp;
  unsigned int flags;
	char version[101];
	char time[101];
} sys_info;

#define MATCH_AC       8
#define MATCH_CPU      4
#define MATCH_BATTERY  2
#define MATCH_PROG     1

#define DEFAULT_VERBOSITY   4
#define DEFAULT_POLL        1
#define DEFAULT_PMPLUGIN    "apm"

typedef struct {
  char config_file[512];
  char pidfile[512];
  char pm_plugin[101];
  unsigned int poll_interval;
  unsigned int has_sysfs;
  unsigned int no_daemon;
  unsigned int log_level_overridden;
  unsigned int acpi_workaround;
  int log_level;
  rule *rules;
  profile *profiles;
} general;

