/* disks.c (cpudyn) - Functions to put a disk in stand by            */
/*          - by Ricardo Galli (C) 2003      -- Licence GPL          */

#include <time.h>



struct _device_t;
typedef struct _device_t {
	char        *dev;
	char		*sys_stat;
	int         fd;
	unsigned    major;
	unsigned    minor;
	unsigned    ops;
	time_t      timestamp;
	struct _device_t    *next;
	unsigned    sleeping;
	unsigned    flushed;
//	unsigned	dummy_ops;	// Kernel 2.5 adds 1 even por ioctls
} device_t;

typedef unsigned (*get_opts_t)(device_t *, int);




// Forward declarations
get_opts_t get_device_t_ops_version();
unsigned get_device_t_ops_25(device_t *, int );
unsigned get_device_t_ops_24(device_t *, int );
