/*
 * This file is part of the FORS Data Reduction Pipeline
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * response.h
 *
 *  Created on: 2014 3 28
 *      Author: cgarcia
 */

#ifndef RESPONSE_H_
#define RESPONSE_H_

#include <vector>
#include <utility>
#include "spectrum.h"
#include "spec_std_star.h"

namespace mosca {

class response
{
public:

    typedef std::pair<double, double> wave_range;

    response();

    virtual ~response();
    
    void compute_response
       (spectrum& observed_spectrum, spec_std_star& std_star);

    void fit_response
        (int spline_knots,
         const std::vector<double>& ignored_waves  = std::vector<double>(),
         const std::vector<wave_range>& ignored_wave_ranges = 
                         std::vector<wave_range>());    
    std::vector<double>& wave();

    std::vector<double>& efficiency_raw();

    std::vector<double>& efficiency_fit();

    std::vector<double>& response_fit();

    std::vector<double>& response_raw();

    std::vector<double>& observed_flux();

    std::vector<double>& tabulated_flux();

private:
    
    std::vector<double> m_wave;

    std::vector<double> m_wave_bin;
    
    std::vector<double> m_efficiency_raw;

    std::vector<double> m_efficiency_fit;

    std::vector<double> m_response_fit;

    std::vector<double> m_response_raw;

    std::vector<double> m_observed_flux;

    std::vector<double> m_tabulated_flux;
};

} /* namespace mosca */
#endif /* RESPONSE_H_ */
