/* $Id: fors_flat_normalise.h,v 1.3 2013-09-09 12:14:12 cgarcia Exp $
 *
 * This file is part of the VIMOS Pipeline
 * Copyright (C) 2002-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-09-09 12:14:12 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifndef FORS_FLAT_NORMALISE_H
#define FORS_FLAT_NORMALISE_H

#include <cpl.h>
#include "mosca_image.h"

namespace fors
{

class flat_normaliser
{
    
public:

    flat_normaliser();
    ~flat_normaliser();
    
    int mos_normalise(mosca::image& flat, cpl_image *spatial, 
                      cpl_table *slits, cpl_table *polytraces, 
                      double reference, double blue, double red, 
                      double dispersion,
                      int spa_smooth_radius, int disp_smooth_radius, 
                      int spa_fit_polyorder, int disp_fit_nknots,
                      double fit_threshold);
    
    int lss_normalise(mosca::image& flat,
                       int spa_smooth_radius, int disp_smooth_radius, 
                       int spa_fit_polyorder, int disp_fit_nknots,
                       double fit_threshold);

    const mosca::image& get_normalisation_image() const;
    
    const std::vector<std::vector<float> >& get_wave_profiles() const;
    
    cpl_image * get_wave_profiles_im() const;

private:
    
    mosca::image m_normalisation_image;
    
    std::vector<std::vector<float> > m_wave_profiles;
    
    
};

}

#endif   /* FORS_FLAT_NORMALISE_H */
