---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Обновление Windows Phone

В этом руководстве показано, как изменить Windows Phone проектов, обе версии 7 и 8, для обновления старых версий Cordova. Большинство этих инструкций применимы для проектов, созданных с старого набора средств командной строки, которые предшествуют `cordova` утилиты CLI. Увидеть интерфейс командной строки для информации как обновить версию инфраструктуры CLI. В следующем разделе показано, как перейти от проектов-CLI.

## Обновление к CLI (3.0.0) с 2.9.0

1.  Создайте новый проект Apache Cordova 3.0.0, используя cordova CLI, как описано в интерфейс командной строки.

2.  Добавить ваши платформы cordova проекта, например:`cordova
platform add wp7 wp8`.

3.  Скопируйте содержимое проекта `www` каталог `www` директорию в корне проекта cordova, вы только что создали.

4.  Копировать или перезаписать любые родной активы от вашего первоначального проекта ( `SplashScreen` , `ApplicationIcon` , и т.д.), что делает уверен, чтобы добавить новые файлы в `.csproj` файл. Построение проектов внутри Телефон windows `platforms\wp7` или `platforms\wp8` каталог.

5.  Используйте средство CLI cordova для установки плагинов, что вам нужно. Обратите внимание, что CLI обрабатывает все основные API плагинов, так что они могут и должны быть добавлены. Только 3.0.0 плагины совместимы с CLI.

6.  Построение и тестирование.

## Обновление до 3.0.0 (номера CLI) с 2.9.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 3.0.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

4.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

5.  Построение и тестирование.

**Примечание:** все основные API будут удалены от Кордова версии 3.0 и должны устанавливаться отдельно как плагины. Дополнительные сведения о том, как повторно включить эти функции в рабочем процессе-CLI см с помощью Plugman управление плагины.

## Обновление до 2.9.0 с 2.8.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.9.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить имя `cordova.js` в теге HTML, если это по-прежнему используя cordova-VERSION.js (должно быть просто`cordova.js`).

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в файл .csproj.

6.  Построение и тестирование.

## Обновление до 2.8.0 от 2.7.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.8.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova.js` файл. (Обратите внимание на отсутствие номер версии в имени файла.)

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 2.7.0 с 2.6.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.7.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.7.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 2.6.0 с 2.5.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.6.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.6.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 2.5.0 с 2.4.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.5.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.5.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление 2.4.0 с 2.3.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый Apache Cordova WP7 или WP8 2.4.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.4.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновления 2.3.0 из 2.2.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый WP7 Apache Cordova 2.3.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.3.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 2.2.0 из 2.1.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый WP7 Apache Cordova 2.2.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.2.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление 2.1.0 от 2.0.0

В окне Обозреватель решений Visual Studio:

1.  Создайте новый WP7 Apache Cordova 2.1.0 проекта.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.1.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 2.0.0 от 1.9.0

Произошли значительные изменения к структуре проекта WP7 в Apache Cordova 2.0.0 которые делают это обновления немного сложнее которые другие. По существу это не обновления, но создание нового проекта и скопируйте существующих исходных файлов.

В окне Обозреватель решений Visual Studio:

1.  Создайте новый проект 2.0 WP7 Apache Cordova.

2.  Скопируйте содержимое вашего `www` каталога в новый проект и убедитесь, что эти элементы добавляются в проект VS.

3.  Обновить ваш HTML, чтобы использовать новый `cordova-2.0.0.js` файл.

4.  Скопируйте и перезаписать любой экран-заставку, или изображения значка.

5.  Копирование через любые плагины от `plugins` каталога в новый проект и убедитесь, что они также добавляются в проект VS.

6.  Построение и тестирование.

## Обновление до 1.9.0 от 1.8.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.9.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.9.0.js` файл.

## Обновление до 1.8.0 от 1.7.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.8.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.8.0.js` файл.

## Обновить до версии 1.7.0 1.6.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.7.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.7.0.js` файл.

## Обновить до 1.6.1 1.6.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.6.1.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.6.1.js` файл.

## Обновление до 1.6.0 от 1.5.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.6.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.6.0.js` файл.

## Обновление до 1.5.0 с 1.4.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.5.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.5.0.js` файл.

## Обновление до 1.4.0 от 1.3.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.4.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.4.0.js` файл.

## Обновления 1.3.0 из 1.2.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.3.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.3.0.js` файл.

## Обновление до 1.2.0 с 1.1.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** Вы можете просматривать версию библиотеки DLL, щелкнув правой кнопкой мыши на ссылку и выбрав **Свойства**.

5.  Скопируйте новый `cordova-1.2.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.2.0.js` файл.

## Обновление 1.1.0 1.0.0

В окне Обозреватель решений Visual Studio:

1.  Удалить `GapLib/WP7CordovaClassLib.dll` из вашего проекта.

2.  Удалите ссылку на `WP7CordovaClassLib` в папке **ссылки** .

3.  Щелкните правой кнопкой мыши **ссылки** и выберите **Добавить ссылку**.

4.  Перейдите к новое распределение и добавить файл`WP7CordovaClassLib.dll`.
    
    *   **Примечание:** версия библиотеки DLL можно просмотреть, щелкнув правой кнопкой мыши на ссылку и выбрав **свойства**.

5.  Скопируйте новый `cordova-1.1.0.js` в ваш проект. (Убедитесь, что он помечен как содержимого.)

6.  Обновить ваш HTML, чтобы использовать новый `cordova-1.1.0.js` файл.