---
license: Licensed to the Apache Software Foundation (ASF) under one
         or more contributor license agreements.  See the NOTICE file
         distributed with this work for additional information
         regarding copyright ownership.  The ASF licenses this file
         to you under the Apache License, Version 2.0 (the
         "License"); you may not use this file except in compliance
         with the License.  You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0

         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
         under the License.
---

# The config.xml File

Many aspects of an app's behavior can be controlled with a global
configuration file, `config.xml`, that is placed in the top-level web
asset directory along with the app's home page.  This
platform-agnostic XML file is formatted based on the W3C's [Packaged
Web Apps (Widgets)](http://www.w3.org/TR/widgets/) specification, and
extended to specify core Cordova API features, plugins, and
platform-specific settings.

For projects created with the Cordova CLI (described in The
Command-line Interface), this file can be found in the top-level `www`
directory.  Using the CLI to build a project regenerates versions of
this file in various subdirectories within `platforms`. If you use the
CLI to create a project, but then shift your workflow to an SDK, the
platform-specific file serves as a source.

This section details global and cross-platform configuration options.
See the following sections for platform-specific options:

- iOS Configuration
- Android Configuration
- BlackBerry Configuration

## Core Configuration Elements

This example shows the default `config.xml` generated by the CLI's
`create` command, described in The Command-line Interface:

        <widget id="com.example.hello" version="0.0.1">
            <name>HelloWorld</name>
            <description>
                A sample Apache Cordova application that responds to the deviceready event.
            </description>
            <author email="dev@callback.apache.org" href="http://cordova.io">
                Apache Cordova Team
            </author>
            <content src="index.html" />
            <access origin="*" />
            <preference name="Fullscreen" value="true" />
            <preference name="WebViewBounce" value="true" />
        </widget>

<!-- QUERY: is WebViewBounce superseded by DisallowOverscroll? -->

The following configuration elements appear in the top-level
`config.xml` file, and are supported across all supported Cordova
platforms:

- The `<widget>` element's `id` attribute provides the app's
  reverse-domain identifier, and the `version` its full version number
  expressed in major/minor/patch notation.

- The `<name>` element specifies the app's formal name, as it appears
  on the device's home screen and within app-store interfaces.

- The `<description>` and `<author>` elements specify metadata and
  contact information that may appear within app-store listings.

- The optional `<content>` element defines your application's starting
  page in the top-level web assets directory. The default value is
  `index.html`, which customarily appears in a project's top-level
  `www` directory.

- `<access>` elements define the set of external domains the app is
  allowed to communicate with. The default value shown above allows it
  to access any server. See the Domain Whitelist Guide for details.

- The `<preference>` tag sets various options as pairs of
  `name`/`value` attributes. Each preference's `name` is
  case-insensitive.  Many preferences are unique to specific
  platforms, as listed at the top of this page. The following sections
  detail preferences that apply to more than one platform.

## Global Preferences

The following global preferences apply to all platforms:

- `Fullscreen` allows you to hide the status bar at the top of the
  screen. The default value is `false`. Example:

        <preference name="Fullscreen" value="true" />

- `Orientation` allows you to lock orientation and prevent the
  interface from rotating in response to changes in orientation.
  Possible values are `default`, `landscape`, or `portrait`. Example:

        <preference name="Orientation" value="landscape" />

  __NOTE:__ The `default` value means _both_ landscape and portrait
  orientations are enabled.  If you want to use each platform's
  default settings (usually portrait-only), leave this tag out of the
  `config.xml` file. Also, BlackBerry uses `auto` instead of `default`
  in its `config.xml` file. If you specify `default` in the global
  `config.xml`, it translates to `auto` in the BlackBerry build.

## Multi-platform Preferences

The following preferences apply to more than one platform, but not to
all of them:

- `DisallowOverscroll` (boolean, defaults to `false`): set to `true`
  if you don't want the interface to display any feedback when users
  scroll past the beginning or end of content.

        <preference name="DisallowOverscroll" value="true"/>

  Applies to Android and iOS. On iOS, overscroll gestures cause
  content to bounce back to its original position.  On Android, they
  produce a more subtle glowing effect along the top or bottom edge of
  the content.

- `BackgroundColor`: Set the app's background color.  Supports a
  four-byte hex value, with the first byte representing the alpha
  channel, and standard RGB values for the following three bytes.  This
  example specifies blue:

        <preference name="BackgroundColor" value="0xff0000ff"/>

  Applies to Android and BlackBerry. Overrides CSS otherwise available
  across _all_ platforms, for example: `body{background-color:blue}`.

- `HideKeyboardFormAccessoryBar` (boolean, defaults to `false`): set
  to `true` to hide the additional toolbar that appears above the
  keyboard, helping users navigate from one form input to another.

        <preference name="HideKeyboardFormAccessoryBar" value="true"/>

  Applies to iOS and BlackBerry. 

  __NOTE:__ For BlackBerry, valid values are `enable` or `disable`.

## The `<feature>` Element

If you use the CLI to build applications, you use the `plugin` command
to enable device APIs. This does not modify the top-level `config.xml`
file, so the `<feature>` element does not apply to your workflow. If
you are working directly in an SDK and using the platform-specific
`config.xml` file as source, you use the `<feature>` tag to enable
device-level APIs and external plugins. They typically appear in this
form:

        <feature name="Plugin" value="PluginID" />

They often appear with custom values in platform-specific `config.xml`
files. For example, here is how to specify the Device API for Android
projects:

        <feature name="Device">
            <param name="android-package" value="org.apache.cordova.device.Device" />
        </feature>

Here is how the element appears for iOS projects:

        <feature name="Device">
            <param name="ios-package" value="CDVDevice" />
        </feature>

See the API Reference for details on how to specify each feature. See
the Plugin Development Guide for more information on plugins.
