'\" t
.\"	cook - file construction tool
.\"	Copyright (C) 1993, 1994, 1995, 1997, 1998, 1999, 2001 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
.\"
.\" MANIFEST: source of the BUILDING file
.\"
.if n .ftr CB B
.if n .ftr CI I
.if n .ftr CW R
.if n .ftr C  R
.TH Build Cook Cook "Reference Manual"
.so version.so
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.SH NAME
cook \- a file construction tool
.XX "" "How to Build the Sources"
.SH SPACE REQUIREMENTS
You will need about 5MB to unpack and build the
.I Cook
package.
Your milage may vary.
.br
.ne 1i
.SH BEFORE YOU START
There are a few pieces of software you may want to
fetch and install before you proceed with your installation of Cook.
.PP
Please note: if you install these packages into \fI/usr/local\fP (for
example) you must ensure that the \fI./configure\fP script is told
to also look in \fI/usr/local/include\fP for include files (CFLAGS),
and \fI/usr/local/lib\fP for library files (LDFLAGS).  Otherwise the
\&\fI./configure\fP script will incorrecly conclude that they have not
been installed.
.TP 8n
GNU Gettext
.RS
The
.I Cook
package has been internationalized.
It can now print error messages in any of the supported languages.
In order to do this, the GNU Gettext package must be installed
.I before
you run the configure script as detailed in the next section.
This is because the configure script looks for it.
On systems which use the GNU C library, version 2.0 or later,
there is no need to explictly do this as GNU Gettext is included.
Remember to use the GNU Gettext configure \fI--with-gnu-gettext\fP option
if your system has native gettext tools.
.RE
.TP 8n
GNU rx
.RS
Cook needs regular expressions to operate correctly.
Get a copy from your nearest GNU mirror.
On systems which use the GNU C library, version 2.0 or later,
there is no need to explictly do this as GNU rx is included.
.RE
.TP 8n
GNU Groff
The documentation for the
.I Cook
package was prepared using the GNU Groff package.
This distribution includes full documentation,
which may be processed into PostScript or DVI files
at install time \- if GNU Groff has been installed.
You must use GNU Groff version 1.15 or later.
.TP 8n
Bison
If your operating system does not have a native
.IR yacc (1)
you will need to fetch and install GNU Bison
in order to build the
.I Cook
package.
.TP 8n
GCC
You may also want to consider fetching and installing the GNU C Compiler
if you have not done so already.  This is not essential.
.PP
The GNU FTP archives may be found at \f(CWftp.gnu.org\fP,
and are mirrored around the world.
.br
.ne 1i
.SH SITE CONFIGURATION
The
.B Cook
package is configured using the
.I configure
program included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system-dependent variables used during compilation,
and creates the
.I Makefile
and
.I common/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.PP
Normally,
you just
.I cd
to the directory containing
.IR Cook "'s"
source code and type
.RS
.ft CW
.nf
\fB% \fP./configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
\fB% \fPsh configure
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run
.I configure
using the quiet option;
for example,
.RS
.FT CW
.nf
\fB% \fP./configure --quiet
\bB%\fP
.fi
.ft R
.RE
.PP
There is a known problem with GCC 2.8.3 and HP/UX.
You will need to set \f(CWCFLAGS = -O\fP in the generated Makefile.
(The configure script sets it to \f(CWCFLAGS = -O2\fP.)
This is because the code optimization breaks the fingerprints.
If test 46 fails (see below) this is probably the reason.
.PP
To compile the
.B Cook
package in a different directory from the one
containing the source code,
you must use a version of
.I make
that supports the
.I VPATH variable,
such as
.IR "GNU make" .
.I cd
to the directory where you want the object files and executables to go and run
the
.I configure
script.
.I configure
automatically checks for the source code in the directory that
.I configure
is in and in
.IR \&..
(the parent directory).
If for some reason
.I configure
is not in the source code directory that you are configuring,
then it will report that it can't find the source code.
In that case,
run
.I configure
with the option \f(CW--srcdir=\fP\fIDIR\fP,
where
.I DIR
is the directory that contains the source code.
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B Cook
package's files in
.IR /usr/local/bin ,
.IR /usr/local/lib ,
.IR /usr/local/share
and
.IR /usr/local/man .
There are a number of options which allow you to control the placement
of these files.
.TP 8n
\f[CW]--prefix=\fP\fIPATH\fP
This specifies the path prefix to be used in the installation.
Defaults to \fI/usr/local\fP unless otherwise specified.
.TP 8n
\f[CW]--exec-prefix=\fP\fIPATH\fP
You can specify separate installation prefixes for
architecture-specific files files.
Defaults to \fI${prefix}\fP unless otherwise specified.
.TP 8n
\f[CW]--bindir=\fP\fIPATH\fP
This directory contains executable programs.  On a network, this
directory may be shared between machines with identical hardware and
operating systems; it may be mounted read-only.  Defaults to
\fI${exec_prefix}/bin\fP unless otherwise specified.
.TP 8n
\f[CW]--datadir=\fP\fIPATH\fP
This directory contains installed data, such as the documentation and
cookbooks distributed with Cook.  On a network, this directory may be
shared between all machines; it may be mounted read-only.  Defaults to
\fI${prefix}/share/cook\fP unless otherwise specified.  A ``cook''
directory will be appended if there is none in the specified path.
.TP 8n
\f[CW]--libdir=\fP\fIPATH\fP
This directory contains installed data, such as the error message
catalogues.  On a network, this directory may be shared between machines
with identical hardware and operating systems; it may be mounted
read-only.  Defaults to \fI${exec_prefix}/lib/cook\fP unless otherwise
specified.  A ``cook'' directory will be appended if there is none in
the specified path.
.TP 8n
\f[CW]--mandir=\fP\fIPATH\fP
This directory contains the on-line manual entries.  On a network, this
directory may be shared between all machines; it may be mounted
read-only.  Defaults to \fI${prefix}/man\fP unless otherwise specified.
.PP
.I configure
ignores most other arguments that you give it;
use the \f[CW]--help\fP option for a complete list.
.br
.ne 2i
.PP
On systems that require unusual options for compilation or linking
that the
.I Cook
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne-compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
\fB$ \fPCC='gcc -traditional' LIBS=-lposix ./configure
\fI\&...lots of output...\fP
\fB$\fP
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR cc .
.TP 8n
Variable: CPPFLAGS
Preprocessor flags, commonly defines and include search paths.
Defaults to empty.
It is common to use \f[CW]CFLAGS=-I/usr/local/include\fP to access other
installed packages.
.TP 8n
Variable: INSTALL
Program to use to install files.
The default is
.I install
if you have it,
.I cp
otherwise.
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f(CW-l\fP\fIfoo\fP \f(CW-l\fP\fIbar\fP.
The
.I configure
script will append to this,
rather than replace it.
It is common to use \f[CW]LIBS=-L/usr/local/lib\fP to access other
installed packages.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 1i
.SH BUILDING COOK
All you should need to do is use the
.RS
.ft CW
.nf
\fB% \fPmake
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing nine files:
.IR c_incl ,
.IR cook ,
.IR cookfp ,
.IR cooktime ,
.IR find_libs ,
.I make2cook
and
.IR roffpp .
.TP 8n
.B cook
.The
.I cook
program is a file construction tool,
and may invoke the following tools
in some of its recipes.
.TP 8n
.B cookfp
The
.I cookfp
program is a utility distributed with
.I Cook
which calculates the fingerprints of files.
It uses the same algorithm as the fingerprints used by
.I cook
itself.
For more information, see
.IR cook (1)
and
.IR cookfp (1).
.TP 8n
.B cooktime
The
.I cooktime
program is a utility distributed with
.I Cook
which allows the time-last-modified and time-last-accessed
stamps of files to be set to specific times.
For more information, see
.IR cooktime (1).
.TP 8n
.B c_incl
The
.I c_incl
program is a utility distributed with
.I Cook
which examines C files and determines all the files it includes
directly and indirectly.
For more information, see
.IR c_incl (1).
.TP 8n
.B find_libs
The
.I find_libs
program is a utility distributed with
.I Cook
which tracks down the names of library files,
given cc-style library options (-L and -l).
For more information, see
.IR find_libs (1).
.TP 8n
.B make2cook
The
.I make2cook
program is a utility to help convert Makefiles into cookbooks.
An exact 1:1 semantic mapping is not possible,
so some addition editing is often required.
.TP 8n
.B roffpp
The
.I roffpp
program is a utility distributed with
.I Cook
which acts as a proprocessor for *roff
files,
removing source (\&.so) directives.
It accepts include search path command line options
just as \fI/lib/cpp\fP does.
For more information, see
.IR roffpp (1).
.br
.ne 1.5i
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
\fB% \fPmake clean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I common/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
\fB% \fPmake distclean
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
.PP
The file
.I etc/configure.in
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.br
.ne 1i
.SH TESTING COOK
The
.I Cook
program comes with a test suite.
To run this test suite, use the command
.RS
.ft CW
.nf
\fB% \fPmake sure
\fI\&...lots of output...\fP
.if n \fBPassed All Tests\fP
.if t \f(CBPassed All Tests\fP
\fB%\fP
.fi
.ft R
.RE
.PP
The tests take a few seconds each,
with a few very fast,
and a couple very slow,
but it varies greatly depending on your CPU.
.PP
If all went well, the message
.RS
.ft CW
Passed All Tests
.ft R
.RE
should appear at the end of the make.
.SS Known Problems
If test 46 fails, this is often caused by optimization bugs in gcc.
Edit the \f[CW]Makefile\fP to change \f[CW]-O2\fP to \f[CW]-O\fP, and
delete \f[CW]common/fp/*.o\fP to cause them to be re-built.
Make and test again.
.PP
If you are using Sun's tmpfs file system as your /tmp
directory, some tests will fail.  This is because the
tmpfs file system does not support file locking.  Set the
COOK_TMP environment variable to somewhere else before
running the tests.  Something like
.RS
.ft CW
.nf
\fB%\fP setenv COOK_TMP /usr/tmp
\fB%\fP
.fi
.ft R
.RE
is usually sufficient if you are using C shell, or
.RS
.ft CW
.nf
\fB$\fP COOK_TMP=/usr/tmp
\fB$\fP export COOK_TMP
\fB$\fP
.fi
.ft R
.RE
if you are using Bourne shell.  Remember, this must be
done before running the tests.
.PP
Tests 121 and 122 can sometimes have problems on Solaris, where they
give false negatives.  If you work out why, please let the author know.
.br
.ne 1i
.SH INSTALLING COOK
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I Cook
package is installed under the
.I /usr/local
tree by default.
Use the \f(CW--prefix=\fP\fIPATH\fP option to
.I configure
if you want some other path.
More specific installation locations are assignable,
use the \f(CW--help\fP option to
.I configure
for details.
.PP
All that is required to install the
.I Cook
package is to use the
.RS
.ft CW
.nf
\fB% \fPmake install
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file and the other files written by the
.I configure
script;
it is best to reconfigure using the
.I configure
script, rather than attempting to do this by hand.
.br
.ne 1i
.SH PRINTED MANUALS
The easiest way to get copies of the manuals
is to get the
.I cook.\*(v).rm.ps.gz
and
.I cook.\*(v).ug.ps.gz
files from the archive site.
These are compressed PostScript files of the Reference Manual and User Guide,
respectively.
The Reference Manual (about 36 pages) contains the README file,
the BUILDING file
and internationalization notes,
as well as all of the manual pages for all of the commands.
The User Guide (about 56 pages) tells you how to use the Cook package.
.PP
This distribution contains the sources to
all of the documentation for
.IR Cook .
The author used the GNU groff package
and a postscript printer to prepare the documentation.
If you do not have this software,
you will need to substitute commands appropriate to your site.
.PP
If you have the GNU Groff package installed
.I before
you run the
.I configure
script, the
.I Makefile
will contain instructions for constructing the documentation.
If you alreday used the
.I make
command, above, this has already been done.
The following command
.RS
.ft CW
.nf
\fB% \fPmake groff_all
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
can be used to do this explicitly, if you managed to get to this point
without doing it.  Please note that there may be some warnings from groff,
particularly for the \f(CW.txt\fP files; this is normal.
.PP
Once the documents have been formatted, you only need to print them.
The following command
.RS
.ft CW
.nf
\fB% \fPlpr lib/en/refman.ps lib/en/user-guide.ps
\fB%\fP
.fi
.ft R
.RE
will print the English PostScript version of the Reference Manual and
the User Guide.
Watch the
.I make
output to see what other versions are available.
.br
.ne 1i
.SH GETTING HELP
If you need assistance with the
.I Cook
program,
please do not hesitate to contact the author at
.RS
.ft CW
Peter Miller <millerp@canb.auug.org.au>
.ft R
.RE
Any and all feedback is welcome.
.PP
When reporting problems,
please include the version number
given by the
.RS
.ft CW
.nf
\fB% \fPcook -version
.if n \fBcook version\fP \fI\*(V)\fP
.if t \f(CBcook version\fP \fI\*(V)\fP
\fI\&...warranty disclaimer...\fP
\fB%\fP
.fi
.ft R
.RE
command.
Please do not send this example;
run the program for the exact version number.
.PP
In the
.I common/main.h
file, there is a define of
.I DEBUG
in comments.
If the comments are removed,
extensive debugging is turned on.
This causes some performance loss,
but performs much run-time checking
and adds the
.B -TRACIng
command line option.
.PP
When the
.B -TRACing
option is followed by one or more file names,
it turns on execution traces in those source files.
It is best to put this option on the end of the command,
so that the names of the files to be traced are not confused
with any other filenames or strings on the command line.
.so ../building/windows-nt.so
.br
.ne 2i
.SH COPYRIGHT
.I cook
version \*(v)
.br
Copyright
.if n (C)
.if t \(co
.nr d) \n(.d
\*(Y) Peter Miller;
.if '\n(d)'\n(.d' .br
All rights reserved.
.PP
The
.I Cook
package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
It should be in the
.I LICENSE
file included with this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter Miller;E-Mail:;millerp@canb.auug.org.au
\f(CW/\e/\e*\fP;WWW:;http://www.canb.auug.org.au/~millerp/
.TE
