/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopmenu.h>
// kde specific
#include <kmimetype.h>
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "webmenufiller.h"

static const int WebBaseId = 1000;


void WebMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    const KURL URL = Contact.url();
    if( !URL.isEmpty() )
    {
        LazyFillMenu *SubMenu = new LazyFillMenu( new WebMenuFiller(URL), false, Menu );
        Menu->insertItem( SmallIconSet("www"), i18n("&Homepage"), SubMenu );
    }
}

WebMenuFiller::WebMenuFiller( const KURL U )
: URL( U )
{
}


void WebMenuFiller::fill( QPopupMenu *Menu )
{
    connect( Menu, SIGNAL(activated(int)), this, SLOT(browse(int)) );

    Menu->insertItem( KMimeType::pixmapForURL(URL,0,KIcon::Small), protectAmpersand(URL.url()), WebBaseId );
}



void WebMenuFiller::browse( int id )
{
    if( id >= WebBaseId )
    {
        kapp->invokeBrowser( URL.url() );
    }
}

#include "webmenufiller.moc"
