/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopmenu.h>
#include <qapplication.h>
#include <qclipboard.h>
// kde specific
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "phonemenufiller.h"

static const int PhoneBaseId = 1000;


void PhoneMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    int NoOfPhoneNumbers = Contact.phoneNumbers().size();
    if( NoOfPhoneNumbers > 0 )
    {
        LazyFillMenu *SubMenu = new LazyFillMenu( new PhoneMenuFiller(Contact), false, Menu );
        Menu->insertItem( SmallIconSet("kcall"), 
                          NoOfPhoneNumbers==1?i18n("&Phone number"):i18n("&Phone numbers"), SubMenu  );
    }
}



PhoneMenuFiller::PhoneMenuFiller( const KABC::Addressee C )
: Contact( C )
{
}


void PhoneMenuFiller::fill( QPopupMenu *Menu )
{
    connect( Menu, SIGNAL(activated(int)), this, SLOT(phone(int)) );

    const KABC::PhoneNumber::List PhoneNumbers = Contact.phoneNumbers();
    int i = PhoneBaseId;
    KABC::PhoneNumber::List::ConstIterator it = PhoneNumbers.begin();
    for( ; it != PhoneNumbers.end(); ++it,++i )
        Menu->insertItem( protectAmpersand(i18n("%1 (%2)").arg( (*it).number(), (*it).typeLabel() )), i );
}



void PhoneMenuFiller::phone( int id )
{
    if( id >= PhoneBaseId )
    {
        QApplication::clipboard()->setText( Contact.phoneNumbers()[id-PhoneBaseId].number(), QClipboard::Clipboard );
//         kapp->invokeMailer( Contact.fullEmail(EmailAddresses[id-PhoneBaseId]), QString::null );
    }
}

#include "phonemenufiller.moc"
