/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef CONTACTLISTMENUFILLER_H
#define CONTACTLISTMENUFILLER_H


// menu specific
#include "addresseelistspan.h"
#include "menufiller.h"

class LazyFillMenu;

class ContactListMenuFiller : public MenuFiller
{
public:
    ContactListMenuFiller( const AddresseeListSpan Span, const QString &FirstToken, const QString &LastToken );

public: // MenuFiller API
    virtual void fill( QPopupMenu *Menu );

protected:
    // reimplemented in subclass to collect created menu objects
    // per default they are added to the parent menu to be autodeleted
    virtual LazyFillMenu *createSubMenu( MenuFiller *Filler, QPopupMenu *Menu );


protected:
    static void createTokens( QString &PreviousToken, QString &NextToken, 
                              const QString &Previous, const QString &Next );

protected:
    /** sublist of contacts to care of */
    AddresseeListSpan ContactsSpan;
    /** */
    QString UpperFirstEntryToken;
    QString UpperLastEntryToken;
};

#endif
