
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include <X11/Xatom.h>
#include <X11/extensions/Xrender.h>
#include <compiz.h>
//SETTINGS
//UNTESTED PROBABLY DOESENT WORK YET
//#define USE_CONVOLUTION
#define FILTERING GL_LINEAR
static Bool FakeFBOPath=TRUE;
static int displayPrivateIndex=0;
//FROM PAINT.C
#define GENBOX(w,x,y,xw,yh) w.x1=x;w.y1=y;w.x2=xw;w.y2=yh;
#define WIN_XO(w) ((w)->attrib.x - (w)->input.left)
#define WIN_YO(w) ((w)->attrib.y - (w)->input.top)
#define WIN_WO(w) ((w)->width + (w)->input.left + (w)->input.right)
#define WIN_HO(w) ((w)->height + (w)->input.top + (w)->input.bottom)
#define WIN_X(w) ((w)->attrib.x - (w)->output.left)
#define WIN_Y(w) ((w)->attrib.y - (w)->output.top)
#define WIN_W(w) ((w)->width + (w)->output.left + (w)->output.right)
#define WIN_H(w) ((w)->height + (w)->output.top + (w)->output.bottom)
static Region ScreenUpdate=NULL;
#define BOX_TO_RECT(b,r) r.x=b.x1;r.y=b.y1;r.width=b.x2-b.x1;r.height=b.y2-b.y1;
#define REFLECTION_DISPLAY_OPTION_MAP 0

#define NUMBER_OF_OPTIONS 1
/*
End of settings
*/
static void
frustum (GLfloat left,
	 GLfloat right,
	 GLfloat bottom,
	 GLfloat top,
	 GLfloat nearval,
	 GLfloat farval)
{
   GLfloat x, y, a, b, c, d;
   GLfloat m[16];

   x = (2.0 * nearval) / (right - left);
   y = (2.0 * nearval) / (top - bottom);
   a = (right + left) / (right - left);
   b = (top + bottom) / (top - bottom);
   c = -(farval + nearval) / ( farval - nearval);
   d = -(2.0 * farval * nearval) / (farval - nearval);

#define M(row,col)  m[col*4+row]
   M(0,0) = x;     M(0,1) = 0.0F;  M(0,2) = a;      M(0,3) = 0.0F;
   M(1,0) = 0.0F;  M(1,1) = y;     M(1,2) = b;      M(1,3) = 0.0F;
   M(2,0) = 0.0F;  M(2,1) = 0.0F;  M(2,2) = c;      M(2,3) = d;
   M(3,0) = 0.0F;  M(3,1) = 0.0F;  M(3,2) = -1.0F;  M(3,3) = 0.0F;
#undef M

   glMultMatrixf (m);
}

static void
perspective (GLfloat fovy,
	     GLfloat aspect,
	     GLfloat zNear,
	     GLfloat zFar)
{
   GLfloat xmin, xmax, ymin, ymax;

   ymax = zNear * tan (fovy * M_PI / 360.0);
   ymin = -ymax;
   xmin = ymin * aspect;
   xmax = ymax * aspect;

   frustum (xmin, xmax, ymin, ymax, zNear, zFar);
}
typedef struct _RectTexture
{
	int Width;
	int Height;
	unsigned int Handle;

}RectTexture;

typedef struct _ReflectionDisplay
{
	int PrivateIndex;
	 CompOption opt[NUMBER_OF_OPTIONS];

}ReflectionDisplay;
static Bool
ReflectionPaintWindow (CompWindow		  *w,
		  const WindowPaintAttrib *attrib,
		  Region		  region,
		  unsigned int		  mask);
void ReInitMode(CompDisplay     *display);

typedef struct _ReflectionScreen
{
	//Pointers to GL extensions
	GLGenFramebuffersProc        genFramebuffers; 
	GLBindFramebufferProc	     bindFrameBuffer;
	GLFramebufferTexture2DProc   FramebufferTexture2D;
	int HasInit;	//Set to one once initiliazed
	int DList;
	RectTexture RMap;	//Temporary textures are stored here
	Region ExtraDamage; //Combined with screenupdate to update properly
	Bool Toggle; //Activate and deactivates reflections
	#ifdef USE_CONVOLUTION
		//5x5 guassian filter
		float Filter[5][5];
	#endif
	DrawWindowTextureProc  drawWindowTexture; //Function that we will intercept
	AddWindowGeometryProc addWindowGeometry;
	PaintScreenProc	       paintScreen;
	DamageWindowRectProc	damageWindowRect;
	PaintBackgroundProc paintBackground;
}ReflectionScreen;

//TAKEN FROM PAINT.C		
#define ADD_RECT(data, m, n, x1, y1, x2, y2)	   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x1); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y2); \
    }						   \
    *(data)++ = (x1);				   \
    *(data)++ = (y2);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x2); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y2); \
    }						   \
    *(data)++ = (x2);				   \
    *(data)++ = (y2);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x2); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y1); \
    }						   \
    *(data)++ = (x2);				   \
    *(data)++ = (y1);				   \
    for (it = 0; it < n; it++)			   \
    {						   \
	*(data)++ = COMP_TEX_COORD_X (&m[it], x1); \
	*(data)++ = COMP_TEX_COORD_Y (&m[it], y1); \
    }						   \
    *(data)++ = (x1);				   \
    *(data)++ = (y1)
typedef struct _Point2f
{
	float x;
	float y;
}Point2f;
#include <glib.h>
Region tmpRegion=NULL;
static Bool Init=FALSE;
static void
DrawGeometry(float U,float V,RectTexture Texture,CompWindow *window,Bool IncludeDecor,Region Current);
void ReflectionPaintBackground (CompScreen   *screen,
				     Region	  region,
				     unsigned int mask);
static void GenReflectionMap(CompScreen *Screen,ReflectionScreen* rs, CompWindow *w);
static Bool 
ReflectionDamageWindowRect (CompWindow *window, Bool initial, BoxPtr box);
static Bool
ReflectionPaintScreen (CompScreen		 *s,
		 const ScreenPaintAttrib *sAttrib,
		 Region			 region,
		 unsigned int		 mask);
//Taken for frag.c
#ifdef USE_BEST_SHADER
#define blurFPH blurFP_BESTH
#define blurFPV blurFP_BESTV
#else
#define blurFPH blurFP_FASTH
#define blurFPV blurFP_FASTV
#endif


static Bool 
ReflectionDamageWindowRect (CompWindow *window, Bool initial, BoxPtr box)
{
	//Get the display
	ReflectionDisplay*rd=(ReflectionDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)window->screen->privates[rd->PrivateIndex].ptr;
	if (rs->Toggle)
	{
		//Merge with the current damage set
		XRectangle NewArea;
		box->x1-=5;
		box->y1-=5;
		box->x2+=5;
		box->y2+=5;
		BOX Box=*box;
		BOX_TO_RECT(Box,NewArea);
		XUnionRectWithRegion(&NewArea,rs->ExtraDamage,rs->ExtraDamage);
	}
	UNWRAP (rs, window->screen, damageWindowRect);
	Bool status = (*window->screen->damageWindowRect) (window, initial, box);
	WRAP (rs, window->screen, damageWindowRect, ReflectionDamageWindowRect);
	return status;

}

void InitReflectionScreen(ReflectionScreen* rs,int ScreenWidth,int ScreenHeight,CompScreen* Current,ReflectionDisplay *rd);
#define GLERROR GLenum Error;
#define CHECK_ERROR(x)	//Error=glGetError(); if (Error!=  GL_NO_ERROR) {printf ("The GL error has occured at line:%d error #%d\n",x,Error);}


//Get the region of the actual window (used only by texture copy on wobbly for correction)
Region
GetWindowRegion(CompWindow *w)
{
	//Shouldnt happen even but if it does return NULL
	if (w->vCount!=NULL)
		return NULL;
	//Get the vertices
	int     texUnit = w->texUnits;
   	int     currentTexUnit = 0;
   	int     stride = (1 + texUnit);
   	Point2f *vertices = (Point2f*)w->vertices + (stride - 2);
	//Get the minimum and the maximum position
	Point2f min=vertices[0];
	Point2f max=vertices[0];
	//Go through each vertex
	int vertex=0;
	int position=0;
	while (vertex!=w->vCount)
	{
		//Get the min and max
		min.x=MIN(min.x,vertices[position].x);
		min.x=MIN(min.y,vertices[position].y);
		max.x=MAX(min.x,vertices[position].x);
		max.x=MAX(min.y,vertices[position].y);
		//Go to the next vertex
		position+=stride;
		vertex++;
	}
	//Generate a region
	Region WindowRegion=XCreateRegion();
	//Fill the region
	WindowRegion->numRects=1;
	WindowRegion->rects=calloc(1,sizeof(BOX));
	WindowRegion->rects->x1=min.x;
	WindowRegion->rects->y1=min.y;
	WindowRegion->rects->x2=max.x;
	WindowRegion->rects->y2=max.y;
	WindowRegion->extents=*WindowRegion->rects;
}
//Just steals the region of the screen thats updated
ReflectionaddWindowGeometry (CompWindow *window,
				       CompMatrix *matrix,
				       int	  nMatrix,
				       Region	  region,
				       Region	  clip)
{
	//Get the display
   	ReflectionDisplay*rd=(ReflectionDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)window->screen->privates[rd->PrivateIndex].ptr;
	ScreenUpdate=clip;
	UNWRAP (rs, window->screen, addWindowGeometry);
	(*window->screen->addWindowGeometry) (window,matrix,nMatrix,region,clip);
	WRAP (rs, window->screen, addWindowGeometry, ReflectionaddWindowGeometry);
			

}
//Function to draw the window 
static void
DrawGeometry(float U,float V,RectTexture Texture,CompWindow *window,Bool IncludeDecor,Region Current)
{
   //Get the display
   ReflectionDisplay*rd=(ReflectionDisplay*)window->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)window->screen->privates[rd->PrivateIndex].ptr;
    CompWindow copy;
   //Copy the current window
    memcpy(&copy,window,sizeof(CompWindow));
    
    CompScreen*s=window->screen;
	if (!tmpRegion)
	{
		tmpRegion=XCreateRegion();
	}
	else
	{
		XDestroyRegion(tmpRegion);
		tmpRegion=NULL;
		tmpRegion=XCreateRegion();
	}		
  //Generate our vertex buffer
   if (!IncludeDecor)
  {
	
	Current=tmpRegion;
	Region tmp=XCreateRegion();
	XUnionRegion (ScreenUpdate, rs->ExtraDamage, tmp);
	XIntersectRegion(tmp,window->region,Current);
	if (Current->numRects==0)
		return NULL;			
      
	  
  }
  else
 {
					
					//Generate the border around the window
					
					
	
					  XRectangle Outer;
						getOuterRectOfWindow(window,&Outer);
					  BOX border;
					XRectangle converted;
					 GENBOX(border,Outer.x
,window->attrib.y,window->attrib.x,Outer.y+Outer.height)
					BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
					GENBOX(border,Outer.x,Outer.y,Outer.x+Outer.width,window->attrib.y )
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					 GENBOX(border,window->attrib.x+window->attrib.width,window->attrib.y,Outer.x+Outer.width,window->attrib.y+window->attrib.height)
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					 GENBOX(border,Outer.x,window->height+window->attrib.y,Outer.x+Outer.width,Outer.y+Outer.height)
						BOX_TO_RECT(border,converted)
					XUnionRectWithRegion(&converted,tmpRegion,tmpRegion);
				
					tmpRegion->extents=window->region->extents;
					Current=tmpRegion;
				
					//Calculate the visible region of the window borders only by subtracting everything else
					Region tmp=XCreateRegion();
					XUnionRegion(ScreenUpdate,rs->ExtraDamage,tmp);
					XIntersectRegion(tmp,Current,Current);
					XDestroyRegion(tmp);
			
}			
//Speed improvements for non fragment since we are not generating a blur map for non-visible windows
	
 
    CompMatrix Tex;
 
	Tex.x0=0;
	Tex.y0=0;
   	Tex.xx=(float)rs->RMap.Width/(float)window->screen->width;
    	Tex.yy=(float)rs->RMap.Height/(float)window->screen->height;
   CompMatrix *TexPtr=&Tex;
 copy.vertices   = 0;
    copy.vertexSize = 0;
    copy.indices    = 0;
    copy.indexSize  = 0;
    copy.vCount     = 0;
    copy.texUnits=1;
	//Examine the region to see if its good or else we will be killing older cards with huge number of vertices
	//Avoid this on cards with pixel shaders
	
		if (Current->numRects>15)
		{
			XRectangle UpdatedRect;
			XClipBox (Current,&UpdatedRect);
			Current=XCreateRegion();
			XUnionRectWithRegion(&UpdatedRect,Current,Current);
			 (*window->screen->addWindowGeometry) (&copy,TexPtr,1,Current,ScreenUpdate);
			XDestroyRegion(Current);
			
		}
		else
		{
			 (*window->screen->addWindowGeometry) (&copy,TexPtr,1,Current,ScreenUpdate);
		}
			
	
				
	//Correct the texture coordinates so they are 1 to 1 mappings
	int     texUnit = copy.texUnits;
	int     currentTexUnit = 0;
	int     stride = (1 + texUnit) * 2;
	GLfloat *vert= copy.vertices + (stride - 2);
	GLfloat *texc= vert -2;
	int v=0;	
	int vertex=0;
	while (vertex!=copy.vCount)
	{
		if (v+3<copy.vertexSize)
		{
			texc[v]=COMP_TEX_COORD_X(TexPtr,texc[v+2]);
			texc[v+1]=COMP_TEX_COORD_Y(TexPtr,texc[v+3]);
		}
		v+=stride;
		vertex++;
	}
	if (copy.vCount)
{
(*window->screen->clientActiveTexture) (GL_TEXTURE0_ARB);
    glBindTexture(GL_TEXTURE_RECTANGLE_ARB,Texture.Handle);
	//Activate blending
	glPushAttrib(GL_COLOR_BUFFER_BIT);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1,1,1,1);
    (*window->screen->drawWindowGeometry)(&copy);
	glDisable(GL_BLEND);
	glPopAttrib();
   	free(copy.indices);
    	free(copy.vertices);
	
}
	
		
} 

void DrawQuad(int x,int y,int w,int h,CompMatrix *TexPtr)
{

  GLfloat *vertices=(GLfloat*)malloc(sizeof(GLfloat)*4*4);
  GLfloat *data=vertices;
    vertices+=2;
    GLfloat *texcoord=vertices;
    texcoord-=2; 
       int it;
   ADD_RECT(data,TexPtr,1,x,y,x+w,y+h);
    //Draw the quad
    glVertexPointer (2, GL_FLOAT, sizeof(GLfloat)*4, vertices);
    glTexCoordPointer (2, GL_FLOAT,  sizeof(GLfloat)*4, texcoord);
 glDrawArrays (GL_QUADS, 0, 4);
	
    free(texcoord);
	
}

//Draw the texture
static void
ReflectionDrawWindowTexture(CompWindow		*w,CompTexture	       *texture,
				       const WindowPaintAttrib *attrib,
				       unsigned int	       mask)
{
	//Get the display
	ReflectionDisplay*rd=(ReflectionDisplay*)w->screen->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)w->screen->privates[rd->PrivateIndex].ptr;
	if (((attrib->xScale!=1.0f)||(attrib->yScale!=1.0f))||(mask&PAINT_WINDOW_SOLID_MASK)||(WINDOW_INVISIBLE(w)))
	{
		 UNWRAP (rs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (rs, w->screen, drawWindowTexture, ReflectionDrawWindowTexture);
	
	        return;
	}
	//Disable blurring if the window is being animated
	if (w->mapNum==0)
	{
		UNWRAP (rs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (rs, w->screen, drawWindowTexture, ReflectionDrawWindowTexture);
	        return;
	}

	//Initiliaze the screen if it has not beens
	if (rs->HasInit!=1)
	{
		rs->genFramebuffers=w->screen->genFramebuffers;
		rs-> bindFrameBuffer=w->screen->bindFramebuffer;
		rs->FramebufferTexture2D=w->screen->framebufferTexture2D;
		InitReflectionScreen(rs,w->screen->width,w->screen->height,w->screen,rd);
		
		
	}
	//Check if it is toggled on
	if ((rs->Toggle==FALSE)||(rs->RMap.Handle==-1))
	{
		UNWRAP (rs, w->screen, drawWindowTexture);
	        (*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	        WRAP (rs, w->screen, drawWindowTexture, ReflectionDrawWindowTexture);
	        return;
	}
	//CHECK_ERROR(1)
	if ((!w->minimized)&&(!w->shaded)&&(w->frame!=None))
	{
		if (mask&PAINT_WINDOW_DECORATION_MASK)
		{
		
			glEnable(GL_TEXTURE_RECTANGLE_ARB);
		
			DrawGeometry(WIN_X(w),WIN_Y(w),rs->RMap,w,TRUE,ScreenUpdate);
			glDisable(GL_TEXTURE_RECTANGLE_ARB);
		
			
		}
	}	
	//Draw the contents
	UNWRAP (rs, w->screen, drawWindowTexture);
	(*w->screen->drawWindowTexture) (w,texture,attrib,mask);
	WRAP (rs, w->screen, drawWindowTexture, ReflectionDrawWindowTexture);

}


//Free all OpenGL resources
void DeinitReflectionScreen(ReflectionScreen* rs)
{
	if (rs->HasInit)
	{
		//Delete the textures
		glDeleteTextures(1,&rs->RMap);
	}
}
//Does opengl level iniliazation of the screen
void InitReflectionScreen(ReflectionScreen* rs,int ScreenWidth,int ScreenHeight,CompScreen* Current,ReflectionDisplay *rd)
{
	char *Filename=rd->opt[REFLECTION_DISPLAY_OPTION_MAP ].value.s;
	//Ensure that then set a file name or else act the same as if they didnt load a file
	Bool Toggle=FALSE;
	//Read the image data
	int Width;
	int Height;
	char *Pixels;
	if (strlen(Filename)>0)
	{
		
		Toggle=readPng(Filename,&Pixels,&Width,&Height);
		
	}
	if (Toggle)
	{
	//Enable texturing
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	//Generate the OpenGL textures
	glGenTextures (1,&rs->RMap.Handle);
	//Record with and height
	rs->RMap.Width=Width;
	rs->RMap.Height=Height;
	//Bind the texture
	glBindTexture(GL_TEXTURE_RECTANGLE_ARB,rs->RMap.Handle);
	//Load the parameters
	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER,FILTERING);
   	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
    	glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA, rs->RMap.Width,rs->RMap.Height, 0, GL_BGRA, GL_UNSIGNED_BYTE, Pixels);
	free(Pixels);
	glDisable(GL_TEXTURE_RECTANGLE_ARB);
	rs->Toggle=TRUE;
	
	}
	else
	{
		rs->RMap.Handle=-1;
		rs->Toggle=FALSE;
	}
	rs->HasInit=1;
	
}
static Bool
ReflectionPaintScreen (CompScreen		 *s,
		 const ScreenPaintAttrib *sAttrib,
		 Region			 region,
		 unsigned int		 mask)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)s->privates[rd->PrivateIndex].ptr;
	//Activate by default
	rs->Toggle=TRUE;
	//Deactivate on zooms
	if (sAttrib->zCamera!=defaultScreenPaintAttrib.zCamera)
	{
		rs->Toggle=FALSE; 
	}
	if (sAttrib->xRotate!=0)
	{
		rs->Toggle=FALSE; 
	}
	if (rs->Toggle)
	{
		Region Duplicate=XCreateRegion();
		XSubtractRegion(region,&emptyRegion,Duplicate);
		region=Duplicate;
		XRectangle NewRect;
		int i=0;
		// Increase the region sizes
		for (i = 0; i < region->numRects; i++) {

			NewRect.x = region->rects[i].x1 - 5;
			NewRect.y = region->rects[i].y1 - 5;
			NewRect.width = region->rects[i].x2 - region->rects[i].x1 + 10;
			NewRect.height = region->rects[i].y2 - region->rects[i].y1  + 10;

			XUnionRectWithRegion(&NewRect,region,region);
		}
	}
	UNWRAP (rs, s, paintScreen);
	Bool status=(*rs->paintScreen)(s,sAttrib,region,mask);
	WRAP (rs, s, paintScreen, ReflectionPaintScreen);
	if (rs->Toggle)
	{
		XDestroyRegion(region);
		
	}
	XDestroyRegion(rs->ExtraDamage);
	rs->ExtraDamage=XCreateRegion();
	return status;
	
}
static Bool
ReflectionInitScreen (CompPlugin *p,
		 CompScreen *s)
{
	
	if (!s->textureRectangle)
	{
		printf("Cannot initilaize due to lack of texture rectangle support\n");
		return FALSE;
	}
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Create a blur screen
	ReflectionScreen* rs=(ReflectionScreen*)calloc(1,sizeof(ReflectionScreen));
	//Setup the toggle
	rs->Toggle=TRUE;
	rs->ExtraDamage=XCreateRegion();
	s->privates[rd->PrivateIndex].ptr=rs;
	//Take over the window draw function
	WRAP (rs, s, drawWindowTexture, ReflectionDrawWindowTexture);
	WRAP (rs, s, addWindowGeometry, ReflectionaddWindowGeometry);
	WRAP (rs, s, paintScreen, ReflectionPaintScreen);
	WRAP (rs, s, damageWindowRect, ReflectionDamageWindowRect);
	
	return TRUE;
}


static void
ReflectionFiniScreen (CompPlugin *p,
		 CompScreen *s)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)s->display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	ReflectionScreen* rs=(ReflectionScreen*)s->privates[rd->PrivateIndex].ptr;
	//Deinitiliaze the screen and free the pointer
	DeinitReflectionScreen(rs);
	//Restore the original function
	UNWRAP (rs, s, drawWindowTexture);
   	UNWRAP (rs, s, addWindowGeometry);
	UNWRAP (rs, s, paintScreen);
	UNWRAP (rs,s, damageWindowRect);
	//Free the pointer
	free(rs);
	
}
//Initiliaze the options
static void
ReflectionDisplayInitOptions (ReflectionDisplay *rd, CompDisplay *display)
{
	CompOption *o;
	//Reflectio map to use 
	o = &rd->opt[REFLECTION_DISPLAY_OPTION_MAP ];
   	o->name                       = "reflection_map";
    	o->shortDesc                  = N_("Sepcifies a RGBA png for the reflection map");
    	o->longDesc                   = N_("Sepcifies a RGBA png for the reflection map");
    	o->type                       = CompOptionTypeString;
	o->value.s=g_strdup("SampleMap.png"); //(File wont be found and it will deactivate)
 	o->rest.s.string = NULL;
   	o->rest.s.nString = 0;
}

static Bool
ReflectionInitDisplay (CompPlugin  *p,
		  CompDisplay *d)
{
	//Generate a blur display
	ReflectionDisplay* rd=(ReflectionDisplay*)malloc(sizeof(ReflectionDisplay));
	//Allocate a private index
	rd->PrivateIndex = allocateScreenPrivateIndex (d);
	//Check if its valid
	if (rd->PrivateIndex<0)
	{
		//Its invalid so free memory and return
		free(rd);
		return FALSE;
	}
	//Initiliaze options
	ReflectionDisplayInitOptions(rd,d);
	//Record the display
	d->privates[displayPrivateIndex].ptr=rd;
	return TRUE;
}

static void
ReflectionFiniDisplay (CompPlugin *p,
		  CompDisplay *d)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)d->privates[displayPrivateIndex].ptr;
	//Free the private index
	freeScreenPrivateIndex (d, rd->PrivateIndex);
	//Free the pointer
	free(rd);
}
static Bool
ReflectionInit (CompPlugin *p)
{
     displayPrivateIndex = allocateDisplayPrivateIndex ();
    if (displayPrivateIndex < 0)
	return FALSE;

    return TRUE;
}

static void
ReflectionFini (CompPlugin *p)
{
   if (displayPrivateIndex >= 0)
	freeDisplayPrivateIndex (displayPrivateIndex);
}
//Options
static CompOption *
ReflectionGetDisplayOptions (CompDisplay *display, int *count)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)display->privates[displayPrivateIndex].ptr;
	*count=NUMBER_OF_OPTIONS;
	return &rd->opt[0];

}

static void ReLoadMap(CompDisplay *display)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)display->privates[displayPrivateIndex].ptr;
	//Get the blur screen
	CompScreen *screen=display->screens;
	glEnable(GL_TEXTURE_RECTANGLE_ARB);
	char *Filename=rd->opt[REFLECTION_DISPLAY_OPTION_MAP ].value.s;
	//Ensure that then set a file name or else act the same as if they didnt load a file
	Bool Toggle=FALSE;
	//Read the image data
	int Width;
	int Height;
	char *Pixels;
	if (strlen(Filename)>0)
	{
		
		Toggle=readPng(Filename,&Pixels,&Width,&Height);
		
	}
	while (screen!=NULL)
	{
		ReflectionScreen* rs=(ReflectionScreen*)screen->privates[rd->PrivateIndex].ptr;
		if (Toggle)
		{
			if (rs->HasInit==1)
			{
				if (rs->RMap.Handle!=-1)
					glDeleteTextures(1,&rs->RMap.Handle);
				glGenTextures(1,&rs->RMap.Handle);
				//Bind the texture
				glBindTexture(GL_TEXTURE_RECTANGLE_ARB,rs->RMap.Handle);
				//Load the parameters
				glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MIN_FILTER, FILTERING);
		    		glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_MAG_FILTER,FILTERING);
		   		glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
		    		glTexParameteri (GL_TEXTURE_RECTANGLE_ARB, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);	
				glTexImage2D(GL_TEXTURE_RECTANGLE_ARB, 0, GL_RGBA,Width,Height,0,GL_BGRA,GL_UNSIGNED_BYTE,Pixels);
			}
		}
		else
		{
			rs->Toggle=Toggle;
		}
		screen=screen->next;
	}
	//Free the image data
	if (Toggle) free(Pixels);
	glDisable(GL_TEXTURE_RECTANGLE_ARB);
	
}
static Bool
ReflectionSetDisplayOption (CompDisplay     *display,
		       char	       *name,
		       CompOptionValue *value)
{
	//Get the display handle
	ReflectionDisplay* rd=(ReflectionDisplay*)display->privates[displayPrivateIndex].ptr;
	//Get the option and the index
	CompOption *o;
   	int	       index;
	o = compFindOption (rd->opt, NUMBER_OF_OPTIONS, name, &index);
	//Check if we found the option or else return
	if (!o)
		return FALSE;
	//Find the index and set the option
	switch(index)
	{
		case REFLECTION_DISPLAY_OPTION_MAP:
		if (compSetStringOption (o, value))
		{
			ReLoadMap(display);
			return TRUE;
		}
		break;
		default:
		break;
	}

	return FALSE;
}

CompPluginVTable ReflectionVTable = {
    "reflection",
    "Implements reflections on decorations",
    "Implements reflection maps for window decorations",
    ReflectionInit,
    ReflectionFini,
    ReflectionInitDisplay,
    ReflectionFiniDisplay,
    ReflectionInitScreen,
    ReflectionFiniScreen,
    0,
    0,
   ReflectionGetDisplayOptions, /* GetDisplayOptions */
   ReflectionSetDisplayOption, /* SetDisplayOption */
    0,
    0,
    0,
    0
};

CompPluginVTable *
getCompPluginInfo (void)
{
    return &ReflectionVTable;
}
