/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE klass;
  VALUE mImpl;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/* Don't use for expressions have side effect */
#ifndef RB_STRING_VALUE
#define RB_STRING_VALUE(s) (TYPE(s) == T_STRING ? (s) : (*(volatile VALUE *)&(s) = rb_str_to_str(s)))
#endif
#ifndef StringValue
#define StringValue(s) RB_STRING_VALUE(s)
#endif
#ifndef StringValuePtr
#define StringValuePtr(s) RSTRING(RB_STRING_VALUE(s))->ptr
#endif
#ifndef StringValueLen
#define StringValueLen(s) RSTRING(RB_STRING_VALUE(s))->len
#endif
#ifndef SafeStringValue
#define SafeStringValue(v) do {\
    StringValue(v);\
    rb_check_safe_str(v);\
} while (0)
#endif

#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
#define rb_define_alloc_func(klass, func) rb_define_singleton_method((klass), "new", VALUEFUNC((func)), -1)
#define rb_undef_alloc_func(klass) rb_undef_method(CLASS_OF((klass)), "new")
#endif

/* Contract support */

#define SWIG_contract_assert(expr, msg) if (!(expr)) { rb_raise(rb_eRuntimeError, (char *) msg ); } else


/*************************************************************** -*- c -*-
 * ruby/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Ruby_TypeRegister
#define SWIG_TypeCheck       SWIG_Ruby_TypeCheck
#define SWIG_TypeCast        SWIG_Ruby_TypeCast
#define SWIG_TypeDynamicCast SWIG_Ruby_TypeDynamicCast
#define SWIG_TypeName        SWIG_Ruby_TypeName
#define SWIG_TypeQuery       SWIG_Ruby_TypeQuery
#define SWIG_TypeClientData  SWIG_Ruby_TypeClientData
#define SWIG_PackData        SWIG_Ruby_PackData 
#define SWIG_UnpackData      SWIG_Ruby_UnpackData 

/* Also rename all exported symbols from rubydef.swig */

/* Common SWIG API */
#define SWIG_ConvertPtr(obj, pp, type, flags) \
  SWIG_Ruby_ConvertPtr(obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags) \
  SWIG_Ruby_NewPointerObj(p, type, flags)
#define SWIG_MustGetPtr(p, type, argnum, flags) \
  SWIG_Ruby_MustGetPtr(p, type, argnum, flags)

/* Ruby-specific SWIG API */

#define SWIG_InitRuntime() \
  SWIG_Ruby_InitRuntime()
#define SWIG_define_class(ty) \
  SWIG_Ruby_define_class(ty)
#define SWIG_NewClassInstance(value, ty) \
  SWIG_Ruby_NewClassInstance(value, ty)
#define SWIG_MangleStr(value) \
  SWIG_Ruby_MangleStr(value)
#define SWIG_CheckConvert(value, ty) \
  SWIG_Ruby_CheckConvert(value, ty)
#define SWIG_NewPackedObj(ptr, sz, ty) \
  SWIG_Ruby_NewPackedObj(ptr, sz, ty)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Ruby_ConvertPacked(obj, ptr, sz, ty, flags)


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_Ruby_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_Ruby_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_Ruby_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_Ruby_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return StringValuePtr(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_Ruby_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else {
    Data_Get_Struct(obj, void, *ptr);
  }
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (*ptr == 0)
            rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
          return 0;
        }
    }
    if ((c = SWIG_MangleStr(obj)) == NULL) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) {
      if (flags & SWIG_POINTER_EXCEPTION)
        rb_raise(rb_eTypeError, "Expected %s", ty->str);
      else
        return -1;
    }
    *ptr = SWIG_TypeCast(tc, *ptr);
  }
  return 0;
}

/* Convert a pointer value, signal an exception on a type mismatch */
SWIGRUNTIME(void *)
SWIG_Ruby_MustGetPtr(VALUE obj, swig_type_info *ty, int argnum, int flags)
{
  void *result;
  SWIG_ConvertPtr(obj, &result, ty, flags | SWIG_POINTER_EXCEPTION);
  return result;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_Ruby_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

SWIGRUNTIME(VALUE)
SWIG_Ruby_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_Ruby_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = StringValuePtr(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_lsampl_t swig_types[0] 
#define  SWIGTYPE_p_sampl_t swig_types[1] 
#define  SWIGTYPE_p_comedi_calibration_setting_t swig_types[2] 
#define  SWIGTYPE_p_double swig_types[3] 
#define  SWIGTYPE_p_comedi_range swig_types[4] 
#define  SWIGTYPE_p_unsigned_int swig_types[5] 
#define  SWIGTYPE_p_void swig_types[6] 
#define  SWIGTYPE_p_comedi_subdinfo_struct swig_types[7] 
#define  SWIGTYPE_p_comedi_krange_struct swig_types[8] 
#define  SWIGTYPE_p_comedi_rangeinfo_struct swig_types[9] 
#define  SWIGTYPE_p_comedi_chaninfo_struct swig_types[10] 
#define  SWIGTYPE_p_comedi_cmd_struct swig_types[11] 
#define  SWIGTYPE_p_comedi_insnlist_struct swig_types[12] 
#define  SWIGTYPE_p_comedi_insn_struct swig_types[13] 
#define  SWIGTYPE_p_comedi_trig_struct swig_types[14] 
#define  SWIGTYPE_p_comedi_devinfo_struct swig_types[15] 
#define  SWIGTYPE_p_char swig_types[16] 
#define  SWIGTYPE_p_comedi_devconfig_struct swig_types[17] 
#define  SWIGTYPE_p_comedi_bufconfig_struct swig_types[18] 
#define  SWIGTYPE_p_comedi_bufinfo_struct swig_types[19] 
#define  SWIGTYPE_p_comedi_calibration_t swig_types[20] 
#define  SWIGTYPE_p_comedi_sv_t swig_types[21] 
#define  SWIGTYPE_p_chanlist swig_types[22] 
#define  SWIGTYPE_p_comedi_insn swig_types[23] 
#define  SWIGTYPE_p_comedi_insnlist swig_types[24] 
#define  SWIGTYPE_p_comedi_caldac_t swig_types[25] 
#define  SWIGTYPE_p_comedi_t swig_types[26] 
#define  SWIGTYPE_p_int swig_types[27] 
#define  SWIGTYPE_p_comedi_cmd swig_types[28] 
static swig_type_info *swig_types[30];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_comedi
#define SWIG_name    "Comedi"

static VALUE mComedi;

#include "comedilib.h"


#ifdef __cplusplus
extern "C" {
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
struct timeval rb_time_timeval(VALUE);
#endif
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
#include "rubyio.h"
#ifdef __cplusplus
}
#endif


static unsigned int cr_pack(unsigned int chan, unsigned int rng, unsigned int aref){
	return CR_PACK(chan,rng,aref);
}
static unsigned int cr_pack_flags(unsigned int chan, unsigned int rng, unsigned int aref, unsigned int flags){
	return CR_PACK_FLAGS(chan,rng,aref, flags);
}
static unsigned int cr_chan(unsigned int a){
	return CR_CHAN(a);
}
static unsigned int cr_range(unsigned int a){
	return CR_RANGE(a);
}
static unsigned int cr_aref(unsigned int a){
	return CR_AREF(a);
}


typedef unsigned int chanlist;

chanlist *new_chanlist(int nelements){
  return (unsigned int *) calloc(nelements,sizeof(unsigned int));
}
void delete_chanlist(chanlist *self){
  free(self);
}
unsigned int chanlist_getitem(chanlist *self,int index){
  return self[index];
}
void chanlist_setitem(chanlist *self,int index,unsigned int value){
  self[index] = value;
}
unsigned int *chanlist_cast(chanlist *self){
  return self;
}
chanlist *chanlist_frompointer(unsigned int *t){
  return (chanlist *) t;
}

swig_class cChanlist;
static void free_chanlist(chanlist *);

swig_class cComedi_trig_struct;
static void free_comedi_trig_struct(struct comedi_trig_struct *);

swig_class cComedi_insn_struct;
static void free_comedi_insn_struct(struct comedi_insn_struct *);

swig_class cComedi_insnlist_struct;
static void free_comedi_insnlist_struct(struct comedi_insnlist_struct *);

swig_class cComedi_cmd_struct;
static void free_comedi_cmd_struct(struct comedi_cmd_struct *);

swig_class cComedi_chaninfo_struct;
static void free_comedi_chaninfo_struct(struct comedi_chaninfo_struct *);

swig_class cComedi_rangeinfo_struct;
static void free_comedi_rangeinfo_struct(struct comedi_rangeinfo_struct *);

swig_class cComedi_krange_struct;
static void free_comedi_krange_struct(struct comedi_krange_struct *);

swig_class cComedi_subdinfo_struct;
static void free_comedi_subdinfo_struct(struct comedi_subdinfo_struct *);

swig_class cComedi_devinfo_struct;
static void free_comedi_devinfo_struct(struct comedi_devinfo_struct *);

swig_class cComedi_devconfig_struct;
static void free_comedi_devconfig_struct(struct comedi_devconfig_struct *);

swig_class cComedi_bufconfig_struct;
static void free_comedi_bufconfig_struct(struct comedi_bufconfig_struct *);

swig_class cComedi_bufinfo_struct;
static void free_comedi_bufinfo_struct(struct comedi_bufinfo_struct *);

swig_class cComedi_range;
static void free_comedi_range(comedi_range *);

swig_class cComedi_sv_t;
static void free_comedi_sv_t(comedi_sv_t *);

static VALUE output_helper(VALUE target, VALUE o) {
    if (NIL_P(target)) {
	target = o;
    } else {
	if (TYPE(target) != T_ARRAY) {
	    VALUE o2 = target;
	    target = rb_ary_new();
	    rb_ary_push(target, o2);
	}
	rb_ary_push(target, o);
    }
    return target;
}


swig_class cComedi_caldac_t;
static void free_comedi_caldac_t(comedi_caldac_t *);

swig_class cComedi_calibration_setting_t;
static void free_comedi_calibration_setting_t(comedi_calibration_setting_t *);

swig_class cComedi_calibration_t;
static void free_comedi_calibration_t(comedi_calibration_t *);
static VALUE
_wrap_cr_pack(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2UINT(argv[0]);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (unsigned int)cr_pack(arg1,arg2,arg3);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_cr_pack_flags(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    arg1 = NUM2UINT(argv[0]);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    result = (unsigned int)cr_pack_flags(arg1,arg2,arg3,arg4);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_cr_chan(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2UINT(argv[0]);
    result = (unsigned int)cr_chan(arg1);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_cr_range(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2UINT(argv[0]);
    result = (unsigned int)cr_range(arg1);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_cr_aref(int argc, VALUE *argv, VALUE self) {
    unsigned int arg1 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2UINT(argv[0]);
    result = (unsigned int)cr_aref(arg1);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_chanlist_allocate(VALUE self) {
#else
    static VALUE
    _wrap_chanlist_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_chanlist);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_chanlist(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    chanlist *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    result = (chanlist *)new_chanlist(arg1);
    DATA_PTR(self) = result;
    return self;
}


static void
free_chanlist(chanlist *arg1) {
    delete_chanlist(arg1);
;
}
static VALUE
_wrap_chanlist___getitem__(int argc, VALUE *argv, VALUE self) {
    chanlist *arg1 = (chanlist *) 0 ;
    int arg2 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_chanlist, 1);
    arg2 = NUM2INT(argv[0]);
    result = (unsigned int)chanlist_getitem(arg1,arg2);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_chanlist___setitem__(int argc, VALUE *argv, VALUE self) {
    chanlist *arg1 = (chanlist *) 0 ;
    int arg2 ;
    unsigned int arg3 ;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_chanlist, 1);
    arg2 = NUM2INT(argv[0]);
    arg3 = NUM2UINT(argv[1]);
    chanlist_setitem(arg1,arg2,arg3);
    
    return Qnil;
}


static VALUE
_wrap_chanlist_cast(int argc, VALUE *argv, VALUE self) {
    chanlist *arg1 = (chanlist *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_chanlist, 1);
    result = (unsigned int *)chanlist_cast(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_chanlist_frompointer(int argc, VALUE *argv, VALUE self) {
    unsigned int *arg1 = (unsigned int *) 0 ;
    chanlist *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_unsigned_int, 1);
    result = (chanlist *)chanlist_frompointer(arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_chanlist,0);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_subdev_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdev = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_subdev_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->subdev);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_mode_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->mode = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_mode_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->mode);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_n_chan_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n_chan = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_n_chan_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->n_chan);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_chanlist_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->chanlist = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_chanlist_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int *) ((arg1)->chanlist);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_data_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    sampl_t *arg2 = (sampl_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_sampl_t, 1);
    if (arg1) (arg1)->data = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_data_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    sampl_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (sampl_t *) ((arg1)->data);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_sampl_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_n_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_n_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->n);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_trigsrc_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->trigsrc = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_trigsrc_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->trigsrc);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_trigvar_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->trigvar = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_trigvar_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->trigvar);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_trigvar1_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->trigvar1 = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_trigvar1_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->trigvar1);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_data_len_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->data_len = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_data_len_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int) ((arg1)->data_len);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_trig_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_trig_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *arg1 = (struct comedi_trig_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_trig_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_trig_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_trig_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_trig_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_trig_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_trig_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_trig_struct *)(struct comedi_trig_struct *) calloc(1, sizeof(struct comedi_trig_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_trig_struct(struct comedi_trig_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_insn_struct_insn_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->insn = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_insn_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (unsigned int) ((arg1)->insn);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_insn_struct_n_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_n_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (unsigned int) ((arg1)->n);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_insn_struct_data_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    lsampl_t *arg2 = (lsampl_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_lsampl_t, 1);
    if (arg1) (arg1)->data = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_data_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    lsampl_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (lsampl_t *) ((arg1)->data);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_lsampl_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_insn_struct_subdev_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdev = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_subdev_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (unsigned int) ((arg1)->subdev);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_insn_struct_chanspec_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->chanspec = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_chanspec_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (unsigned int) ((arg1)->chanspec);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_insn_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 3; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_insn_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *arg1 = (struct comedi_insn_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insn_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_insn_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_insn_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_insn_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_insn_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_insn_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_insn_struct *)(struct comedi_insn_struct *) calloc(1, sizeof(struct comedi_insn_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_insn_struct(struct comedi_insn_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_insnlist_struct_n_insns_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insnlist_struct *arg1 = (struct comedi_insnlist_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insnlist_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n_insns = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insnlist_struct_n_insns_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insnlist_struct *arg1 = (struct comedi_insnlist_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insnlist_struct, 1);
    result = (unsigned int) ((arg1)->n_insns);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_insnlist_struct_insns_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_insnlist_struct *arg1 = (struct comedi_insnlist_struct *) 0 ;
    comedi_insn *arg2 = (comedi_insn *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insnlist_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_comedi_insn, 1);
    if (arg1) (arg1)->insns = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_insnlist_struct_insns_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_insnlist_struct *arg1 = (struct comedi_insnlist_struct *) 0 ;
    comedi_insn *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_insnlist_struct, 1);
    result = (comedi_insn *) ((arg1)->insns);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_insn,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_insnlist_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_insnlist_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_insnlist_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_insnlist_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_insnlist_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_insnlist_struct *)(struct comedi_insnlist_struct *) calloc(1, sizeof(struct comedi_insnlist_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_insnlist_struct(struct comedi_insnlist_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_cmd_struct_subdev_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdev = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_subdev_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->subdev);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_start_src_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->start_src = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_start_src_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->start_src);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_start_arg_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->start_arg = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_start_arg_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->start_arg);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_scan_begin_src_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->scan_begin_src = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_scan_begin_src_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->scan_begin_src);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_scan_begin_arg_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->scan_begin_arg = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_scan_begin_arg_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->scan_begin_arg);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_convert_src_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->convert_src = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_convert_src_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->convert_src);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_convert_arg_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->convert_arg = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_convert_arg_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->convert_arg);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_scan_end_src_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->scan_end_src = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_scan_end_src_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->scan_end_src);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_scan_end_arg_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->scan_end_arg = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_scan_end_arg_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->scan_end_arg);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_stop_src_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->stop_src = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_stop_src_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->stop_src);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_stop_arg_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->stop_arg = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_stop_arg_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->stop_arg);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_chanlist_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->chanlist = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_chanlist_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int *) ((arg1)->chanlist);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_chanlist_len_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->chanlist_len = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_chanlist_len_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->chanlist_len);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_data_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    sampl_t *arg2 = (sampl_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_sampl_t, 1);
    if (arg1) (arg1)->data = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_data_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    sampl_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (sampl_t *) ((arg1)->data);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_sampl_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_cmd_struct_data_len_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->data_len = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_cmd_struct_data_len_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *arg1 = (struct comedi_cmd_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_cmd_struct, 1);
    result = (unsigned int) ((arg1)->data_len);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_cmd_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_cmd_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_cmd_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_cmd_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_cmd_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_cmd_struct *)(struct comedi_cmd_struct *) calloc(1, sizeof(struct comedi_cmd_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_cmd_struct(struct comedi_cmd_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_chaninfo_struct_subdev_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdev = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_chaninfo_struct_subdev_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    result = (unsigned int) ((arg1)->subdev);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_chaninfo_struct_maxdata_list_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    lsampl_t *arg2 = (lsampl_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_lsampl_t, 1);
    if (arg1) (arg1)->maxdata_list = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_chaninfo_struct_maxdata_list_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    lsampl_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    result = (lsampl_t *) ((arg1)->maxdata_list);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_lsampl_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_chaninfo_struct_flaglist_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->flaglist = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_chaninfo_struct_flaglist_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    result = (unsigned int *) ((arg1)->flaglist);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_chaninfo_struct_rangelist_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->rangelist = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_chaninfo_struct_rangelist_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    result = (unsigned int *) ((arg1)->rangelist);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_chaninfo_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 4; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_chaninfo_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *arg1 = (struct comedi_chaninfo_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_chaninfo_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_chaninfo_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_chaninfo_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_chaninfo_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_chaninfo_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_chaninfo_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_chaninfo_struct *)(struct comedi_chaninfo_struct *) calloc(1, sizeof(struct comedi_chaninfo_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_chaninfo_struct(struct comedi_chaninfo_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_rangeinfo_struct_range_type_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_rangeinfo_struct *arg1 = (struct comedi_rangeinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_rangeinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->range_type = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_rangeinfo_struct_range_type_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_rangeinfo_struct *arg1 = (struct comedi_rangeinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_rangeinfo_struct, 1);
    result = (unsigned int) ((arg1)->range_type);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_rangeinfo_struct_range_ptr_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_rangeinfo_struct *arg1 = (struct comedi_rangeinfo_struct *) 0 ;
    void *arg2 = (void *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_rangeinfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, 0, 1);
    if (arg1) (arg1)->range_ptr = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_rangeinfo_struct_range_ptr_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_rangeinfo_struct *arg1 = (struct comedi_rangeinfo_struct *) 0 ;
    void *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_rangeinfo_struct, 1);
    result = (void *) ((arg1)->range_ptr);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_void,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_rangeinfo_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_rangeinfo_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_rangeinfo_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_rangeinfo_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_rangeinfo_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_rangeinfo_struct *)(struct comedi_rangeinfo_struct *) calloc(1, sizeof(struct comedi_rangeinfo_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_rangeinfo_struct(struct comedi_rangeinfo_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_krange_struct_min_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->min = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_krange_struct_min_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    result = (int) ((arg1)->min);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_krange_struct_max_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->max = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_krange_struct_max_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    result = (int) ((arg1)->max);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_krange_struct_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_krange_struct_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *arg1 = (struct comedi_krange_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_krange_struct, 1);
    result = (unsigned int) ((arg1)->flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_krange_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_krange_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_krange_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_krange_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_krange_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_krange_struct *)(struct comedi_krange_struct *) calloc(1, sizeof(struct comedi_krange_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_krange_struct(struct comedi_krange_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_subdinfo_struct_type_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->type = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_type_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->type);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_n_chan_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n_chan = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_n_chan_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->n_chan);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_subd_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subd_flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_subd_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->subd_flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_timer_type_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->timer_type = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_timer_type_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->timer_type);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_len_chanlist_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->len_chanlist = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_len_chanlist_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->len_chanlist);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_maxdata_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    lsampl_t arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->maxdata = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_maxdata_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    lsampl_t result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (lsampl_t) ((arg1)->maxdata);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_range_type_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->range_type = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_range_type_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->range_type);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_settling_time_0_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->settling_time_0 = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_settling_time_0_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int) ((arg1)->settling_time_0);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_subdinfo_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 9; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_subdinfo_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *arg1 = (struct comedi_subdinfo_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_subdinfo_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_subdinfo_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_subdinfo_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_subdinfo_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_subdinfo_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_subdinfo_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_subdinfo_struct *)(struct comedi_subdinfo_struct *) calloc(1, sizeof(struct comedi_subdinfo_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_subdinfo_struct(struct comedi_subdinfo_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_devinfo_struct_version_code_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->version_code = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_version_code_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (unsigned int) ((arg1)->version_code);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_n_subdevs_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->n_subdevs = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_n_subdevs_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (unsigned int) ((arg1)->n_subdevs);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_driver_name_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = StringValuePtr(argv[0]);
    {
        if (arg2) strncpy(arg1->driver_name,arg2,COMEDI_NAMELEN);
        else arg1->driver_name[0] = 0;
    }
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_driver_name_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (char *)(char *) ((arg1)->driver_name);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_board_name_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = StringValuePtr(argv[0]);
    {
        if (arg2) strncpy(arg1->board_name,arg2,COMEDI_NAMELEN);
        else arg1->board_name[0] = 0;
    }
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_board_name_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (char *)(char *) ((arg1)->board_name);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_read_subdevice_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->read_subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_read_subdevice_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (int) ((arg1)->read_subdevice);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_write_subdevice_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->write_subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_write_subdevice_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (int) ((arg1)->write_subdevice);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_devinfo_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_int, 1);
    {
        int ii;
        int *b = (int *) arg1->unused;
        for (ii = 0; ii < 30; ii++) b[ii] = *((int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_devinfo_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *arg1 = (struct comedi_devinfo_struct *) 0 ;
    int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devinfo_struct, 1);
    result = (int *)(int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_devinfo_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_devinfo_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_devinfo_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_devinfo_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_devinfo_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_devinfo_struct *)(struct comedi_devinfo_struct *) calloc(1, sizeof(struct comedi_devinfo_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_devinfo_struct(struct comedi_devinfo_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_devconfig_struct_board_name_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devconfig_struct *arg1 = (struct comedi_devconfig_struct *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devconfig_struct, 1);
    arg2 = StringValuePtr(argv[0]);
    {
        if (arg2) strncpy(arg1->board_name,arg2,COMEDI_NAMELEN);
        else arg1->board_name[0] = 0;
    }
    return Qnil;
}


static VALUE
_wrap_comedi_devconfig_struct_board_name_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devconfig_struct *arg1 = (struct comedi_devconfig_struct *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devconfig_struct, 1);
    result = (char *)(char *) ((arg1)->board_name);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_devconfig_struct_options_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_devconfig_struct *arg1 = (struct comedi_devconfig_struct *) 0 ;
    int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devconfig_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_int, 1);
    {
        int ii;
        int *b = (int *) arg1->options;
        for (ii = 0; ii < COMEDI_NDEVCONFOPTS; ii++) b[ii] = *((int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_devconfig_struct_options_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_devconfig_struct *arg1 = (struct comedi_devconfig_struct *) 0 ;
    int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_devconfig_struct, 1);
    result = (int *)(int *) ((arg1)->options);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_devconfig_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_devconfig_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_devconfig_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_devconfig_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_devconfig_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_devconfig_struct *)(struct comedi_devconfig_struct *) calloc(1, sizeof(struct comedi_devconfig_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_devconfig_struct(struct comedi_devconfig_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_bufconfig_struct_subdevice_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufconfig_struct_subdevice_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    result = (unsigned int) ((arg1)->subdevice);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufconfig_struct_flags_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->flags = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufconfig_struct_flags_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    result = (unsigned int) ((arg1)->flags);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufconfig_struct_maximum_size_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->maximum_size = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufconfig_struct_maximum_size_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    result = (unsigned int) ((arg1)->maximum_size);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufconfig_struct_size_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->size = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufconfig_struct_size_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    result = (unsigned int) ((arg1)->size);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufconfig_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 4; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_bufconfig_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *arg1 = (struct comedi_bufconfig_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufconfig_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_bufconfig_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_bufconfig_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_bufconfig_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_bufconfig_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufconfig_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_bufconfig_struct *)(struct comedi_bufconfig_struct *) calloc(1, sizeof(struct comedi_bufconfig_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_bufconfig_struct(struct comedi_bufconfig_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_bufinfo_struct_subdevice_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_subdevice_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->subdevice);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_bytes_read_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->bytes_read = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_bytes_read_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->bytes_read);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_int_ptr_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->buf_int_ptr = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_int_ptr_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->buf_int_ptr);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_user_ptr_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->buf_user_ptr = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_user_ptr_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->buf_user_ptr);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_int_count_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->buf_int_count = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_int_count_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->buf_int_count);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_user_count_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->buf_user_count = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_buf_user_count_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->buf_user_count);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_bytes_written_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->bytes_written = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_bytes_written_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int) ((arg1)->bytes_written);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_bufinfo_struct_unused_set(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->unused;
        for (ii = 0; ii < 4; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_bufinfo_struct_unused_get(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *arg1 = (struct comedi_bufinfo_struct *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_bufinfo_struct, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->unused);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_bufinfo_struct_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_bufinfo_struct_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_bufinfo_struct);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_bufinfo_struct(int argc, VALUE *argv, VALUE self) {
    struct comedi_bufinfo_struct *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (struct comedi_bufinfo_struct *)(struct comedi_bufinfo_struct *) calloc(1, sizeof(struct comedi_bufinfo_struct));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_bufinfo_struct(struct comedi_bufinfo_struct *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_range_min_set(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (arg1) (arg1)->min = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_range_min_get(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    result = (double) ((arg1)->min);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_comedi_range_max_set(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    double arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    arg2 = (double) NUM2DBL(argv[0]);
    if (arg1) (arg1)->max = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_range_max_get(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    result = (double) ((arg1)->max);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_comedi_range_unit_set(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->unit = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_range_unit_get(int argc, VALUE *argv, VALUE self) {
    comedi_range *arg1 = (comedi_range *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_range, 1);
    result = (unsigned int) ((arg1)->unit);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_range_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_range_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_range);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_range(int argc, VALUE *argv, VALUE self) {
    comedi_range *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (comedi_range *)(comedi_range *) calloc(1, sizeof(comedi_range));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_range(comedi_range *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_sv_t_dev_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    comedi_t *arg2 = (comedi_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, 0, 1);
    if (arg1) (arg1)->dev = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_dev_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    comedi_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (comedi_t *) ((arg1)->dev);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_subdevice_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_subdevice_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (unsigned int) ((arg1)->subdevice);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_chan_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->chan = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_chan_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (unsigned int) ((arg1)->chan);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_range_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->range = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_range_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (int) ((arg1)->range);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_aref_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->aref = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_aref_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (int) ((arg1)->aref);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_n_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2INT(argv[0]);
    if (arg1) (arg1)->n = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_n_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (int) ((arg1)->n);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_t_maxdata_set(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    lsampl_t arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->maxdata = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_sv_t_maxdata_get(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    lsampl_t result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (lsampl_t) ((arg1)->maxdata);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_sv_t_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_sv_t_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_sv_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_sv_t(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (comedi_sv_t *)(comedi_sv_t *) calloc(1, sizeof(comedi_sv_t));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_sv_t(comedi_sv_t *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_open(int argc, VALUE *argv, VALUE self) {
    char *arg1 ;
    comedi_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    result = (comedi_t *)comedi_open((char const *)arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_close(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_close(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_loglevel(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    result = (int)comedi_loglevel(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_perror(int argc, VALUE *argv, VALUE self) {
    char *arg1 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    comedi_perror((char const *)arg1);
    
    return Qnil;
}


static VALUE
_wrap_comedi_strerror(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = NUM2INT(argv[0]);
    result = (char *)comedi_strerror(arg1);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_errno(int argc, VALUE *argv, VALUE self) {
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (int)comedi_errno();
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_fileno(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_fileno(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_set_global_oor_behavior(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = (int) NUM2INT(argv[0]);
    result = (int)comedi_set_global_oor_behavior((enum comedi_oor_behavior)arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_n_subdevices(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_get_n_subdevices(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_version_code(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_get_version_code(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_driver_name(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (char *)comedi_get_driver_name(arg1);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_board_name(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (char *)comedi_get_board_name(arg1);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_read_subdevice(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_get_read_subdevice(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_write_subdevice(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (int)comedi_get_write_subdevice(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_subdevice_type(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_subdevice_type(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_find_subdevice_by_type(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    int arg2 ;
    unsigned int arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2INT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_find_subdevice_by_type(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_subdevice_flags(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_subdevice_flags(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_n_channels(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_n_channels(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_range_is_chan_specific(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_range_is_chan_specific(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_maxdata_is_chan_specific(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_maxdata_is_chan_specific(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_maxdata(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    lsampl_t result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (lsampl_t)comedi_get_maxdata(arg1,arg2,arg3);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_n_ranges(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_get_n_ranges(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_range(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    comedi_range *result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    result = (comedi_range *)comedi_get_range(arg1,arg2,arg3,arg4);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_range,0);
    return vresult;
}


static VALUE
_wrap_comedi_find_range(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    double arg5 ;
    double arg6 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = (double) NUM2DBL(argv[4]);
    arg6 = (double) NUM2DBL(argv[5]);
    result = (int)comedi_find_range(arg1,arg2,arg3,arg4,arg5,arg6);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_buffer_size(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_buffer_size(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_max_buffer_size(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_max_buffer_size(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_set_buffer_size(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_set_buffer_size(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_do_insnlist(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    comedi_insnlist *arg2 = (comedi_insnlist *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_insnlist, 1);
    result = (int)comedi_do_insnlist(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_do_insn(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    comedi_insn *arg2 = (comedi_insn *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_insn, 1);
    result = (int)comedi_do_insn(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_lock(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_lock(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_unlock(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_unlock(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_to_phys(int argc, VALUE *argv, VALUE self) {
    lsampl_t arg1 ;
    comedi_range *arg2 = (comedi_range *) 0 ;
    lsampl_t arg3 ;
    double result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = NUM2UINT(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_range, 1);
    arg3 = NUM2UINT(argv[2]);
    result = (double)comedi_to_phys(arg1,arg2,arg3);
    
    vresult = rb_float_new(result);
    return vresult;
}


static VALUE
_wrap_comedi_from_phys(int argc, VALUE *argv, VALUE self) {
    double arg1 ;
    comedi_range *arg2 = (comedi_range *) 0 ;
    lsampl_t arg3 ;
    lsampl_t result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    arg1 = (double) NUM2DBL(argv[0]);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_range, 1);
    arg3 = NUM2UINT(argv[2]);
    result = (lsampl_t)comedi_from_phys(arg1,arg2,arg3);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sampl_to_phys(int argc, VALUE *argv, VALUE self) {
    double *arg1 = (double *) 0 ;
    int arg2 ;
    sampl_t *arg3 = (sampl_t *) 0 ;
    int arg4 ;
    comedi_range *arg5 = (comedi_range *) 0 ;
    lsampl_t arg6 ;
    int arg7 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 7) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_double, 1);
    arg2 = NUM2INT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_sampl_t, 1);
    arg4 = NUM2INT(argv[3]);
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_comedi_range, 1);
    arg6 = NUM2UINT(argv[5]);
    arg7 = NUM2INT(argv[6]);
    result = (int)comedi_sampl_to_phys(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sampl_from_phys(int argc, VALUE *argv, VALUE self) {
    sampl_t *arg1 = (sampl_t *) 0 ;
    int arg2 ;
    double *arg3 = (double *) 0 ;
    int arg4 ;
    comedi_range *arg5 = (comedi_range *) 0 ;
    lsampl_t arg6 ;
    int arg7 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 7) || (argc > 7))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 7)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_sampl_t, 1);
    arg2 = NUM2INT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_double, 1);
    arg4 = NUM2INT(argv[3]);
    SWIG_ConvertPtr(argv[4], (void **) &arg5, SWIGTYPE_p_comedi_range, 1);
    arg6 = NUM2UINT(argv[5]);
    arg7 = NUM2INT(argv[6]);
    result = (int)comedi_sampl_from_phys(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_data_read(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    lsampl_t *arg6 = (lsampl_t *) 0 ;
    int result;
    lsampl_t temp6 ;
    VALUE vresult = Qnil;
    
    arg6 = &temp6;
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    result = (int)comedi_data_read(arg1,arg2,arg3,arg4,arg5,arg6);
    
    vresult = INT2NUM(result);
    {
        VALUE o = UINT2NUM((unsigned int) (*arg6));
        vresult = output_helper(vresult, o);
    }
    return vresult;
}


static VALUE
_wrap_comedi_data_read_n(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    lsampl_t *arg6 = (lsampl_t *) 0 ;
    unsigned int arg7 ;
    int result;
    lsampl_t temp6 ;
    VALUE vresult = Qnil;
    
    arg6 = &temp6;
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    arg7 = NUM2UINT(argv[5]);
    result = (int)comedi_data_read_n(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    vresult = INT2NUM(result);
    {
        VALUE o = UINT2NUM((unsigned int) (*arg6));
        vresult = output_helper(vresult, o);
    }
    return vresult;
}


static VALUE
_wrap_comedi_data_read_hint(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 5) || (argc > 5))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 5)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    result = (int)comedi_data_read_hint(arg1,arg2,arg3,arg4,arg5);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_data_read_delayed(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    lsampl_t *arg6 = (lsampl_t *) 0 ;
    unsigned int arg7 ;
    int result;
    lsampl_t temp6 ;
    VALUE vresult = Qnil;
    
    arg6 = &temp6;
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    arg7 = NUM2UINT(argv[5]);
    result = (int)comedi_data_read_delayed(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    
    vresult = INT2NUM(result);
    {
        VALUE o = UINT2NUM((unsigned int) (*arg6));
        vresult = output_helper(vresult, o);
    }
    return vresult;
}


static VALUE
_wrap_comedi_data_write(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    lsampl_t arg6 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    arg6 = NUM2UINT(argv[5]);
    result = (int)comedi_data_write(arg1,arg2,arg3,arg4,arg5,arg6);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_dio_config(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    result = (int)comedi_dio_config(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_dio_read(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int *arg4 = (unsigned int *) 0 ;
    int result;
    unsigned int temp4 ;
    VALUE vresult = Qnil;
    
    arg4 = &temp4;
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_dio_read(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    {
        VALUE o = UINT2NUM((unsigned int) (*arg4));
        vresult = output_helper(vresult, o);
    }
    return vresult;
}


static VALUE
_wrap_comedi_dio_write(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    result = (int)comedi_dio_write(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_dio_bitfield(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int *arg4 = (unsigned int *) 0 ;
    int result;
    unsigned int temp4 ;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    {
        temp4 = (unsigned int) NUM2UINT(argv[3]);
        arg4 = &temp4;
    }
    result = (int)comedi_dio_bitfield(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    {
        VALUE o = UINT2NUM((unsigned int) (*arg4));
        vresult = output_helper(vresult, o);
    }
    return vresult;
}


static VALUE
_wrap_comedi_sv_init(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    comedi_t *arg2 = (comedi_t *) 0 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, 0, 1);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    result = (int)comedi_sv_init(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_update(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    result = (int)comedi_sv_update(arg1);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_sv_measure(int argc, VALUE *argv, VALUE self) {
    comedi_sv_t *arg1 = (comedi_sv_t *) 0 ;
    double *arg2 = (double *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_comedi_sv_t, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_double, 1);
    result = (int)comedi_sv_measure(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_cmd_src_mask(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    comedi_cmd *arg3 = (comedi_cmd *) 0 ;
    int result;
    VALUE info3 ;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_comedi_cmd, 1);
    result = (int)comedi_get_cmd_src_mask(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    {
        vresult = output_helper(vresult, argv[2]);
    }
    return vresult;
}


static VALUE
_wrap_comedi_get_cmd_generic_timed(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    comedi_cmd *arg3 = (comedi_cmd *) 0 ;
    unsigned int arg4 ;
    int result;
    VALUE info3 ;
    VALUE vresult = Qnil;
    
    if ((argc < 4) || (argc > 4))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 4)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    SWIG_ConvertPtr(argv[2], (void **) &arg3, SWIGTYPE_p_comedi_cmd, 1);
    arg4 = NUM2UINT(argv[3]);
    result = (int)comedi_get_cmd_generic_timed(arg1,arg2,arg3,arg4);
    
    vresult = INT2NUM(result);
    {
        vresult = output_helper(vresult, argv[2]);
    }
    return vresult;
}


static VALUE
_wrap_comedi_cancel(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_cancel(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_command(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    comedi_cmd *arg2 = (comedi_cmd *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_cmd, 1);
    result = (int)comedi_command(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_command_test(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    comedi_cmd *arg2 = (comedi_cmd *) 0 ;
    int result;
    VALUE info2 ;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    SWIG_ConvertPtr(argv[1], (void **) &arg2, SWIGTYPE_p_comedi_cmd, 1);
    result = (int)comedi_command_test(arg1,arg2);
    
    vresult = INT2NUM(result);
    {
        vresult = output_helper(vresult, argv[1]);
    }
    return vresult;
}


static VALUE
_wrap_comedi_poll(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_poll(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_set_max_buffer_size(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_set_max_buffer_size(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_buffer_contents(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_buffer_contents(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_mark_buffer_read(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 3) || (argc > 3))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 3)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    result = (int)comedi_mark_buffer_read(arg1,arg2,arg3);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_buffer_offset(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 2) || (argc > 2))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 2)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    result = (int)comedi_get_buffer_offset(arg1,arg2);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_caldac_t_subdevice_set(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_caldac_t_subdevice_get(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    result = (unsigned int) ((arg1)->subdevice);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_caldac_t_channel_set(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->channel = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_caldac_t_channel_get(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    result = (unsigned int) ((arg1)->channel);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_caldac_t_value_set(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->value = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_caldac_t_value_get(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *arg1 = (comedi_caldac_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_caldac_t, 1);
    result = (unsigned int) ((arg1)->value);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_caldac_t_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_caldac_t_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_caldac_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_caldac_t(int argc, VALUE *argv, VALUE self) {
    comedi_caldac_t *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (comedi_caldac_t *)(comedi_caldac_t *) calloc(1, sizeof(comedi_caldac_t));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_caldac_t(comedi_caldac_t *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_calibration_setting_t_subdevice_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->subdevice = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_subdevice_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int) ((arg1)->subdevice);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_channels_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->channels = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_channels_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int *) ((arg1)->channels);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_channels_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->num_channels = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_channels_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int) ((arg1)->num_channels);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_ranges_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *arg2 = (unsigned int *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    if (arg1) (arg1)->ranges = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_ranges_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int *) ((arg1)->ranges);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_ranges_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->num_ranges = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_ranges_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int) ((arg1)->num_ranges);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_arefs_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_unsigned_int, 1);
    {
        int ii;
        unsigned int *b = (unsigned int *) arg1->arefs;
        for (ii = 0; ii < 4; ii++) b[ii] = *((unsigned int *) arg2 + ii);
    }
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_arefs_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int *)(unsigned int *) ((arg1)->arefs);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_unsigned_int,0);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_arefs_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->num_arefs = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_arefs_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int) ((arg1)->num_arefs);
    
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_caldacs_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    comedi_caldac_t *arg2 = (comedi_caldac_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_comedi_caldac_t, 1);
    if (arg1) (arg1)->caldacs = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_caldacs_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    comedi_caldac_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (comedi_caldac_t *) ((arg1)->caldacs);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_caldac_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_caldacs_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->num_caldacs = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_setting_t_num_caldacs_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *arg1 = (comedi_calibration_setting_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    result = (unsigned int) ((arg1)->num_caldacs);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_calibration_setting_t_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_calibration_setting_t_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_calibration_setting_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_calibration_setting_t(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_setting_t *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (comedi_calibration_setting_t *)(comedi_calibration_setting_t *) calloc(1, sizeof(comedi_calibration_setting_t));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_calibration_setting_t(comedi_calibration_setting_t *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_calibration_t_driver_name_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    arg2 = StringValuePtr(argv[0]);
    {
        if (arg1->driver_name) free((char*)arg1->driver_name);
        if (arg2) {
            arg1->driver_name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->driver_name,arg2);
        } else {
            arg1->driver_name = 0;
        }
    }
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_t_driver_name_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    result = (char *) ((arg1)->driver_name);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_t_board_name_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    char *arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    arg2 = StringValuePtr(argv[0]);
    {
        if (arg1->board_name) free((char*)arg1->board_name);
        if (arg2) {
            arg1->board_name = (char *) malloc(strlen(arg2)+1);
            strcpy((char*)arg1->board_name,arg2);
        } else {
            arg1->board_name = 0;
        }
    }
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_t_board_name_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    result = (char *) ((arg1)->board_name);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_t_settings_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    comedi_calibration_setting_t *arg2 = (comedi_calibration_setting_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    SWIG_ConvertPtr(argv[0], (void **) &arg2, SWIGTYPE_p_comedi_calibration_setting_t, 1);
    if (arg1) (arg1)->settings = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_t_settings_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    comedi_calibration_setting_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    result = (comedi_calibration_setting_t *) ((arg1)->settings);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_calibration_setting_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_calibration_t_num_settings_set(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    unsigned int arg2 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    arg2 = NUM2UINT(argv[0]);
    if (arg1) (arg1)->num_settings = arg2;
    
    return Qnil;
}


static VALUE
_wrap_comedi_calibration_t_num_settings_get(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    result = (unsigned int) ((arg1)->num_settings);
    
    vresult = UINT2NUM(result);
    return vresult;
}


#ifdef HAVE_RB_DEFINE_ALLOC_FUNC
static VALUE
_wrap_comedi_calibration_t_allocate(VALUE self) {
#else
    static VALUE
    _wrap_comedi_calibration_t_allocate(int argc, VALUE *argv, VALUE self) {
#endif
        
        
        VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_comedi_calibration_t);
#ifndef HAVE_RB_DEFINE_ALLOC_FUNC
        rb_obj_call_init(vresult, argc, argv);
#endif
        return vresult;
    }
    

static VALUE
_wrap_new_comedi_calibration_t(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    result = (comedi_calibration_t *)(comedi_calibration_t *) calloc(1, sizeof(comedi_calibration_t));
    DATA_PTR(self) = result;
    return self;
}


static void
free_comedi_calibration_t(comedi_calibration_t *arg1) {
    free((char*) arg1);
}
static VALUE
_wrap_comedi_parse_calibration_file(int argc, VALUE *argv, VALUE self) {
    char *arg1 ;
    comedi_calibration_t *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    arg1 = StringValuePtr(argv[0]);
    result = (comedi_calibration_t *)comedi_parse_calibration_file((char const *)arg1);
    
    vresult = SWIG_NewPointerObj((void *) result, SWIGTYPE_p_comedi_calibration_t,0);
    return vresult;
}


static VALUE
_wrap_comedi_apply_parsed_calibration(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    comedi_calibration_t *arg6 = (comedi_calibration_t *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    SWIG_ConvertPtr(argv[5], (void **) &arg6, SWIGTYPE_p_comedi_calibration_t, 1);
    result = (int)comedi_apply_parsed_calibration(arg1,arg2,arg3,arg4,arg5,(comedi_calibration_t const *)arg6);
    
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_comedi_get_default_calibration_path(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    result = (char *)comedi_get_default_calibration_path(arg1);
    
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_comedi_cleanup_calibration(int argc, VALUE *argv, VALUE self) {
    comedi_calibration_t *arg1 = (comedi_calibration_t *) 0 ;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, SWIGTYPE_p_comedi_calibration_t, 1);
    comedi_cleanup_calibration(arg1);
    
    return Qnil;
}


static VALUE
_wrap_comedi_apply_calibration(int argc, VALUE *argv, VALUE self) {
    comedi_t *arg1 = (comedi_t *) 0 ;
    unsigned int arg2 ;
    unsigned int arg3 ;
    unsigned int arg4 ;
    unsigned int arg5 ;
    char *arg6 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 6) || (argc > 6))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 6)",argc);
    SWIG_ConvertPtr(argv[0], (void **) &arg1, 0, 1);
    arg2 = NUM2UINT(argv[1]);
    arg3 = NUM2UINT(argv[2]);
    arg4 = NUM2UINT(argv[3]);
    arg5 = NUM2UINT(argv[4]);
    arg6 = StringValuePtr(argv[5]);
    result = (int)comedi_apply_calibration(arg1,arg2,arg3,arg4,arg5,(char const *)arg6);
    
    vresult = INT2NUM(result);
    return vresult;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_chanlistTo_p_unsigned_int(void *x) {
    return (void *)((unsigned int *)  ((chanlist *) x));
}
static swig_type_info _swigt__p_lsampl_t[] = {{"_p_lsampl_t", 0, "lsampl_t *", 0},{"_p_chanlist"},{"_p_lsampl_t"},{"_p_unsigned_int"},{0}};
static swig_type_info _swigt__p_sampl_t[] = {{"_p_sampl_t", 0, "sampl_t *", 0},{"_p_sampl_t"},{0}};
static swig_type_info _swigt__p_comedi_calibration_setting_t[] = {{"_p_comedi_calibration_setting_t", 0, "comedi_calibration_setting_t *", 0},{"_p_comedi_calibration_setting_t"},{0}};
static swig_type_info _swigt__p_double[] = {{"_p_double", 0, "double *", 0},{"_p_double"},{0}};
static swig_type_info _swigt__p_comedi_range[] = {{"_p_comedi_range", 0, "comedi_range *", 0},{"_p_comedi_range"},{0}};
static swig_type_info _swigt__p_unsigned_int[] = {{"_p_unsigned_int", 0, "unsigned int *", 0},{"_p_chanlist", _p_chanlistTo_p_unsigned_int},{"_p_lsampl_t"},{"_p_unsigned_int"},{0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *", 0},{"_p_comedi_t"},{"_p_void"},{0}};
static swig_type_info _swigt__p_comedi_subdinfo_struct[] = {{"_p_comedi_subdinfo_struct", 0, "struct comedi_subdinfo_struct *", 0},{"_p_comedi_subdinfo_struct"},{0}};
static swig_type_info _swigt__p_comedi_krange_struct[] = {{"_p_comedi_krange_struct", 0, "struct comedi_krange_struct *", 0},{"_p_comedi_krange_struct"},{0}};
static swig_type_info _swigt__p_comedi_rangeinfo_struct[] = {{"_p_comedi_rangeinfo_struct", 0, "struct comedi_rangeinfo_struct *", 0},{"_p_comedi_rangeinfo_struct"},{0}};
static swig_type_info _swigt__p_comedi_chaninfo_struct[] = {{"_p_comedi_chaninfo_struct", 0, "struct comedi_chaninfo_struct *", 0},{"_p_comedi_chaninfo_struct"},{0}};
static swig_type_info _swigt__p_comedi_cmd_struct[] = {{"_p_comedi_cmd_struct", 0, "struct comedi_cmd_struct *", 0},{"_p_comedi_cmd_struct"},{"_p_comedi_cmd"},{0}};
static swig_type_info _swigt__p_comedi_insnlist_struct[] = {{"_p_comedi_insnlist_struct", 0, "struct comedi_insnlist_struct *", 0},{"_p_comedi_insnlist"},{"_p_comedi_insnlist_struct"},{0}};
static swig_type_info _swigt__p_comedi_insn_struct[] = {{"_p_comedi_insn_struct", 0, "struct comedi_insn_struct *", 0},{"_p_comedi_insn_struct"},{"_p_comedi_insn"},{0}};
static swig_type_info _swigt__p_comedi_trig_struct[] = {{"_p_comedi_trig_struct", 0, "struct comedi_trig_struct *", 0},{"_p_comedi_trig_struct"},{0}};
static swig_type_info _swigt__p_comedi_devinfo_struct[] = {{"_p_comedi_devinfo_struct", 0, "struct comedi_devinfo_struct *", 0},{"_p_comedi_devinfo_struct"},{0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0},{"_p_char"},{0}};
static swig_type_info _swigt__p_comedi_devconfig_struct[] = {{"_p_comedi_devconfig_struct", 0, "struct comedi_devconfig_struct *", 0},{"_p_comedi_devconfig_struct"},{0}};
static swig_type_info _swigt__p_comedi_bufconfig_struct[] = {{"_p_comedi_bufconfig_struct", 0, "struct comedi_bufconfig_struct *", 0},{"_p_comedi_bufconfig_struct"},{0}};
static swig_type_info _swigt__p_comedi_bufinfo_struct[] = {{"_p_comedi_bufinfo_struct", 0, "struct comedi_bufinfo_struct *", 0},{"_p_comedi_bufinfo_struct"},{0}};
static swig_type_info _swigt__p_comedi_calibration_t[] = {{"_p_comedi_calibration_t", 0, "comedi_calibration_t *", 0},{"_p_comedi_calibration_t"},{0}};
static swig_type_info _swigt__p_comedi_sv_t[] = {{"_p_comedi_sv_t", 0, "comedi_sv_t *", 0},{"_p_comedi_sv_t"},{0}};
static swig_type_info _swigt__p_chanlist[] = {{"_p_chanlist", 0, "chanlist *", 0},{"_p_chanlist"},{0}};
static swig_type_info _swigt__p_comedi_insn[] = {{"_p_comedi_insn", 0, "comedi_insn *", 0},{"_p_comedi_insn_struct"},{"_p_comedi_insn"},{0}};
static swig_type_info _swigt__p_comedi_insnlist[] = {{"_p_comedi_insnlist", 0, "comedi_insnlist *", 0},{"_p_comedi_insnlist"},{"_p_comedi_insnlist_struct"},{0}};
static swig_type_info _swigt__p_comedi_caldac_t[] = {{"_p_comedi_caldac_t", 0, "comedi_caldac_t *", 0},{"_p_comedi_caldac_t"},{0}};
static swig_type_info _swigt__p_comedi_t[] = {{"_p_comedi_t", 0, "comedi_t *", 0},{"_p_comedi_t"},{"_p_void"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"_p_int"},{0}};
static swig_type_info _swigt__p_comedi_cmd[] = {{"_p_comedi_cmd", 0, "comedi_cmd *", 0},{"_p_comedi_cmd"},{"_p_comedi_cmd_struct"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_lsampl_t, 
_swigt__p_sampl_t, 
_swigt__p_comedi_calibration_setting_t, 
_swigt__p_double, 
_swigt__p_comedi_range, 
_swigt__p_unsigned_int, 
_swigt__p_void, 
_swigt__p_comedi_subdinfo_struct, 
_swigt__p_comedi_krange_struct, 
_swigt__p_comedi_rangeinfo_struct, 
_swigt__p_comedi_chaninfo_struct, 
_swigt__p_comedi_cmd_struct, 
_swigt__p_comedi_insnlist_struct, 
_swigt__p_comedi_insn_struct, 
_swigt__p_comedi_trig_struct, 
_swigt__p_comedi_devinfo_struct, 
_swigt__p_char, 
_swigt__p_comedi_devconfig_struct, 
_swigt__p_comedi_bufconfig_struct, 
_swigt__p_comedi_bufinfo_struct, 
_swigt__p_comedi_calibration_t, 
_swigt__p_comedi_sv_t, 
_swigt__p_chanlist, 
_swigt__p_comedi_insn, 
_swigt__p_comedi_insnlist, 
_swigt__p_comedi_caldac_t, 
_swigt__p_comedi_t, 
_swigt__p_int, 
_swigt__p_comedi_cmd, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_comedi(void) {
    int i;
    
    SWIG_InitRuntime();
    mComedi = rb_define_module("Comedi");
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    rb_define_module_function(mComedi, "cr_pack", _wrap_cr_pack, -1);
    rb_define_module_function(mComedi, "cr_pack_flags", _wrap_cr_pack_flags, -1);
    rb_define_module_function(mComedi, "cr_chan", _wrap_cr_chan, -1);
    rb_define_module_function(mComedi, "cr_range", _wrap_cr_range, -1);
    rb_define_module_function(mComedi, "cr_aref", _wrap_cr_aref, -1);
    
    cChanlist.klass = rb_define_class_under(mComedi, "Chanlist", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_chanlist, (void *) &cChanlist);
    rb_define_alloc_func(cChanlist.klass, _wrap_chanlist_allocate);
    rb_define_method(cChanlist.klass, "initialize", _wrap_new_chanlist, -1);
    rb_define_method(cChanlist.klass, "[]", _wrap_chanlist___getitem__, -1);
    rb_define_method(cChanlist.klass, "[]=", _wrap_chanlist___setitem__, -1);
    rb_define_method(cChanlist.klass, "cast", _wrap_chanlist_cast, -1);
    rb_define_singleton_method(cChanlist.klass, "frompointer", _wrap_chanlist_frompointer, -1);
    cChanlist.mark = 0;
    cChanlist.destroy = (void (*)(void *)) free_chanlist;
    rb_define_const(mComedi,"CR_FLAGS_MASK", INT2NUM(0xfc000000));
    rb_define_const(mComedi,"CR_ALT_FILTER", INT2NUM((1<<26)));
    rb_define_const(mComedi,"CR_DITHER", INT2NUM((1<<26)));
    rb_define_const(mComedi,"CR_DEGLITCH", INT2NUM((1<<26)));
    rb_define_const(mComedi,"CR_ALT_SOURCE", INT2NUM((1<<27)));
    rb_define_const(mComedi,"CR_EDGE", INT2NUM((1<<30)));
    rb_define_const(mComedi,"CR_INVERT", INT2NUM((1<<31)));
    rb_define_const(mComedi,"AREF_GROUND", INT2NUM(0x00));
    rb_define_const(mComedi,"AREF_COMMON", INT2NUM(0x01));
    rb_define_const(mComedi,"AREF_DIFF", INT2NUM(0x02));
    rb_define_const(mComedi,"AREF_OTHER", INT2NUM(0x03));
    rb_define_const(mComedi,"GPCT_RESET", INT2NUM(0x0001));
    rb_define_const(mComedi,"GPCT_SET_SOURCE", INT2NUM(0x0002));
    rb_define_const(mComedi,"GPCT_SET_GATE", INT2NUM(0x0004));
    rb_define_const(mComedi,"GPCT_SET_DIRECTION", INT2NUM(0x0008));
    rb_define_const(mComedi,"GPCT_SET_OPERATION", INT2NUM(0x0010));
    rb_define_const(mComedi,"GPCT_ARM", INT2NUM(0x0020));
    rb_define_const(mComedi,"GPCT_DISARM", INT2NUM(0x0040));
    rb_define_const(mComedi,"GPCT_GET_INT_CLK_FRQ", INT2NUM(0x0080));
    rb_define_const(mComedi,"GPCT_INT_CLOCK", INT2NUM(0x0001));
    rb_define_const(mComedi,"GPCT_EXT_PIN", INT2NUM(0x0002));
    rb_define_const(mComedi,"GPCT_NO_GATE", INT2NUM(0x0004));
    rb_define_const(mComedi,"GPCT_UP", INT2NUM(0x0008));
    rb_define_const(mComedi,"GPCT_DOWN", INT2NUM(0x0010));
    rb_define_const(mComedi,"GPCT_HWUD", INT2NUM(0x0020));
    rb_define_const(mComedi,"GPCT_SIMPLE_EVENT", INT2NUM(0x0040));
    rb_define_const(mComedi,"GPCT_SINGLE_PERIOD", INT2NUM(0x0080));
    rb_define_const(mComedi,"GPCT_SINGLE_PW", INT2NUM(0x0100));
    rb_define_const(mComedi,"GPCT_CONT_PULSE_OUT", INT2NUM(0x0200));
    rb_define_const(mComedi,"GPCT_SINGLE_PULSE_OUT", INT2NUM(0x0400));
    rb_define_const(mComedi,"INSN_MASK_WRITE", INT2NUM(0x8000000));
    rb_define_const(mComedi,"INSN_MASK_READ", INT2NUM(0x4000000));
    rb_define_const(mComedi,"INSN_MASK_SPECIAL", INT2NUM(0x2000000));
    rb_define_const(mComedi,"INSN_READ", INT2NUM((0|0x4000000)));
    rb_define_const(mComedi,"INSN_WRITE", INT2NUM((1|0x8000000)));
    rb_define_const(mComedi,"INSN_BITS", INT2NUM((2|0x4000000|0x8000000)));
    rb_define_const(mComedi,"INSN_CONFIG", INT2NUM((3|0x4000000|0x8000000)));
    rb_define_const(mComedi,"INSN_GTOD", INT2NUM((4|0x4000000|0x2000000)));
    rb_define_const(mComedi,"INSN_WAIT", INT2NUM((5|0x8000000|0x2000000)));
    rb_define_const(mComedi,"INSN_INTTRIG", INT2NUM((6|0x8000000|0x2000000)));
    rb_define_const(mComedi,"TRIG_BOGUS", INT2NUM(0x0001));
    rb_define_const(mComedi,"TRIG_DITHER", INT2NUM(0x0002));
    rb_define_const(mComedi,"TRIG_DEGLITCH", INT2NUM(0x0004));
    rb_define_const(mComedi,"TRIG_CONFIG", INT2NUM(0x0010));
    rb_define_const(mComedi,"CMDF_PRIORITY", INT2NUM(0x00000008));
    rb_define_const(mComedi,"TRIG_RT", INT2NUM(0x00000008));
    rb_define_const(mComedi,"TRIG_WAKE_EOS", INT2NUM(0x00000020));
    rb_define_const(mComedi,"CMDF_WRITE", INT2NUM(0x00000040));
    rb_define_const(mComedi,"TRIG_WRITE", INT2NUM(0x00000040));
    rb_define_const(mComedi,"CMDF_RAWDATA", INT2NUM(0x00000080));
    rb_define_const(mComedi,"COMEDI_EV_START", INT2NUM(0x00040000));
    rb_define_const(mComedi,"COMEDI_EV_SCAN_BEGIN", INT2NUM(0x00080000));
    rb_define_const(mComedi,"COMEDI_EV_CONVERT", INT2NUM(0x00100000));
    rb_define_const(mComedi,"COMEDI_EV_SCAN_END", INT2NUM(0x00200000));
    rb_define_const(mComedi,"COMEDI_EV_STOP", INT2NUM(0x00400000));
    rb_define_const(mComedi,"TRIG_ROUND_MASK", INT2NUM(0x00030000));
    rb_define_const(mComedi,"TRIG_ROUND_NEAREST", INT2NUM(0x00000000));
    rb_define_const(mComedi,"TRIG_ROUND_DOWN", INT2NUM(0x00010000));
    rb_define_const(mComedi,"TRIG_ROUND_UP", INT2NUM(0x00020000));
    rb_define_const(mComedi,"TRIG_ROUND_UP_NEXT", INT2NUM(0x00030000));
    rb_define_const(mComedi,"TRIG_ANY", INT2NUM(0xffffffff));
    rb_define_const(mComedi,"TRIG_INVALID", INT2NUM(0x00000000));
    rb_define_const(mComedi,"TRIG_NONE", INT2NUM(0x00000001));
    rb_define_const(mComedi,"TRIG_NOW", INT2NUM(0x00000002));
    rb_define_const(mComedi,"TRIG_FOLLOW", INT2NUM(0x00000004));
    rb_define_const(mComedi,"TRIG_TIME", INT2NUM(0x00000008));
    rb_define_const(mComedi,"TRIG_TIMER", INT2NUM(0x00000010));
    rb_define_const(mComedi,"TRIG_COUNT", INT2NUM(0x00000020));
    rb_define_const(mComedi,"TRIG_EXT", INT2NUM(0x00000040));
    rb_define_const(mComedi,"TRIG_INT", INT2NUM(0x00000080));
    rb_define_const(mComedi,"TRIG_OTHER", INT2NUM(0x00000100));
    rb_define_const(mComedi,"SDF_BUSY", INT2NUM(0x0001));
    rb_define_const(mComedi,"SDF_BUSY_OWNER", INT2NUM(0x0002));
    rb_define_const(mComedi,"SDF_LOCKED", INT2NUM(0x0004));
    rb_define_const(mComedi,"SDF_LOCK_OWNER", INT2NUM(0x0008));
    rb_define_const(mComedi,"SDF_MAXDATA", INT2NUM(0x0010));
    rb_define_const(mComedi,"SDF_FLAGS", INT2NUM(0x0020));
    rb_define_const(mComedi,"SDF_RANGETYPE", INT2NUM(0x0040));
    rb_define_const(mComedi,"SDF_MODE0", INT2NUM(0x0080));
    rb_define_const(mComedi,"SDF_MODE1", INT2NUM(0x0100));
    rb_define_const(mComedi,"SDF_MODE2", INT2NUM(0x0200));
    rb_define_const(mComedi,"SDF_MODE3", INT2NUM(0x0400));
    rb_define_const(mComedi,"SDF_MODE4", INT2NUM(0x0800));
    rb_define_const(mComedi,"SDF_CMD", INT2NUM(0x1000));
    rb_define_const(mComedi,"SDF_READABLE", INT2NUM(0x00010000));
    rb_define_const(mComedi,"SDF_WRITABLE", INT2NUM(0x00020000));
    rb_define_const(mComedi,"SDF_WRITEABLE", INT2NUM(0x00020000));
    rb_define_const(mComedi,"SDF_INTERNAL", INT2NUM(0x00040000));
    rb_define_const(mComedi,"SDF_RT", INT2NUM(0x00080000));
    rb_define_const(mComedi,"SDF_GROUND", INT2NUM(0x00100000));
    rb_define_const(mComedi,"SDF_COMMON", INT2NUM(0x00200000));
    rb_define_const(mComedi,"SDF_DIFF", INT2NUM(0x00400000));
    rb_define_const(mComedi,"SDF_OTHER", INT2NUM(0x00800000));
    rb_define_const(mComedi,"SDF_DITHER", INT2NUM(0x01000000));
    rb_define_const(mComedi,"SDF_DEGLITCH", INT2NUM(0x02000000));
    rb_define_const(mComedi,"SDF_MMAP", INT2NUM(0x04000000));
    rb_define_const(mComedi,"SDF_RUNNING", INT2NUM(0x08000000));
    rb_define_const(mComedi,"SDF_LSAMPL", INT2NUM(0x10000000));
    rb_define_const(mComedi,"SDF_PACKED", INT2NUM(0x20000000));
    rb_define_const(mComedi,"COMEDI_SUBD_UNUSED", INT2NUM(0));
    rb_define_const(mComedi,"COMEDI_SUBD_AI", INT2NUM(1));
    rb_define_const(mComedi,"COMEDI_SUBD_AO", INT2NUM(2));
    rb_define_const(mComedi,"COMEDI_SUBD_DI", INT2NUM(3));
    rb_define_const(mComedi,"COMEDI_SUBD_DO", INT2NUM(4));
    rb_define_const(mComedi,"COMEDI_SUBD_DIO", INT2NUM(5));
    rb_define_const(mComedi,"COMEDI_SUBD_COUNTER", INT2NUM(6));
    rb_define_const(mComedi,"COMEDI_SUBD_TIMER", INT2NUM(7));
    rb_define_const(mComedi,"COMEDI_SUBD_MEMORY", INT2NUM(8));
    rb_define_const(mComedi,"COMEDI_SUBD_CALIB", INT2NUM(9));
    rb_define_const(mComedi,"COMEDI_SUBD_PROC", INT2NUM(10));
    rb_define_const(mComedi,"COMEDI_INPUT", INT2NUM(0));
    rb_define_const(mComedi,"COMEDI_OUTPUT", INT2NUM(1));
    rb_define_const(mComedi,"COMEDI_OPENDRAIN", INT2NUM(2));
    rb_define_const(mComedi,"INSN_CONFIG_ANALOG_TRIG", INT2NUM(0x10));
    rb_define_const(mComedi,"INSN_CONFIG_ALT_SOURCE", INT2NUM(0x14));
    rb_define_const(mComedi,"INSN_CONFIG_DIGITAL_TRIG", INT2NUM(0x15));
    rb_define_const(mComedi,"INSN_CONFIG_BLOCK_SIZE", INT2NUM(0x16));
    rb_define_const(mComedi,"INSN_CONFIG_TIMER_1", INT2NUM(0x17));
    rb_define_const(mComedi,"INSN_CONFIG_FILTER", INT2NUM(0x18));
    rb_define_const(mComedi,"INSN_CONFIG_CHANGE_NOTIFY", INT2NUM(0x19));
    
    cComedi_trig_struct.klass = rb_define_class_under(mComedi, "Comedi_trig_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_trig_struct, (void *) &cComedi_trig_struct);
    rb_define_alloc_func(cComedi_trig_struct.klass, _wrap_comedi_trig_struct_allocate);
    rb_define_method(cComedi_trig_struct.klass, "initialize", _wrap_new_comedi_trig_struct, -1);
    rb_define_method(cComedi_trig_struct.klass, "subdev=", _wrap_comedi_trig_struct_subdev_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "subdev", _wrap_comedi_trig_struct_subdev_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "mode=", _wrap_comedi_trig_struct_mode_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "mode", _wrap_comedi_trig_struct_mode_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "flags=", _wrap_comedi_trig_struct_flags_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "flags", _wrap_comedi_trig_struct_flags_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "n_chan=", _wrap_comedi_trig_struct_n_chan_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "n_chan", _wrap_comedi_trig_struct_n_chan_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "chanlist=", _wrap_comedi_trig_struct_chanlist_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "chanlist", _wrap_comedi_trig_struct_chanlist_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "data=", _wrap_comedi_trig_struct_data_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "data", _wrap_comedi_trig_struct_data_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "n=", _wrap_comedi_trig_struct_n_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "n", _wrap_comedi_trig_struct_n_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigsrc=", _wrap_comedi_trig_struct_trigsrc_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigsrc", _wrap_comedi_trig_struct_trigsrc_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigvar=", _wrap_comedi_trig_struct_trigvar_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigvar", _wrap_comedi_trig_struct_trigvar_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigvar1=", _wrap_comedi_trig_struct_trigvar1_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "trigvar1", _wrap_comedi_trig_struct_trigvar1_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "data_len=", _wrap_comedi_trig_struct_data_len_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "data_len", _wrap_comedi_trig_struct_data_len_get, -1);
    rb_define_method(cComedi_trig_struct.klass, "unused=", _wrap_comedi_trig_struct_unused_set, -1);
    rb_define_method(cComedi_trig_struct.klass, "unused", _wrap_comedi_trig_struct_unused_get, -1);
    cComedi_trig_struct.mark = 0;
    cComedi_trig_struct.destroy = (void (*)(void *)) free_comedi_trig_struct;
    
    cComedi_insn_struct.klass = rb_define_class_under(mComedi, "Comedi_insn_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_insn_struct, (void *) &cComedi_insn_struct);
    rb_define_alloc_func(cComedi_insn_struct.klass, _wrap_comedi_insn_struct_allocate);
    rb_define_method(cComedi_insn_struct.klass, "initialize", _wrap_new_comedi_insn_struct, -1);
    rb_define_method(cComedi_insn_struct.klass, "insn=", _wrap_comedi_insn_struct_insn_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "insn", _wrap_comedi_insn_struct_insn_get, -1);
    rb_define_method(cComedi_insn_struct.klass, "n=", _wrap_comedi_insn_struct_n_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "n", _wrap_comedi_insn_struct_n_get, -1);
    rb_define_method(cComedi_insn_struct.klass, "data=", _wrap_comedi_insn_struct_data_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "data", _wrap_comedi_insn_struct_data_get, -1);
    rb_define_method(cComedi_insn_struct.klass, "subdev=", _wrap_comedi_insn_struct_subdev_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "subdev", _wrap_comedi_insn_struct_subdev_get, -1);
    rb_define_method(cComedi_insn_struct.klass, "chanspec=", _wrap_comedi_insn_struct_chanspec_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "chanspec", _wrap_comedi_insn_struct_chanspec_get, -1);
    rb_define_method(cComedi_insn_struct.klass, "unused=", _wrap_comedi_insn_struct_unused_set, -1);
    rb_define_method(cComedi_insn_struct.klass, "unused", _wrap_comedi_insn_struct_unused_get, -1);
    cComedi_insn_struct.mark = 0;
    cComedi_insn_struct.destroy = (void (*)(void *)) free_comedi_insn_struct;
    
    cComedi_insnlist_struct.klass = rb_define_class_under(mComedi, "Comedi_insnlist_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_insnlist_struct, (void *) &cComedi_insnlist_struct);
    rb_define_alloc_func(cComedi_insnlist_struct.klass, _wrap_comedi_insnlist_struct_allocate);
    rb_define_method(cComedi_insnlist_struct.klass, "initialize", _wrap_new_comedi_insnlist_struct, -1);
    rb_define_method(cComedi_insnlist_struct.klass, "n_insns=", _wrap_comedi_insnlist_struct_n_insns_set, -1);
    rb_define_method(cComedi_insnlist_struct.klass, "n_insns", _wrap_comedi_insnlist_struct_n_insns_get, -1);
    rb_define_method(cComedi_insnlist_struct.klass, "insns=", _wrap_comedi_insnlist_struct_insns_set, -1);
    rb_define_method(cComedi_insnlist_struct.klass, "insns", _wrap_comedi_insnlist_struct_insns_get, -1);
    cComedi_insnlist_struct.mark = 0;
    cComedi_insnlist_struct.destroy = (void (*)(void *)) free_comedi_insnlist_struct;
    
    cComedi_cmd_struct.klass = rb_define_class_under(mComedi, "Comedi_cmd_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_cmd_struct, (void *) &cComedi_cmd_struct);
    rb_define_alloc_func(cComedi_cmd_struct.klass, _wrap_comedi_cmd_struct_allocate);
    rb_define_method(cComedi_cmd_struct.klass, "initialize", _wrap_new_comedi_cmd_struct, -1);
    rb_define_method(cComedi_cmd_struct.klass, "subdev=", _wrap_comedi_cmd_struct_subdev_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "subdev", _wrap_comedi_cmd_struct_subdev_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "flags=", _wrap_comedi_cmd_struct_flags_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "flags", _wrap_comedi_cmd_struct_flags_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "start_src=", _wrap_comedi_cmd_struct_start_src_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "start_src", _wrap_comedi_cmd_struct_start_src_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "start_arg=", _wrap_comedi_cmd_struct_start_arg_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "start_arg", _wrap_comedi_cmd_struct_start_arg_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_begin_src=", _wrap_comedi_cmd_struct_scan_begin_src_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_begin_src", _wrap_comedi_cmd_struct_scan_begin_src_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_begin_arg=", _wrap_comedi_cmd_struct_scan_begin_arg_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_begin_arg", _wrap_comedi_cmd_struct_scan_begin_arg_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "convert_src=", _wrap_comedi_cmd_struct_convert_src_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "convert_src", _wrap_comedi_cmd_struct_convert_src_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "convert_arg=", _wrap_comedi_cmd_struct_convert_arg_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "convert_arg", _wrap_comedi_cmd_struct_convert_arg_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_end_src=", _wrap_comedi_cmd_struct_scan_end_src_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_end_src", _wrap_comedi_cmd_struct_scan_end_src_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_end_arg=", _wrap_comedi_cmd_struct_scan_end_arg_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "scan_end_arg", _wrap_comedi_cmd_struct_scan_end_arg_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "stop_src=", _wrap_comedi_cmd_struct_stop_src_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "stop_src", _wrap_comedi_cmd_struct_stop_src_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "stop_arg=", _wrap_comedi_cmd_struct_stop_arg_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "stop_arg", _wrap_comedi_cmd_struct_stop_arg_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "chanlist=", _wrap_comedi_cmd_struct_chanlist_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "chanlist", _wrap_comedi_cmd_struct_chanlist_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "chanlist_len=", _wrap_comedi_cmd_struct_chanlist_len_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "chanlist_len", _wrap_comedi_cmd_struct_chanlist_len_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "data=", _wrap_comedi_cmd_struct_data_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "data", _wrap_comedi_cmd_struct_data_get, -1);
    rb_define_method(cComedi_cmd_struct.klass, "data_len=", _wrap_comedi_cmd_struct_data_len_set, -1);
    rb_define_method(cComedi_cmd_struct.klass, "data_len", _wrap_comedi_cmd_struct_data_len_get, -1);
    cComedi_cmd_struct.mark = 0;
    cComedi_cmd_struct.destroy = (void (*)(void *)) free_comedi_cmd_struct;
    
    cComedi_chaninfo_struct.klass = rb_define_class_under(mComedi, "Comedi_chaninfo_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_chaninfo_struct, (void *) &cComedi_chaninfo_struct);
    rb_define_alloc_func(cComedi_chaninfo_struct.klass, _wrap_comedi_chaninfo_struct_allocate);
    rb_define_method(cComedi_chaninfo_struct.klass, "initialize", _wrap_new_comedi_chaninfo_struct, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "subdev=", _wrap_comedi_chaninfo_struct_subdev_set, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "subdev", _wrap_comedi_chaninfo_struct_subdev_get, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "maxdata_list=", _wrap_comedi_chaninfo_struct_maxdata_list_set, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "maxdata_list", _wrap_comedi_chaninfo_struct_maxdata_list_get, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "flaglist=", _wrap_comedi_chaninfo_struct_flaglist_set, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "flaglist", _wrap_comedi_chaninfo_struct_flaglist_get, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "rangelist=", _wrap_comedi_chaninfo_struct_rangelist_set, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "rangelist", _wrap_comedi_chaninfo_struct_rangelist_get, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "unused=", _wrap_comedi_chaninfo_struct_unused_set, -1);
    rb_define_method(cComedi_chaninfo_struct.klass, "unused", _wrap_comedi_chaninfo_struct_unused_get, -1);
    cComedi_chaninfo_struct.mark = 0;
    cComedi_chaninfo_struct.destroy = (void (*)(void *)) free_comedi_chaninfo_struct;
    
    cComedi_rangeinfo_struct.klass = rb_define_class_under(mComedi, "Comedi_rangeinfo_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_rangeinfo_struct, (void *) &cComedi_rangeinfo_struct);
    rb_define_alloc_func(cComedi_rangeinfo_struct.klass, _wrap_comedi_rangeinfo_struct_allocate);
    rb_define_method(cComedi_rangeinfo_struct.klass, "initialize", _wrap_new_comedi_rangeinfo_struct, -1);
    rb_define_method(cComedi_rangeinfo_struct.klass, "range_type=", _wrap_comedi_rangeinfo_struct_range_type_set, -1);
    rb_define_method(cComedi_rangeinfo_struct.klass, "range_type", _wrap_comedi_rangeinfo_struct_range_type_get, -1);
    rb_define_method(cComedi_rangeinfo_struct.klass, "range_ptr=", _wrap_comedi_rangeinfo_struct_range_ptr_set, -1);
    rb_define_method(cComedi_rangeinfo_struct.klass, "range_ptr", _wrap_comedi_rangeinfo_struct_range_ptr_get, -1);
    cComedi_rangeinfo_struct.mark = 0;
    cComedi_rangeinfo_struct.destroy = (void (*)(void *)) free_comedi_rangeinfo_struct;
    
    cComedi_krange_struct.klass = rb_define_class_under(mComedi, "Comedi_krange_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_krange_struct, (void *) &cComedi_krange_struct);
    rb_define_alloc_func(cComedi_krange_struct.klass, _wrap_comedi_krange_struct_allocate);
    rb_define_method(cComedi_krange_struct.klass, "initialize", _wrap_new_comedi_krange_struct, -1);
    rb_define_method(cComedi_krange_struct.klass, "min=", _wrap_comedi_krange_struct_min_set, -1);
    rb_define_method(cComedi_krange_struct.klass, "min", _wrap_comedi_krange_struct_min_get, -1);
    rb_define_method(cComedi_krange_struct.klass, "max=", _wrap_comedi_krange_struct_max_set, -1);
    rb_define_method(cComedi_krange_struct.klass, "max", _wrap_comedi_krange_struct_max_get, -1);
    rb_define_method(cComedi_krange_struct.klass, "flags=", _wrap_comedi_krange_struct_flags_set, -1);
    rb_define_method(cComedi_krange_struct.klass, "flags", _wrap_comedi_krange_struct_flags_get, -1);
    cComedi_krange_struct.mark = 0;
    cComedi_krange_struct.destroy = (void (*)(void *)) free_comedi_krange_struct;
    
    cComedi_subdinfo_struct.klass = rb_define_class_under(mComedi, "Comedi_subdinfo_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_subdinfo_struct, (void *) &cComedi_subdinfo_struct);
    rb_define_alloc_func(cComedi_subdinfo_struct.klass, _wrap_comedi_subdinfo_struct_allocate);
    rb_define_method(cComedi_subdinfo_struct.klass, "initialize", _wrap_new_comedi_subdinfo_struct, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "type=", _wrap_comedi_subdinfo_struct_type_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "type", _wrap_comedi_subdinfo_struct_type_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "n_chan=", _wrap_comedi_subdinfo_struct_n_chan_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "n_chan", _wrap_comedi_subdinfo_struct_n_chan_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "subd_flags=", _wrap_comedi_subdinfo_struct_subd_flags_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "subd_flags", _wrap_comedi_subdinfo_struct_subd_flags_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "timer_type=", _wrap_comedi_subdinfo_struct_timer_type_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "timer_type", _wrap_comedi_subdinfo_struct_timer_type_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "len_chanlist=", _wrap_comedi_subdinfo_struct_len_chanlist_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "len_chanlist", _wrap_comedi_subdinfo_struct_len_chanlist_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "maxdata=", _wrap_comedi_subdinfo_struct_maxdata_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "maxdata", _wrap_comedi_subdinfo_struct_maxdata_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "flags=", _wrap_comedi_subdinfo_struct_flags_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "flags", _wrap_comedi_subdinfo_struct_flags_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "range_type=", _wrap_comedi_subdinfo_struct_range_type_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "range_type", _wrap_comedi_subdinfo_struct_range_type_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "settling_time_0=", _wrap_comedi_subdinfo_struct_settling_time_0_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "settling_time_0", _wrap_comedi_subdinfo_struct_settling_time_0_get, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "unused=", _wrap_comedi_subdinfo_struct_unused_set, -1);
    rb_define_method(cComedi_subdinfo_struct.klass, "unused", _wrap_comedi_subdinfo_struct_unused_get, -1);
    cComedi_subdinfo_struct.mark = 0;
    cComedi_subdinfo_struct.destroy = (void (*)(void *)) free_comedi_subdinfo_struct;
    
    cComedi_devinfo_struct.klass = rb_define_class_under(mComedi, "Comedi_devinfo_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_devinfo_struct, (void *) &cComedi_devinfo_struct);
    rb_define_alloc_func(cComedi_devinfo_struct.klass, _wrap_comedi_devinfo_struct_allocate);
    rb_define_method(cComedi_devinfo_struct.klass, "initialize", _wrap_new_comedi_devinfo_struct, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "version_code=", _wrap_comedi_devinfo_struct_version_code_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "version_code", _wrap_comedi_devinfo_struct_version_code_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "n_subdevs=", _wrap_comedi_devinfo_struct_n_subdevs_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "n_subdevs", _wrap_comedi_devinfo_struct_n_subdevs_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "driver_name=", _wrap_comedi_devinfo_struct_driver_name_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "driver_name", _wrap_comedi_devinfo_struct_driver_name_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "board_name=", _wrap_comedi_devinfo_struct_board_name_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "board_name", _wrap_comedi_devinfo_struct_board_name_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "read_subdevice=", _wrap_comedi_devinfo_struct_read_subdevice_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "read_subdevice", _wrap_comedi_devinfo_struct_read_subdevice_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "write_subdevice=", _wrap_comedi_devinfo_struct_write_subdevice_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "write_subdevice", _wrap_comedi_devinfo_struct_write_subdevice_get, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "unused=", _wrap_comedi_devinfo_struct_unused_set, -1);
    rb_define_method(cComedi_devinfo_struct.klass, "unused", _wrap_comedi_devinfo_struct_unused_get, -1);
    cComedi_devinfo_struct.mark = 0;
    cComedi_devinfo_struct.destroy = (void (*)(void *)) free_comedi_devinfo_struct;
    
    cComedi_devconfig_struct.klass = rb_define_class_under(mComedi, "Comedi_devconfig_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_devconfig_struct, (void *) &cComedi_devconfig_struct);
    rb_define_alloc_func(cComedi_devconfig_struct.klass, _wrap_comedi_devconfig_struct_allocate);
    rb_define_method(cComedi_devconfig_struct.klass, "initialize", _wrap_new_comedi_devconfig_struct, -1);
    rb_define_method(cComedi_devconfig_struct.klass, "board_name=", _wrap_comedi_devconfig_struct_board_name_set, -1);
    rb_define_method(cComedi_devconfig_struct.klass, "board_name", _wrap_comedi_devconfig_struct_board_name_get, -1);
    rb_define_method(cComedi_devconfig_struct.klass, "options=", _wrap_comedi_devconfig_struct_options_set, -1);
    rb_define_method(cComedi_devconfig_struct.klass, "options", _wrap_comedi_devconfig_struct_options_get, -1);
    cComedi_devconfig_struct.mark = 0;
    cComedi_devconfig_struct.destroy = (void (*)(void *)) free_comedi_devconfig_struct;
    
    cComedi_bufconfig_struct.klass = rb_define_class_under(mComedi, "Comedi_bufconfig_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_bufconfig_struct, (void *) &cComedi_bufconfig_struct);
    rb_define_alloc_func(cComedi_bufconfig_struct.klass, _wrap_comedi_bufconfig_struct_allocate);
    rb_define_method(cComedi_bufconfig_struct.klass, "initialize", _wrap_new_comedi_bufconfig_struct, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "subdevice=", _wrap_comedi_bufconfig_struct_subdevice_set, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "subdevice", _wrap_comedi_bufconfig_struct_subdevice_get, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "flags=", _wrap_comedi_bufconfig_struct_flags_set, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "flags", _wrap_comedi_bufconfig_struct_flags_get, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "maximum_size=", _wrap_comedi_bufconfig_struct_maximum_size_set, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "maximum_size", _wrap_comedi_bufconfig_struct_maximum_size_get, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "size=", _wrap_comedi_bufconfig_struct_size_set, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "size", _wrap_comedi_bufconfig_struct_size_get, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "unused=", _wrap_comedi_bufconfig_struct_unused_set, -1);
    rb_define_method(cComedi_bufconfig_struct.klass, "unused", _wrap_comedi_bufconfig_struct_unused_get, -1);
    cComedi_bufconfig_struct.mark = 0;
    cComedi_bufconfig_struct.destroy = (void (*)(void *)) free_comedi_bufconfig_struct;
    
    cComedi_bufinfo_struct.klass = rb_define_class_under(mComedi, "Comedi_bufinfo_struct", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_bufinfo_struct, (void *) &cComedi_bufinfo_struct);
    rb_define_alloc_func(cComedi_bufinfo_struct.klass, _wrap_comedi_bufinfo_struct_allocate);
    rb_define_method(cComedi_bufinfo_struct.klass, "initialize", _wrap_new_comedi_bufinfo_struct, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "subdevice=", _wrap_comedi_bufinfo_struct_subdevice_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "subdevice", _wrap_comedi_bufinfo_struct_subdevice_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "bytes_read=", _wrap_comedi_bufinfo_struct_bytes_read_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "bytes_read", _wrap_comedi_bufinfo_struct_bytes_read_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_int_ptr=", _wrap_comedi_bufinfo_struct_buf_int_ptr_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_int_ptr", _wrap_comedi_bufinfo_struct_buf_int_ptr_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_user_ptr=", _wrap_comedi_bufinfo_struct_buf_user_ptr_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_user_ptr", _wrap_comedi_bufinfo_struct_buf_user_ptr_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_int_count=", _wrap_comedi_bufinfo_struct_buf_int_count_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_int_count", _wrap_comedi_bufinfo_struct_buf_int_count_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_user_count=", _wrap_comedi_bufinfo_struct_buf_user_count_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "buf_user_count", _wrap_comedi_bufinfo_struct_buf_user_count_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "bytes_written=", _wrap_comedi_bufinfo_struct_bytes_written_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "bytes_written", _wrap_comedi_bufinfo_struct_bytes_written_get, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "unused=", _wrap_comedi_bufinfo_struct_unused_set, -1);
    rb_define_method(cComedi_bufinfo_struct.klass, "unused", _wrap_comedi_bufinfo_struct_unused_get, -1);
    cComedi_bufinfo_struct.mark = 0;
    cComedi_bufinfo_struct.destroy = (void (*)(void *)) free_comedi_bufinfo_struct;
    rb_define_const(mComedi,"RF_EXTERNAL", INT2NUM((1<<8)));
    rb_define_const(mComedi,"UNIT_volt", INT2NUM(0));
    rb_define_const(mComedi,"UNIT_mA", INT2NUM(1));
    rb_define_const(mComedi,"UNIT_none", INT2NUM(2));
    rb_define_const(mComedi,"COMEDI_CB_EOS", INT2NUM(1));
    rb_define_const(mComedi,"COMEDI_CB_EOA", INT2NUM(2));
    rb_define_const(mComedi,"COMEDI_CB_BLOCK", INT2NUM(4));
    rb_define_const(mComedi,"COMEDI_CB_EOBUF", INT2NUM(8));
    rb_define_const(mComedi,"COMEDI_CB_ERROR", INT2NUM(16));
    rb_define_const(mComedi,"COMEDI_CB_OVERFLOW", INT2NUM(32));
    
    cComedi_range.klass = rb_define_class_under(mComedi, "Comedi_range", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_range, (void *) &cComedi_range);
    rb_define_alloc_func(cComedi_range.klass, _wrap_comedi_range_allocate);
    rb_define_method(cComedi_range.klass, "initialize", _wrap_new_comedi_range, -1);
    rb_define_method(cComedi_range.klass, "min=", _wrap_comedi_range_min_set, -1);
    rb_define_method(cComedi_range.klass, "min", _wrap_comedi_range_min_get, -1);
    rb_define_method(cComedi_range.klass, "max=", _wrap_comedi_range_max_set, -1);
    rb_define_method(cComedi_range.klass, "max", _wrap_comedi_range_max_get, -1);
    rb_define_method(cComedi_range.klass, "unit=", _wrap_comedi_range_unit_set, -1);
    rb_define_method(cComedi_range.klass, "unit", _wrap_comedi_range_unit_get, -1);
    cComedi_range.mark = 0;
    cComedi_range.destroy = (void (*)(void *)) free_comedi_range;
    
    cComedi_sv_t.klass = rb_define_class_under(mComedi, "Comedi_sv_t", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_sv_t, (void *) &cComedi_sv_t);
    rb_define_alloc_func(cComedi_sv_t.klass, _wrap_comedi_sv_t_allocate);
    rb_define_method(cComedi_sv_t.klass, "initialize", _wrap_new_comedi_sv_t, -1);
    rb_define_method(cComedi_sv_t.klass, "dev=", _wrap_comedi_sv_t_dev_set, -1);
    rb_define_method(cComedi_sv_t.klass, "dev", _wrap_comedi_sv_t_dev_get, -1);
    rb_define_method(cComedi_sv_t.klass, "subdevice=", _wrap_comedi_sv_t_subdevice_set, -1);
    rb_define_method(cComedi_sv_t.klass, "subdevice", _wrap_comedi_sv_t_subdevice_get, -1);
    rb_define_method(cComedi_sv_t.klass, "chan=", _wrap_comedi_sv_t_chan_set, -1);
    rb_define_method(cComedi_sv_t.klass, "chan", _wrap_comedi_sv_t_chan_get, -1);
    rb_define_method(cComedi_sv_t.klass, "range=", _wrap_comedi_sv_t_range_set, -1);
    rb_define_method(cComedi_sv_t.klass, "range", _wrap_comedi_sv_t_range_get, -1);
    rb_define_method(cComedi_sv_t.klass, "aref=", _wrap_comedi_sv_t_aref_set, -1);
    rb_define_method(cComedi_sv_t.klass, "aref", _wrap_comedi_sv_t_aref_get, -1);
    rb_define_method(cComedi_sv_t.klass, "n=", _wrap_comedi_sv_t_n_set, -1);
    rb_define_method(cComedi_sv_t.klass, "n", _wrap_comedi_sv_t_n_get, -1);
    rb_define_method(cComedi_sv_t.klass, "maxdata=", _wrap_comedi_sv_t_maxdata_set, -1);
    rb_define_method(cComedi_sv_t.klass, "maxdata", _wrap_comedi_sv_t_maxdata_get, -1);
    cComedi_sv_t.mark = 0;
    cComedi_sv_t.destroy = (void (*)(void *)) free_comedi_sv_t;
    rb_define_const(mComedi,"COMEDI_OOR_NUMBER", INT2NUM(COMEDI_OOR_NUMBER));
    rb_define_const(mComedi,"COMEDI_OOR_NAN", INT2NUM(COMEDI_OOR_NAN));
    rb_define_module_function(mComedi, "comedi_open", _wrap_comedi_open, -1);
    rb_define_module_function(mComedi, "comedi_close", _wrap_comedi_close, -1);
    rb_define_module_function(mComedi, "comedi_loglevel", _wrap_comedi_loglevel, -1);
    rb_define_module_function(mComedi, "comedi_perror", _wrap_comedi_perror, -1);
    rb_define_module_function(mComedi, "comedi_strerror", _wrap_comedi_strerror, -1);
    rb_define_module_function(mComedi, "comedi_errno", _wrap_comedi_errno, -1);
    rb_define_module_function(mComedi, "comedi_fileno", _wrap_comedi_fileno, -1);
    rb_define_module_function(mComedi, "comedi_set_global_oor_behavior", _wrap_comedi_set_global_oor_behavior, -1);
    rb_define_module_function(mComedi, "comedi_get_n_subdevices", _wrap_comedi_get_n_subdevices, -1);
    rb_define_module_function(mComedi, "comedi_get_version_code", _wrap_comedi_get_version_code, -1);
    rb_define_module_function(mComedi, "comedi_get_driver_name", _wrap_comedi_get_driver_name, -1);
    rb_define_module_function(mComedi, "comedi_get_board_name", _wrap_comedi_get_board_name, -1);
    rb_define_module_function(mComedi, "comedi_get_read_subdevice", _wrap_comedi_get_read_subdevice, -1);
    rb_define_module_function(mComedi, "comedi_get_write_subdevice", _wrap_comedi_get_write_subdevice, -1);
    rb_define_module_function(mComedi, "comedi_get_subdevice_type", _wrap_comedi_get_subdevice_type, -1);
    rb_define_module_function(mComedi, "comedi_find_subdevice_by_type", _wrap_comedi_find_subdevice_by_type, -1);
    rb_define_module_function(mComedi, "comedi_get_subdevice_flags", _wrap_comedi_get_subdevice_flags, -1);
    rb_define_module_function(mComedi, "comedi_get_n_channels", _wrap_comedi_get_n_channels, -1);
    rb_define_module_function(mComedi, "comedi_range_is_chan_specific", _wrap_comedi_range_is_chan_specific, -1);
    rb_define_module_function(mComedi, "comedi_maxdata_is_chan_specific", _wrap_comedi_maxdata_is_chan_specific, -1);
    rb_define_module_function(mComedi, "comedi_get_maxdata", _wrap_comedi_get_maxdata, -1);
    rb_define_module_function(mComedi, "comedi_get_n_ranges", _wrap_comedi_get_n_ranges, -1);
    rb_define_module_function(mComedi, "comedi_get_range", _wrap_comedi_get_range, -1);
    rb_define_module_function(mComedi, "comedi_find_range", _wrap_comedi_find_range, -1);
    rb_define_module_function(mComedi, "comedi_get_buffer_size", _wrap_comedi_get_buffer_size, -1);
    rb_define_module_function(mComedi, "comedi_get_max_buffer_size", _wrap_comedi_get_max_buffer_size, -1);
    rb_define_module_function(mComedi, "comedi_set_buffer_size", _wrap_comedi_set_buffer_size, -1);
    rb_define_module_function(mComedi, "comedi_do_insnlist", _wrap_comedi_do_insnlist, -1);
    rb_define_module_function(mComedi, "comedi_do_insn", _wrap_comedi_do_insn, -1);
    rb_define_module_function(mComedi, "comedi_lock", _wrap_comedi_lock, -1);
    rb_define_module_function(mComedi, "comedi_unlock", _wrap_comedi_unlock, -1);
    rb_define_module_function(mComedi, "comedi_to_phys", _wrap_comedi_to_phys, -1);
    rb_define_module_function(mComedi, "comedi_from_phys", _wrap_comedi_from_phys, -1);
    rb_define_module_function(mComedi, "comedi_sampl_to_phys", _wrap_comedi_sampl_to_phys, -1);
    rb_define_module_function(mComedi, "comedi_sampl_from_phys", _wrap_comedi_sampl_from_phys, -1);
    rb_define_module_function(mComedi, "comedi_data_read", _wrap_comedi_data_read, -1);
    rb_define_module_function(mComedi, "comedi_data_read_n", _wrap_comedi_data_read_n, -1);
    rb_define_module_function(mComedi, "comedi_data_read_hint", _wrap_comedi_data_read_hint, -1);
    rb_define_module_function(mComedi, "comedi_data_read_delayed", _wrap_comedi_data_read_delayed, -1);
    rb_define_module_function(mComedi, "comedi_data_write", _wrap_comedi_data_write, -1);
    rb_define_module_function(mComedi, "comedi_dio_config", _wrap_comedi_dio_config, -1);
    rb_define_module_function(mComedi, "comedi_dio_read", _wrap_comedi_dio_read, -1);
    rb_define_module_function(mComedi, "comedi_dio_write", _wrap_comedi_dio_write, -1);
    rb_define_module_function(mComedi, "comedi_dio_bitfield", _wrap_comedi_dio_bitfield, -1);
    rb_define_module_function(mComedi, "comedi_sv_init", _wrap_comedi_sv_init, -1);
    rb_define_module_function(mComedi, "comedi_sv_update", _wrap_comedi_sv_update, -1);
    rb_define_module_function(mComedi, "comedi_sv_measure", _wrap_comedi_sv_measure, -1);
    rb_define_module_function(mComedi, "comedi_get_cmd_src_mask", _wrap_comedi_get_cmd_src_mask, -1);
    rb_define_module_function(mComedi, "comedi_get_cmd_generic_timed", _wrap_comedi_get_cmd_generic_timed, -1);
    rb_define_module_function(mComedi, "comedi_cancel", _wrap_comedi_cancel, -1);
    rb_define_module_function(mComedi, "comedi_command", _wrap_comedi_command, -1);
    rb_define_module_function(mComedi, "comedi_command_test", _wrap_comedi_command_test, -1);
    rb_define_module_function(mComedi, "comedi_poll", _wrap_comedi_poll, -1);
    rb_define_module_function(mComedi, "comedi_set_max_buffer_size", _wrap_comedi_set_max_buffer_size, -1);
    rb_define_module_function(mComedi, "comedi_get_buffer_contents", _wrap_comedi_get_buffer_contents, -1);
    rb_define_module_function(mComedi, "comedi_mark_buffer_read", _wrap_comedi_mark_buffer_read, -1);
    rb_define_module_function(mComedi, "comedi_get_buffer_offset", _wrap_comedi_get_buffer_offset, -1);
    
    cComedi_caldac_t.klass = rb_define_class_under(mComedi, "Comedi_caldac_t", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_caldac_t, (void *) &cComedi_caldac_t);
    rb_define_alloc_func(cComedi_caldac_t.klass, _wrap_comedi_caldac_t_allocate);
    rb_define_method(cComedi_caldac_t.klass, "initialize", _wrap_new_comedi_caldac_t, -1);
    rb_define_method(cComedi_caldac_t.klass, "subdevice=", _wrap_comedi_caldac_t_subdevice_set, -1);
    rb_define_method(cComedi_caldac_t.klass, "subdevice", _wrap_comedi_caldac_t_subdevice_get, -1);
    rb_define_method(cComedi_caldac_t.klass, "channel=", _wrap_comedi_caldac_t_channel_set, -1);
    rb_define_method(cComedi_caldac_t.klass, "channel", _wrap_comedi_caldac_t_channel_get, -1);
    rb_define_method(cComedi_caldac_t.klass, "value=", _wrap_comedi_caldac_t_value_set, -1);
    rb_define_method(cComedi_caldac_t.klass, "value", _wrap_comedi_caldac_t_value_get, -1);
    cComedi_caldac_t.mark = 0;
    cComedi_caldac_t.destroy = (void (*)(void *)) free_comedi_caldac_t;
    rb_define_const(mComedi,"CS_MAX_AREFS_LENGTH", INT2NUM(4));
    
    cComedi_calibration_setting_t.klass = rb_define_class_under(mComedi, "Comedi_calibration_setting_t", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_calibration_setting_t, (void *) &cComedi_calibration_setting_t);
    rb_define_alloc_func(cComedi_calibration_setting_t.klass, _wrap_comedi_calibration_setting_t_allocate);
    rb_define_method(cComedi_calibration_setting_t.klass, "initialize", _wrap_new_comedi_calibration_setting_t, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "subdevice=", _wrap_comedi_calibration_setting_t_subdevice_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "subdevice", _wrap_comedi_calibration_setting_t_subdevice_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "channels=", _wrap_comedi_calibration_setting_t_channels_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "channels", _wrap_comedi_calibration_setting_t_channels_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_channels=", _wrap_comedi_calibration_setting_t_num_channels_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_channels", _wrap_comedi_calibration_setting_t_num_channels_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "ranges=", _wrap_comedi_calibration_setting_t_ranges_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "ranges", _wrap_comedi_calibration_setting_t_ranges_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_ranges=", _wrap_comedi_calibration_setting_t_num_ranges_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_ranges", _wrap_comedi_calibration_setting_t_num_ranges_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "arefs=", _wrap_comedi_calibration_setting_t_arefs_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "arefs", _wrap_comedi_calibration_setting_t_arefs_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_arefs=", _wrap_comedi_calibration_setting_t_num_arefs_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_arefs", _wrap_comedi_calibration_setting_t_num_arefs_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "caldacs=", _wrap_comedi_calibration_setting_t_caldacs_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "caldacs", _wrap_comedi_calibration_setting_t_caldacs_get, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_caldacs=", _wrap_comedi_calibration_setting_t_num_caldacs_set, -1);
    rb_define_method(cComedi_calibration_setting_t.klass, "num_caldacs", _wrap_comedi_calibration_setting_t_num_caldacs_get, -1);
    cComedi_calibration_setting_t.mark = 0;
    cComedi_calibration_setting_t.destroy = (void (*)(void *)) free_comedi_calibration_setting_t;
    
    cComedi_calibration_t.klass = rb_define_class_under(mComedi, "Comedi_calibration_t", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_comedi_calibration_t, (void *) &cComedi_calibration_t);
    rb_define_alloc_func(cComedi_calibration_t.klass, _wrap_comedi_calibration_t_allocate);
    rb_define_method(cComedi_calibration_t.klass, "initialize", _wrap_new_comedi_calibration_t, -1);
    rb_define_method(cComedi_calibration_t.klass, "driver_name=", _wrap_comedi_calibration_t_driver_name_set, -1);
    rb_define_method(cComedi_calibration_t.klass, "driver_name", _wrap_comedi_calibration_t_driver_name_get, -1);
    rb_define_method(cComedi_calibration_t.klass, "board_name=", _wrap_comedi_calibration_t_board_name_set, -1);
    rb_define_method(cComedi_calibration_t.klass, "board_name", _wrap_comedi_calibration_t_board_name_get, -1);
    rb_define_method(cComedi_calibration_t.klass, "settings=", _wrap_comedi_calibration_t_settings_set, -1);
    rb_define_method(cComedi_calibration_t.klass, "settings", _wrap_comedi_calibration_t_settings_get, -1);
    rb_define_method(cComedi_calibration_t.klass, "num=tings=", _wrap_comedi_calibration_t_num_settings_set, -1);
    rb_define_method(cComedi_calibration_t.klass, "num=tings", _wrap_comedi_calibration_t_num_settings_get, -1);
    cComedi_calibration_t.mark = 0;
    cComedi_calibration_t.destroy = (void (*)(void *)) free_comedi_calibration_t;
    rb_define_module_function(mComedi, "comedi_parse_calibration_file", _wrap_comedi_parse_calibration_file, -1);
    rb_define_module_function(mComedi, "comedi_apply_parsed_calibration", _wrap_comedi_apply_parsed_calibration, -1);
    rb_define_module_function(mComedi, "comedi_get_default_calibration_path", _wrap_comedi_get_default_calibration_path, -1);
    rb_define_module_function(mComedi, "comedi_cleanup_calibration", _wrap_comedi_cleanup_calibration, -1);
    rb_define_module_function(mComedi, "comedi_apply_calibration", _wrap_comedi_apply_calibration, -1);
}

