#!/usr/bin/python
# -*- coding: utf-8 -*-
"""# -*- coding: latin-1 -*-"""

def revision():
    return '$Revision: 7.19 $'.split()[1]

entete = """
###############################################################################
#
#    This file is part of COLLATINVS.
#
#    COLLATINVS is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    COLLATINVS is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with COLLATINVS; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###############################################################################
"""
#BOGUES
#  - Le dialogue d'ajout/modification n'est pas dtruit dans certains cas,
#     seulement cach.
#  - l'indicateur de modification reste positif aprs chargement d'un nouveau texte
#  - duobus est bien analys, mais n'apparat pas sous la souris.
#
#    ( corriger lorsque le dialogue de prcaution sera implment)
#  - Le systme de renvoi "cf. " donne le lemme double, Ce qui se justifie pour des
#    lemmes existants, comme inpono vs impono. Or cette forme double, souvent,
#    est postiche. Elle sert, par exemple,  renvoyer  une entre sans singulier.
#    kalenda, modle uita, n'existe pas, mais sa prsence dans le lexique permet de 
#    lemmatiser les formes au pluriel de kalendae, arum. Dans ce cas, la lemmatisation
#    devrait donner non pas le lemme double, mais la forme sur laquelle pointe le renvoi.
#    il faut donc imaginer une syntaxe de renvoi qui respecte cette diffrence.
#
# A FAIRE :
#     Gnration d'une page html avec le texte latin et des balises title sur chaque mot.
#     Dialogue de prcaution avant Quitter, Nouveau et Ouvrir
#     Dialogue de recherche 
#     Internationalisation : 
#         menu de choix de la langue-cible
#         rsolution du problme lemmata : lemmata-fr, lemmata-de, etc.
#

# collatinus.py $Revision: 7.19 $
# dernire mise  jour : $Date: 2006/02/22 16:57:40 $
# par $Author: collatinus $

# generated by wxGlade 0.3.1 on Thu Apr 29 11:38:42 2004
from wxPython.wx import *
import version, latinus
from latinus import viaD, viaL, lexicumP, Linux, chaineAnalyse, lemmatise, \
     string, lemmatisem, lexique, ijuv, peupleRadicaux, Lmodeles, \
     ecrisP, tentreeP 

import os, sys
from wxPython.stc import * # qui fournit wxStyledTextCtrl
import re
import flexfr
from flexfr import conjugue, Pluriel, Accorde
import array
# modif du chemin d'importation :
import sys
sys.path.append(viaD)
# crer un fichier de conf s'il n'existe pas
if not os.path.exists(viaD + 'conf.py'):
    f = open(viaD + 'conf.py', 'w')
    f.write('TriLemm = 1\n')
    f.write('Communiquer = 0\n')
    f.write("depot = 'http://www.collatinus.org/collatinus/lemmata'\n")
    f.write('inscriptio = "utor@utor.org"\n')
    f.write('diesLemmata = "Sat, 19 Jun 2004 05:06:27 GMT"')
    f.close()
    print "configuratio acta"
# et l'importer
import conf

# La version de wxPython doit tre connue
# pour afficher en ascii ou unicode
from wxPython import __version__
wx6 = __version__[2] == '6' 

path_images ="/usr/share/collatinus/images/"

# en-ttes et pieds des sorties
# 1. LaTeX
en_tete_LaTeX = """
\documentclass[12pt]{article}
\usepackage[T1]{fontenc}
\usepackage[latin1]{inputenc}
\usepackage{geometry}
\usepackage[frenchb]{babel}
\geometry{a4paper, left=1in, right=1in, top=1in, bottom=1in}
\\begin{document}
"""

debut_lemm_LaTeX = """
\\begin{itemize}\n
"""

pied_LaTeX = """
\\end{itemize}
\\end{document}
"""

# 2. Html
en_tete_html = """
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
  <title>Collatinus - Sine nomine</title>
</head>
<body>
"""

# filtre qui permet d'extraire le premier mot d'une ligne
filtre = re.compile("^\w+")
# filtre qui permet d'extraire du champ *tentree.texte* 
# le mot qui servira pour la traduction
filtreFr = re.compile("^[\w+,\.\s]*\:[1-9\s\-]*(se\s|le\s|la\s|l'|s')?([\-\w]+)")

# indicateur de modification

class MyFrame(wxFrame):
    def __init__(self, *args, **kwds):
        #Constantes de menu
        idNouveau = wxNewId()
        idOuvrir = wxNewId()
        idSauver  = wxNewId()
        idSauverSous = wxNewId()
        idExit = wxNewId()
        idCollerDansLatin = wxNewId()
        idCopierLemm = wxNewId()
        idRetourLigne = wxNewId()
        idEffLigne = wxNewId()
        idToutCopier = wxNewId()
        idEffLemm = wxNewId()
        idPlus = wxNewId()
        idMinus = wxNewId()
        idAequus = wxNewId()
        idLemmLigne = wxNewId()
        idLemmMot = wxNewId()
        idToutLemmatiser = wxNewId()
        self.idLemmTriee = wxNewId()
        idLexicum = wxNewId()
        self.idCommuniquer = wxNewId()
        idTextCtrl1 = wxNewId()
        idAuxilium = wxNewId()
        idAPropos = wxNewId()
        idModif = wxNewId()
        # frquences
        idFreq = wxNewId()

        # begin wxGlade: MyFrame.__init__
        kwds["style"] = wxDEFAULT_FRAME_STYLE
        wxFrame.__init__(self, *args, **kwds)
        self.window_1 = wxSplitterWindow(self, -1)
        self.notebook_1 = wxNotebook(self.window_1, -1, style=wxNB_BOTTOM)
        
        # Menu Bar
        self.frame_1_menubar = wxMenuBar()
        self.SetMenuBar(self.frame_1_menubar)
        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(idNouveau, "&Noua\tCtrl+N", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idOuvrir, "&Legere\tCtrl+O", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idSauver, "&Scribere\tCtrl+S", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idSauverSous, "S&cribere sub", "", wxITEM_NORMAL)
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(idExit, "E&xit\tCtrl+Q", "", wxITEM_NORMAL)
        self.frame_1_menubar.Append(wxglade_tmp_menu, "&Capsa")
        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(idCollerDansLatin, "in latinum deponere", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idCopierLemm, "Lemmatizationem copiare", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idToutCopier, "Omnia copiare\tCtrl+B", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idEffLemm, "Lemmatizationem rad&ere\tCtrl+E", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idNouveau, "Om&nia radere\tCtrl+N", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idEffLigne, "lineam tollere\tCtrl+L", "", wxITEM_NORMAL)
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(idRetourLigne, "A linea auto", "", wxITEM_CHECK)
        self.frame_1_menubar.Append(wxglade_tmp_menu, "Editio")
        wxglade_tmp_menu = wxMenu()
        self.frame_1_menubar.Append(wxglade_tmp_menu, "Visio")
        wxglade_tmp_menu.Append(idPlus, "Maiorem\tCtrl+M", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idMinus, "Minorem\tCtrl+P", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idAequus, "Sicut est\tCtrl+=", "", wxITEM_NORMAL)

        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(idToutLemmatiser, "&Omnia lemmatizare\tF9", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idLemmLigne, "&Lineam\tF10", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idLemmMot, "&Vocem\tF8", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(self.idLemmTriee, "Alphabetice", "", wxITEM_CHECK)
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(idLexicum, "Lexicum", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(self.idCommuniquer, "Per Telam lexicum committere", "", wxITEM_CHECK)
        self.frame_1_menubar.Append(wxglade_tmp_menu, "Lemmatizare")
        wxglade_tmp_menu = wxMenu()
        wxglade_tmp_menu.Append(idAuxilium, "&Auxilium\tF1", "", wxITEM_NORMAL)
        wxglade_tmp_menu.Append(idAPropos, "De Collatino", "", wxITEM_NORMAL)
        self.frame_1_menubar.Append(wxglade_tmp_menu, "Auxilium")
        # Menu Bar end

        # Tool Bar
        # aide.png      ciseaux.png  copier.png  lemmatiser.png  ouvrir.png
        # chercher.png  coller.png   gomme.png   nouveau.png     sauver.png
        self.frame_1_toolbar = wxToolBar(self, -1, style=wxTB_HORIZONTAL|wxTB_FLAT)
        self.SetToolBar(self.frame_1_toolbar)
        self.frame_1_toolbar.AddLabelTool(idNouveau, "Nouveau", 
           wxBitmap(path_images+"nouveau.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "Omnia delere", "")
        self.frame_1_toolbar.AddLabelTool(idOuvrir, "Ouvrir", 
           wxBitmap(path_images+"ouvrir.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "latinum capsam legere", "")
        self.frame_1_toolbar.AddLabelTool(idSauver, "Sauver", 
           wxBitmap(path_images+"sauver.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "Omnia in discum scribere", "")
        self.frame_1_toolbar.AddLabelTool(idCollerDansLatin, "Coller", 
           wxBitmap(path_images+"coller.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "glutinare in latinum aeditorem", "")
        self.frame_1_toolbar.AddLabelTool(idToutCopier, "omnia exscribere", 
           wxBitmap(path_images+"copier.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "lemmatizationem exscribere", "")
        self.frame_1_toolbar.AddLabelTool(idEffLemm, "radere", 
           wxBitmap(path_images+"gomme.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "lemmatizationem radere", "")
        self.frame_1_toolbar.AddLabelTool(idToutLemmatiser, "Tout lemm.", 
           wxBitmap(path_images+"lemmatiser.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "Omnia lemmatizare", "")
        self.frame_1_toolbar.AddLabelTool(idAuxilium, "Aide", 
           wxBitmap(path_images+"aide.png", 
           wxBITMAP_TYPE_ANY), wxNullBitmap, wxITEM_NORMAL, 
           "Auxilium", "")
        # Tool Bar end
        
        # Ajout d'une combo pour slectionner la difficult lexicale
        liste_freq = ["uerba omnia","rariora (1)","rariora (2)",
                      "rariora (3)","rariora (4)","rarissima"]
        self.combo_1 = wxComboBox(self.frame_1_toolbar, idFreq, 
           "uerba omnia", choices=liste_freq, style=wxCB_READONLY, size = (200, -1)) 
        self.frame_1_toolbar.AddControl(self.combo_1)
        # ncessaire pour Fentres :
        self.frame_1_toolbar.Realize()

       
        # Barre d'tat
        self.statusbar = self.CreateStatusBar(3)

        self.text_ctrl_1 = wxStyledTextCtrl(self.window_1,idTextCtrl1)
        self.text_ctrl_2 = wxStyledTextCtrl(self.notebook_1, -1) 
        self.text_ctrl_3 = wxStyledTextCtrl(self.notebook_1, -1) 
        self.text_ctrl_4 = wxStyledTextCtrl(self.notebook_1, -1) 
        self.text_ctrl_5 = wxStyledTextCtrl(self.notebook_1, -1)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade

        # mot survol
        self.ancien_mot = ""
        # indicateur d'affichage de la bulle
        self.AffBulle = 0 
        self.NomFichier = ''

        # gestionnaires d'vnements
        EVT_MENU(self, idNouveau, self.OnNouveau)
        EVT_MENU(self, idOuvrir, self.OnOuvrir)
        EVT_MENU(self, idSauver, self.OnSauver)
        EVT_MENU(self, idSauverSous, self.OnSauverSous)
        EVT_MENU(self, idExit, self.OnExit)
        EVT_MENU(self, idCollerDansLatin, self.OnCollerDansLatin)
        EVT_MENU(self, idCopierLemm, self.OnCopierLemm)
        EVT_MENU(self, idToutCopier, self.OnToutCopier)
        EVT_MENU(self, idEffLemm, self.OnEffLemm)
        EVT_MENU(self, idPlus, self.OnPlus)
        EVT_MENU(self, idMinus, self.OnMinus)
        EVT_MENU(self, idAequus, self.OnAequus)
        EVT_MENU(self, idToutLemmatiser, self.OnToutLemmatiser)
        EVT_MENU(self, idLemmLigne, self.OnLemmLigne)
        EVT_MENU(self, idLemmMot, self.OnLemmMot)
        EVT_MENU(self, idLexicum, self.OnLexicum)
        EVT_MENU(self, self.idCommuniquer, self.OnCommuniquer)
        EVT_MENU(self, idRetourLigne, self.OnRetourLigne)
        EVT_MENU(self, idEffLigne, self.OnEffLigne)
        EVT_MENU(self, idAuxilium, self.OnAuxilium)
        EVT_MENU(self, idAPropos, self.OnAPropos)
        EVT_MOTION(self.text_ctrl_1, self.OnMotionL)
        EVT_MOTION(self.text_ctrl_2, self.OnMotion)
        EVT_MOTION(self.text_ctrl_3, self.OnMotion)
        EVT_MOTION(self.text_ctrl_4, self.OnMotion)
        EVT_LEFT_UP(self.text_ctrl_1, self.OnLemmatiseMot)
        EVT_STC_MODIFIED(self.text_ctrl_1,self.text_ctrl_1.GetId() , self.OnModif)
        EVT_STC_MODIFIED(self.text_ctrl_2,self.text_ctrl_2.GetId() , self.OnModif)
        EVT_STC_MODIFIED(self.text_ctrl_3,self.text_ctrl_3.GetId() , self.OnModif)
        EVT_STC_MODIFIED(self.text_ctrl_4,self.text_ctrl_4.GetId() , self.OnModif)
        EVT_CLOSE(self, self.OnClose)

    def __set_properties(self):
        # begin wxGlade: MyFrame.__set_properties
        self.SetTitle("Collatinus "+version.number)
        _icon = wxEmptyIcon()
        _icon.CopyFromBitmap(wxBitmap(path_images+"icon.xpm", wxBITMAP_TYPE_ANY))
        self.SetIcon(_icon)
        self.SetSize((562, 429))
        self.text_ctrl_1.SetSize((558, 166))
        self.text_ctrl_1.SetFocus()
        self.window_1.SplitHorizontally(self.text_ctrl_1, self.notebook_1, 168)
        # end wxGlade
        self.statusbar.SetStatusWidths([-1, -1, -1])
        # menu
        self.frame_1_menubar.GetMenu(3).Check(self.idLemmTriee, conf.TriLemm)
        self.frame_1_menubar.GetMenu(3).Check(self.idCommuniquer, conf.Communiquer)
        
        # statusbar fields
        self.status_textes = ['','','aucune lemmatisation']
        # retour  la ligne auto dans l'diteur latin
        self.text_ctrl_1.SetWrapMode(wxSTC_WRAP_WORD)
        self.signum_M = 0

    def __do_layout(self):
        # begin wxGlade: MyFrame.__do_layout
        sizer_1 = wxBoxSizer(wxVERTICAL)
        self.notebook_1.AddPage(self.text_ctrl_2, "texte")
        self.notebook_1.AddPage(self.text_ctrl_3, "LaTeX")
        self.notebook_1.AddPage(self.text_ctrl_4, "html")
        self.notebook_1.AddPage(self.text_ctrl_5, "Flexio")
        sizer_1.Add(self.window_1, 1, wxEXPAND, 0)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_1)
        self.Layout()
        self.Centre()
        # end wxGlade

    # traitements
    def OnModif(self, event):
        self.status_textes[1] = 'mutatus'
        self.maj_status()
        self.signum_M = 1
    
    def precaution(self, event): 
        dlg = wxMessageDialog(self, 
            message = "Opus tuum scriptum non est : id facere uis nunc ?", 
            caption = "Vide quod facturus sis !", 
            style=wxYES_NO + wxCANCEL)
        resp = dlg.ShowModal()
        if resp == wxID_YES:
		    return 'scribo'
        if resp == wxID_NO:
            return 'nonscribo'
        return 'redeo'

    def maj_status(self):
        for i in range(len(self.status_textes)):
            self.statusbar.SetStatusText(self.status_textes[i], i)

    def SubMure(self, s_pos):
        """ renvoie le mot sous le curseur de la souris dans le contrle latin"""
        """ sub mure uocem in latino textu reddit"""
        t_pos = self.text_ctrl_1.PositionFromPoint(s_pos)
        ab = self.text_ctrl_1.WordStartPosition(t_pos, 1)
        ad = self.text_ctrl_1.WordEndPosition(t_pos, 1)
        reditus = self.text_ctrl_1.GetTextRange(ab, ad)
        return reditus.encode('latin-1','replace')

    def Traduc(self, m):
        """ traduit la forme latine flchie en la forme franaise correspondante.
            m est une instance de latinus.morpho.
        """
        tr = ''
        cl = m.lemme.classe_gr()
        o = filtreFr.search(m.lemme.texte)
        if o:
           tr = o.group(2)
        else: return "legere non potui."

        if cl == "nom":
            if m.des.nombre == 2:
                return Pluriel(tr)
            return tr
        if cl == "verbe":
            d = m.des
            modfr = d.mode
            # rectifier l'absence de conditionnel en latin
            if modfr >= 3 : modfr += 1
            # ... et l'absence de pass compos
            tempsfr = d.temps
            if d.voix == 2 and tempsfr >= 4: tempsfr += 1
            # def conjugue(inf, P, T, M, V, Pr):
            pers = d.personne
            # je, tu, nous, vous : ajouter le pronom
            pron = pers < 3 
            # correction du systme 3 vs 6 personnes
            if d.nombre > 1: pers += 3
            return conjugue(tr, pers, tempsfr, modfr, d.voix, pron) 
        if cl == "adj":
            return Accorde(tr, m.des.genre, m.des.nombre)
        if cl == "pron":
            return tr 
        return tr
        #return m.lemme.texte
        

    
    def OnMotionL(self, event):
        """ Affichage de l'analyse morpho dans une bulle d'aide.
            Il faut sortir de la fonction si le mot est rest le mme. 
            Si une bulle existait, il faut la supprimer avant d'en crer une autre.
            N'ayant rien trouv dans l'API, j'ai adopt la solution de garder  jour 
            un indicateur d'affichage de cette bulle.
        """
        s_pos = event.GetPosition()
        mot = self.SubMure(s_pos)
        if mot == self.ancien_mot: return
        mot = mot.encode('latin-1','replace')
        self.ancien_mot = mot
        # placer la bulle sous la souris
        if self.AffBulle:
           self.win.Destroy()
        self.win = Bulle(self, -1)
        s_pos = (s_pos[0], s_pos[1] + 20)
        if event.m_controlDown:
           analysesB = latinus.lemmatiseMBrut(mot)
           liste = []
           for a in analysesB.items.keys():
               # verbe, nom, ou ni l'un ni l'autre ?
               for b in analysesB.items[a]:
                   ntr = self.Traduc(b)
                   if not ntr in liste: 
                      liste.append(ntr)
               self.win.Affiche(string.join(liste, "\n"), s_pos)
           #self.win.Affiche(mots, s_pos)
        else: 
           analyses = chaineAnalyse(mot)
           self.win.Affiche(analyses, s_pos)
        self.AffBulle = 1

    def OnMotion(self, event):
        """ Rponse globale  un dplacement de souris : la bulle est ferme
           si elle tait ouverte, et l'indicateur mis  jour. Appele par tous
           les diteurs qui reoivent la lemmatisation.
        """
        if self.AffBulle:
             self.win.Destroy()
             self.AffBulle = 0

    def OnLemmatiseMot(self, event):
        """ Appele par un clic gauche dans l'diteur latin. 
            -- Si Ctrl n'est pas enfonce, ajoute la lemmatisation 
               dans l'diteur actif du notebook. 
            -- Si Ctrl est enfonce, propose plusieurs fonctionnalits, dont
               * traduction flchie dans la langue cible
               * tableau de flexion du mot
        """
        s_pos = event.GetPosition()
        mot = self.SubMure(s_pos)
        if event.m_controlDown or self.notebook_1.GetSelection() == 3:
            m = latinus.morphos(mot)
            t = ""
            for e in m.items.keys():
                t = "%s %s\n%s %s%s\n" % ("*"*20, 
                    t, e.upper(),m.items[e][0].lemme.texte, "*"*20)
                t += m.items[e][0].lemme.flechis()
            # slectionner l'onglet Flexio
            self.notebook_1.SetSelection(3)
            if wx6:
                t = unicode (t, 'cp1252')
            self.text_ctrl_5.SetText(t)
        else :
            analyses = lemmatisem(mot, self.format_lemmes())
            if wx6:
                analyses = unicode (analyses, 'cp1252')
            self.page().AddText(analyses)
            self.signum_M = 1
        event.Skip()

    def OnNouveau(self, event):
        # prcaution
        if self.signum_M > 0:
            resp = self.precaution(event)
            if resp == 'scribo': 
                self.OnSauver(event)
            if resp == 'redeo': return

        self.text_ctrl_1.ClearAll()
        self.text_ctrl_2.ClearAll()
        self.text_ctrl_3.ClearAll()
        self.text_ctrl_4.ClearAll()
        # titre
        self.SetTitle("Collatinus "+version.number)

    def OnOuvrir(self, event):
        # prcaution
        if self.signum_M > 0:
            resp = self.precaution(event)
            if resp == 'scribo':
                self.OnSauver(event)
            if resp == 'redeo': return
        dlg = wxFileDialog(self, defaultDir = os.getcwd(),
                  wildcard = "Tout fichier|*",
                  style = wxOPEN | wxCHANGE_DIR)
        if dlg.ShowModal() == wxID_OK:
           nom_f = dlg.GetFilename() 
           self.text_ctrl_1.LoadFile(nom_f) 
           self.status_textes[1] = 'integer'
           self.status_textes[0] = nom_f
           self.maj_status()
        dlg.Destroy()
        self.NomFichier = '' 

    def OnSauver(self, event):
        if self.NomFichier:
            f = open(self.NomFichier, 'w') 
            f.write(self.Sortie())
            f.close()
            self.signum_M = 0
        else: self.OnSauverSous(event)

    def OnSauverSous(self, event):
        format = self.format_lemmes() 
        if format == 'texte':
           wild = 'Tout fichier|*'
        elif format == 'LaTeX':
           wild = 'LaTeX|*.tex'
        else : format = 'fichier html|*.html'
        dlg = wxFileDialog(self, defaultDir = os.getcwd(),
                  wildcard = "*", 
                  style = wxSAVE | wxCHANGE_DIR)
        if dlg.ShowModal() == wxID_OK:
            self.NomFichier = dlg.GetFilename()
            f = open(self.NomFichier, 'w') 
            s = self.Sortie().encode('latin1', 'replace')
            f.write (s)
            f.close()
            # titre
            self.SetTitle("Collatinus "+version.number+' - '+self.NomFichier)
        dlg.Destroy()
        self.signum_M = 0

    def OnClose(self, event):
        # prcaution
        if self.signum_M > 0:
            resp = self.precaution(event)
            if resp == 'scribo': 
                self.OnSauver(event)
                return
            if resp == 'redeo': return

        self.SauveConfig()
        print "VALE"
        self.Destroy()

    def OnExit(self, event):
        self.OnClose(event)

    def OnCollerDansLatin(self, event):
        self.text_ctrl_1.Paste() 
        self.signum_M = 1
    
    def OnCopierLemm(self, event):
        p = self.page() 
        p.HideSelection(0)
        p.SelectAll()
        p.HideSelection(1)
        p.Copy()

    def Sortie(self):
        """ renvoie le contenu des deux diteurs en respectant le format de chacun"""
        format = self.format_lemmes() 
        lat = self.text_ctrl_1.GetText()
        lem = self.page().GetText()
        if format == "texte":
           return "%s \n %s" % (lat, lem)
        if format == "LaTeX":
           return "%s %s %s %s %s" % (en_tete_LaTeX, lat, 
              debut_lemm_LaTeX, lem, pied_LaTeX)
        return "%s %s %s %s %s" % (en_tete_html, lat, "<ul>", lem, 
              "</ul>\n</body>\n</html>" )
       

    def OnToutCopier(self, event):
        """ copie dans le presse-papier le contenu des deux diteurs en 
            respectant le format de chacun"""
        wxTheClipboard.Open()
        wxTheClipboard.SetData(wxTextDataObject(self.Sortie()))
        wxTheClipboard.Close()

    def OnEffLemm(self, event):
        self.page().ClearAll() 
        self.signum_M = 1

    def OnPlus(self, event):
        eds = [self.text_ctrl_1,self.text_ctrl_2,self.text_ctrl_3,self.text_ctrl_4]
        for ed in eds:
           ed.SetZoom(ed.GetZoom() + 1)

    def OnMinus(self, event):
        eds = [self.text_ctrl_1,self.text_ctrl_2,self.text_ctrl_3,self.text_ctrl_4]
        for ed in eds:
           ed.SetZoom(ed.GetZoom() - 1)

    def OnAequus(self, event):
        eds = [self.text_ctrl_1,self.text_ctrl_2,self.text_ctrl_3,self.text_ctrl_4]
        for ed in eds:
           ed.SetZoom(0)

    def page(self): 
        """ retourne le text_ctrl actif dans le notebook """
        format = self.format_lemmes() 
        if format == "texte":
           return self.text_ctrl_2
        elif format == "LaTeX":
           return self.text_ctrl_3
        else : return self.text_ctrl_4

    def format_lemmes(self):
        """ retourne le titre de la page du notebook,
            qui est aussi celui d'un des formats de sortie
            dfinis dans latinus.py"""
        return self.notebook_1.GetPageText(self.notebook_1.GetSelection())

    def OnToutLemmatiser(self, event):
        """ lemmatise tout le texte, et le met
            en forme suivant le format demand """
        ctrl = self.page()
        # appel de lemmatisation filtre
        texte = self.text_ctrl_1.GetText()
        texte = texte.encode('latin-1','replace')
        #lignes = lemmatise(self.text_ctrl_1.GetText(), 
        lignes = lemmatise(texte,
            self.format_lemmes(), 
            self.combo_1.GetSelection(),  
            self.frame_1_menubar.GetMenu(3).IsChecked(self.idLemmTriee))
        if wx6:
            lignes = unicode (lignes, 'cp1252')
        ctrl.SetText(lignes)
        self.status_textes[2] = "%d uoces lemmatizatae" % (self.page().GetLineCount())
        self.maj_status()
        self.signum_M = 1

    def OnLemmLigne(self, event):
        ctrl = self.text_ctrl_1
        page = self.page()
        page.AddText(lemmatise(ctrl.GetLine(ctrl.GetCurrentLine()), 
           self.format_lemmes()))
        page.CmdKeyExecute(wxSTC_CMD_DOCUMENTEND)
        ctrl.CmdKeyExecute(wxSTC_CMD_LINEDOWN)
        self.signum_M = 1

    def OnLemmMot(self, event):
        """ Lemmatise le mot sous le caret, et avance le caret d'un mot """
        ctrl = self.text_ctrl_1
        page = self.page()
        t_pos = ctrl.GetCurrentPos()
        while string.letters.find(ctrl.GetText()[t_pos]) < 0:
            ctrl.CmdKeyExecute(wxSTC_CMD_WORDRIGHT)
            t_pos = ctrl.GetCurrentPos()
        ab = ctrl.WordStartPosition(t_pos, 1)
        ad = ctrl.WordEndPosition(t_pos, 1)
        mot = ctrl.GetTextRange(ab, ad)
        analyses = lemmatisem(mot, self.format_lemmes())
        self.page().AddText(analyses)
        page.CmdKeyExecute(wxSTC_CMD_DOCUMENTEND)
        ctrl.CmdKeyExecute(wxSTC_CMD_WORDRIGHT)
        self.signum_M = 1

    def OnLexicum(self, event):
        Dialogon = DialogonLex(None, -1, "Collatinus-Lexicum") 
        # mot actif, si possible
        ctrl = self.text_ctrl_1
        t_pos = ctrl.GetCurrentPos()
        ab = ctrl.WordStartPosition(t_pos, 1)
        ad = ctrl.WordEndPosition(t_pos, 1)
        mot = ctrl.GetTextRange(ab, ad)
        if mot == '': mot = 'ab'
        mot = ijuv(mot[:2])
        # peupler la liste
        Dialogon.text_ctrl_5.SetValue(mot)
        Dialogon.list_box_1.Clear()
        Dialogon.OnAlterLemm(None)
        Dialogon.ShowModal()
        Dialogon.Destroy()
        peupleRadicaux()

    def OnCommuniquer(self, event):
        conf.Communiquer = self.frame_1_menubar.GetMenu(3).IsChecked(self.idCommuniquer)

    def OnRetourLigne(self, event):
        ctrl = self.page()
        if event.IsChecked():
            ctrl.SetWrapMode(wxSTC_WRAP_WORD)
        else: 
            ctrl.SetWrapMode(wxSTC_WRAP_NONE)

    def OnEffLigne(self, event):
        ctrl = self.page()
        ctrl.CmdKeyExecute(wxSTC_CMD_LINECUT)

    def SauveConfig(self):
        f = open(viaD + 'conf.py', 'w')
        f.write('TriLemm=%d\n' % self.frame_1_menubar.GetMenu(3).IsChecked(self.idLemmTriee))
        f.write('Communiquer=%d\n' % conf.Communiquer)
        f.write('depot = "%s"\n' % conf.depot)
        f.write('inscriptio = "%s"\n' % conf.inscriptio)
        f.write('diesLemmata = "%s"\n' % conf.diesLemmata)
        f.close()

    def OnAPropos(self, event):
        de = """
         Collatinus-"""+version.number+"""
         Collatinus.py revisus : """+revision()+"""
         Latinus.py revisus : """+latinus.revision()+"""
         Flexfr : revisus"""+flexfr.revision()+"""
      (c) Yves Ouvrard 2004-2005
     http://www.collatinus.org
    yves.ouvrard@collatinus.org
          Licence GPL     """
        dlg=wxMessageDialog(self, de, 'Collatinus', wxOK)
        dlg.ShowModal()
        dlg.Destroy()

    def OnAuxilium(self, event):
        os.system('dillo /usr/share/doc/collatinus/html/collatinus.html')

# end of class MyFrame

class Bulle(wxPanel):
    # cette classe est une adaptation du fichier gnr par wxglade.
    # j'ai fait driver Bulle de wxPanel au lieu de wxFrame, qui
    # provoquait,  son activation, une perte de focus de la 
    # fentre principale.
    def __init__(self, parent, id):
            wxPanel.__init__(self, parent, id)
            self.st = wxStaticText(self, -1, "", pos=(10,10))
            self.__set_properties()

    def __set_properties(self):
        # begin wxGlade: Bulle.__set_properties
        if Linux: self.SetBackgroundColour(wxColour(248, 252, 176))
        else: self.st.SetBackgroundColour(wxColour(248, 252, 176))
        # end wxGlade

    def Affiche(self, texte, position):
            if wx6:
                texte = unicode (texte, 'cp1252')
            self.st.SetLabel(texte)
            sz = self.st.GetBestSize()
            self.SetSize((sz.width+20, sz.height+20)) 
            largP = self.GetParent().GetSize()[0] 
            #print largP
            if self.GetSize()[0] > largP - position[0]:
                 position = (largP-self.GetSize()[0], position[1])
            self.SetPosition(position)
            self.Show(1)


class DialogonLex(wxDialog):
    def __init__(self, *args, **kwds):
        idAlterLemm = wxNewId()
        idAbeo      = wxNewId()
        idEmendo    = wxNewId()
        idAddo      = wxNewId()
        idDeleo     = wxNewId()
        idSel       = wxNewId()
        # begin wxGlade: MyDialog.__init__
        kwds["style"] = wxDEFAULT_DIALOG_STYLE
        wxDialog.__init__(self, *args, **kwds)
        self.list_box_1 = wxListBox(self, idSel, 
            choices=["a", "ab", "abeo"])
        self.text_ctrl_5 = wxTextCtrl(self, idAlterLemm, "ab")
        self.bt_emendo = wxButton(self, idEmendo, " emendo ")
        self.bt_addo = wxButton(self, idAddo, " addo ")
        self.bt_deleo = wxButton(self, idDeleo, " deleo ")
        self.bt_abeo = wxButton(self, idAbeo, " nunc abeo ")
        self.text_ctrl_6 = wxTextCtrl(self, -1, "", 
            style=wxTE_MULTILINE|wxTE_READONLY|wxHSCROLL)

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        EVT_TEXT(self, idAlterLemm, self.OnAlterLemm)
        EVT_BUTTON(self, idAbeo, self.OnAbeo)
        EVT_BUTTON(self, idEmendo, self.OnEmendo)
        EVT_BUTTON(self, idAddo, self.OnAddo)
        EVT_BUTTON(self, idDeleo, self.OnDeleo)
        EVT_LISTBOX(self, idSel, self.OnSel)
        # lexique interne
        self.Lemm = lexique.keys()
        self.Lemm.sort()

    def __set_properties(self):
        # begin wxGlade: MyDialog.__set_properties
        self.SetTitle("Collatinus - lexicum")
        _icon = wxEmptyIcon()
        _icon.CopyFromBitmap(wxBitmap(path_images+"icon.xpm", 
            wxBITMAP_TYPE_ANY))
        self.SetIcon(_icon)
        self.SetSize((337, 428))
        self.list_box_1.SetSelection(0)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: MyDialog.__do_layout
        sizer_2 = wxBoxSizer(wxVERTICAL)
        sizer_4 = wxBoxSizer(wxHORIZONTAL)
        sizer_5 = wxBoxSizer(wxVERTICAL)
        sizer_4.Add(self.list_box_1, 0, wxEXPAND, 0)
        sizer_5.Add(self.text_ctrl_5, 0, wxEXPAND, 0)
        sizer_5.Add(self.bt_emendo, 0, 0, 0)
        sizer_5.Add(self.bt_addo, 0, 0, 0)
        sizer_5.Add(self.bt_deleo, 0, 0, 0)
        sizer_5.Add(20, 20, 0, 0, 0)
        sizer_5.Add(self.text_ctrl_6, 5, wxEXPAND, 0)
        sizer_5.Add(self.bt_abeo, 0, 0, 0)
        sizer_4.Add(sizer_5, 1, wxEXPAND, 0)
        sizer_2.Add(sizer_4, 1, wxEXPAND, 0)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_2)
        self.Layout()
        # end wxGlade

    def OnAlterLemm(self, event):
        def SubLexicum(uerbum):
            v = self.text_ctrl_5.GetValue()
            l = len(v)
            #return re.match("^"+initium, uerbum)
            return uerbum[:l] == v
        if len(self.text_ctrl_5.GetValue()) < 2: return 
        aff = filter(SubLexicum, self.Lemm) 
        self.list_box_1.Clear()
        self.list_box_1.InsertItems(aff, 0)
        self.list_box_1.SetSelection(0)
        self.OnSel(event)
        
    def OnSel(self, event):
        v = self.list_box_1.GetStringSelection()
        if lexique.has_key(v):
            self.text_ctrl_6.SetValue(lexique[v].docLemm())

    def OnAbeo(self, event):
        self.Show(false)

    def OnEmendo(self, event):
        v = self.list_box_1.GetStringSelection()
        # chercher le lexique cible (lexique ou lexicumP ?)
        if lexicumP.has_key(v):
           cible = lexicumP
        else : cible = lexique
        e = cible[v]
        if not v: return
        dlg = DCanon(None, -1, "Emendare") 
        # peupler le dialogue
        dlg.text_gr.SetValue(e.graphie)
        dlg.text_mdl.SetValue(Lmodeles[e.modele])
        dlg.text_sem.SetValue(e.texte)
        dlg.text_r2.SetValue(e.r2)
        dlg.text_supin.SetValue(e.r3)
        if dlg.ShowModal() == wxID_YES:
        # rcuprer les donnes
           lemma = dlg.Lemma()
           lemma.status =  0 # pour mmoire. Valeur dj affecte
           self.Emenda(lemma, cible)
        dlg.Destroy()

    def Emenda(self, lemma, cible):
        # dialogue de prcaution
        nunt = "Num emendare possum hoc ?\n %s" % lemma.docLemm()
        dlg=wxMessageDialog(self, nunt, 'Collatinus', wxYES_NO)
        if dlg.ShowModal() == wxID_YES:
            # Si le lemme est dj prsent, le corriger
            # Sinon (improbable, si on dsactive la ligne de saisie graphie), 
            # l'ajouter avec la mention alter
            lexicumP[lemma.graphie] = lemma
            ecrisP()
            # ventuellement, prendre en compte la modification.
            # Tant pis pour la redondance si c'est lexicumP qui est vis.
            cible[lemma.graphie] = lemma
        dlg.Destroy()

    def OnAddo(self, event):
        dlg = DCanon(None, -1, "Addere") 
        dlg.text_gr.SetValue(self.text_ctrl_5.GetValue())
        if dlg.ShowModal() == wxID_YES:
            lemma = dlg.Lemma()
            self.Adde(lemma)
        dlg.Destroy()

    def Adde(self, lemma):
        nunt = "Num uis me addere %s ?" % lemma.docLemm()
        dlg=wxMessageDialog(self, nunt, 'Collatinus', wxYES_NO)
        if dlg.ShowModal() == wxID_YES:
           lemma.status = 0
           lexicumP[lemma.graphie] = lemma
           ecrisP()
           lexique[lemma.graphie] = lemma
        dlg.Destroy()

    def OnDeleo(self, event):
        v = self.list_box_1.GetStringSelection()
        if not v: return
        nunt = "Certior me fac : delere debeo << %s >> ?" % v
        dlg=wxMessageDialog(self, nunt, 'Collatinus', wxYES_NO)
        if dlg.ShowModal() == wxID_YES:
            # lemma in "lexicumP" ? scribere debuerim : lexicoP !
            if lexicumP.has_key(v):
               del(lexicumP[v])
            # Certe in lexico est.
            else:
                l = lexicumP[v]
                # ajouter l'indication de suppression dans lexicumP
                lexicumP[v] = tentreeP(2, l.modele, l.graphie, l.texte)
                del(lexique[v])
            ecrisP()
        dlg.Destroy()

# end of class DialogonLex

class DCanon(wxDialog):
    def __init__(self, *args, **kwds):
        """ La classe DCanon sert  modifier les entres du
        lexique. Ces modifications sont ensuite dposes
        dans un fichier ~/.collatinus/canons.xml. 
        Elle est lance si on veut ajouter ou modifier
        un lemme, mais pas si on veut le supprimer.  """
        idVolo = wxNewId()
        idNolo = wxNewId()
        idMdl = wxNewId()
        idRadioM = wxNewId()
        # begin wxGlade: DCanon.__init__
        kwds["style"] = wxDIALOG_MODAL|wxCAPTION
        wxDialog.__init__(self, *args, **kwds)
        self.label_gr = wxStaticText(self, -1, " lemme ")
        self.text_gr = wxTextCtrl(self, -1, "")
        self.label_m = wxStaticText(self, -1, " modle ")
        self.text_mdl = wxTextCtrl(self, idMdl, "")
        self.chx_m = wxRadioBox(self, idRadioM, "modles", 
            choices=Lmodeles,
            majorDimension=7, style=wxRA_SPECIFY_COLS)
        self.label_2 = wxStaticText(self, -1, 
            " radix genetiui, \n aut perfecti ", style=wxALIGN_RIGHT)
        self.text_r2 = wxTextCtrl(self, -1, "")
        self.label_supin = wxStaticText(self, -1, " radical de supin ")
        self.text_supin = wxTextCtrl(self, -1, "")
        self.text_sem = wxTextCtrl(self, -1, "", 
            style=wxTE_PROCESS_ENTER|wxTE_MULTILINE)
        self.panel_1 = wxPanel(self, -1)
        self.btNolo = wxButton(self, idNolo, " Nolo ")
        self.btVolo = wxButton(self, idVolo, " Volo ")

        self.__set_properties()
        self.__do_layout()
        # end wxGlade
        EVT_BUTTON(self, idNolo, self.OnNolo)
        EVT_BUTTON(self, idVolo, self.OnVolo)
        EVT_TEXT(self, idMdl, self.OnModele)
        EVT_RADIOBOX(self, idRadioM, self.OnRadioM)

    def __set_properties(self):
        # begin wxGlade: DCanon.__set_properties
        self.SetTitle("Collatinus - lemmatis aeditio")
        _icon = wxEmptyIcon()
        _icon.CopyFromBitmap(wxBitmap(path_images+"icon.xpm", 
            wxBITMAP_TYPE_ANY))
        self.SetIcon(_icon)
        self.SetSize((465, 453))
        # end wxGlade
        #peupler la liste des modles
        l = string.join(Lmodeles, ' ')

    def __do_layout(self):
        # begin wxGlade: DCanon.__do_layout
        sizer_3 = wxBoxSizer(wxVERTICAL)
        sizer_8 = wxBoxSizer(wxHORIZONTAL)
        sizer_7 = wxBoxSizer(wxHORIZONTAL)
        sizer_6 = wxBoxSizer(wxHORIZONTAL)
        sizer_6.Add(self.label_gr, 1, 0, 0)
        sizer_6.Add(self.text_gr, 2, 0, 0)
        sizer_6.Add(self.label_m, 1, 0, 0)
        sizer_6.Add(self.text_mdl, 2, 0, 0)
        sizer_6.Add(20, 20, 0, 0, 0)
        sizer_3.Add(sizer_6, 0, wxEXPAND, 0)
        sizer_3.Add(self.chx_m, 0, 0, 0)
        sizer_7.Add(self.label_2, 1, 0, 0)
        sizer_7.Add(self.text_r2, 1, 0, 0)
        sizer_7.Add(self.label_supin, 1, 0, 0)
        sizer_7.Add(self.text_supin, 1, 0, 0)
        sizer_7.Add(20, 20, 0, 0, 0)
        sizer_3.Add(sizer_7, 0, wxEXPAND, 0)
        sizer_3.Add(self.text_sem, 3, wxEXPAND, 0)
        sizer_8.Add(self.panel_1, 3, wxEXPAND, 0)
        sizer_8.Add(self.btNolo, 1, 0, 0)
        sizer_8.Add(20, 20, 0, 0, 0)
        sizer_8.Add(self.btVolo, 1, 0, 0)
        sizer_8.Add(20, 20, 0, 0, 0)
        sizer_3.Add(sizer_8, 0, wxEXPAND, 0)
        self.SetAutoLayout(1)
        self.SetSizer(sizer_3)
        self.Layout()
        # end wxGlade

    def OnModele(self, event):
       try: m = Lmodeles.index(self.text_mdl.GetValue())
       except: return 
       if self.chx_m.GetSelection() != m:
          self.chx_m.SetSelection(m)

    def OnRadioM(self, event):
       self.text_mdl.SetValue(self.chx_m.GetStringSelection())

    def OnNolo(self, event):
        self.EndModal(wxID_NO)

    def OnVolo(self, event):
        self.EndModal(wxID_YES)
        
    def Lemma(self):
        return tentreeP(
                       0,  
                       self.chx_m.GetSelection(),
                       self.text_gr.GetValue(),
                       self.text_sem.GetValue(),
                       self.text_r2.GetValue(), 
                       self.text_supin.GetValue())
# end of class DCanon

def epistula():
    """Envoie  lexique@collatinus.org une copie du fichier 
      ~/.collatinus/canons.xml (unices)
      \Program Files\collatinus\canons.xml (Fentres)
      L'envoi est propos si les dix entres au moins sont
      ajoutes, modifies ou supprimes.
      """
    try:  
       if not conf.Communiquer: return
    except: conf.Communiquer = true 
    if lexicumP.nonCommuniquees() > 10:
            msg = """lexicon tuum nunc X uerba continet. 
               Visne id mittere ad Collatini situm ?"""
            dlg = wxMessageDialog(None, msg, 'Collatinus', wxYES_NO)
            result = dlg.ShowModal()
            dlg.Destroy()
            if result != wxID_YES: return 
            import smtplib
            # test. Prvoir des wxTextEntryDialog de gestion
            ex = conf.inscriptio 
            ad = 'lexicon@collatinus.org'
            serveur = smtplib.SMTP('pop3.collatinus.org')
            #msg = "From: %s\nTo: %s\n%s\r\n\r\n" % (ex, ad, doc.toxml())
            msg = "From: %s\nTo: %s\n\n%s\n\n" % (ex, ad, doc.toxml("iso-8859-1"))
            serveur.set_debuglevel(1)
            #serveur.sendmail(ex, ad, msg.encode('latin-1'))
            serveur.sendmail(ex, ad, msg)
            serveur.quit()
            lexicumP.setEnvoye()
            lexicumP.ecris()
            print "Lexicum missum."
    return 0

def majLemmata():
    """Consulte le dpt pour savoir si une version plus rcente
       du fichier lemmata a t dpose dans le dpt, et propose
       la mise  jour."""
    try:  
       if not conf.Communiquer: return
    except: conf.Communiquer = true 
    import urllib, time
    try:
        # comparer la taille
        u = urllib.urlopen(conf.depot)
    except: return false
    # test d'existence du fichier lemmata utilisateur :
    print "test de mise  jour..."
    if os.path.exists(viaL): f = urllib.urlopen(viaL) 
    else :
        f = urllib.urlopen('/usr/share/collatinus/lemmata')
    dies = u.info()['last-modified']
    if dies != conf.diesLemmata:
        # informer l'utilisateur d'une mise  jour
        msg = "Un nouveau lexique est en place sur le serveur. Le tlcharger ?"
        dlg = wxMessageDialog(None, msg, 'Collatinus', wxYES_NO)
        r = dlg.ShowModal()
        dlg.Destroy()
        if r != wxID_YES: 
           return
       # tlcharger l = u.read()
        f = open(viaL, 'w')
        f.write(l)
        f.close()
        print "tlchargement termin"
        conf.diesLemmata = dies
        # ddoublonner lemmata / xml perso
        if conf.Communiquer:
            lexicumP.dedoublonne()
        #  crire : questionnaire en cas de diffrence
        # entre lexique et lexicumP
    else: print "Pas de mise  jour."
    return 0

class MyApp(wxApp):
    def OnInit(self):
        wxInitAllImageHandlers()
        frame_1 = MyFrame(None, -1, "")
        self.SetTopWindow(frame_1)
        frame_1.Show(1)
        # Ouverture du fichier en paramtre
        if len(sys.argv) >1 and sys.argv[1] > '':
           frame_1.text_ctrl_1.LoadFile(sys.argv[1]) 
           frame_1.status_textes[0] = sys.argv[1]
        else:
           frame_1.text_ctrl_1.LoadFile('/usr/share/doc/collatinus/caesar.txt')
           frame_1.status_textes[0] = 'caesar.txt'
        frame_1.status_textes[1] = 'integer'
        frame_1.maj_status()
        # A placer sous condition : envoi du lexique personnel ?
        if conf.Communiquer:
            majLemmata()
            epistula()
        return 1

# end of class MyApp

if __name__ == "__main__":
    app = MyApp(0)
    app.MainLoop()
