from __future__ import generators

import py
optparse = py.compat.optparse

defaultconfig = py.magic.autopath().dirpath('defaultconftest.py')
dummy = object()

#
# configuration file handling  
#
configbasename = 'conftest.py'


# XXX move to Config class
basetemp = None
def ensuretemp(string, dir=1): 
    """ return temporary directory path with
        the given string as the trailing part. 
    """ 
    global basetemp
    if basetemp is None: 
        basetemp = py.path.local.make_numbered_dir(prefix='pytest-')
    return basetemp.ensure(string, dir=dir) 
   
class Config(object): 
    """ central hub for dealing with configuration/initialization data. """ 
    Option = optparse.Option

    def __init__(self): 
        self.option = optparse.Values()
        self._parser = optparse.OptionParser() 
        self._initialconfigmodules = []

    # class level attributes 
    def _reset(cls): 
        cls._config = cls() 
    _reset = classmethod(_reset)

    def getvalue(cls, name, path=None, default=dummy, trydefaultconfig=True): 
        """ return 'name' value looked up from the first conftest file 
            found up the path (including the path itself). 
        """
        configpaths = guessconfigpaths(path) 
        if trydefaultconfig: 
            configpaths.append(defaultconfig) 
        for p in configpaths: 
            mod = importconfig(p) 
            if hasattr(mod, name): 
                return getattr(mod, name) 
        if default is not dummy: 
            return default 
        raise ValueError("config value not found: %r, path=%r" % (name, path))
    getvalue = classmethod(getvalue) 

    def parse(cls, args): 
        """ return Config object and remaining arguments from parsing 
            command line arguments. 
        """ 
        configpaths = guessconfigpaths(*getanchorpaths(args))
        config = bootstrapconfig(configpaths) 
        config._origargs = args
        cmdlineoption, remaining = config._parser.parse_args(args) 
        for name, value in vars(cmdlineoption).items(): 
            setattr(config.option, name, value) 
        fixoptions(config.option) 
        if not remaining: 
            remaining.append(py.std.os.getcwd()) 
        config.remaining = remaining 
        return config, remaining 
    parse = classmethod(parse) 

    def addoptions(cls, groupname, *specs): 
        """ add a named group of options to the current testing session. 
            This function gets invoked during testing session initialization. 
        """ 
        parser = cls._config._parser 
        optgroup = optparse.OptionGroup(parser, groupname) 
        optgroup.add_options(specs) 
        parser.add_option_group(optgroup)
        for opt in specs: 
            if hasattr(opt, 'default'): 
                setattr(cls._config.option, opt.dest, opt.default) 
        return cls._config.option 
    addoptions = classmethod(addoptions) 

    # instance methods dealing with initial config module handling 

    def loadconfig(self, configpath): 
        """ load configpath as an initial config module. """ 
        mod = importconfig(configpath) 
        self._initialconfigmodules.append(mod) 
        return mod 

    def getinitialvalue(self, name, default=dummy): 
        """ return first value found in initial config modules. """ 
        for confmodule in self._initialconfigmodules: 
            if hasattr(confmodule, name): 
                return getattr(confmodule, name)
        if default is not dummy: 
            return default
        raise ValueError("initial config value not found: %r" % name)

    def getsessionclass(self): 
        """ return Session class determined from cmdline options
            and looked up in initial config modules. 
        """
        name = self.option.session 
        name += 'Session'
        try: 
            return self.getinitialvalue(name) 
        except ValueError: 
            return getattr(py.test, name) 

Config._reset() 

#
# helpers
#

def fixoptions(option):
    """ sanity checks and making option values canonical. """
    if option.looponfailing and option.usepdb:
        raise ValueError, "--looponfailing together with --pdb not supported yet."
    if option.executable and option.usepdb:
        raise ValueError, "--exec together with --pdb not supported yet."

    # setting a correct executable
    remote = False
    if option.executable is not None:
        remote = True 
        exe = py.path.local(py.std.os.path.expanduser(option.executable))
        if not exe.check():
            exe = py.path.local.sysfind(option.executable)
        assert exe.check()
        option.executable = exe
    else: 
        option.executable = py.std.sys.executable 

    # make information available about wether we should/will be remote 
    option._remote = remote or option.looponfailing
    option._fromremote = False 

    # setting a correct frontend session 
    if option.session:
        name = option.session
    elif option.tkinter:
        name = 'tkinter'
    else:
        name = 'terminal'
    name = name.capitalize() 
    option.session = name 

def bootstrapconfig(configpaths):
    """ return 'current' config object, after initializing 
        it with the given configpaths. 
    """ 
    # XXX Config._config holds all options that are added from 
    # conftest's py.test.Config.addoptions() invocations.  This "global state"
    # manipulation is unfortunate but how else could we allow
    # applications to add cmdline options and provide them
    # access to the resulting config values?   

    config = Config._config 
    # trigger loading conftest files which might add options! 
    for configpath in configpaths: 
        config.loadconfig(configpath) 
    config.loadconfig(defaultconfig).adddefaultoptions() 
    # each time we make a config object (which assembled cmdline 
    # options through py.test.addoptions() invocations) 
    # we want to reset and clean up the global state 
    Config._reset() 
    return config 


def guessconfigpaths(*paths):
    """ return test configuration paths from skimming the args. """ 
    d = {}
    for anchor in paths: 
        if anchor: 
            for p in anchor.parts():
                x = p.join(configbasename)
                if x.check(file=1):
                    d[x] = True 
    configpaths = d.keys() 
    configpaths.sort(lambda x,y: cmp(len(str(x)), len(str(y))))
    return configpaths 

def getanchorpaths(args):
    """ yield "anchors" from skimming the args for existing files/dirs. """
    current = py.path.local()
    l = []
    for arg in args:
        anchor = current.join(arg, abs=1)
        if anchor.check():
            l.append(anchor)
    if not l:
        l = [current]
    return l

def importconfig(configpath): 
    if not configpath.dirpath('__init__.py').check(file=1): 
        # HACK: we don't want a "globally" imported conftest.py, 
        #       prone to conflicts and subtle problems 
        modname = str(configpath).replace('.', configpath.sep) 
        return configpath.pyimport(modname=modname) 
    else: 
        return configpath.pyimport() 
    

#XXX was needed for extracting defaults, not needed anymore? 
#def flattenoptions(parser):
#    for group in parser.option_groups:
#        for y in group.option_list:
#            yield y
#    for x in parser.option_list:
#        yield x
