//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah
// file name            : newprojectdlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#ifndef __newprojectdlg__
#define __newprojectdlg__

/**
@file
Subclass of NewProjectBaseDlg, which is generated by wxFormBuilder.
*/

#include "newprojectbasedlg.h"
#include "project.h"
#include "list"
#include "map"

/** Implementing NewProjectBaseDlg */
class NewProjectDlg : public NewProjectBaseDlg
{
	std::list<ProjectPtr> m_list;
	std::map<wxString,int> m_mapImages;
	ProjectData m_projectData;

protected:
	// Handlers for NewProjectBaseDlg events.
	void OnProjectNameChanged( wxCommandEvent& event );
	void OnProjectPathChanged( wxFileDirPickerEvent& event );
	void OnCreate(wxCommandEvent &event);
	void OnTemplateSelected( wxListEvent& event );
	void OnCategorySelected( wxCommandEvent& event );

	ProjectPtr FindProject(const wxString &name);
	void GetProjectTemplateList(std::list<ProjectPtr> &list);
	void FillProjectTemplateListCtrl(const wxString& category);

	void UpdateFullFileName();
	void UpdateProjectPage();

public:
	/** Constructor */
	NewProjectDlg( wxWindow* parent );
	virtual ~NewProjectDlg();

	const ProjectData& GetProjectData() const { return m_projectData; }
};

#endif // __newprojectdlg__
