#!/usr/bin/perl

use XML::Parser;

$infile = "phones.xml";
$cap=0;
$parser = new XML::Parser(Handlers =>    {Start => \&handle_start,
						End   => \&handle_end,
						Char  => \&handle_char});

open SESAME,">detect.c";
print SESAME qq!
/****************************************************************************
*
* detect.c - Autogenerated from $infile
*
****************************************************************************/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <string.h>
#include "detect.std.h"
#include "../capabilities.h"

int detectModel ( char *model, char *software, long *cap, v24_port_t *comPort) {
char response[255];

!;

$parser->parsefile($infile);

print SESAME qq!

return 1;

}
!;

close SESAME;

sub handle_start () {
	my %attr;
	my $i=2;
	while (exists($_[$i]) ) {
		#print "attr $_[$i] = ".$_[$i+1]."\n";
		$attr{$_[$i]} = $_[$i+1];
		$i+=2;
	}

	if (lc($_[1]) eq "request") {
		print SESAME 'if(doRequest(comPort, response, "AT'.$attr{value}.'\r"'.
		",".(length($attr{value})+3).")) { return 2; } \n";
	} elsif (lc($_[1]) eq "response") {
		print SESAME 'if (strncmp(response, "'.$attr{value}.'", '.length($attr{value}).")==0){\n";
	} elsif (lc($_[1]) eq "phone") {
		print SESAME 'sprintf(model, "'.$attr{model}.'%c",0x00);'."\n";
		print SESAME 'sprintf(software, "'.$attr{software}.'%c",0x00);'."\n";
	} elsif (lc($_[1]) eq "capabilities") {
		$cap=1;
	}
}

sub handle_end () {
	if (lc($_[1]) eq "response") {
		print SESAME "}\n";
	}
}

sub handle_char () {
	chomp(my $in=$_[1]);
	if ($cap == 1) {
		print SESAME "*cap = $in ;\n";
		print SESAME "return 0;\n";
	}
	$cap=0;
}
