/*
*
* get.c - COBEX - Get a file from a device.
*
* Copyright 2003,2004,2005 Fredrik Srensson
*
* History:
* v0.5 - fsn - 04-02-22 - First version
* v0.6 - fsn - 05-07-19 - Using general signal handling and general path handling
*
* Source:
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>

#include "cobex_core.h"
#include "cobex_tools.h"
#include "cobex_serial.h"


// Main routine

int main (int argc, char *argv[]) {
	v24_port_t *UsedPort=NULL;
	static char IRMCSYNC[]={ 0x49, 0x52, 0x4d, 0x43, 0x2d, 0x53, 0x59, 0x4e, 0x43, 0x00 };
	static char fsBrowser[]={ 0xf9, 0xec, 0x7b, 0xc4, 0x95, 0x3c, 0x11, 0xd2, 0x98, 0x4e, 0x52, 0x54, 0x00, 0xdc, 0x9e, 0x09, 0x00};
	int rc;

	char aBuffer[513];
	obex_packet aPacket;

	aPacket.max=512;
	aPacket.buffer=aBuffer;
	
	char *name;
	char *path;

	if (argc != 3) {
		printf ("ERR: Wrong argc : %d.\n",argc);
		return 1;
	}

	// Set up the port
	UsedPort = cobex_openPort(argv[1]);
	ctools_installSignalhandler();
	ctools_setup_state(UsedPort);

	// Do some testing
	if (cobex_testComm(UsedPort)) {
		fputs ("ERR: Comms testing failed.\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}	

	// Go obex
	if (ctools_connect(UsedPort)) {
		fputs ("ERR: OBEX connect failed.\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}	

	// Do an obex connect

	obex_opcode_connect( &aPacket );
	obex_hi_target ( &aPacket, IRMCSYNC, 9 );
	cobex_packlgt( &aPacket );
	
	//dump_packet_headers(&aPacket);


	if (cobex_packet_send(&aPacket, UsedPort) != COBEX_OK) {
		fputs ("ERR: Didn't send connect.\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}

	if ( cobex_packet_recieve(&aPacket, UsedPort) != COBEX_OK) {
		fputs ("ERR: Didn't recieve response\n",stderr);
		cobex_closePort(UsedPort);
		return COBEX_ERR;
	}
	//dump_packet_headers(&aPacket);

	path = calloc( strlen(argv[2])+1, sizeof(char) );
	name = calloc( strlen(argv[2])+1, sizeof(char) );
	
	ctools_buildPath ( argv[2], path, name );	
	rc=ctools_recursePath( &aPacket, path, UsedPort );		
	rc=ctools_getFileByName( &aPacket, name, UsedPort );
	
	free (path);
	free (name);
	
	if (cobex_response_code(&aPacket) != (OBEX_RESPONSE_OK|OBEX_FINAL_BIT) ) { 
		fprintf (stderr, "ERR: %s \n",
			cobex_respstring(cobex_response_code(&aPacket)) ) ;
	}

	// Bye, y'all!

	ctools_disconnect( &aPacket, UsedPort );	
	cobex_closePort(UsedPort);
	
	return rc;

}

