/*
*
* cobex_serial.h - Functions for serial comm for OBEX-over-cable
*
* Copyright (c) 2005 Fredrik Srensson
*
* History:
* v0.1 - fsn - 05-07-19 - First version
*
* Source:
*
*/

#include <sys/types.h>
#include <ezV24/ezV24.h>
#include <signal.h>

#include "cobex_defs.h"
#include "cobex_core.h"

#ifndef __COBEX_SERIAL_H
#define __COBEX_SERIAL_H

#define NAPTIME 10000

// Reading and writing over the cable

int cobex_packet_send 		( obex_packet *inpacket, v24_port_t *port );
int cobex_packet_recieve	( obex_packet *outPacket, v24_port_t *port );
int cobex_packet_recieve_t 	( obex_packet *outPacket, v24_port_t *port, int );
int cobex_waitFor		( v24_port_t *aPort, char *msg, int lgt, char *bmsg, int blgt );
v24_port_t* cobex_openPort	( char *port );
int cobex_closePort		( v24_port_t *aPort );
int cobex_testComm		( v24_port_t *aPort );

#endif

