;;; -*- Log: C.Log -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;;
(ext:file-comment
  "$Header: /project/cmucl/cvsroot/src/code/exports.lisp,v 1.202 2003/03/21 23:43:35 pmai Exp $")
;;;
;;; **********************************************************************
;;;
;;; All the stuff necessary to export various symbols from various packages.
;;;

(in-package "LISP")

(if (find-package "PCL")
    (rename-package "PCL" "PCL" 'nil)
    (make-package "PCL" :nicknames 'nil :use nil))
(shadow 'class "PCL")

(if (find-package "C-CALL")
    (rename-package "C-CALL" "C-CALL" 'nil)
    (make-package "C-CALL" :nicknames 'nil :use nil))
(if (find-package "INSPECT")
    (rename-package "INSPECT" "INSPECT" 'nil)
    (make-package "INSPECT" :nicknames 'nil :use nil))
(if (find-package "BIGNUM")
    (rename-package "BIGNUM" "BIGNUM" 'nil)
    (make-package "BIGNUM" :nicknames 'nil :use nil))
(if (find-package "UNIX")
    (rename-package "UNIX" "UNIX" 'nil)
    (make-package "UNIX" :nicknames 'nil :use nil))
(if (find-package "FORMAT")
    (rename-package "FORMAT" "FORMAT" 'nil)
    (make-package "FORMAT" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP")
    (rename-package "COMMON-LISP" "COMMON-LISP" '("CL" "LISP"))
    (make-package "LISP" :nicknames 'nil :use nil))
(if (find-package "EVAL")
    (rename-package "EVAL" "EVAL" 'nil)
    (make-package "EVAL" :nicknames 'nil :use nil))
#+pmax
(if (find-package "PMAX")
    (rename-package "PMAX" "PMAX" '("VM"))
    (make-package "PMAX" :nicknames '("VM") :use nil))
#+sparc
(if (find-package "SPARC")
    (rename-package "SPARC" "SPARC" '("VM"))
    (make-package "SPARC" :nicknames '("VM") :use nil))
#+ibmrt
(if (find-package "RT")
    (rename-package "RT" "RT" '("VM"))
    (make-package "RT" :nicknames '("VM") :use nil))
#+x86
(if (find-package "X86")
    (rename-package "X86" "X86" '("VM"))
    (make-package "X86" :nicknames '("VM") :use nil))
#+hppa
(if (find-package "HPPA")
    (rename-package "HPPA" "HPPA" '("VM"))
    (make-package "HPPA" :nicknames '("VM") :use nil))
#+alpha
(if (find-package "ALPHA")
    (rename-package "ALPHA" "ALPHA" '("VM"))
    (make-package "ALPHA" :nicknames '("VM") :use nil))
#+sgi
(if (find-package "SGI")
    (rename-package "SGI" "SGI" '("VM"))
    (make-package "SGI" :nicknames '("VM") :use nil))
#+ppc
(if (find-package "PPC")
    (rename-package "PPC" "PPC" '("VM"))
    (make-package "PPC" :nicknames '("VM")))
(if (find-package "CONDITIONS")
    (rename-package "CONDITIONS" "CONDITIONS" 'nil)
    (make-package "CONDITIONS" :nicknames 'nil :use nil))
(if (find-package "DISASSEM")
    (rename-package "DISASSEM" "DISASSEM" 'nil)
    (make-package "DISASSEM" :nicknames 'nil :use nil))
(if (find-package "DEBUG")
    (rename-package "DEBUG" "DEBUG" 'nil)
    (make-package "DEBUG" :nicknames 'nil :use nil))
(if (find-package "EXTENSIONS")
    (rename-package "EXTENSIONS" "EXTENSIONS" '("EXT"))
    (make-package "EXTENSIONS" :nicknames '("EXT") :use nil))
(if (find-package "LOOP")
    (rename-package "LOOP" "LOOP" 'nil)
    (make-package "LOOP" :nicknames 'nil :use nil))
(if (find-package "DEBUG-INTERNALS")
    (rename-package "DEBUG-INTERNALS" "DEBUG-INTERNALS" '("DI"))
    (make-package "DEBUG-INTERNALS" :nicknames '("DI") :use nil))
(if (find-package "C")
    (rename-package "C" "C" '("OLD-C"))
    (make-package "C" :nicknames '("OLD-C") :use nil))
(if (find-package "XREF")
    (rename-package "XREF" "XREF" 'nil))
(if (find-package "WIRE")
    (rename-package "WIRE" "WIRE" 'nil)
    (make-package "WIRE" :nicknames 'nil :use nil))
(if (find-package "PRETTY-PRINT")
    (rename-package "PRETTY-PRINT" "PRETTY-PRINT" '("PP"))
    (make-package "PRETTY-PRINT" :nicknames '("PP") :use nil))
(if (find-package "SYSTEM")
    (rename-package "SYSTEM" "SYSTEM" '("SYS"))
    (make-package "SYSTEM" :nicknames '("SYS") :use nil))
(if (find-package "ALIEN")
    (rename-package "ALIEN" "ALIEN" 'nil)
    (make-package "ALIEN" :nicknames 'nil :use nil))
(if (find-package "ALIEN-INTERNALS")
    (rename-package "ALIEN-INTERNALS" "ALIEN-INTERNALS" 'nil)
    (make-package "ALIEN-INTERNALS" :nicknames 'nil :use nil))
(if (find-package "PROFILE")
    (rename-package "PROFILE" "PROFILE" 'nil)
    (make-package "PROFILE" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP-USER")
    (rename-package "COMMON-LISP-USER" "COMMON-LISP-USER" '("CL-USER" "USER"))
    (make-package "COMMON-LISP-USER" :nicknames '("CL-USER" "USER") :use nil))
(if (find-package "KERNEL")
    (rename-package "KERNEL" "KERNEL" 'nil)
    (make-package "KERNEL" :nicknames 'nil :use nil))
(if (find-package "NEW-ASSEM")
    (rename-package "NEW-ASSEM" "NEW-ASSEM" 'nil)
    (make-package "NEW-ASSEM" :nicknames 'nil :use nil))
(if (find-package "MULTIPROCESSING")
    (rename-package "MULTIPROCESSING" "MULTIPROCESSING" 'nil)
    (make-package "MULTIPROCESSING" :nicknames '("MP") :use nil))

(use-package '("SYSTEM" "ALIEN-INTERNALS" "ALIEN" "LISP") "C-CALL")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "INSPECT")
(use-package '("LISP" "KERNEL") "BIGNUM")
(use-package '("LISP") "UNIX")
(use-package '("KERNEL" "LISP" "EXTENSIONS") "FORMAT")
(use-package '("EXTENSIONS" "SYSTEM" "DEBUG" "KERNEL" "BIGNUM") "LISP")
(use-package '("LISP" "KERNEL") "EVAL")
(use-package
 '("C-CALL" "ALIEN-INTERNALS" "ALIEN" "BIGNUM" "LISP" "KERNEL" "EXTENSIONS"
   "SYSTEM" "C")
 "VM")
(use-package '("EXTENSIONS" "LISP") "CONDITIONS")
(use-package '("LISP") "DISASSEM")
(use-package '("EXTENSIONS" "LISP" "SYSTEM") "DEBUG")
(use-package '("C-CALL" "ALIEN" "LISP" "SYSTEM") "EXTENSIONS")
(use-package '("LISP") "LOOP")
(use-package '("LISP" "SYSTEM" "EXTENSIONS" "KERNEL") "DEBUG-INTERNALS")
(use-package
 '("ALIEN-INTERNALS" "ALIEN" "LISP" "EXTENSIONS" "KERNEL" "SYSTEM" "BIGNUM")
 "C")
(use-package '("LISP") "WIRE")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "PRETTY-PRINT")
(use-package '("EXTENSIONS" "LISP") "SYSTEM")
(use-package '("SYSTEM" "EXTENSIONS" "LISP") "ALIEN")
(use-package '("LISP") "ALIEN-INTERNALS")
(use-package '("LISP") "PROFILE")
(use-package '("EXTENSIONS" "LISP") "COMMON-LISP-USER")
(use-package '("ALIEN-INTERNALS" "LISP" "EXTENSIONS" "SYSTEM" "BIGNUM")
             "KERNEL")
(use-package '("LISP") "NEW-ASSEM")

(defpackage "ANSI-LOOP")

(defpackage "C-CALL"
            (:export "C-STRING" "CHAR" "DOUBLE" "FLOAT" "INT" "LONG" "SHORT"
             "UNSIGNED-CHAR" "UNSIGNED-INT" "UNSIGNED-LONG" "UNSIGNED-SHORT"
             "VOID"))
(defpackage "INSPECT"
            (:export "*INTERFACE-STYLE*" "REMOVE-ALL-DISPLAYS"
             "REMOVE-OBJECT-DISPLAY" "SHOW-OBJECT"))
(defpackage "BIGNUM"
            (:export "%ADD-WITH-CARRY" "%ALLOCATE-BIGNUM" "%ASHL" "%ASHR"
             "%BIGNUM-LENGTH" "%BIGNUM-REF" "%BIGNUM-SET" "%BIGNUM-SET-LENGTH"
             "%DIGIT-0-OR-PLUSP" "%DIGIT-LOGICAL-SHIFT-RIGHT"
             "%FIXNUM-DIGIT-WITH-CORRECT-SIGN" "%FIXNUM-TO-DIGIT" "%FLOOR"
             "%LOGAND" "%LOGIOR" "%LOGNOT" "%LOGXOR" "%MULTIPLY"
             "%MULTIPLY-AND-ADD" "%SUBTRACT-WITH-BORROW" "ADD-BIGNUMS"
             "BIGNUM-ASHIFT-LEFT" "BIGNUM-ASHIFT-RIGHT" "BIGNUM-COMPARE"
             "BIGNUM-DEPOSIT-BYTE" "BIGNUM-ELEMENT-TYPE" "BIGNUM-GCD"
             "BIGNUM-INDEX" "BIGNUM-INTEGER-LENGTH" "BIGNUM-LOAD-BYTE"
	     "BIGNUM-LOGBITP" "BIGNUM-LOGCOUNT"
	     "BIGNUM-LOGICAL-AND" "BIGNUM-LOGICAL-IOR"
             "BIGNUM-LOGICAL-NOT" "BIGNUM-LOGICAL-XOR" "BIGNUM-PLUS-P"
             "BIGNUM-TO-FLOAT" "BIGNUM-TRUNCATE" "BIGNUM-TYPE"
             "FLOAT-BIGNUM-RATIO" "MAKE-SMALL-BIGNUM"
             "MULTIPLY-BIGNUM-AND-FIXNUM" "MULTIPLY-BIGNUMS" "MULTIPLY-FIXNUMS"
             "NEGATE-BIGNUM" "SUBTRACT-BIGNUM"))

(defpackage "UNIX"
            (:export "CADDR-T" "D-INO" "D-NAME" "D-NAMLEN" "D-OFF" "D-RECLEN"
             "DADDR-T" "DEV-T" "DIRECT" "EXECGRP" "EXECOTH" "EXECOWN" "F-DUPFD"
             "F-GETFD" "F-GETFL" "F-GETOWN" "F-SETFD" "F-SETFL" "F-SETOWN"
             "FAPPEND" "FASYNC" "FCREAT" "FEXCL" "FIONREAD" "FNDELAY" "FTRUNC"
             "F_OK" "GET-UNIX-ERROR-MSG" "GID-T" "INO-T" "IT-INTERVAL"
             "IT-VALUE" "ITIMERVAL" "UNIX-SETITIMER" "UNIX-GETITIMER"
	     "BLKCNT-T" "FSBLKCNT-T" "FSFILCNT-T"
	     "F_TEST" "F_TLOCK" "F_LOCK" "F_ULOCK" "UNIX-LOCKF"
	     "KBDCGET" "KBDCRESET" "KBDCRST" "KBDCSET"
             "KBDCSSTD" "KBDGCLICK" "KBDSCLICK" "KBDSGET" "L_INCR" "L_SET"
             "L_XTND" "OFF-T" "O_APPEND" "O_CREAT" "O_EXCL" "O_RDONLY" "O_RDWR"
             "O_TRUNC" "O_WRONLY" "READGRP" "READOTH" "READOWN" "RLIM-CUR"
             "RLIM-MAX" "RLIMIT" "RU-IDRSS" "RU-INBLOCK" "RU-ISRSS" "RU-IXRSS"
             "RU-MAJFLT" "RU-MAXRSS" "RU-MINFLT" "RU-MSGRCV" "RU-MSGSND"
             "RU-NIVCSW" "RU-NSIGNALS" "RU-NSWAP" "RU-NVCSW" "RU-OUBLOCK"
             "RU-STIME" "RU-UTIME" "RUSAGE_CHILDREN" "RUSAGE_SELF" "RUSEAGE"
             "R_OK" "S-IEXEC" "S-IFBLK" "S-IFCHR" "S-IFDIR" "S-IFLNK" "S-IFMT"
             "S-IFREG" "S-IFSOCK" "S-IREAD" "S-ISGID" "S-ISUID" "S-ISVTX"
             "S-IWRITE" "SAVETEXT" "SC-MASK" "SC-ONSTACK" "SC-PC" "SETGIDEXEC"
             "SETUIDEXEC" "SG-ERASE" "SG-FLAGS" "SG-ISPEED" "SG-KILL"
             "SG-OSPEED" "SGTTYB" "SIGCONTEXT" "SIZE-T" "ST-ATIME" "ST-BLKSIZE"
             "ST-BLOCKS" "ST-CTIME" "ST-DEV" "ST-GID" "ST-MODE" "ST-MTIME"
             "ST-NLINK" "ST-RDEV" "ST-SIZE" "ST-UID" "STAT" "SWBLK-T" "T-BRKC"
             "T-DSUSPC" "T-EOFC" "T-FLUSHC" "T-INTRC" "T-LNEXTC" "T-QUITC"
             "T-RPRNTC" "T-STARTC" "T-STOPC" "T-SUSPC" "T-WERASC" "TCHARS"
             "TERMINAL-SPEEDS" "TIME-T" "TIMEVAL" "TIMEZONE" "TIOCFLUSH"
             "TIOCGETC" "TIOCGETP" "TIOCGLTC" "TIOCGPGRP" "TIOCGWINSZ"
             "TIOCNOTTY" "TIOCSETC" "TIOCSETP" "TIOCSLTC" "TIOCSPGRP"
             "TIOCSWINSZ" "TTY-CBREAK" "TTY-CRMOD" "TTY-LCASE"
             "TTY-RAW" "TTY-TANDEM" "TV-SEC" "TV-USEC" "TZ-DSTTIME"
             "TZ-MINUTESWEST" "UID-T" "UNIX-ACCEPT" "UNIX-ACCESS" "UNIX-BIND"
             "UNIX-CHDIR" "UNIX-CHMOD" "UNIX-CHOWN" "UNIX-CLOSE" "UNIX-CONNECT"
             "UNIX-CREAT" "UNIX-CURRENT-DIRECTORY" "UNIX-DUP" "UNIX-DUP2"
             "UNIX-ERRNO" "UNIX-EXECVE" "UNIX-EXIT" "UNIX-FCHMOD" "UNIX-FCHOWN"
             "UNIX-FCNTL" "UNIX-FD" "UNIX-FILE-MODE" "UNIX-FORK" "UNIX-FSTAT"
             "UNIX-FSYNC" "UNIX-FTRUNCATE" "UNIX-GETDTABLESIZE" "UNIX-GETEGID"
             "UNIX-GETGID" "UNIX-GETHOSTID" "UNIX-GETHOSTNAME"
             "UNIX-GETPAGESIZE"  "UNIX-GETPEERNAME" "UNIX-GETPGRP"
	     "UNIX-GETPID" "UNIX-GETPPID" "UNIX-GETRUSAGE" "UNIX-GETSOCKNAME"
	     "UNIX-GETSOCKOPT" "UNIX-GETTIMEOFDAY" "UNIX-GETUID" "UNIX-GID"
             "UNIX-IOCTL" "UNIX-ISATTY" "UNIX-LINK" "UNIX-LISTEN" "UNIX-LSEEK"
             "UNIX-LSTAT" "UNIX-MKDIR" "UNIX-OPEN" "UNIX-PATHNAME" "UNIX-PID"
             "UNIX-PIPE" "UNIX-READ" "UNIX-READLINK" "UNIX-RECV" "UNIX-RENAME"
             "UNIX-RMDIR" "UNIX-SCHED-YIELD" "UNIX-SELECT"
	     "UNIX-SEND" "UNIX-SETPGID" "UNIX-SETPGRP"
             "UNIX-SETREGID" "UNIX-SETREUID" "UNIX-SETSOCKOPT" "UNIX-SOCKET"
	     "UNIX-STAT" "UNIX-SYMLINK" "UNIX-SYNC"
	     "UNIX-TIMES" "UNIX-TRUNCATE" "UNIX-TTYNAME" "UNIX-UID"
	     "UNIX-UNAME" "UNIX-UNLINK" "UNIX-UTIMES" "UNIX-WRITE" "WINSIZE"
             "WRITEGRP" "WRITEOTH" "WRITEOWN" "WS-COL" "WS-ROW" "WS-XPIXEL"
             "WS-YPIXEL" "W_OK" "X_OK" "SIGSYS" "TCSETPGRP" "FD-ZERO"
             "SIGEMSG" "SIGQUIT" "SIGCHLD" "SIGSEGV" "FD-CLR" "SIGUSR2"
             "EALREADY" "SIGPIPE" "EACCES" "CHECK" "SIGXCPU" "EOPNOTSUPP"
             "SIGFPE" "SIGHUP" "ENOTSOCK" "OPEN-DIR" "SIGMASK" "EINTR"
             "SIGCONT" "UNIX-RESOLVE-LINKS" "SIGKILL" "EMSGSIZE" "ERANGE"
             "EPROTOTYPE" "UNIX-SIGNAL-NUMBER" "EPFNOSUPPORT" "SIGILL"
             "EDOM" "UNIX-SIGPAUSE" "EDQUOT" "FD-SETSIZE" "SIGTSTP"
             "EAFNOSUPPORT" "TCGETPGRP" "EMFILE" "ECONNRESET"
             "EADDRNOTAVAIL" "SIGALRM" "ENETDOWN" "EVICEOP"
             "UNIX-FAST-GETRUSAGE" "EPERM" "SIGINT" "EXDEV" "EDEADLK"
             "ENOSPC" "ECONNREFUSED" "SIGWINCH" "ENOPROTOOPT" "ESRCH"
             "EUSERS" "SIGVTALRM" "ENOTCONN" "ESUCCESS" "EPIPE"
             "UNIX-SIMPLIFY-PATHNAME" "EISCONN" "FD-ISSET" "SIGMSG"
             "ESHUTDOWN" "EBUSY" "SIGTERM" "ENAMETOOLONG" "EMLINK"
             "EADDRINUSE" "SIGBUS" "ERESTART" "TTY-PROCESS-GROUP"
             "UNIX-SIGNAL-NAME" "ETIMEDOUT" "ECHILD" "EFBIG" "SIGTRAP"
             "UNIX-KILLPG" "ENOTBLK" "SIGIOT" "SIGUSR1" "ECONNABORTED"
             "EHOSTUNREACH" "EBADF" "EINVAL" "FD-SET" "CLOSE-DIR" "EISDIR"
             "SIGTTIN" "UNIX-KILL" "ENOTDIR" "EHOSTDOWN" "E2BIG" "ESPIPE"
             "UNIX-FAST-SELECT" "ENXIO" "ENOTTY" "ELOOP" "LTCHARS"
             "UNIX-SIGNAL-DESCRIPTION" "SIGXFSZ" "EINPROGRESS" "ENOENT"
             "EPROTONOSUPPORT" "UNIX-SIGBLOCK" "SIGIO" "ENOMEM" "SIGEMT"
             "EFAULT" "ENODEV" "EIO" "EVICEERR" "ETXTBSY" "EWOULDBLOCK"
             "EAGAIN" "EDESTADDRREQ" "ENOEXEC" "ENETUNREACH" "ENOTEMPTY"
             "READ-DIR" "UNIX-MAYBE-PREPEND-CURRENT-DIRECTORY" "ENFILE"
             "SIGTTOU" "EEXIST" "SIGPROF" "SIGSTOP" "ENETRESET" "SIGURG"
             "ENOBUFS" "EPROCLIM" "EROFS" "ETOOMANYREFS" "UNIX-FILE-KIND"
             "ELOCAL" "UNIX-SIGSETMASK" "EREMOTE" "ESOCKTNOSUPPORT"
	     "TIOCSIGSEND" "SIGWAITING" "SIGABRT"
	     "C-IFLAG" "UNIX-TCGETATTR" "C-LFLAG" "C-OFLAG" "C-CFLAG"
	     "TCSAFLUSH" "C-CC" "C-ISPEED" "C-OSPEED" "SIOCSPGRP" "TERMIOS"
	     "UNIX-TCSETATTR" "O_NDELAY" "O_NOCTTY"
             "O_NONBLOCK" "TCSANOW" "TCSADRAIN" "TCIFLUSH" "TCOFLUSH"
             "TCIOFLUSH" "UNIX-CFGETOSPEED" "UNIX-CFSETOSPEED"
             "UNIX-CFGETISPEED" "UNIX-CFSETISPEED"
             "TTY-IGNBRK" "TTY-BRKINT" "TTY-IGNPAR" "TTY-PARMRK"
             "TTY-INPCK" "TTY-ISTRIP" "TTY-INLCR" "TTY-IGNCR" "TTY-ICRNL"
             "TTY-IUCLC" "TTY-IXON" "TTY-IXANY" "TTY-IXOFF" "TTY-IENQAK"
             "TTY-IMAXBEL" "TTY-OPOST" "TTY-OLCUC" "TTY-ONLCR" "TTY-OCRNL"
             "TTY-ONOCR" "TTY-ONLRET" "TTY-OFILL" "TTY-OFDEL" "TTY-ISIG"
             "TTY-ICANON" "TTY-XCASE" "TTY-ECHO" "TTY-ECHOE" "TTY-ECHOK"
             "TTY-ECHONL" "TTY-NOFLSH" "TTY-IEXTEN" "TTY-TOSTOP" "TTY-ECHOCTL"
             "TTY-ECHOPRT" "TTY-ECHOKE"  "TTY-DEFECHO" "TTY-FLUSHO"
             "TTY-PENDIN" "TTY-CSTOPB" "TTY-CREAD" "TTY-PARENB" "TTY-PARODD"
             "TTY-HUPCL" "TTY-CLOCAL" "RCV1EN" "XMT1EN" "TTY-LOBLK" "VINTR"
             "VQUIT" "VERASE" "VKILL" "VEOF" "VEOL" "VEOL2" "TTY-CBAUD"
             "TTY-CSIZE" "TTY-CS5" "TTY-CS6" "TTY-CS7" "TTY-CS8" "VMIN" "VTIME"
             "VSUSP" "VSTART" "VSTOP" "VDSUSP" "UNIX-TCSENDBREAK"
             "UNIX-TCDRAIN" "UNIX-TCFLUSH" "UNIX-TCFLOW"
	     #+(or svr4 bsd linux) "O_NDELAY")
            #+(or svr4 linux)
            (:export "EADDRINUSE" "EADDRNOTAVAIL" "EADV" "EAFNOSUPPORT"
	     "EALREADY" "EBADE" "EBADFD" "EBADMSG" "EBADR" "EBADRQC"
	     "EBADSLT" "EBFONT" #+svr4 "ECANCELED" "ECHRNG" "ECOMM"
	     "ECONNABORTED" "ECONNREFUSED" "ECONNRESET" "EDEADLK"
	     "EDEADLOCK" "EDESTADDRREQ" #+linux "EDOTDOT" #+linux "EDQUOT"
	     "EHOSTDOWN" "EHOSTUNREACH" "EIDRM" "EILSEQ" "EINPROGRESS"
	     "EISCONN" #+linux "EISNAM" "EL2HLT" "EL2NSYNC" "EL3HLT"
	     "EL3RST" "ELIBACC" "ELIBBAD" "ELIBEXEC" "ELIBMAX" "ELIBSCN"
	     "ELNRNG" "ELOOP" "EMSGSIZE" "EMULTIHOP" "ENAMETOOLONG"
	     #+linux "ENAVAIL" "ENETDOWN" "ENETRESET" "ENETUNREACH" "ENOANO"
	     "ENOBUFS" "ENOCSI" "ENODATA" "ENOLCK" "ENOLINK" "ENOMSG" "ENONET"
	     "ENOPKG" "ENOPROTOOPT" "ENOSR" "ENOSTR" "ENOSYS" "ENOTCONN"
	     "ENOTEMPTY" #+linux "ENOTNAM" "ENOTSOCK" #+svr4 "ENOTSUP"
	     "ENOTUNIQ" "EOPNOTSUPP" "EOVERFLOW" "EPFNOSUPPORT" "EPROTO"
	     "EPROTONOSUPPORT" "EPROTOTYPE" "EREMCHG" "EREMOTE"
	     #+linux "EREMOTEIO" "ERESTART" "ESHUTDOWN" "ESOCKTNOSUPPORT"
	     "ESRMNT" "ESTALE" "ESTRPIPE" "ETIME" "ETIMEDOUT" "ETOOMANYREFS"
	     #+linux "EUCLEAN" "EUNATCH" "EUSERS" "EWOULDBLOCK" "EXFULL"
	     "UTSNAME"
	     #+linux "SIGSTKFLT"
             "UNIX-GETPWNAM" "UNIX-GETPWUID" "UNIX-GETGRNAM" "UNIX-GETGRGID"
             "USER-INFO" "USER-INFO-NAME" "USER-INFO-PASSWORD" "USER-INFO-UID"
             "USER-INFO-GID" "USER-INFO-GECOS" "USER-INFO-DIR" "USER-INFO-SHELL"
             "GROUP-INFO" "GROUP-INFO-NAME" "GROUP-INFO-GID" "GROUP-INFO-MEMBERS"))
  
(defpackage "FORMAT")
(defpackage "COMMON-LISP"
	    (:nicknames "CL" "LISP")
	    (:export "&ALLOW-OTHER-KEYS" "&AUX" "&BODY" "&ENVIRONMENT" "&KEY"
             "&OPTIONAL" "&REST" "&WHOLE" "*" "**" "***"
             "*BREAK-ON-SIGNALS*"
             "*COMPILE-FILE-PATHNAME*" "*COMPILE-FILE-TRUENAME*"
             "*COMPILE-PRINT*" "*COMPILE-VERBOSE*" "*DEBUG-IO*"
             "*DEBUGGER-HOOK*" "*DEFAULT-PATHNAME-DEFAULTS*"
	     "*ERROR-OUTPUT*"
             "*FEATURES*" "*GENSYM-COUNTER*" "*LOAD-PATHNAME*"
             "*LOAD-PRINT*" "*LOAD-TRUENAME*" "*LOAD-VERBOSE*"
             "*MACROEXPAND-HOOK*" "*MODULES*" "*PACKAGE*" "*PRINT-ARRAY*"
             "*PRINT-BASE*" "*PRINT-CASE*" "*PRINT-CIRCLE*"
             "*PRINT-ESCAPE*" "*PRINT-GENSYM*" "*PRINT-LENGTH*"
             "*PRINT-LEVEL*" "*PRINT-LINES*" "*PRINT-MISER-WIDTH*"
             "*PRINT-PPRINT-DISPATCH*" "*PRINT-PRETTY*" "*PRINT-RADIX*"
             "*PRINT-READABLY*" "*PRINT-RIGHT-MARGIN*" "*QUERY-IO*"
             "*RANDOM-STATE*" "*READ-BASE*" "*READ-DEFAULT-FLOAT-FORMAT*"
             "*READ-EVAL*" "*READ-SUPPRESS*" "*READTABLE*"
             "*STANDARD-INPUT*" "*STANDARD-OUTPUT*" "*TERMINAL-IO*"
             "*TRACE-OUTPUT*" "+" "++" "+++" "-" "/" "//" "///" "/=" "1+"
             "1-" "<" "<=" "=" ">" ">=" "ABORT" "ABS" "ACONS" "ACOS"
             "ACOSH" "ADJOIN" "ADJUST-ARRAY" "ADJUSTABLE-ARRAY-P"
             "ALPHA-CHAR-P" "ALPHANUMERICP" "AND" "APPEND" "APPLY"
	     "APROPOS" "APROPOS-LIST" "AREF" "ARITHMETIC-ERROR"
             "ARITHMETIC-ERROR-OPERANDS" "ARITHMETIC-ERROR-OPERATION"
             "ARRAY" "ARRAY-DIMENSION" "ARRAY-DIMENSION-LIMIT"
             "ARRAY-DIMENSIONS" "ARRAY-DISPLACEMENT" "ARRAY-ELEMENT-TYPE"
             "ARRAY-HAS-FILL-POINTER-P" "ARRAY-IN-BOUNDS-P" "ARRAY-RANK"
             "ARRAY-RANK-LIMIT" "ARRAY-ROW-MAJOR-INDEX" "ARRAY-TOTAL-SIZE"
             "ARRAY-TOTAL-SIZE-LIMIT" "ARRAYP" "ASH" "ASIN" "ASINH"
             "ASSERT" "ASSOC" "ASSOC-IF" "ASSOC-IF-NOT" "ATAN" "ATANH"
             "ATOM" "BASE-CHAR" "BASE-STRING" "BIGNUM"
             "BIT" "BIT-AND" "BIT-ANDC1" "BIT-ANDC2" "BIT-EQV" "BIT-IOR"
             "BIT-NAND" "BIT-NOR" "BIT-NOT" "BIT-ORC1" "BIT-ORC2"
             "BIT-VECTOR" "BIT-VECTOR-P" "BIT-XOR" "BLOCK" "BOOLE" "BOOLEAN"
             "BOOLE-1" "BOOLE-2" "BOOLE-AND" "BOOLE-ANDC1" "BOOLE-ANDC2"
             "BOOLE-C1" "BOOLE-C2" "BOOLE-CLR" "BOOLE-EQV" "BOOLE-IOR"
             "BOOLE-NAND" "BOOLE-NOR" "BOOLE-ORC1" "BOOLE-ORC2" "BOOLE-SET"
             "BOOLE-XOR" "BOTH-CASE-P" "BOUNDP" "BREAK" 
	     "BROADCAST-STREAM" "BROADCAST-STREAM-STREAMS" "BUILT-IN-CLASS"
	     "BUTLAST" "BYTE" "BYTE-POSITION" "BYTE-SIZE"
	     "CAAAAR" "CAAADR" "CAAAR" "CAADAR" "CAADDR" "CAADR" "CAAR"
	     "CADAAR" "CADADR" "CADAR" "CADDAR" "CADDDR" "CADDR" "CADR"
	     "CALL-ARGUMENTS-LIMIT" "CAR" "CASE"
             "CATCH" "CCASE" "CDAAAR" "CDAADR" "CDAAR" "CDADAR" "CDADDR"
             "CDADR" "CDAR" "CDDAAR" "CDDADR" "CDDAR" "CDDDAR" "CDDDDR"
             "CDDDR" "CDDR" "CDR" "CEILING" "CELL-ERROR" "CERROR" "CHAR"
	     "CHAR-CODE" "CHAR-CODE-LIMIT" "CHAR-DOWNCASE"
             "CHAR-EQUAL" "CHAR-GREATERP" "CHAR-INT" "CHAR-LESSP" 
             "CHAR-NAME" "CHAR-NOT-EQUAL" "CHAR-NOT-GREATERP"
             "CHAR-NOT-LESSP" "CHAR-UPCASE" "CHAR/="
             "CHAR<" "CHAR<=" "CHAR=" "CHAR>" "CHAR>=" "CHARACTER"
             "CHARACTERP" "CHECK-TYPE" "CIS" "CLASS" "CLASS-OF" "CLASS-NAME"
	     "CLEAR-INPUT" "CLEAR-OUTPUT"
             "CLOSE" "CLRHASH" "CODE-CHAR" "COERCE"
             "COMPILATION-SPEED" "COMPILE" "COMPILE-FILE"
	     "COMPILE-FILE-PATHNAME"
             "COMPILED-FUNCTION" "COMPILED-FUNCTION-P"
	     "COMPILER-MACRO" "COMPILER-MACRO-FUNCTION"
	     "COMPLEMENT" "COMPLEX"
	     "COMPLEXP" "COMPUTE-RESTARTS" "CONCATENATE"
	     "CONCATENATED-STREAM" "CONCATENATED-STREAM-STREAMS"
	     "COND" "CONDITION"
             "CONJUGATE" "CONS" "CONSP" "CONSTANTLY" "CONSTANTP" "CONTINUE"
             "CONTROL-ERROR" "COPY-ALIST" "COPY-LIST"
             "COPY-PPRINT-DISPATCH" "COPY-READTABLE" "COPY-SEQ"
	     "COPY-STRUCTURE"
             "COPY-SYMBOL" "COPY-TREE" "COS" "COSH" "COUNT" "COUNT-IF"
             "COUNT-IF-NOT" "CTYPECASE" "DEBUG" "DECF" "DECLAIM"
             "DECLARATION" "DECLARE" "DECODE-FLOAT" "DECODE-UNIVERSAL-TIME"
             "DEFCONSTANT" "DEFINE-COMPILER-MACRO" "DEFINE-CONDITION"
             "DEFINE-MODIFY-MACRO" "DEFINE-SYMBOL-MACRO"
	     "DEFMACRO" "DEFPACKAGE"
             "DEFPARAMETER" "DEFSETF" "DEFSTRUCT" "DEFTYPE" "DEFUN" "DEFVAR"
             "DELETE" "DELETE-DUPLICATES" "DELETE-FILE" "DELETE-IF"
             "DELETE-IF-NOT" "DELETE-PACKAGE"
	     "DENOMINATOR" "DEPOSIT-FIELD" "DESCRIBE"
             "DESTRUCTURING-BIND" "DIGIT-CHAR" "DIGIT-CHAR-P" "DIRECTORY"
             "DIRECTORY-NAMESTRING" "DISASSEMBLE" "DIVISION-BY-ZERO" "DO" "DO*"
             "DO-ALL-SYMBOLS" "DO-EXTERNAL-SYMBOLS" "DO-SYMBOLS"
             "DOCUMENTATION" "DOLIST" "DOTIMES" "DOUBLE-FLOAT"
             "DOUBLE-FLOAT-EPSILON" "DOUBLE-FLOAT-NEGATIVE-EPSILON" "DPB"
             "DRIBBLE" "DYNAMIC-EXTENT"
	     "ECASE" "ECHO-STREAM" "ECHO-STREAM-INPUT-STREAM"
	     "ECHO-STREAM-OUTPUT-STREAM"
	     "ED" "EIGHTH" "ELT" "ENCODE-UNIVERSAL-TIME"
             "END-OF-FILE" "ENDP" "ENOUGH-NAMESTRING"
	     "ENSURE-DIRECTORIES-EXIST" "EQ" "EQL" "EQUAL"
             "EQUALP" "ERROR" "ETYPECASE" "EVAL" "EVAL-WHEN" "EVENP"
             "EVERY" "EXP" "EXPORT" "EXPT" "EXTENDED-CHAR" "FBOUNDP" "FCEILING"
             "FDEFINITION" "FFLOOR" "FIFTH" "FILE-AUTHOR" "FILE-ERROR"
             "FILE-ERROR-PATHNAME" "FILE-LENGTH" "FILE-NAMESTRING"
             "FILE-POSITION" "FILE-STREAM" "FILE-STRING-LENGTH"
	     "FILE-WRITE-DATE" "FILL" "FILL-POINTER" "FIND"
             "FIND-ALL-SYMBOLS" "FIND-CLASS"
	     "FIND-IF" "FIND-IF-NOT" "FIND-PACKAGE"
             "FIND-RESTART" "FIND-SYMBOL" "FINISH-OUTPUT" "FIRST" "FIXNUM"
             "FLET" "FLOAT" "FLOAT-DIGITS" "FLOAT-PRECISION" "FLOAT-RADIX"
             "FLOAT-SIGN" "FLOATING-POINT-INEXACT"
	     "FLOATING-POINT-INVALID-OPERATION"
	     "FLOATING-POINT-OVERFLOW" "FLOATING-POINT-UNDERFLOW"
             "FLOATP" "FLOOR" "FMAKUNBOUND" "FORCE-OUTPUT" "FORMAT" "FORMATTER"
             "FOURTH" "FRESH-LINE" "FROUND" "FTRUNCATE" "FTYPE" "FUNCALL"
             "FUNCTION" "FUNCTION-LAMBDA-EXPRESSION" "FUNCTIONP"
	     "GCD" "GENERIC-FUNCTION" "GENSYM"
             "GENTEMP" "GET" "GET-DECODED-TIME" "GET-DISPATCH-MACRO-CHARACTER"
             "GET-INTERNAL-REAL-TIME" "GET-INTERNAL-RUN-TIME"
             "GET-MACRO-CHARACTER" "GET-OUTPUT-STREAM-STRING" "GET-PROPERTIES"
             "GET-UNIVERSAL-TIME" "GETF" "GETHASH" "GO" "GRAPHIC-CHAR-P"
             "HANDLER-BIND" "HANDLER-CASE" "HASH-TABLE" "HASH-TABLE-COUNT"
             "HASH-TABLE-P" "HASH-TABLE-REHASH-THRESHOLD"
	     "HASH-TABLE-REHASH-SIZE" "HASH-TABLE-SIZE" "HASH-TABLE-TEST"
	     "HOST-NAMESTRING" "IDENTITY" "IF" "IGNORABLE"
             "IGNORE" "IGNORE-ERRORS" "IMAGPART" "IMPORT" "IN-PACKAGE"
	     "INTERACTIVE-STREAM-P" "INCF"
             "INLINE" "INPUT-STREAM-P" "INSPECT" "INTEGER"
             "INTEGER-DECODE-FLOAT" "INTEGER-LENGTH" "INTEGERP" "INTERN"
             "INTERNAL-TIME-UNITS-PER-SECOND" "INTERSECTION" "INVOKE-DEBUGGER"
             "INVOKE-RESTART" "INVOKE-RESTART-INTERACTIVELY" "ISQRT" "KEYWORD"
             "KEYWORDP" "LABELS" "LAMBDA" "LAMBDA-LIST-KEYWORDS"
             "LAMBDA-PARAMETERS-LIMIT" "LAST" "LCM" "LDB" "LDB-TEST" "LDIFF"
             "LEAST-NEGATIVE-DOUBLE-FLOAT" "LEAST-NEGATIVE-LONG-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT"
	     "LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT"
             "LEAST-NEGATIVE-SHORT-FLOAT" "LEAST-NEGATIVE-SINGLE-FLOAT"
             "LEAST-POSITIVE-DOUBLE-FLOAT" "LEAST-POSITIVE-LONG-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-LONG-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT"
             "LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT"
             "LEAST-POSITIVE-SHORT-FLOAT" "LEAST-POSITIVE-SINGLE-FLOAT"
             "LENGTH" "LET" "LET*" "LISP-IMPLEMENTATION-TYPE"
             "LISP-IMPLEMENTATION-VERSION" "LIST" "LIST*" "LIST-ALL-PACKAGES"
             "LIST-LENGTH" "LISTEN" "LISTP" "LOAD"
	     "LOAD-LOGICAL-PATHNAME-TRANSLATIONS" "LOAD-TIME-VALUE" "LOCALLY"
             "LOG" "LOGAND" "LOGANDC1" "LOGANDC2" "LOGBITP" "LOGCOUNT" "LOGEQV"
	     "LOGICAL-PATHNAME" "LOGICAL-PATHNAME-TRANSLATIONS"
	     "LOGIOR" "LOGNAND" "LOGNOR" "LOGNOT" "LOGORC1" "LOGORC2" "LOGTEST"
             "LOGXOR" "LONG-FLOAT" "LONG-FLOAT-EPSILON"
             "LONG-FLOAT-NEGATIVE-EPSILON" "LONG-SITE-NAME" "LOOP"
             "LOOP-FINISH" "LOWER-CASE-P" "MACHINE-INSTANCE" "MACHINE-TYPE"
             "MACHINE-VERSION" "MACRO-FUNCTION" "MACROEXPAND" "MACROEXPAND-1"
             "MACROLET" "MAKE-ARRAY" "MAKE-BROADCAST-STREAM"
             "MAKE-CONCATENATED-STREAM" "MAKE-CONDITION"
             "MAKE-DISPATCH-MACRO-CHARACTER" "MAKE-ECHO-STREAM"
             "MAKE-HASH-TABLE" "MAKE-LIST" "MAKE-PACKAGE" "MAKE-PATHNAME"
             "MAKE-RANDOM-STATE" "MAKE-SEQUENCE" "MAKE-STRING"
             "MAKE-STRING-INPUT-STREAM" "MAKE-STRING-OUTPUT-STREAM"
             "MAKE-SYMBOL" "MAKE-SYNONYM-STREAM" "MAKE-TWO-WAY-STREAM"
             "MAKUNBOUND" "MAP" "MAP-INTO" "MAPC" "MAPCAN" "MAPCAR" "MAPCON"
	     "MAPHASH" "MAPL" "MAPLIST" "MASK-FIELD" "MAX" "MEMBER" "MEMBER-IF"
             "MEMBER-IF-NOT" "MERGE" "MERGE-PATHNAMES" "MIN" "MINUSP"
             "MISMATCH" "MOD" "MOST-NEGATIVE-DOUBLE-FLOAT"
             "MOST-NEGATIVE-FIXNUM" "MOST-NEGATIVE-LONG-FLOAT"
             "MOST-NEGATIVE-SHORT-FLOAT" "MOST-NEGATIVE-SINGLE-FLOAT"
             "MOST-POSITIVE-DOUBLE-FLOAT" "MOST-POSITIVE-FIXNUM"
             "MOST-POSITIVE-LONG-FLOAT" "MOST-POSITIVE-SHORT-FLOAT"
             "MOST-POSITIVE-SINGLE-FLOAT" "MUFFLE-WARNING"
             "MULTIPLE-VALUE-BIND" "MULTIPLE-VALUE-CALL" "MULTIPLE-VALUE-LIST"
             "MULTIPLE-VALUE-PROG1" "MULTIPLE-VALUE-SETQ"
             "MULTIPLE-VALUES-LIMIT" "NAME-CHAR" "NAMESTRING" "NBUTLAST"
             "NCONC" "NIL" "NINTERSECTION" "NINTH" "NOT" "NOTANY" "NOTEVERY"
             "NOTINLINE" "NRECONC" "NREVERSE" "NSET-DIFFERENCE"
             "NSET-EXCLUSIVE-OR" "NSTRING-CAPITALIZE" "NSTRING-DOWNCASE"
             "NSTRING-UPCASE" "NSUBLIS" "NSUBST" "NSUBST-IF" "NSUBST-IF-NOT"
             "NSUBSTITUTE" "NSUBSTITUTE-IF" "NSUBSTITUTE-IF-NOT" "NTH"
             "NTH-VALUE" "NTHCDR" "NULL" "NUMBER" "NUMBERP" "NUMERATOR"
             "NUNION" "ODDP" "OPEN" "OPEN-STREAM-P" "OPTIMIZE" "OR" "OTHERWISE"
             "OUTPUT-STREAM-P" "PACKAGE" "PACKAGE-ERROR"
             "PACKAGE-ERROR-PACKAGE" "PACKAGE-NAME" "PACKAGE-NICKNAMES"
             "PACKAGE-SHADOWING-SYMBOLS" "PACKAGE-USE-LIST"
             "PACKAGE-USED-BY-LIST" "PACKAGEP" "PAIRLIS" "PARSE-ERROR" 
	     "PARSE-INTEGER" "PARSE-NAMESTRING" "PATHNAME" "PATHNAME-DEVICE"
             "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-MATCH-P"
             "PATHNAME-NAME" "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMEP"
             "PEEK-CHAR" "PHASE" "PI" "PLUSP" "POP" "POSITION" "POSITION-IF"
             "POSITION-IF-NOT" "PPRINT" "PPRINT-DISPATCH"
             "PPRINT-EXIT-IF-LIST-EXHAUSTED" "PPRINT-FILL" "PPRINT-INDENT"
             "PPRINT-LINEAR" "PPRINT-LOGICAL-BLOCK" "PPRINT-NEWLINE"
             "PPRINT-POP" "PPRINT-TAB" "PPRINT-TABULAR" "PRIN1"
             "PRIN1-TO-STRING" "PRINC" "PRINC-TO-STRING" "PRINT"
             "PRINT-UNREADABLE-OBJECT" "PROBE-FILE" "PROCLAIM" "PROG" "PROG*"
             "PROG1" "PROG2" "PROGN" "PROGRAM-ERROR" "PROGV" "PROVIDE" "PSETF"
             "PSETQ" "PUSH" "PUSHNEW" "QUOTE" "RANDOM" "RANDOM-STATE"
             "RANDOM-STATE-P" "RASSOC" "RASSOC-IF" "RASSOC-IF-NOT" "RATIO"
             "RATIONAL" "RATIONALIZE" "RATIONALP" "READ" "READ-BYTE"
             "READ-CHAR" "READ-CHAR-NO-HANG" "READ-DELIMITED-LIST"
             "READ-FROM-STRING" "READ-LINE" "READ-PRESERVING-WHITESPACE"
	     "READ-SEQUENCE"
	     "READER-ERROR" "READTABLE" "READTABLE-CASE" "READTABLEP" "REAL"
	     "REALP" "REALPART" "REDUCE" "REM" "REMF" "REMHASH"
             "REMOVE" "REMOVE-DUPLICATES" "REMOVE-IF" "REMOVE-IF-NOT"
             "REMPROP" "RENAME-FILE" "RENAME-PACKAGE" "REPLACE" "REQUIRE"
             "REST" "RESTART" "RESTART-BIND" "RESTART-CASE" "RESTART-NAME"
             "RETURN" "RETURN-FROM" "REVAPPEND" "REVERSE" "ROOM" "ROTATEF"
             "ROUND" "ROW-MAJOR-AREF" "RPLACA" "RPLACD" "SAFETY"
             "SATISFIES" "SBIT" "SCALE-FLOAT" "SCHAR" "SEARCH" "SECOND"
             "SEQUENCE" "SERIOUS-CONDITION" "SET"
             "SET-DIFFERENCE" "SET-DISPATCH-MACRO-CHARACTER"
             "SET-EXCLUSIVE-OR" "SET-MACRO-CHARACTER" "SET-PPRINT-DISPATCH"
             "SET-SYNTAX-FROM-CHAR" "SETF" "SETQ" "SEVENTH" "SHADOW"
             "SHADOWING-IMPORT" "SHIFTF" "SHORT-FLOAT"
             "SHORT-FLOAT-EPSILON" "SHORT-FLOAT-NEGATIVE-EPSILON"
             "SHORT-SITE-NAME" "SIGNAL" "SIGNED-BYTE" "SIGNUM"
             "SIMPLE-ARRAY" "SIMPLE-BASE-STRING" "SIMPLE-BIT-VECTOR"
             "SIMPLE-BIT-VECTOR-P" "SIMPLE-CONDITION"
             "SIMPLE-CONDITION-FORMAT-ARGUMENTS"
	     "SIMPLE-CONDITION-FORMAT-CONTROL"
	     "SIMPLE-ERROR"
             "SIMPLE-STRING" "SIMPLE-STRING-P" "SIMPLE-TYPE-ERROR"
             "SIMPLE-VECTOR" "SIMPLE-VECTOR-P" "SIMPLE-WARNING" "SIN"
             "SINGLE-FLOAT" "SINGLE-FLOAT-EPSILON"
             "SINGLE-FLOAT-NEGATIVE-EPSILON" "SINH" "SIXTH" "SLEEP"
             "SOFTWARE-TYPE" "SOFTWARE-VERSION" "SOME" "SORT" "SPACE"
             "SPECIAL" "SPECIAL-OPERATOR-P" "SPEED" "SQRT" "STABLE-SORT"
             "STANDARD-CHAR" "STANDARD-CHAR-P" "STEP"
             "STORAGE-CONDITION" "STORE-VALUE" "STREAM"
             "STREAM-ELEMENT-TYPE" "STREAM-ERROR" "STREAM-ERROR-STREAM"
	     "STREAM-EXTERNAL-FORMAT"
	     "STREAMP" "STRING" "STRING-CAPITALIZE"
             "STRING-DOWNCASE" "STRING-EQUAL"
             "STRING-GREATERP" "STRING-LEFT-TRIM" "STRING-LESSP"
             "STRING-NOT-EQUAL" "STRING-NOT-GREATERP" "STRING-NOT-LESSP"
             "STRING-RIGHT-TRIM" "STRING-STREAM"
	     "STRING-TRIM" "STRING-UPCASE" "STRING/="
             "STRING<" "STRING<=" "STRING=" "STRING>" "STRING>=" "STRINGP"
             "STRUCTURE" "STRUCTURE-CLASS" "STRUCTURE-OBJECT"
	     "SUBLIS" "SUBSEQ" "SUBSETP" "SUBST" "SUBST-IF"
             "SUBST-IF-NOT" "SUBSTITUTE" "SUBSTITUTE-IF"
             "SUBSTITUTE-IF-NOT" "SUBTYPEP" "SVREF" "SXHASH" "SYMBOL"
             "SYMBOL-FUNCTION" "SYMBOL-MACROLET" "SYMBOL-NAME"
             "SYMBOL-PACKAGE" "SYMBOL-PLIST" "SYMBOL-VALUE" "SYMBOLP"
	     "SYNONYM-STREAM" "SYNONYM-STREAM-SYMBOL" "T"
             "TAGBODY" "TAILP" "TAN" "TANH" "TENTH" "TERPRI" "THE" "THIRD"
             "THROW" "TIME" "TRACE" "TRANSLATE-LOGICAL-PATHNAME"
	     "TRANSLATE-PATHNAME" "TREE-EQUAL"
             "TRUENAME" "TRUNCATE" "TWO-WAY-STREAM"
	     "TWO-WAY-STREAM-INPUT-STREAM" "TWO-WAY-STREAM-OUTPUT-STREAM"
	     "TYPE" "TYPE-ERROR" "TYPE-ERROR-DATUM"
             "TYPE-ERROR-EXPECTED-TYPE" "TYPE-OF" "TYPECASE" "TYPEP"
             "UNBOUND-VARIABLE" "UNDEFINED-FUNCTION" "UNEXPORT" "UNINTERN"
             "UNION" "UNLESS" "UNREAD-CHAR" "UNSIGNED-BYTE" "UNTRACE"
             "UNUSE-PACKAGE" "UNWIND-PROTECT" "UPGRADED-ARRAY-ELEMENT-TYPE"
	     "UPGRADED-COMPLEX-PART-TYPE" "UPPER-CASE-P"
             "USE-PACKAGE" "USE-VALUE" "USER-HOMEDIR-PATHNAME" "VALUES"
             "VALUES-LIST" "VARIABLE" "VECTOR" "VECTOR-POP" "VECTOR-PUSH"
             "VECTOR-PUSH-EXTEND" "VECTORP" "WARN" "WARNING" "WHEN"
             "WILD-PATHNAME-P" "WITH-COMPILATION-UNIT"
	     "WITH-CONDITION-RESTARTS"
             "WITH-HASH-TABLE-ITERATOR" "WITH-INPUT-FROM-STRING"
             "WITH-OPEN-FILE" "WITH-OPEN-STREAM" "WITH-OUTPUT-TO-STRING"
             "WITH-PACKAGE-ITERATOR" "WITH-SIMPLE-RESTART"
             "WITH-STANDARD-IO-SYNTAX" "WRITE" "WRITE-BYTE" "WRITE-CHAR"
             "WRITE-LINE" "WRITE-STRING" "WRITE-TO-STRING"
	     "WRITE-SEQUENCE" "Y-OR-N-P" "YES-OR-NO-P" "ZEROP"

             "ADD-METHOD" "ALLOCATE-INSTANCE" "CALL-METHOD"
             "CALL-NEXT-METHOD" "CHANGE-CLASS"
             "COMPUTE-APPLICABLE-METHODS" "DEFCLASS" "DEFGENERIC"
             "DEFINE-METHOD-COMBINATION" "DEFMETHOD" "DESCRIBE-OBJECT"
	     "ENSURE-GENERIC-FUNCTION"
	     "FIND-METHOD" "FUNCTION-KEYWORDS"
	     "INITIALIZE-INSTANCE" "INVALID-METHOD-ERROR"
             "MAKE-INSTANCE" "MAKE-INSTANCES-OBSOLETE"
             "METHOD-COMBINATION-ERROR" "METHOD-QUALIFIERS" "NEXT-METHOD-P"
             "NO-APPLICABLE-METHOD" "NO-NEXT-METHOD" "PRINT-OBJECT"
             "REINITIALIZE-INSTANCE" "REMOVE-METHOD" "SHARED-INITIALIZE"
             "SLOT-BOUNDP" "SLOT-EXISTS-P" "SLOT-MAKUNBOUND" "SLOT-MISSING"
             "SLOT-UNBOUND" "SLOT-VALUE" "STANDARD" "STANDARD-CLASS"
             "STANDARD-GENERIC-FUNCTION" "STANDARD-METHOD" "STANDARD-OBJECT"
	     "UPDATE-INSTANCE-FOR-DIFFERENT-CLASS"
             "UPDATE-INSTANCE-FOR-REDEFINED-CLASS" "WITH-ACCESSORS" "WITH-SLOTS"
	     "MAKE-METHOD" "UNBOUND-SLOT" "UNBOUND-SLOT-INSTANCE"
             "CELL-ERROR-NAME"
             "GET-SETF-EXPANSION" "STYLE-WARNING" 
             "PRINT-NOT-READABLE-OBJECT"
             "DEFINE-SETF-EXPANDER" "PRINT-NOT-READABLE" "METHOD"
	     "METHOD-COMBINATION" 
	     "MAKE-LOAD-FORM" "MAKE-LOAD-FORM-SAVING-SLOTS"))

(defpackage "EVAL"
            (:export "*EVAL-STACK-TRACE*" "*INTERNAL-APPLY-NODE-TRACE*"
             "*INTERPRETED-FUNCTION-CACHE-MINIMUM-SIZE*"
             "*INTERPRETED-FUNCTION-CACHE-THRESHOLD*"
             "FLUSH-INTERPRETED-FUNCTION-CACHE" "INTERNAL-EVAL"
	     "INTERPRETED-FUNCTION"
             "INTERPRETED-FUNCTION-ARGLIST" "INTERPRETED-FUNCTION-CLOSURE"
             "INTERPRETED-FUNCTION-LAMBDA-EXPRESSION"
             "INTERPRETED-FUNCTION-NAME" "INTERPRETED-FUNCTION-P"
             "INTERPRETED-FUNCTION-TYPE" "MAKE-INTERPRETED-FUNCTION"
             "TRACE-EVAL"))
(dolist
    (name
     '("%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD"
       "%SBITSET" "%SCHARSET" "%SET-FDEFINITION"
       "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH"
       "%SP-STRING-COMPARE" "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
       "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
       "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM"
       "READ-ONLY-SPACE-START" "SHORT-FLOAT-P" "STATIC-SPACE-START"
       "STRING/=*" "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"))
  (intern name "LISP"))
(dolist (name '("%PRIMITIVE" "%STANDARD-CHAR-P"))
  (intern name "SYSTEM"))
(intern "BIGNUM-TYPE" "BIGNUM")
(dolist
    (name
     '("%SP-SET-DEFINITION" "%SP-SET-PLIST" "ARRAY-HEADER-P" "BASE-CHAR-P"
       "DOUBLE-FLOAT-P" "LONG-FLOAT-P" "SIMPLE-ARRAY-P" "SINGLE-FLOAT-P"))
  (intern name "KERNEL"))
(defpackage #+pmax "PMAX"
	    #+sparc "SPARC"
	    #+ibmrt "RT"
            #+x86 "X86"
	    #+hppa "HPPA"
	    #+alpha "ALPHA"
	    #+sgi "SGI"
	    #+ppc "PPC"
            (:nicknames "VM" #+(or pmax sgi) "MIPS")
            (:import-from "LISP" "%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET"
             "%PUT" "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET"
             "%SET-FDEFINITION" "%SET-FILL-POINTER"
             "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
             "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
             "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
             "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM"
             "READ-ONLY-SPACE-START" "SHORT-FLOAT-P" "STATIC-SPACE-START"
	     "STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
             "STRING>*" "STRING>=*")
  (:export "*ASSEMBLY-UNIT-LENGTH*" "*PRIMITIVE-OBJECTS*"
	   "AFTER-BREAKPOINT-TRAP"
	   "ANY-REG-SC-NUMBER" "ARRAY-DATA-SLOT" "ARRAY-DIMENSIONS-OFFSET"
	   "ARRAY-DISPLACED-P-SLOT" "ARRAY-DISPLACEMENT-SLOT"
	   "ARRAY-ELEMENTS-SLOT" "ARRAY-FILL-POINTER-P-SLOT"
	   "ARRAY-FILL-POINTER-SLOT" "ATOMIC-FLAG" "BASE-CHAR-REG-SC-NUMBER"
	   "BASE-CHAR-STACK-SC-NUMBER" "BASE-CHAR-TYPE"
	   "BIGNUM-DIGITS-OFFSET" "BIGNUM-TYPE" "BINDING-SIZE"
	   "BINDING-SYMBOL-SLOT" "BINDING-VALUE-SLOT" "BREAKPOINT-TRAP"
	   "BYTE-CODE-CLOSURE-TYPE" "BYTE-CODE-FUNCTION-TYPE"
	   "BYTE-BITS" "BYTE-REG-SC-NUMBER"
	   "CATCH-BLOCK-CURRENT-CODE-SLOT"
	   "CATCH-BLOCK-CURRENT-CONT-SLOT" "CATCH-BLOCK-CURRENT-UWP-SLOT"
	   "CATCH-BLOCK-ENTRY-PC-SLOT" "CATCH-BLOCK-PREVIOUS-CATCH-SLOT"
	   "CATCH-BLOCK-SC-NUMBER" "CATCH-BLOCK-SIZE" "CATCH-BLOCK-SIZE-SLOT"
	   "CATCH-BLOCK-TAG-SLOT" "CERROR-TRAP"
	   "CLOSURE-FUNCTION-HEADER-TYPE" "CLOSURE-FUNCTION-SLOT"
	   "CLOSURE-HEADER-TYPE" "CLOSURE-INFO-OFFSET" "CODE-BREAKDOWN"
	   "CODE-CODE-SIZE-SLOT" "CODE-CONSTANTS-OFFSET"
	   "CODE-DEBUG-INFO-SLOT" "CODE-ENTRY-POINTS-SLOT" "CODE-HEADER-TYPE"
	   "CODE-TRACE-TABLE-OFFSET-SLOT" "COMPLEX-ARRAY-TYPE"
	   "COMPLEX-BIT-VECTOR-TYPE" "COMPLEX-DOUBLE-FLOAT-FILLER-SLOT"
	   "COMPLEX-DOUBLE-FLOAT-IMAG-SLOT" "COMPLEX-DOUBLE-FLOAT-REAL-SLOT"
	   "COMPLEX-DOUBLE-FLOAT-SIZE" "COMPLEX-DOUBLE-FLOAT-TYPE"
	   "COMPLEX-DOUBLE-REG-SC-NUMBER" "COMPLEX-DOUBLE-STACK-SC-NUMBER" 
	   "COMPLEX-IMAG-SLOT" "COMPLEX-REAL-SLOT"
	   "COMPLEX-LONG-FLOAT-IMAG-SLOT" "COMPLEX-LONG-FLOAT-REAL-SLOT"
	   "COMPLEX-LONG-FLOAT-SIZE" "COMPLEX-LONG-FLOAT-TYPE"
	   "COMPLEX-LONG-REG-SC-NUMBER" "COMPLEX-LONG-STACK-SC-NUMBER" 
	   "COMPLEX-SINGLE-FLOAT-IMAG-SLOT" "COMPLEX-SINGLE-FLOAT-REAL-SLOT"
	   "COMPLEX-SINGLE-FLOAT-SIZE" "COMPLEX-SINGLE-FLOAT-TYPE"
	   "COMPLEX-SINGLE-REG-SC-NUMBER" "COMPLEX-SINGLE-STACK-SC-NUMBER"
	   "COMPLEX-SIZE" "COMPLEX-STRING-TYPE" "COMPLEX-TYPE"
	   "COMPLEX-VECTOR-TYPE" "CONS-CAR-SLOT" "CONS-CDR-SLOT" "CONS-SIZE"
	   "CONSTANT-SC-NUMBER" "CONTROL-STACK-FORK" "CONTROL-STACK-RESUME"
	   "CONTROL-STACK-RETURN" "CONTROL-STACK-SC-NUMBER" "COUNT-NO-OPS"
	   "CURRENT-FLOAT-TRAP" "DEFINE-FOR-EACH-PRIMITIVE-OBJECT"
	   "DESCRIPTOR-REG-SC-NUMBER" "DESCRIPTOR-VS-NON-DESCRIPTOR-STORAGE"
	   "DOUBLE-FLOAT-EXPONENT-BYTE" "DOUBLE-FLOAT-BIAS"
	   "DOUBLE-FLOAT-DIGITS" "DOUBLE-FLOAT-EXPONENT-BYTE"
	   "DOUBLE-FLOAT-FILLER-SLOT" "DOUBLE-FLOAT-HIDDEN-BIT"
	   "DOUBLE-FLOAT-NORMAL-EXPONENT-MAX"
	   "DOUBLE-FLOAT-NORMAL-EXPONENT-MIN" "DOUBLE-FLOAT-SIGNIFICAND-BYTE"
	   "DOUBLE-FLOAT-SIZE" "DOUBLE-FLOAT-TRAPPING-NAN-BIT"
	   "DOUBLE-FLOAT-TYPE" "DOUBLE-FLOAT-VALUE-SLOT"
	   "DOUBLE-INT-CARG-REG-SC-NUMBER" "DOUBLE-REG-SC-NUMBER"
	   "DOUBLE-STACK-SC-NUMBER" "DYLAN-FUNCTION-HEADER-TYPE"
	   "ERROR-TRAP" "EVEN-FIXNUM-TYPE"
	   "EXPORTED-STATIC-SYMBOLS" "EXTERN-ALIEN-NAME"
	   "FDEFN-FUNCTION-SLOT" "FDEFN-NAME-SLOT" "FDEFN-RAW-ADDR-SLOT"
	   "FDEFN-SIZE" "FDEFN-TYPE" "FIND-HOLES" "FIXNUM"
	   "FIXUP-CODE-OBJECT" "FLOAT-DENORMAL-TRAP-BIT"
	   "FLOAT-DIVIDE-BY-ZERO-TRAP-BIT"
	   "FLOAT-IMPRECISE-TRAP-BIT" "FLOAT-INVALID-TRAP-BIT"
	   "FLOAT-OVERFLOW-TRAP-BIT" "FLOAT-SIGN-SHIFT"
	   "FLOAT-UNDERFLOW-TRAP-BIT" "FLOATING-POINT-MODES"
	   "FORWARDING-POINTER-TYPE"
	   "FP-CONSTANT-SC-NUMBER"
	   "FP-DOUBLE-ZERO-SC-NUMBER" "FP-SINGLE-ZERO-SC-NUMBER"
	   "FUNCALLABLE-INSTANCE-FUNCTION-SLOT"
	   "FUNCALLABLE-INSTANCE-HEADER-TYPE" 
	   "FUNCALLABLE-INSTANCE-INFO-OFFSET"
	   "FUNCTION-ARGLIST-SLOT" "FUNCTION-CODE-OFFSET"
	   "FUNCTION-END-BREAKPOINT-TRAP" "FUNCTION-HEADER-TYPE"
	   "FUNCTION-NAME-SLOT" "FUNCTION-NEXT-SLOT" "FUNCTION-POINTER-TYPE"
	   "FUNCTION-SELF-SLOT" "FUNCTION-TYPE-SLOT"
	   "FUNCALLABLE-INSTANCE-LAYOUT-SLOT"
	   "FUNCALLABLE-INSTANCE-LEXENV-SLOT"
	   "GENESIS" "HALT-TRAP" "IGNORE-ME-SC-NUMBER"
	   "IMMEDIATE-BASE-CHAR-SC-NUMBER" "IMMEDIATE-SAP-SC-NUMBER"
	   "IMMEDIATE-SC-NUMBER"
	   "INSTANCE-HEADER-TYPE" "INSTANCE-POINTER-TYPE"
	   "INSTANCE-SLOTS-OFFSET" "INSTANCE-USAGE"
	   "INTERIOR-REG-SC-NUMBER" "INTERNAL-ERROR-ARGUMENTS"
	   "INTERRUPTED-FLAG" "LIST-ALLOCATED-OBJECTS" "LIST-POINTER-TYPE"
	   "LONG-FLOAT-BIAS" "LONG-FLOAT-DIGITS" "LONG-FLOAT-EXPONENT-BYTE"
	   "LONG-FLOAT-HIDDEN-BIT" "LONG-FLOAT-NORMAL-EXPONENT-MAX"
	   "LONG-FLOAT-NORMAL-EXPONENT-MIN" "LONG-FLOAT-SIGNIFICAND-BYTE"
	   "LONG-FLOAT-SIZE" "LONG-FLOAT-TRAPPING-NAN-BIT" "LONG-FLOAT-TYPE"
	   "LONG-FLOAT-VALUE-SLOT" "LONG-REG-SC-NUMBER" "LONG-STACK-SC-NUMBER"
	   "LOWTAG-BITS" "LOWTAG-LIMIT" "LOWTAG-MASK"
	   "MEMORY-USAGE" "MOST-POSITIVE-COST"
	   "NEGATIVE-IMMEDIATE-SC-NUMBER" "NON-DESCRIPTOR-REG-SC-NUMBER"
	   "NULL-SC-NUMBER" "OBJECT-NOT-LIST-TRAP" "OBJECT-NOT-INSTANCE-TRAP"
	   "ODD-FIXNUM-TYPE" "OFFSET-STATIC-SYMBOL" "OTHER-IMMEDIATE-0-TYPE"
	   "OTHER-IMMEDIATE-1-TYPE" "OTHER-POINTER-TYPE"
	   "PAD-DATA-BLOCK" "PENDING-INTERRUPT-TRAP"
	   "PRIMITIVE-OBJECT" "PRIMITIVE-OBJECT-HEADER"
	   "PRIMITIVE-OBJECT-LOWTAG" "PRIMITIVE-OBJECT-NAME"
	   "PRIMITIVE-OBJECT-OPTIONS" "PRIMITIVE-OBJECT-P"
	   "PRIMITIVE-OBJECT-SIZE" "PRIMITIVE-OBJECT-SLOTS"
	   "PRIMITIVE-OBJECT-VARIABLE-LENGTH" "PRINT-ALLOCATED-OBJECTS"
	   "RANDOM-IMMEDIATE-SC-NUMBER" "RATIO-DENOMINATOR-SLOT"
	   "RATIO-NUMERATOR-SLOT" "RATIO-SIZE" "RATIO-TYPE"
	   "REGISTER-SAVE-PENALTY" "RETURN-PC-HEADER-TYPE"
	   "RETURN-PC-RETURN-POINT-OFFSET" "SANCTIFY-FOR-EXECUTION"
	   "SAP-POINTER-SLOT" "SAP-REG-SC-NUMBER" "SAP-SIZE"
	   "SAP-STACK-SC-NUMBER" "SAP-TYPE"
	   "SCAVENGER-HOOK-FUNCTION-SLOT" "SCAVENGER-HOOK-SIZE"
	   "SCAVENGER-HOOK-TYPE" "SCAVENGER-HOOK-VALUE-SLOT"
	   "SCAVENGER-HOOK-NEXT-SLOT"
	   "SIGCONTEXT-FLOATING-POINT-MODES" "SIGCONTEXT-FLOAT-REGISTER"
	   "SIGCONTEXT-PROGRAM-COUNTER" "SIGCONTEXT-REGISTER"
	   "SIGFPE-HANDLER" "SIGNED-REG-SC-NUMBER" "SIGNED-STACK-SC-NUMBER"
	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-TYPE"
	   "SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-DOUBLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-LONG-FLOAT-TYPE"
	   "SIMPLE-ARRAY-SINGLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-TYPE" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-2-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-32-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-4-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-8-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-16-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-30-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-32-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-8-TYPE"
	   "SIMPLE-BIT-VECTOR-TYPE"
	   "SIMPLE-STRING-TYPE" "SIMPLE-VECTOR-TYPE" "SINGLE-FLOAT-BIAS"
	   "SINGLE-FLOAT-DIGITS" "SINGLE-FLOAT-EXPONENT-BYTE"
	   "SINGLE-FLOAT-HIDDEN-BIT" "SINGLE-FLOAT-NORMAL-EXPONENT-MAX"
	   "SINGLE-FLOAT-NORMAL-EXPONENT-MIN" "SINGLE-FLOAT-SIGNIFICAND-BYTE"
	   "SINGLE-FLOAT-SIZE" "SINGLE-FLOAT-TRAPPING-NAN-BIT"
	   "SINGLE-FLOAT-TYPE" "SINGLE-FLOAT-VALUE-SLOT"
           "SINGLE-INT-CARG-REG-SC-NUMBER"
	   "SINGLE-REG-SC-NUMBER" "SINGLE-STACK-SC-NUMBER"
	   "SINGLE-STEP-BREAKPOINT-TRAP"
	   "SINGLE-VALUE-RETURN-BYTE-OFFSET" "SLOT-DOCS"
	   "SLOT-LENGTH" "SLOT-NAME" "SLOT-OFFSET" "SLOT-OPTIONS"
	   "SLOT-REST-P" "STATIC-FUNCTIONS" "STATIC-FUNCTION-OFFSET"
	   "STATIC-SYMBOL-OFFSET" "STATIC-SYMBOL-P" "STATIC-SYMBOLS"
	   "STRUCTURE-USAGE" "SYMBOL-FUNCTION-SLOT"
	   "SYMBOL-HASH-SLOT" "SYMBOL-HEADER-TYPE" "SYMBOL-NAME-SLOT"
	   "SYMBOL-PACKAGE-SLOT" "SYMBOL-PLIST-SLOT"
	   "SYMBOL-RAW-FUNCTION-ADDR-SLOT" "SYMBOL-SETF-FUNCTION-SLOT"
	   "SYMBOL-SIZE" "SYMBOL-UNUSED-SLOT" "SYMBOL-VALUE-SLOT"
	   "TARGET-BINDING-STACK-START" "TARGET-BYTE-ORDER"
	   "TARGET-CONTROL-STACK-START" "TARGET-DYNAMIC-SPACE-START"
	   "TARGET-FASL-CODE-FORMAT" "TARGET-FASL-FILE-TYPE"
	   "TARGET-FOREIGN-LINKAGE-ENTRY-SIZE"
	   "TARGET-FOREIGN-LINKAGE-SPACE-START"
	   "TARGET-HEAP-ADDRESS-SPACE" "TARGET-MOST-NEGATIVE-FIXNUM"
	   "TARGET-MOST-POSITIVE-FIXNUM" "TARGET-READ-ONLY-SPACE-START"
	   "TARGET-STATIC-SPACE-START" "TRACE-TABLE-CALL-SITE"
	   "TRACE-TABLE-FUNCTION-EPILOGUE" "TRACE-TABLE-FUNCTION-PROLOGUE"
	   "TRACE-TABLE-NORMAL" "TYPE-BITS" "TYPE-MASK" "UNBOUND-MARKER-TYPE"
	   "UNINTERNED-SYMBOL-COUNT" "UNSIGNED-IMMEDIATE-SC-NUMBER"
	   "UNSIGNED-REG-SC-NUMBER" "UNSIGNED-STACK-SC-NUMBER"
	   "UNWIND-BLOCK-CURRENT-CODE-SLOT" "UNWIND-BLOCK-CURRENT-CONT-SLOT"
	   "UNWIND-BLOCK-CURRENT-UWP-SLOT" "UNWIND-BLOCK-ENTRY-PC-SLOT"
	   "UNWIND-BLOCK-SIZE" "VALUE-CELL-HEADER-TYPE" "VALUE-CELL-SIZE"
	   "VALUE-CELL-VALUE-SLOT" "VECTOR-DATA-OFFSET" "VECTOR-LENGTH-SLOT"
	   "VECTOR-MUST-REHASH-SUBTYPE" "VECTOR-NORMAL-SUBTYPE"
	   "VECTOR-VALID-HASHING-SUBTYPE"
	   "WEAK-POINTER-BROKEN-SLOT" "WEAK-POINTER-NEXT-SLOT"
	   "WEAK-POINTER-SIZE" "WEAK-POINTER-TYPE" "WEAK-POINTER-VALUE-SLOT"
	   "WORD-BITS" "WORD-BYTES" "WORD-REG-SC-NUMBER" "WORD-SHIFT"
	   "ZERO-SC-NUMBER"
	   #+sparc "POSITIVE-FIXNUM-BITS"
	   #+sparc "FIXNUM-TAG-BITS"
	   #+sparc "FIXNUM-TAG-MASK"
	   #+sparc "PSEUDO-ATOMIC-TRAP"
	   ))

(defpackage "CONDITIONS")
(intern "DISASSEMBLE" "LISP")
(defpackage "DISASSEM"
	    (:import-from "LISP" "DISASSEMBLE")
  (:export "*NOTE-COLUMN*" "*OPCODE-COLUMN-WIDTH*" "ADD-COMMENT-HOOK"
	   "ADD-HOOK" "ADD-NOTE-HOOK" "ARG-VALUE" "CREATE-DSTATE"
	   "DISASSEM-STATE" "DISASSEMBLE" "DISASSEMBLE-CODE-COMPONENT"
	   "DISASSEMBLE-FUNCTION" "DISASSEMBLE-MEMORY" "DISASSEMBLE-SEGMENT"
	   "DISASSEMBLE-SEGMENTS" "DSTATE-CODE" "DSTATE-CURPOS"
	   "DSTATE-GET-PROP" "DSTATE-NEXTPOS" "DSTATE-SEGMENT-LENGTH"
	   "DSTATE-SEGMENT-SAP" "DSTATE-SEGMENT-START" "FIELD-TYPE"
	   "FIND-INST" "GEN-FIELD-TYPE-DECL-FORM" "GEN-INST-DECL-FORM"
	   "GEN-INST-FORMAT-DECL-FORM" "GET-CODE-SEGMENTS"
	   "GET-FUNCTION-SEGMENTS" "GET-INST-SPACE" "HANDLE-BREAK-ARGS"
	   "INST" "INST-FORMAT" "LABEL-SEGMENTS"
	   "MAYBE-NOTE-ASSEMBLER-ROUTINE"
	   "MAYBE-NOTE-STATIC-FUNCTION"
	   "MAYBE-NOTE-ASSOCIATED-STORAGE-REF"
	   "MAYBE-NOTE-NIL-INDEXED-OBJECT"
	   "MAYBE-NOTE-NIL-INDEXED-SYMBOL-SLOT-REF"
	   "MAYBE-NOTE-SINGLE-STORAGE-REF" "NOTE" "NOTE-CODE-CONSTANT"
	   "PARAMS" "PRIN1-QUOTED-SHORT" "PRIN1-SHORT" "PRINT-BYTES"
	   "PRINT-CURRENT-ADDRESS" "PRINT-FIELD" "PRINT-INST"
	   "PRINT-INST-USING" "PRINT-NOTES-AND-NEWLINE" "PRINT-WORDS"
	   "SAP-REF-DCHUNK" "SEG-DEBUG-FUNCTION" "SEG-LENGTH" "SEG-START"
	   "SEGMENT" "SET-ADDRESS-PRINTING-RANGE" "SET-DISASSEM-PARAMS"
	   "SET-DSTATE-SEGMENT" "SIGN-EXTEND" "SPECIALIZE"
	   "GEN-PRINTER-DEF-FORMS-DEF-FORM"
	   "MAKE-DSTATE"
	   "DEFINE-ARGUMENT-TYPE"
	   "GEN-ARG-TYPE-DEF-FORM"
	   "READ-SIGNED-SUFFIX"
	   "ADD-OFFS-HOOK"
	   "MAKE-MEMORY-SEGMENT"
	   "GEN-PREAMBLE-FORM"
	   "MAKE-SEGMENT"
	   "SEGMENT-OVERFLOW"
	   "SEG-VIRTUAL-LOCATION"
	   "MAKE-DECODED-INST"
	   "DCHUNK"
	   "*DEFAULT-DSTATE-HOOKS*"
	   "MAKE-CODE-SEGMENT"
	   "MAKE-OFFS-HOOK"
	   "DSTATE-SEGMENT"
	   "DSTATE-CUR-OFFS"
	   "PRINC16"
	   "INSTRUCTION"
	   "DEFINE-INSTRUCTION-FORMAT"
	   "DSTATE-NEXT-OFFS"
	   "INSTALL-INST-FLAVORS"
	   "SEG-SAP-MAKER"
	   "DISASSEMBLE-ASSEM-SEGMENT"
	   "GEN-CLEAR-INFO-FORM"
	   "READ-SUFFIX"
	   "MAP-SEGMENT-INSTRUCTIONS"
	   "GEN-FORMAT-DEF-FORM"
	   "SET-LOCATION-PRINTING-RANGE"
	   "MAKE-VECTOR-SEGMENT"
	   "ADD-OFFS-NOTE-HOOK"
	   "ADD-OFFS-COMMENT-HOOK"
	   "DSTATE-CUR-ADDR"
	   "DSTATE-NEXT-ADDR"
	   #+sparc "MAYBE-NOTE-STATIC-FUNCTION"
	   ))
(dolist
    (name
     '("*MAX-TRACE-INDENTATION*" "*TRACE-PRINT-LENGTH*" "*TRACE-PRINT-LEVEL*"
       "*TRACED-FUNCTION-LIST*"))
  (intern name "EXTENSIONS"))
(defpackage "DEBUG"
            (:import-from "EXTENSIONS" "*MAX-TRACE-INDENTATION*"
             "*TRACE-PRINT-LENGTH*" "*TRACE-PRINT-LEVEL*"
             "*TRACED-FUNCTION-LIST*")
            (:export "*AUTO-EVAL-IN-FRAME*" "*DEBUG-PRINT-LENGTH*"
             "*DEBUG-PRINT-LEVEL*" "*DEBUG-PROMPT*"
	     "*DEBUG-READTABLE*" "*FLUSH-DEBUG-ERRORS*"
	     "*HELP-LINE-SCROLL-COUNT*" "*IN-THE-DEBUGGER*"
             "*MAX-TRACE-INDENTATION*" "*TRACE-FRAME*" "*TRACE-PRINT-LENGTH*"
             "*TRACE-PRINT-LEVEL*" "*TRACED-FUNCTION-LIST*" "ARG" "BACKTRACE"
             "INTERNAL-DEBUG" "VAR" "*PRINT-LOCATION-KIND*"
	     "*ONLY-BLOCK-START-LOCATIONS*" "*STACK-TOP-HINT*"
	     "*TRACE-VALUES*" "DO-DEBUG-COMMAND"
	     "*TRACE-ENCAPSULATE-DEFAULT*"
	     "*DEFAULT-PRINT-FRAME-CALL-VERBOSITY*"))

(intern "CHAR" "LISP")
(defpackage "EXTENSIONS"
  (:nicknames "EXTENSIONS")
  (:import-from "LISP" "GET-SETF-METHOD")
  (:import-from "KERNEL" "*ANSI-DEFSTRUCT-OPTIONS-P*")
  (:export   "*AFTER-GC-HOOKS*" "*AFTER-SAVE-INITIALIZATIONS*"
	     "*ALL-MODIFIER-NAMES*" "*ANSI-DEFSTRUCT-OPTIONS-P*"
	     "*AUTOLOAD-TRANSLATIONS*"
	     "*BACKUP-EXTENSION*" "*BEFORE-GC-HOOKS*"
             "*BEFORE-SAVE-INITIALIZATIONS*" "*BLOCK-COMPILE-DEFAULT*"
             "*BYTES-CONSED-BETWEEN-GCS*" "*CHAR" "*CLX-FDS-TO-DISPLAYS*"
             "*COMMAND-LINE-STRINGS*" "*COMMAND-LINE-SWITCHES*"
             "*COMMAND-LINE-UTILITY-NAME*" "*COMMAND-LINE-WORDS*"
             "*COMMAND-SWITCH-DEMONS*" "*COMPATIBILITY-WARNINGS*"
             "*COMPILE-PROGRESS*" "*DERIVE-FUNCTION-TYPES*"
             "*DESCRIBE-IMPLEMENTATION-DETAILS*" "*DESCRIBE-INDENTATION*"
             "*DESCRIBE-LEVEL*" "*DESCRIBE-PRINT-LENGTH*"
             "*DESCRIBE-PRINT-LEVEL*" "*DESCRIBE-VERBOSE*"
             "*DISPLAY-EVENT-HANDLERS*" "*EDITOR-LISP-P*"
             "*EFFICIENCY-NOTE-COST-THRESHOLD*" "*EFFICIENCY-NOTE-LIMIT*"
             "*ENCLOSING-SOURCE-CUTOFF*" "*ENVIRONMENT-LIST*"
             "*ERROR-PRINT-LENGTH*" "*ERROR-PRINT-LEVEL*" "*GC-INHIBIT-HOOK*"
             "*GC-NOTIFY-AFTER*" "*GC-NOTIFY-BEFORE*" "*GC-VERBOSE*"
	     "GET-SETF-METHOD" ; temp until uses are converted to g-s-expansion
             "*HEMLOCK-VERSION*" "*IGNORE-FLOATING-POINT-UNDERFLOW*"
             "*INFO-ENVIRONMENT*" "*INTEXP-MAXIMUM-EXPONENT*"
             "*KEYWORD-PACKAGE*" "*LISP-PACKAGE*" "*LOAD-IF-SOURCE-NEWER*"
             "*MAX-OLD-TRACE-INDENTATION*" "*MAX-STEP-INDENTATION*"
             "*MAX-TRACE-INDENTATION*" "*MODULE-FILE-TRANSLATIONS*"
	     "*PROMPT*" "*REQUIRE-VERBOSE*"
	     "*SETF-FDEFINITION-HOOK*"
             "*TOP-LEVEL-AUTO-DECLARE*"
	     "COMPILER-MACROEXPAND-1" "COMPILER-MACROEXPAND"
             "*UNDEFINED-WARNING-LIMIT*" "ACCEPT-TCP-CONNECTION"
	     "ACCEPT-UNIX-CONNECTION"
             "ADD-OOB-HANDLER" "AMBIGUOUS-FILES" "ARGUMENT-LIST" "ASSQ"
             "BASIC-DEFINITION" "BIGNUMP" "BITP" "CACHE-HASH-EQ"
             "CALL-USER-MISCOP" "CANCEL-FINALIZATION" "CAREFUL-SYMBOL-FUNCTION"
             "CAREFULLY-ADD-FONT-PATHS" "CHAR" "CHAR-KEY-EVENT"
             "CLEAN-UP-COMPILER" "CLEAR-INFO" "CLEAR-SEARCH-LIST"
             "CLOSE-SOCKET" "CMD-SWITCH-ARG" "CMD-SWITCH-NAME"
             "CMD-SWITCH-STRING" "CMD-SWITCH-VALUE" "CMD-SWITCH-WORDS"
             "COLLECT" "COMMAND-LINE-SWITCH" "COMMAND-LINE-SWITCH-P"
             "COMPACT-INFO-ENVIRONMENT" "COMPILE-FROM-STREAM" "COMPILEDP"
             "COMPLETE-FILE" "CONCAT-PNAMES" "CONNECT-TO-INET-SOCKET"
             "CONSTANT" "CONSTANT-ARGUMENT" "CONSTANT-FUNCTION"
             "CREATE-INET-LISTENER" "CREATE-INET-SOCKET" "CREATE-UNIX-LISTENER"
	     "DEBUG"
	     "DEF-SOURCE-CONTEXT"
             "DEFAULT-CLX-EVENT-HANDLER" "DEFAULT-DIRECTORY"
             "DEFINE-CLX-MODIFIER" "DEFINE-HASH-CACHE" "DEFINE-INFO-CLASS"
             "DEFINE-INFO-TYPE" "DEFINE-KEY-EVENT-MODIFIER"
             "DEFINE-KEYBOARD-MODIFIER" "DEFINE-KEYSYM" "DEFINE-MOUSE-CODE"
             "DEFINE-MOUSE-KEYSYM" "DEFMODULE" "DEFSWITCH" "DEFUN-CACHED"
             "DELETEF" "DELQ" "DISABLE-CLX-EVENT-HANDLING"
             "DO-ALPHA-KEY-EVENTS" "DO-ANONYMOUS" "DO-INFO"
             "DOUBLE-FLOAT-NEGATIVE-INFINITY" "DOUBLE-FLOAT-POSITIVE-INFINITY"
             "DOUBLE-FLOATP" "DOVECTOR" "ENABLE-CLX-EVENT-HANDLING"
             "ENCAPSULATE" "ENCAPSULATED-DEFINITION" "ENCAPSULATED-P"
             "END-BLOCK" "ENUMERATE-SEARCH-LIST" "FILE-COMMENT" "FILE-WRITABLE"
             "FINALIZE" "FIXNUMP" "FLOAT-DENORMALIZED-P" "FLOAT-INFINITY-P"
             "FLOAT-NAN-P" "FLOAT-TRAPPING-NAN-P" "FLOATING-POINT-INEXACT"
             "FLOATING-POINT-INVALID" "FLUSH-DISPLAY-EVENTS"
             "FORMAT-DECODED-TIME" "FORMAT-UNIVERSAL-TIME" "FREEZE-TYPE" "GC"
             "GC-OFF" "GC-ON" "GET-BYTES-CONSED" "GET-BYTES-CONSED-DFIXNUM"
	     "GET-CODE-POINTER"
             "GET-COMMAND-LINE-SWITCH" "GET-DATA-POINTER"
             "GET-FLOATING-POINT-MODES" "GET-PEER-HOST-AND-PORT"
	     "GET-SOCKET-HOST-AND-PORT"
	     "GET-STREAM-COMMAND" "GRINDEF"
             "HOST-ENTRY" "HOST-ENTRY-ADDR" "HOST-ENTRY-ADDR-LIST"
             "HOST-ENTRY-ALIASES" "HOST-ENTRY-NAME" "HTONL" "HTONS"
             "INADDR-ANY" "INDENTING-FURTHER" "INFO"
             "INHIBIT-WARNINGS" "INTERACTIVE-EVAL" "IPPROTO-TCP" "IPPROTO-UDP"
	     "IP-STRING"
             "ITERATE" "KEY-EVENT" "KEY-EVENT-BIT-P" "KEY-EVENT-BITS"
             "KEY-EVENT-BITS-MODIFIERS" "KEY-EVENT-CHAR" "KEY-EVENT-KEYSYM"
             "KEY-EVENT-MODIFIER-MASK" "KEY-EVENT-P" "KEYSYM-NAMES"
             "KEYSYM-PREFERRED-NAME" "LETF" "LETF*" "LISTEN-SKIP-WHITESPACE"
             "LOAD-FOREIGN" "LONG-FLOAT-NEGATIVE-INFINITY"
             "LONG-FLOAT-POSITIVE-INFINITY" "LONG-FLOATP" "LOOKUP-HOST-ENTRY"
             "MAKE-CASE-FROB-STREAM" "MAKE-INFO-ENVIRONMENT" "MAKE-KEY-EVENT"
             "MAKE-KEY-EVENT-BITS" "MAKE-SCAVENGER-HOOK"
	     "MAKE-STREAM-COMMAND" "MAKE-WEAK-POINTER"
             "MAYBE-INLINE" "MEMQ" "NAME-KEYSYM" "NTOHL" "NTOHS"
             "OBJECT-SET-EVENT-HANDLER" "OLD-TRACE" "OLD-UNTRACE" "ONCE-ONLY"
             "OPEN-CLX-DISPLAY" "OPTIMIZE-INTERFACE"
	     "PACKAGE-CHILDREN" "PACKAGE-PARENT" "PARSE-TIME"
             "PRINT-DIRECTORY" "PRINT-HERALD" "PRINT-PRETTY-KEY"
             "PRINT-PRETTY-KEY-EVENT" "PROCESS-ALIVE-P" "PROCESS-CLOSE"
             "PROCESS-CORE-DUMPED" "PROCESS-ERROR" "PROCESS-EXIT-CODE"
             "PROCESS-INPUT" "PROCESS-KILL" "PROCESS-OUTPUT" "PROCESS-P"
             "PROCESS-PID" "PROCESS-PLIST" "PROCESS-PTY" "PROCESS-STATUS"
             "PROCESS-STATUS-HOOK" "PROCESS-WAIT" "PUTF" "QUIT" "RATIOP"
             "READ-CHAR-NO-EDIT" "REALP" "REMOVE-ALL-OOB-HANDLERS"
             "REMOVE-OOB-HANDLER" "REQUIRED-ARGUMENT" "RESET-FOREIGN-POINTERS"
             "RUN-PROGRAM" "SAVE" "SAVE-ALL-BUFFERS" "SAVE-LISP"
             "SCAVENGER-HOOK" "SCAVENGER-HOOK-P"
	     "SCAVENGER-HOOK-VALUE" "SCAVENGER-HOOK-FUNCTION"
	     "SEARCH-LIST"
             "SEND-CHARACTER-OUT-OF-BAND" "SERVE-BUTTON-PRESS"
             "SERVE-BUTTON-RELEASE" "SERVE-CIRCULATE-NOTIFY"
             "SERVE-CIRCULATE-REQUEST" "SERVE-CLIENT-MESSAGE"
             "SERVE-COLORMAP-NOTIFY" "SERVE-CONFIGURE-NOTIFY"
             "SERVE-CONFIGURE-REQUEST" "SERVE-CREATE-NOTIFY"
             "SERVE-DESTROY-NOTIFY" "SERVE-ENTER-NOTIFY" "SERVE-EXPOSURE"
             "SERVE-FOCUS-IN" "SERVE-FOCUS-OUT" "SERVE-GRAPHICS-EXPOSURE"
             "SERVE-GRAVITY-NOTIFY" "SERVE-KEY-PRESS" "SERVE-KEY-RELEASE"
             "SERVE-LEAVE-NOTIFY" "SERVE-MAP-NOTIFY" "SERVE-MAP-REQUEST"
             "SERVE-MOTION-NOTIFY" "SERVE-NO-EXPOSURE" "SERVE-PROPERTY-NOTIFY"
             "SERVE-REPARENT-NOTIFY" "SERVE-RESIZE-REQUEST"
             "SERVE-SELECTION-CLEAR" "SERVE-SELECTION-NOTIFY"
             "SERVE-SELECTION-REQUEST" "SERVE-UNMAP-NOTIFY"
             "SERVE-VISIBILITY-NOTIFY" "SET-FLOATING-POINT-MODES"
             "SET-SYMBOL-FUNCTION-CAREFULLY" "SHORT-FLOAT-NEGATIVE-INFINITY"
             "SHORT-FLOAT-POSITIVE-INFINITY" "SHORT-FLOATP"
             "SINGLE-FLOAT-NEGATIVE-INFINITY" "SINGLE-FLOAT-POSITIVE-INFINITY"
             "SINGLE-FLOATP" "START-BLOCK" "STREAM-COMMAND"
             "STREAM-COMMAND-ARGS" "STREAM-COMMAND-NAME" "STREAM-COMMAND-P"
	     "INSTANCEP" "SYMBOLICATE" "TRANSLATE-CHARACTER"
             "TRANSLATE-KEY-EVENT" "TRANSLATE-MOUSE-CHARACTER"
             "TRANSLATE-MOUSE-KEY-EVENT" "TRULY-THE" "UNCOMPILE"
             "UNDEFINED-VALUE" "UNENCAPSULATE" "UNIX-NAMESTRING" "WEAK-POINTER"
             "WEAK-POINTER-P" "WEAK-POINTER-VALUE" "WITH-CLX-EVENT-HANDLING"
	     "WITH-FLOAT-TRAPS-MASKED"
	     "FEATUREP" "*IGNORE-EXTRA-CLOSE-PARENTHESES*" "*HERALD-ITEMS*"
	     "SEARCH-LIST-DEFINED-P" "BYTES-CONSED-BETWEEN-GCS"
	     "*LOAD-SOURCE-TYPES*" "*LOAD-OBJECT-TYPES*"
	     "*DEFAULT-PACKAGE-USE-LIST*" "*GC-RUN-TIME*"
	     "CONNECT-TO-UNIX-SOCKET"
	     "DEFINE-HASH-TABLE-TEST"

	     "DO-HASH"
	     "*EFFICIENCY-NOTE-LIMIT*"
	     "*ERROR-PRINT-LINES*"
	     "CREATE-UNIX-SOCKET"
	     "*INLINE-EXPANSION-LIMIT*"
	     "INSTANCE"
	     "*EFFICIENCY-NOTE-COST-THRESHOLD*"
	     "*USE-IMPLEMENTATION-TYPES*"
	     "*BYTE-COMPILE-TOP-LEVEL*"
	     "*BYTE-COMPILE-DEFAULT*"
	     "PURIFY" "MAP-APROPOS"
	     "*BATCH-MODE*"
	     "COMPILER-LET"
	     "DEFINE-FUNCTION-NAME-SYNTAX"
	     "VALID-FUNCTION-NAME-P"

	     ;; Gray streams extension.
	     "FUNDAMENTAL-BINARY-STREAM" "FUNDAMENTAL-BINARY-INPUT-STREAM"
	     "FUNDAMENTAL-BINARY-OUTPUT-STREAM" "FUNDAMENTAL-CHARACTER-STREAM"
	     "FUNDAMENTAL-CHARACTER-INPUT-STREAM"
	     "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM"
	     "FUNDAMENTAL-INPUT-STREAM" "FUNDAMENTAL-OUTPUT-STREAM"
	     "FUNDAMENTAL-STREAM"
	     "STREAM-ADVANCE-TO-COLUMN" "STREAM-CLEAR-INPUT" 
	     "STREAM-CLEAR-OUTPUT" "STREAM-FINISH-OUTPUT" "STREAM-FORCE-OUTPUT"
	     "STREAM-FRESH-LINE" "STREAM-LINE-COLUMN" "STREAM-LINE-LENGTH"
	     "STREAM-LISTEN" "STREAM-PEEK-CHAR" "STREAM-READ-BYTE"
	     "STREAM-READ-CHAR" "STREAM-READ-CHAR-NO-HANG" "STREAM-READ-LINE"
	     "STREAM-START-LINE-P" "STREAM-TERPRI" "STREAM-UNREAD-CHAR"
	     "STREAM-WRITE-BYTE" "STREAM-WRITE-CHAR" "STREAM-WRITE-STRING"
	     "STREAM-READ-SEQUENCE" "STREAM-WRITE-SEQUENCE"))

(defpackage "LOOP")
(dolist
    (name
     '("DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED"
       "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P"
       "DEBUG-SOURCE-START-POSITIONS"))
  (intern name "C"))
(defpackage "DEBUG-INTERNALS"
	    (:nicknames "DI")
            (:import-from "C" "DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED"
             "DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME"
             "DEBUG-SOURCE-P" "DEBUG-SOURCE-START-POSITIONS")
            (:export "*DEBUGGING-INTERPRETER*" "ACTIVATE-BREAKPOINT"
             "AMBIGUOUS-DEBUG-VARIABLES" "AMBIGUOUS-VARIABLE-NAME" "BREAKPOINT"
             "BREAKPOINT-ACTIVE-P" "BREAKPOINT-HOOK-FUNCTION" "BREAKPOINT-INFO"
             "BREAKPOINT-KIND" "BREAKPOINT-P" "BREAKPOINT-WHAT" "CODE-LOCATION"
             "CODE-LOCATION-DEBUG-BLOCK" "CODE-LOCATION-DEBUG-FUNCTION"
             "CODE-LOCATION-DEBUG-SOURCE" "CODE-LOCATION-FORM-NUMBER"
             "CODE-LOCATION-P" "CODE-LOCATION-TOP-LEVEL-FORM-OFFSET"
             "CODE-LOCATION-UNKNOWN-P" "CODE-LOCATION=" "DEACTIVATE-BREAKPOINT"
             "DEBUG-BLOCK" "DEBUG-BLOCK-ELSEWHERE-P" "DEBUG-BLOCK-P"
             "DEBUG-BLOCK-SUCCESSORS" "DEBUG-CONDITION" "DEBUG-ERROR"
             "DEBUG-FUNCTION" "DEBUG-FUNCTION-FUNCTION" "DEBUG-FUNCTION-KIND"
             "DEBUG-FUNCTION-LAMBDA-LIST" "DEBUG-FUNCTION-NAME"
             "DEBUG-FUNCTION-P" "DEBUG-FUNCTION-START-LOCATION"
             "DEBUG-FUNCTION-SYMBOL-VARIABLES" "DEBUG-SOURCE"
             "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM"
             "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P" "DEBUG-SOURCE-ROOT-NUMBER"
             "DEBUG-SOURCE-START-POSITIONS" "DEBUG-VARIABLE"
             "DEBUG-VARIABLE-ID" "DEBUG-VARIABLE-INFO-AVAILABLE"
             "DEBUG-VARIABLE-NAME" "DEBUG-VARIABLE-P" "DEBUG-VARIABLE-PACKAGE"
             "DEBUG-VARIABLE-SYMBOL" "DEBUG-VARIABLE-VALID-VALUE"
             "DEBUG-VARIABLE-VALIDITY" "DEBUG-VARIABLE-VALUE"
             "DELETE-BREAKPOINT" "DELETE-BREAKPOINT-FOR-EDITOR" "DO-BLOCKS"
             "DO-DEBUG-BLOCK-LOCATIONS" "DO-DEBUG-FUNCTION-BLOCKS"
             "DO-DEBUG-FUNCTION-VARIABLES" "EVAL-IN-FRAME"
             "FORM-NUMBER-TRANSLATIONS" "FRAME" "FRAME-CATCHES"
             "FRAME-CODE-LOCATION" "FRAME-DEBUG-FUNCTION" "FRAME-DOWN"
             "FRAME-FUNCTION-MISMATCH" "FRAME-NUMBER" "FRAME-P" "FRAME-UP"
             "FUNCTION-DEBUG-FUNCTION" "FUNCTION-END-COOKIE-VALID-P"
             "INVALID-CONTROL-STACK-POINTER" "INVALID-VALUE"
             "LAMBDA-LIST-UNAVAILABLE" "MAKE-BREAKPOINT" "NO-DEBUG-BLOCKS"
             "NO-DEBUG-FUNCTION-RETURNS" "NO-DEBUG-INFO" "PREPROCESS-FOR-EVAL"
             "RETURN-FROM-FRAME" "SET-BREAKPOINT-FOR-EDITOR"
             "SET-LOCATION-BREAKPOINT-FOR-EDITOR" "SOURCE-PATH-CONTEXT"
             "TOP-FRAME" "UNHANDLED-CONDITION" "UNKNOWN-CODE-LOCATION"
             "UNKNOWN-CODE-LOCATION-P" "UNKNOWN-DEBUG-VARIABLE"
	     "CODE-LOCATION-KIND" "FLUSH-FRAMES-ABOVE"))
(dolist
    (name
     '("%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT"
       "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET"
       "%SET-FDEFINITION" "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
       "%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
       "%SVSET" "%TYPEP" "SHORT-FLOAT-P"
       "STRING/=*" "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"))
  (intern name "LISP"))
(dolist
    (name
      '("FOREIGN-SYMBOL-ADDRESS" "FOREIGN-SYMBOL-CODE-ADDRESS"
	"FOREIGN-SYMBOL-DATA-ADDRESS"))
  (intern name "SYSTEM"))

(defpackage "C"
  (:nicknames "COMPILER")
  (:import-from "LISP" "%ARRAY-TYPEP" "%ASET"
		"%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD" "%SBITSET"
		"%SCHARSET" "%SET-FDEFINITION"
		"%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
		"%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH"
		"%SP-STRING-COMPARE"
		"%SVSET" "%TYPEP" "SHORT-FLOAT-P"
		"STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
		"STRING>*" "STRING>=*")
  (:import-from "SYSTEM" "FOREIGN-SYMBOL-ADDRESS" "FOREIGN-SYMBOL-CODE-ADDRESS"
		"FOREIGN-SYMBOL-DATA-ADDRESS")
  (:export "%ALIEN-FUNCALL" "%CATCH-BREAKUP" "%CONTINUE-UNWIND" "&MORE"
	   "%LISTIFY-REST-ARGS" "%MORE-ARG" "%MORE-ARG-VALUES"
	   "%UNWIND-PROTECT-BREAKUP"
	   "*BACKEND*" "*CODE-SEGMENT*" "*COLLECT-DYNAMIC-STATISTICS*"
	   "*COMPILE-TIME-DEFINE-MACROS*" "*COMPILER-NOTIFICATION-FUNCTION*"
	   "*COMPILING-FOR-INTERPRETER*" "*CONVERTING-FOR-INTERPRETER*"
	   "*COUNT-VOP-USAGES*" "*ELSEWHERE*" "*NATIVE-BACKEND*"
	   "*SUPPRESS-VALUES-DECLARATION*" "*TARGET-BACKEND*"
	   "ALLOC-ALIEN-STACK-SPACE"
	   "ALLOC-NUMBER-STACK-SPACE" "ALLOCATE-CODE-OBJECT" "ALLOCATE-FRAME"
 	   "ALLOCATE-DYNAMIC-CODE-OBJECT"
	   "ALLOCATE-FULL-CALL-FRAME" "ANY" "ARGUMENT-COUNT-ERROR"
	   "ATTRIBUTES" "ATTRIBUTES-INTERSECTION" "ATTRIBUTES-UNION"
	   "ATTRIBUTES=" "BACKEND-ANY-PRIMITIVE-TYPE"
	   "BACKEND-ASSEMBLER-RESOURCES" "BACKEND-BYTE-ORDER"
	   "BACKEND-DISASSEM-PARAMS" "BACKEND-FASL-FILE-IMPLEMENTATION"
	   "BACKEND-FASL-FILE-TYPE" "BACKEND-FASL-FILE-VERSION"
	   "BACKEND-FEATURES" "BACKEND-INFO-ENVIRONMENT"
	   "BACKEND-INSTRUCTION-FLAVORS" "BACKEND-INSTRUCTION-FORMATS"
	   "BACKEND-NAME" "BACKEND-REGISTER-SAVE-PENALTY"
	   "BACKEND-SPECIAL-ARG-TYPES" "BACKEND-VERSION" "BIND" "BRANCH"
	   "CALL" "CALL-LOCAL" "CALL-NAMED" "CALL-OUT" "CALL-VARIABLE"
	   "CALLEE-NFP-TN" "CALLEE-RETURN-PC-TN" "CATCH-BLOCK" "CHECK-CONS"
	   "CHECK-FIXNUM" "CHECK-FUNCTION" "CHECK-FUNCTION-OR-SYMBOL"
	   "CHECK-BIGNUM" "CHECK-SIGNED-BYTE-32" "CHECK-SYMBOL"
	   "CHECK-UNSIGNED-BYTE-32"
	   "CLOSURE-INIT" "CLOSURE-REF" "CODE-CONSTANT-REF"
	   "CODE-CONSTANT-SET" "CODE-INSTRUCTIONS" "COERCE-TO-FUNCTION"
	   "COMPILE-FOR-EVAL" "COMPONENT" "COMPONENT-HEADER-LENGTH"
	   "COMPONENT-INFO" "COMPONENT-LIVE-TN" "COMPUTE-FUNCTION"
	   "COMPUTE-OLD-NFP" "COPY-MORE-ARG" "COUNT-ME"
	   "CURRENT-BINDING-POINTER" "CURRENT-NFP-TN" "CURRENT-STACK-POINTER"
	   "DEALLOC-ALIEN-STACK-SPACE"
	   "DEALLOC-NUMBER-STACK-SPACE" "DEF-BOOLEAN-ATTRIBUTE"
	   "DEF-IR1-TRANSLATOR" "DEF-PRIMITIVE-TRANSLATOR"
	   "DEF-PRIMITIVE-TYPE" "DEF-PRIMITIVE-TYPE-ALIAS"
	   "DEF-SOURCE-TRANSFORM" "DEF-VM-SUPPORT-ROUTINE"
	   "DEFINE-ASSEMBLY-ROUTINE" "DEFINE-MOVE-FUNCTION" "DEFINE-MOVE-VOP"
	   "DEFINE-STORAGE-BASE" "DEFINE-STORAGE-CLASS" "DEFINE-VOP"
	   "DEFKNOWN" "DEFOPTIMIZER" "DEFTRANSFORM" "DERIVE-TYPE"
	   "ENTRY-NODE-INFO-NLX-TAG" "ENTRY-NODE-INFO-ST-TOP"
	   "ENVIRONMENT-DEBUG-LIVE-TN" "ENVIRONMENT-LIVE-TN"
	   "FASL-FILE-IMPLEMENTATIONS" "FAST-SAFE-COERCE-TO-FUNCTION"
	   "FAST-SYMBOL-FUNCTION" "FAST-SYMBOL-VALUE"
	   "FLUSHABLE" "FOLDABLE"
	   "FORCE-TN-TO-STACK" "FOREIGN-SYMBOL-ADDRESS"
	   "FOREIGN-SYMBOL-CODE-ADDRESS" "FOREIGN-SYMBOL-DATA-ADDRESS"
	   "GET-VECTOR-SUBTYPE"
	   "HALT" "IF-EQ" "INSTANCE-REF" "INSTANCE-SET"
	   "IR2-COMPONENT-CONSTANTS" "IR2-CONVERT"
	   "IR2-ENVIRONMENT-NUMBER-STACK-P" "KNOWN-CALL-LOCAL" "KNOWN-RETURN"
	   "LAMBDA-EVAL-INFO-ARGS-PASSED" "LAMBDA-EVAL-INFO-ENTRIES"
	   "LAMBDA-EVAL-INFO-FRAME-SIZE" "LAMBDA-EVAL-INFO-FUNCTION"
	   "LOCATION=" "LTN-ANNOTATE" "MAKE-ALIAS-TN" "MAKE-CATCH-BLOCK"
	   "MAKE-CLOSURE" "MAKE-CONSTANT-TN" "MAKE-FIXNUM"
	   "MAKE-LOAD-TIME-CONSTANT-TN" "MAKE-N-TNS" "MAKE-NORMAL-TN"
	   "MAKE-OTHER-IMMEDIATE-TYPE" "MAKE-RANDOM-TN"
	   "MAKE-REPRESENTATION-TN" "MAKE-RESTRICTED-TN" "MAKE-SC-OFFSET"
	   "MAKE-STACK-POINTER-TN" "MAKE-TN-REF" "MAKE-UNWIND-BLOCK"
	   "MAKE-VALUE-CELL" "MAKE-WIRED-TN" "META-PRIMITIVE-TYPE-OR-LOSE"
	   "META-SB-OR-LOSE" "META-SC-NUMBER-OR-LOSE" "META-SC-OR-LOSE"
	   "MORE-ARG-CONTEXT" "MOVABLE" "MOVE" "MULTIPLE-CALL"
	   "MULTIPLE-CALL-LOCAL" "MULTIPLE-CALL-NAMED"
	   "MULTIPLE-CALL-VARIABLE" "NIL" "NLX-ENTRY" "NLX-ENTRY-MULTIPLE"
	   "NON-DESCRIPTOR-STACK" "NOTE-ENVIRONMENT-START"
	   "NOTE-THIS-LOCATION" "OPTIMIZER"
	   "PACK-TRACE-TABLE" "PMAX-FASL-FILE-IMPLEMENTATION" "POLICY"
	   "PPC-FASL-FILE-IMPLEMENTATION"
	   "PREDICATE" "PRIMITIVE-TYPE" "PRIMITIVE-TYPE-OF"
	   "PRIMITIVE-TYPE-OR-LOSE" "PRIMITIVE-TYPE-VOP" "PUSH-VALUES"
	   "READ-PACKED-BIT-VECTOR" "READ-VAR-INTEGER" "READ-VAR-STRING"
           "*RECORD-XREF-INFO*"
	   "RESET-STACK-POINTER" "RESTORE-DYNAMIC-STATE" "RETURN"
	   "RETURN-MULTIPLE" "RT-AFPA-FASL-FILE-IMPLEMENTATION"
	   "RT-FASL-FILE-IMPLEMENTATION" "SAVE-DYNAMIC-STATE" "SB"
	   "SB-ALLOCATED-SIZE" "SB-NAME" "SB-OR-LOSE" "SB-P" "SC" "SC-CASE"
	   "SC-IS" "SC-NAME" "SC-NUMBER" "SC-NUMBER-OR-LOSE"
	   "SC-OFFSET-OFFSET" "SC-OFFSET-SCN" "SC-OR-LOSE" "SC-P" "SC-SB"
	   "SET" "SET-UNWIND-PROTECT" "SET-VECTOR-SUBTYPE"
	   "SETUP-CLOSURE-ENVIRONMENT" "SETUP-ENVIRONMENT"
	   "SPARC-FASL-FILE-IMPLEMENTATION" "SPECIFY-SAVE-TN" "INSTANCE-REF"
	   "INSTANCE-SET" "SXHASH-SIMPLE-STRING" "SXHASH-SIMPLE-SUBSTRING"
	   "SYMBOL-FUNCTION" "SYMBOL-VALUE" "SYMBOLICATE" "TAIL-CALL"
	   "TAIL-CALL-NAMED" "TAIL-CALL-VARIABLE" "TEMPLATE-OR-LOSE" "THROW"
	   "TN" "TN-OFFSET" "TN-P" "TN-REF" "TN-REF-ACROSS" "TN-REF-LOAD-TN"
	   "TN-REF-NEXT" "TN-REF-NEXT-REF" "TN-REF-P" "TN-REF-TARGET"
	   "TN-REF-TN" "TN-REF-VOP" "TN-REF-WRITE-P" "TN-SC" "TN-VALUE"
	   "TRACE-TABLE-ENTRY" "TYPE-CHECK-ERROR" "UNBIND" "UNBIND-TO-HERE"
	   "UNSAFE" "UNWIND" "UWP-ENTRY"
	   "VALUE-CELL-REF" "VALUE-CELL-SET" "VALUES-LIST"
	   "VERIFY-ARGUMENT-COUNT" "WRITE-PACKED-BIT-VECTOR"
	   "WRITE-VAR-INTEGER" "WRITE-VAR-STRING" "XEP-ALLOCATE-FRAME"
	   "LABEL-ID" "FIXUP" "FIXUP-FLAVOR" "FIXUP-NAME" "FIXUP-OFFSET"
	   "FIXUP-P" "MAKE-FIXUP"
	   "SLOT"
	   "X86-FASL-FILE-IMPLEMENTATION"
	   "BACKEND-FEATUREP"
	   "DEF-ALLOC"
	   "BACKEND-ASSEMBLER-PARAMS"
	   "VAR-ALLOC"
	   "BACKEND-INTERNAL-ERRORS"
	   "BACKEND"
	   "SAFE-FDEFN-FUNCTION"
	   "NOTE-FIXUP"
	   "TARGET-FEATUREP"
	   "DEF-REFFER"
	   "NATIVE-FEATUREP"
	   "EMIT-NOP"
	   "DEF-SETTER"
	   "FIXED-ALLOC"
	   "HPPA-FASL-FILE-IMPLEMENTATION"
	   "ALPHA-FASL-FILE-IMPLEMENTATION"
	   "SGI-FASL-FILE-IMPLEMENTATION"
	   "MAKE-UNBOUND-MARKER"
	   "RETURN-SINGLE"
	   "BACKEND-PAGE-SIZE"
	   "NOTE-NEXT-INSTRUCTION"
	   "SET-SLOT"
	   "LOCATION-NUMBER"
"BYTE-FASL-FILE-VERSION"
"*COMPILE-COMPONENT*"
"BLOCK-NUMBER"
"DYNCOUNT-INFO-COUNTS"
"BACKEND-BYTE-FASL-FILE-IMPLEMENTATION"
"IR2-BLOCK-BLOCK"
"DISASSEM-BYTE-COMPONENT"
"LITTLE-ENDIAN-FASL-FILE-IMPLEMENTATION"
"DYNCOUNT-INFO-COSTS"
"FUNCALLABLE-INSTANCE-LEXENV"
"DISASSEM-BYTE-FUN"
"VOP-BLOCK"
"BACKEND-BYTE-FASL-FILE-TYPE"
"BIG-ENDIAN-FASL-FILE-IMPLEMENTATION"
"*ASSEMBLY-OPTIMIZE*"
"LARGE-ALLOC"
"%SET-FUNCTION-SELF"
"IR2-COMPONENT-DYNCOUNT-INFO"
"DYNCOUNT-INFO" "DYNCOUNT-INFO-P")
)
(defpackage "XREF"
  (:export "INIT-XREF-DATABASE"
           "REGISTER-XREF"
           "WHO-CALLS"
           "WHO-REFERENCES"
           "WHO-BINDS"
           "WHO-SETS"
           #+pcl "WHO-SUBCLASSES"
           #+pcl "WHO-SUPERCLASSES"
           "MAKE-XREF-CONTEXT"
           "XREF-CONTEXT-NAME"
           "XREF-CONTEXT-FILE"
           "XREF-CONTEXT-SOURCE-PATH"))
(defpackage "WIRE"
            (:export "*CURRENT-WIRE*" "CONNECT-TO-REMOTE-SERVER"
             "CREATE-REQUEST-SERVER" "DESTROY-REQUEST-SERVER"
             "FORGET-REMOTE-TRANSLATION" "MAKE-REMOTE-OBJECT" "MAKE-WIRE"
             "REMOTE" "REMOTE-OBJECT" "REMOTE-OBJECT-EQ"
             "REMOTE-OBJECT-LOCAL-P" "REMOTE-OBJECT-P" "REMOTE-OBJECT-VALUE"
             "REMOTE-VALUE" "REMOTE-VALUE-BIND" "WIRE-EOF" "WIRE-ERROR"
             "WIRE-FD" "WIRE-FORCE-OUTPUT" "WIRE-GET-BIGNUM" "WIRE-GET-BYTE"
             "WIRE-GET-NUMBER" "WIRE-GET-OBJECT" "WIRE-GET-STRING"
             "WIRE-IO-ERROR" "WIRE-LISTEN" "WIRE-OUTPUT-BIGNUM"
             "WIRE-OUTPUT-BYTE" "WIRE-OUTPUT-FUNCALL" "WIRE-OUTPUT-NUMBER"
             "WIRE-OUTPUT-OBJECT" "WIRE-OUTPUT-STRING" "WIRE-P"))
(defpackage "PRETTY-PRINT"
	    (:nicknames "PP")
	    (:export "PRETTY-STREAM" "PRETTY-STREAM-P"))
(intern "LOAD-FOREIGN" "EXTENSIONS")
(defpackage "SYSTEM"
	    (:nicknames "SYS")
            (:import-from "EXTENSIONS" "LOAD-FOREIGN")
            (:export "%ASSEMBLER-CODE-TYPE" "%BIND-ALIGNED-SAP" "%PRIMITIVE"
             "%SP-BYTE-BLT" "%SP-FIND-CHARACTER"
             "%SP-FIND-CHARACTER-WITH-ATTRIBUTE"
             "%SP-REVERSE-FIND-CHARACTER-WITH-ATTRIBUTE" "%STANDARD-CHAR-P"
             "*BEEP-FUNCTION*"
	     "*LONG-SITE-NAME*" "*SHORT-SITE-NAME*"
             "*SOFTWARE-TYPE*" "*STDERR*" "*STDIN*" "*STDOUT*" "*TASK-DATA*"
             "*TASK-NOTIFY*" "*TASK-SELF*" "*TTY*" "*TYPESCRIPTPORT*"
	     "*XWINDOW-TABLE*"
             "ADD-FD-HANDLER" "ADD-PORT-DEATH-HANDLER" "ADD-PORT-OBJECT"
             "ADD-XWINDOW-OBJECT" "ALLOCATE-SYSTEM-MEMORY" "BEEP" "BITS"
             "BYTES" "C-PROCEDURE" "CHECK<=" "CHECK=" "COMPILER-VERSION"
             "CT-A-VAL" "CT-A-VAL-OFFSET" "CT-A-VAL-P" "CT-A-VAL-SAP"
             "CT-A-VAL-SIZE" "CT-A-VAL-TYPE" "DEALLOCATE-SYSTEM-MEMORY"
             "DEFAULT-INTERRUPT" "DEFENUMERATION" "DEFOPERATOR" "DEFRECORD"
             "DEPORT-BOOLEAN" "DEPORT-INTEGER" "DOUBLE-FLOAT-RADIX"
             "ENABLE-INTERRUPT" "ENUMERATION" "FD-STREAM" "FD-STREAM-FD"
             "FD-STREAM-P" "FIND-IF-IN-CLOSURE" "FOREIGN-SYMBOL-ADDRESS"
	     "FOREIGN-SYMBOL-CODE-ADDRESS" "FOREIGN-SYMBOL-DATA-ADDRESS"
	     "GET-PAGE-SIZE" "GET-SYSTEM-INFO"
	     "IGNORE-INTERRUPT"
             "INT-SAP" "INVALIDATE-DESCRIPTOR" "IO-TIMEOUT"
	     "LISP-STREAM" "LONG-FLOAT-RADIX" "LONG-WORDS"
	     "MACRO" "MAKE-CT-A-VAL" "MAKE-FD-STREAM"
             "MAKE-INDENTING-STREAM" "MAKE-OBJECT-SET" "MAP-PORT" "MAP-XWINDOW"
             "NATURALIZE-BOOLEAN" "NATURALIZE-INTEGER" "NULL-TERMINATED-STRING"
             "OBJECT-SET-OPERATION" "OUTPUT-RAW-BYTES" "PARSE-BODY"
             "PERQ-STRING" "POINTER" "POINTER<" "POINTER>" "PORT" "PRIMEP"
             "READ-N-BYTES" "REALLOCATE-SYSTEM-MEMORY" "RECORD-SIZE"
             "REMOVE-FD-HANDLER" "REMOVE-PORT-DEATH-HANDLER"
             "REMOVE-PORT-OBJECT" "REMOVE-XWINDOW-OBJECT"
             "RESOLVE-LOADED-ASSEMBLER-REFERENCES" "SAP+" "SAP-" "SAP-INT"
	     "SAP-REF-16" "SAP-REF-32" "SAP-REF-64" "SAP-REF-8"
	     "SAP-REF-DESCRIPTOR"
             "SAP-REF-DOUBLE" "SAP-REF-LONG" "SAP-REF-SAP" "SAP-REF-SINGLE"
	     "SAP<" "SAP<=" "SAP=" "SAP>" "SAP>="
	     "SCRUB-CONTROL-STACK" "SERVE-ALL-EVENTS"
             "SERVE-EVENT" "SERVER" "SERVER-MESSAGE" "SHORT-FLOAT-RADIX"
             "SIGNED-SAP-REF-16" "SIGNED-SAP-REF-32"
	     "SIGNED-SAP-REF-64" "SIGNED-SAP-REF-8"
             "SINGLE-FLOAT-RADIX" "SYMBOL-MACRO-LET" "SYSTEM-AREA-POINTER"
             "SYSTEM-AREA-POINTER-P" "VECTOR-SAP"
             "WAIT-UNTIL-FD-USABLE" "WITH-ENABLED-INTERRUPTS" "WITH-FD-HANDLER"
             "WITH-INTERRUPTS" "WITH-REPLY-PORT" "WITHOUT-GCING"
             "WITHOUT-HEMLOCK" "WITHOUT-INTERRUPTS" "WORDS"
	     "OS-INIT" "ALLOCATE-SYSTEM-MEMORY-AT"
	     "ALTERNATE-GET-GLOBAL-ADDRESS"))
(dolist
    (name
     '("*" "ARRAY" "BOOLEAN" "DOUBLE-FLOAT" "FUNCTION" "INTEGER" "LONG-FLOAT"
       "SINGLE-FLOAT" "UNION" "VALUES"))
  (intern name "LISP"))
(defpackage "ALIEN"
            (:import-from "LISP" "*" "ARRAY" "DOUBLE-FLOAT" "FUNCTION"
             "BOOLEAN" "INTEGER" "LONG-FLOAT" "SINGLE-FLOAT" "UNION" "VALUES")
            (:export "*" "ADDR" "ALIEN" "ALIEN-FUNCALL" "ALIEN-SAP"
             "ALIEN-SIZE" "ARRAY" "BOOLEAN" "CAST" "DEF-ALIEN-ROUTINE"
             "DEF-ALIEN-TYPE" "DEF-ALIEN-VARIABLE" "DEF-BUILTIN-ALIEN-TYPE"
             "DEREF" "DOUBLE-FLOAT" "ENUM" "EXTERN-ALIEN" "FUNCTION" "INTEGER"
             "LONG-FLOAT" "SAP-ALIEN" "SIGNED" "SINGLE-FLOAT" "SLOT" "STRUCT"
	     "UNION" "UNSIGNED" "VALUES" "WITH-ALIEN" "FREE-ALIEN" "NULL-ALIEN"
	     "MAKE-ALIEN" "LOAD-FOREIGN" "SYSTEM-AREA-POINTER"))

(dolist
    (name
     '("%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
       "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
       "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
       "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
       "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
       "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
       "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
       "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
       "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
       "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
       "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
       "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
       "ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
       "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P" "ALIEN-POINTER-TYPE-TO"
       "ALIEN-RECORD-FIELD" "ALIEN-RECORD-FIELD-NAME"
       "ALIEN-RECORD-FIELD-OFFSET" "ALIEN-RECORD-FIELD-P"
       "ALIEN-RECORD-FIELD-TYPE" "ALIEN-RECORD-TYPE"
       "ALIEN-RECORD-TYPE-FIELDS" "ALIEN-RECORD-TYPE-P"
       "ALIEN-SINGLE-FLOAT-TYPE" "ALIEN-SINGLE-FLOAT-TYPE-P"
       "ALIEN-SUBTYPE-P" "ALIEN-TYPE" "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT"
       "ALIEN-TYPE-BITS" "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE"
       "ALIEN-VALUE-TYPE" "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
       "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
       "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
       "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
       "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
       "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
       "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
       "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
       "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
       "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
       "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
       "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
       "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
       "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))
  (intern name "ALIEN"))
(defpackage "ALIEN-INTERNALS"
            (:import-from "ALIEN" "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN"
             "%HEAP-ALIEN-ADDR" "%LOCAL-ALIEN-ADDR"
             "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN" "%SET-DEREF"
             "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT" "%SLOT-ADDR"
             "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
             "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
             "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
             "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
             "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
             "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
             "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
             "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
             "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
             "ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
             "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
             "ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
             "ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
             "ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
             "ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
             "ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
             "ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
             "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
             "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
             "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
             "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
             "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
             "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
             "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
             "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
             "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
             "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
             "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
             "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
             "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
             "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
             "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
             "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE")
            (:export "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
             "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
             "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
             "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
             "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
             "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
             "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
             "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
             "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
             "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
             "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
             "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
             "ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
             "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
             "ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
             "ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
             "ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
             "ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
             "ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
             "ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
             "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
             "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
             "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
             "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
             "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
             "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
             "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
             "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
             "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
             "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
             "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
             "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
             "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
             "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
             "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
             "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))
(defpackage "PROFILE"
            (:export
	     "*DEFAULT-REPORT-TIME-PRINTFUNCTION*" "*INSERT-SPACEREPORTS*"
	     "*TIMED-FUNCTIONS*" "DELETE-SPACEREPORTS" "PRINT-SPACEREPORTS"
	     "PROFILE" "PROFILE-ALL" "REPORT-TIME" "REPORT-TIME-CUSTOM"
	     "RESET-SPACEREPORTS" "RESET-TIME" "UNPROFILE" "WITH-SPACEREPORT"
	     "*NO-CALLS-LIMIT*" "*NO-CALLS*"))
(dolist
    (name
     '("ARRAY-RANK" "ARRAY-TOTAL-SIZE" "BOOLEAN" "CHAR-INT" "FLOAT-DIGITS"
       "FLOAT-RADIX" "PATHNAME-DEVICE" "PATHNAME-DIRECTORY" "PATHNAME-HOST"
       "PATHNAME-NAME" "PATHNAME-TYPE" "PATHNAME-VERSION"))
  (intern name "LISP"))
(intern "VOID" "C-CALL")
(defpackage "KERNEL"
  (:import-from "LISP" "BOOLEAN")
  (:import-from "C-CALL" "VOID")
  (:export "*ANSI-DEFSTRUCT-OPTIONS-P*"
	   "%ACOS" "%ACOSH" "%ARRAY-AVAILABLE-ELEMENTS"
	   "%ARRAY-DATA-VECTOR" "%ARRAY-DIMENSION" "%ARRAY-DISPLACED-P"
	   "%ARRAY-DISPLACEMENT" "%ARRAY-FILL-POINTER"
	   "%ARRAY-FILL-POINTER-P" "%ASIN" "%ASINH" "%ATAN" "%ATAN2" "%ATANH"
	   "%CALLER-FRAME-AND-PC" "%CHECK-BOUND" "%CLOSURE-FUNCTION"
	   "%CLOSURE-INDEX-REF" "%COS" "%COS-QUICK" "%COSH" "%DEPOSIT-FIELD"
	   "%DOUBLE-FLOAT" "%DPB" "%EXP" "%EXPM1" "%HYPOT" "%LDB"
	   "%LOG" "%LOGB" "%LOG10" "%LOG1P" "%LONG-FLOAT"
	   "%MAKE-COMPLEX" "%MAKE-FUNCALLABLE-INSTANCE" "%MAKE-RATIO"
	   "%MASK-FIELD" "%NEGATE" "%POW"
	   "%RAW-BITS" "%RAW-REF-COMPLEX-DOUBLE" "%RAW-REF-COMPLEX-LONG"
	   "%RAW-REF-COMPLEX-SINGLE" "%RAW-REF-DOUBLE" "%RAW-REF-LONG"
	   "%RAW-REF-SINGLE" "%RAW-SET-COMPLEX-DOUBLE"
	   "%RAW-SET-COMPLEX-LONG" "%RAW-SET-COMPLEX-SINGLE"
	   "%RAW-SET-DOUBLE" "%RAW-SET-LONG" "%RAW-SET-SINGLE"
	   "%SCALB" "%SCALBN" "%SET-FUNCALLABLE-INSTANCE-FUNCTION"
	   "%SET-FUNCALLABLE-INSTANCE-INFO" "%SET-RAW-BITS"
	   "%SET-SAP-REF-16" "%SET-SAP-REF-32" "%SET-SAP-REF-64"
	   "%SET-SAP-REF-8" "%SET-SAP-REF-DOUBLE" "%SET-SAP-REF-LONG"
	   "%SET-SAP-REF-SAP" "%SET-SAP-REF-SINGLE"
	   "%SET-SIGNED-SAP-REF-16" "%SET-SIGNED-SAP-REF-32"
	   "%SET-SIGNED-SAP-REF-64" "%SET-SIGNED-SAP-REF-8" 
	   "%SET-STACK-REF" "%SIN" "%SIN-QUICK"
	   "%SINGLE-FLOAT" "%SINH" "%SP-SET-DEFINITION" "%SP-SET-PLIST"
	   "%SQRT" "%SXHASH-SIMPLE-STRING" "%SXHASH-SIMPLE-SUBSTRING" "%TAN"
	   "%TAN-QUICK"
	   "%TANH" "%UNARY-ROUND" "%UNARY-TRUNCATE" "%UNARY-FTRUNCATE"
	   "%UNARY-FTRUNCATE/SINGLE-FLOAT" "%UNARY-FTRUNCATE/DOUBLE-FLOAT"
	   "%WITH-ARRAY-DATA"
	   "*CURRENT-LEVEL*" "*EMPTY-TYPE*" "*EVAL-STACK-TOP*" "*NULL-TYPE*"
	   "*PRETTY-PRINTER*" "*UNIVERSAL-TYPE*"
	   "*UNPARSE-FUNCTION-TYPE-SIMPLIFY*" "*WILD-TYPE*"
	   "32BIT-LOGICAL-AND" "32BIT-LOGICAL-ANDC1" "32BIT-LOGICAL-ANDC2"
	   "32BIT-LOGICAL-EQV" "32BIT-LOGICAL-NAND" "32BIT-LOGICAL-NOR"
	   "32BIT-LOGICAL-NOT" "32BIT-LOGICAL-OR" "32BIT-LOGICAL-ORC1"
	   "32BIT-LOGICAL-ORC2" "32BIT-LOGICAL-XOR" "ALIEN-TYPE-TYPE"
	   "ALIEN-TYPE-TYPE-ALIEN-TYPE" "ALIEN-TYPE-TYPE-P" "ALLOCATE-VECTOR"
	   "ALWAYS-SUBTYPEP" "ARGS-TYPE" "ARGS-TYPE-ALLOWP" "ARGS-TYPE-KEYP"
	   "ARGS-TYPE-KEYWORDS" "ARGS-TYPE-OPTIONAL" "ARGS-TYPE-P"
	   "ARGS-TYPE-REQUIRED" "ARGS-TYPE-REST" "ARRAY-HEADER-P"
	   "ARRAY-RANK" "ARRAY-TOTAL-SIZE" "ARRAY-TYPE" "ARRAY-TYPE-COMPLEXP"
	   "ARRAY-TYPE-DIMENSIONS" "ARRAY-TYPE-ELEMENT-TYPE" "ARRAY-TYPE-P"
	   "ARRAY-TYPE-SPECIALIZED-ELEMENT-TYPE" "ASH-INDEX" "BASE-CHAR-P"
	   "BINDING-STACK-POINTER-SAP" "BIT-BASH-AND" "BIT-BASH-ANDC1"
	   "BIT-BASH-ANDC2" "BIT-BASH-CLEAR" "BIT-BASH-COPY" "BIT-BASH-EQV"
	   "BIT-BASH-IOR" "BIT-BASH-LOGNAND" "BIT-BASH-LOGNOR" "BIT-BASH-NOT"
	   "BIT-BASH-ORC1" "BIT-BASH-ORC2" "BIT-BASH-SET" "BIT-BASH-XOR"
	   "BIT-INDEX" "BOGUS-ARGUMENT-TO-VALUES-LIST-ERROR" "BOOLE-CODE"
	   "BOOLEAN" "BYTE-SPECIFIER" "CALLABLE" "CHAR-INT"
	   "CHECK-FOR-CIRCULARITY" "CODE-COMPONENT" "CODE-COMPONENT-P"
	   "CODE-DEBUG-INFO" "CODE-HEADER-REF" "CODE-HEADER-SET"
	   "CODE-INSTRUCTIONS" "COMPLEX-DOUBLE-FLOAT-P" "COMPLEX-FLOAT-P"
	   "COMPLEX-LONG-FLOAT-P" "COMPLEX-RATIONAL-P" "COMPLEX-SINGLE-FLOAT-P"
	   "CONSED-SEQUENCE" "CONSTANT-TYPE"
	   "CONSTANT-TYPE-P" "CONSTANT-TYPE-TYPE"
	   "CONS-TYPE" "CONS-TYPE-CAR-TYPE" "CONS-TYPE-CDR-TYPE" "CONS-TYPE-P"
	   "CONTAINING-INTEGER-TYPE"
	   "CONTROL-STACK-POINTER-SAP" "COPY-FROM-SYSTEM-AREA"
	   "COPY-NUMERIC-TYPE" "COPY-TO-SYSTEM-AREA" "CSUBTYPEP" "CTYPE"
	   "CTYPE-OF" "CTYPE-P" "CTYPEP" "CURRENT-FP" "CURRENT-SP"
	   "DATA-VECTOR-REF" "DATA-VECTOR-SET" "DECODE-DOUBLE-FLOAT"
	   "DECODE-LONG-FLOAT" "DECODE-SINGLE-FLOAT" "DESCEND-INTO"
	   "DIVISION-BY-ZERO-ERROR"
	   "DOUBLE-FLOAT-EXPONENT" "DOUBLE-FLOAT-HIGH-BITS"
	   "DOUBLE-FLOAT-LOW-BITS" "DOUBLE-FLOAT-P" "FLOAT-WAIT"
	   "DYNAMIC-SPACE-FREE-POINTER" "ERROR-NUMBER-OR-LOSE" "FILENAME"
	   "FLOAT-DIGITS" "FLOAT-EXPONENT" "FLOAT-FORMAT-DIGITS"
	   "FLOAT-FORMAT-MAX" "FLOAT-RADIX" "FORM" "FUNCALLABLE-INSTANCE-P"
	   "FUNCTION-CODE-HEADER" "FUNCTION-TYPE" "FUNCTION-TYPE-ALLOWP"
	   "FUNCTION-TYPE-KEYP" "FUNCTION-TYPE-KEYWORDS"
	   "FUNCTION-TYPE-NARGS" "FUNCTION-TYPE-OPTIONAL" "FUNCTION-TYPE-P"
	   "FUNCTION-TYPE-REQUIRED" "FUNCTION-TYPE-REST"
	   "FUNCTION-TYPE-RETURNS" "FUNCTION-TYPE-WILD-ARGS"
	   "FUNCTION-WORD-OFFSET" "GET-CLOSURE-LENGTH" "GET-HEADER-DATA"
	   "GET-LISP-OBJ-ADDRESS" "GET-LOWTAG" "GET-TYPE" "HAIRY-TYPE"
	   "HAIRY-TYPE-CHECK-TEMPLATE" "HAIRY-TYPE-SPECIFIER"
	   "HANDLE-CIRCULARITY" "INDEX" "INIT-RANDOM-STATE" "INTEGER-DECODE-DOUBLE-FLOAT"
	   "INTEGER-DECODE-LONG-FLOAT" "INTEGER-DECODE-SINGLE-FLOAT"
	   "INTERNAL-TIME"
	   "INVALID-ARGUMENT-COUNT-ERROR" "INVALID-ARRAY-INDEX-ERROR"
	   "INVALID-UNWIND-ERROR" "IRRATIONAL" "KEY-INFO" "KEY-INFO-NAME"
	   "KEY-INFO-P" "KEY-INFO-TYPE"
	   "LAYOUT-INVALID-ERROR" "LEXICAL-ENVIRONMENT"
	   "LONG-FLOAT-EXPONENT" "LONG-FLOAT-EXP-BITS" "LONG-FLOAT-HIGH-BITS"
	   "LONG-FLOAT-LOW-BITS" "LONG-FLOAT-MID-BITS" "LONG-FLOAT-P"
	   "LRA" "LRA-CODE-HEADER" "LRA-P"
	   "MAKE-ALIEN-TYPE-TYPE" "MAKE-ARGS-TYPE"
	   "MAKE-ARRAY-HEADER"  "MAKE-CONS-TYPE"
	   "MAKE-DOUBLE-FLOAT" "MAKE-FUNCTION-TYPE"
	   "MAKE-KEY-INFO" "MAKE-LISP-OBJ" "MAKE-LONG-FLOAT"
	   "MAKE-MEMBER-TYPE"
	   "MAKE-NAMED-TYPE" "MAKE-NUMERIC-TYPE" "MAKE-SINGLE-FLOAT"
	   "%MAKE-INSTANCE" "MAKE-UNION-TYPE"
	   "MAKE-VALUES-TYPE" "MEMBER-TYPE" "MEMBER-TYPE-MEMBERS"
	   "MEMBER-TYPE-P" "MERGE-BITS" "MUTATOR-SELF" "NAMED-TYPE"
	   "NAMED-TYPE-NAME" "NAMED-TYPE-P" "NATIVE-BYTE-ORDER" "NEGATE"
	   "NEVER-SUBTYPEP" "NIL-FUNCTION-RETURNED-ERROR" "NOT-<=-ERROR"
	   "NOT-=-ERROR" "NUMERIC-CONTAGION" "NUMERIC-TYPE"
	   "NUMERIC-TYPE-CLASS" "NUMERIC-TYPE-COMPLEXP" "NUMERIC-TYPE-FORMAT"
	   "NUMERIC-TYPE-HIGH" "NUMERIC-TYPE-LOW" "NUMERIC-TYPE-P"
	   "OBJECT-NOT-ARRAY-ERROR" "OBJECT-NOT-BASE-CHAR-ERROR"
	   "OBJECT-NOT-BIGNUM-ERROR" "OBJECT-NOT-BIT-VECTOR-ERROR"
	   "OBJECT-NOT-COERCABLE-TO-FUNCTION-ERROR"
	   "OBJECT-NOT-COMPLEX-ERROR" "OBJECT-NOT-COMPLEX-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-RATIONAL-ERROR" "OBJECT-NOT-CONS-ERROR"
	   "OBJECT-NOT-DOUBLE-FLOAT-ERROR" "OBJECT-NOT-FIXNUM-ERROR"
	   "OBJECT-NOT-FLOAT-ERROR" "OBJECT-NOT-FUNCTION-ERROR"
	   "OBJECT-NOT-FUNCTION-OR-SYMBOL-ERROR" "OBJECT-NOT-INSTANCE-ERROR"
	   "OBJECT-NOT-INTEGER-ERROR"
	   "OBJECT-NOT-LIST-ERROR" "OBJECT-NOT-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-NUMBER-ERROR"
	   "OBJECT-NOT-RATIO-ERROR" "OBJECT-NOT-RATIONAL-ERROR"
	   "OBJECT-NOT-REAL-ERROR" "OBJECT-NOT-SAP-ERROR"
	   "OBJECT-NOT-SIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-16-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-2-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-4-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-8-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-16-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-30-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-32-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-8-ERROR"
	   "OBJECT-NOT-SIMPLE-BIT-VECTOR-ERROR"
	   "OBJECT-NOT-SIMPLE-STRING-ERROR" "OBJECT-NOT-SIMPLE-VECTOR-ERROR"
	   "OBJECT-NOT-SINGLE-FLOAT-ERROR" "OBJECT-NOT-STRING-ERROR"
	   "OBJECT-NOT-INSTANCE-ERROR" "OBJECT-NOT-SYMBOL-ERROR"
	   "OBJECT-NOT-TYPE-ERROR" "OBJECT-NOT-UNSIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-VECTOR-ERROR" "OBJECT-NOT-WEAK-POINTER-ERROR"
	   "ODD-KEYWORD-ARGUMENTS-ERROR" "ORDER-LAYOUT-INHERITS"
	   "OUTPUT-OBJECT" "OUTPUT-UGLY-OBJECT"
	   "PARSE-LAMBDA-LIST" "PARSE-UNKNOWN-TYPE"
	   "PARSE-UNKNOWN-TYPE-SPECIFIER" "PATHNAME-DEVICE"
	   "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-NAME"
	   "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMELIKE" "PUNT-IF-TOO-LONG"
	   "SCALE-DOUBLE-FLOAT" "SCALE-LONG-FLOAT" "SCALE-SINGLE-FLOAT"
	   "SEQUENCE-END" "SET-HEADER-DATA" "SHIFT-TOWARDS-END"
	   "SHIFT-TOWARDS-START" "SIGNAL-INIT" "SIGNED-BYTE-32-P"
	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-P"
	   "SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-P"
	   "SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-P"
	   "SIMPLE-ARRAY-DOUBLE-FLOAT-P" "SIMPLE-ARRAY-LONG-FLOAT-P"
	   "SIMPLE-ARRAY-P"
	   "SIMPLE-ARRAY-SINGLE-FLOAT-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-P"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-2-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-32-P"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-4-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-8-P"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-16-P" "SIMPLE-ARRAY-SIGNED-BYTE-30-P"
	   "SIMPLE-ARRAY-SIGNED-BYTE-32-P" "SIMPLE-ARRAY-SIGNED-BYTE-8-P" 
	   "SIMPLE-UNBOXED-ARRAY" "SINGLE-FLOAT-BITS" "SINGLE-FLOAT-EXPONENT"
	   "SINGLE-FLOAT-P" "SINGLE-VALUE-TYPE" "SPECIFIER-TYPE" "STACK-REF"
	   "STD-COMPUTE-CLASS-PRECEDENCE-LIST"
	   "STREAMLIKE" "STRINGABLE" "STRINGLIKE"
	   "%INSTANCE-LENGTH"
	   "%INSTANCE-REF" "%INSTANCE-SET"
	   "SYSTEM-AREA-CLEAR"
	   "SYSTEM-AREA-COPY" "TRUTH" "TWO-ARG-*" "TWO-ARG-+" "TWO-ARG--"
	   "TWO-ARG-/" "TWO-ARG-/=" "TWO-ARG-<" "TWO-ARG-<=" "TWO-ARG-="
	   "TWO-ARG->" "TWO-ARG->=" "TWO-ARG-AND" "TWO-ARG-GCD" "TWO-ARG-IOR"
	   "TWO-ARG-LCM" "TWO-ARG-XOR" "TYPE-DIFFERENCE" "TYPE-EXPAND"
	   "TYPE-INIT" "TYPE-INTERSECT" "TYPE-INTERSECTION" "TYPE-SPECIFIER"
	   "TYPE-SPECIFIER-SYMBOLS" "TYPE-UNION" "TYPE/=" "TYPE="
	   "TYPES-INTERSECT" "UNBOUND-SYMBOL-ERROR" "UNBOXED-ARRAY"
	   "UNDEFINED-SYMBOL-ERROR" "UNDEFINED-FOREIGN-SYMBOL-ERROR"
           "UNDEFINED-FOREIGN-SYMBOL-ERROR-HANDLER"
	   "UNION-TYPE" "UNION-TYPE-P"
	   "UNION-TYPE-TYPES" "UNKNOWN-ERROR"
	   "UNKNOWN-KEYWORD-ARGUMENT-ERROR" "UNKNOWN-TYPE" "UNKNOWN-TYPE-P"
	   "UNKNOWN-TYPE-SPECIFIER" "UNSEEN-THROW-TAG-ERROR"
	   "UNSIGNED-BYTE-32-P" "VALUES-SPECIFIER-TYPE"
	   "VALUES-SPECIFIER-TYPE-CACHE-CLEAR" "VALUES-SUBTYPEP"
	   "VALUES-TYPE" "VALUES-TYPE-ALLOWP" "VALUES-TYPE-INTERSECT"
	   "VALUES-TYPE-INTERSECTION" "VALUES-TYPE-KEYP"
	   "VALUES-TYPE-KEYWORDS" "VALUES-TYPE-OPTIONAL" "VALUES-TYPE-P"
	   "VALUES-TYPE-REQUIRED" "VALUES-TYPE-REST" "VALUES-TYPE-UNION"
	   "VALUES-TYPES" "VALUES-TYPES-INTERSECT" "VOID"
	   "WITH-CIRCULARITY-DETECTION" "WRONG-NUMBER-OF-INDICES-ERROR"
	   "FDEFN" "MAKE-FDEFN" "FDEFN-P" "FDEFN-NAME" "FDEFN-FUNCTION"
	   "FDEFN-MAKUNBOUND" "%COERCE-TO-FUNCTION" "FUNCTION-SUBTYPE"
	   "*MAXIMUM-ERROR-DEPTH*" "%SET-SYMBOL-PLIST"
	   "INFINITE-ERROR-PROTECT"
	   "FIND-CALLER-NAME" "OLD-IN-PACKAGE"
	   "%SET-SYMBOL-VALUE" "%SET-SYMBOL-PACKAGE" "OUTPUT-SYMBOL-NAME"
	   "FSET" "RAW-DEFINITION" "%IN-PACKAGE" "%DEFPACKAGE"
	   "INVOKE-MACROEXPAND-HOOK" "TYPEDEF-INIT" "DEFAULT-STRUCTURE-PRINT"
	   "LAYOUT" "LAYOUT-LENGTH" "RATIOP" "FIXNUMP"
	   "LAMBDA-WITH-ENVIRONMENT" "LAYOUT-PURE" "DSD-RAW-TYPE"
	   "%COMPILER-DEFSTRUCT" "DEFSTRUCT-DESCRIPTION" "UNDEFINE-STRUCTURE"
	   "BIGNUMP" "DD-COPIER" "UNDEFINE-FUNCTION-NAME" "DD-TYPE"
	   "CLASS-STATE" "INSTANCE"
	   "*TYPE-SYSTEM-INITIALIZED*" "WEAK-POINTER-P" "FIND-LAYOUT"
	   "DSD-NAME" "%TYPEP" "DD-RAW-INDEX" "DD-NAME" "CLASS-SUBCLASSES"
	   "CLASS-LAYOUT"
	   "DD-RAW-LENGTH" "NOTE-NAME-DEFINED"
	   "%CODE-CODE-SIZE" "DD-SLOTS" "%IMAGPART" "DSD-ACCESSOR" "CLASS-INIT"
	   "%CODE-DEBUG-INFO" "DSD-%NAME" "LAYOUT-CLASS" "LAYOUT-INVALID"
	   "%FUNCTION-NAME" "DSD-TYPE" "%INSTANCEP"
	   "DEFSTRUCT-SLOT-DESCRIPTION"
	   "MAKE-STRUCTURE-LOAD-FORM" "BITP" "%FUNCTION-ARGLIST"
	   "%FUNCTION-NEXT" "LAYOUT-HASH-LENGTH" "DD-PREDICATE"
	   "CLASS-PROPER-NAME" "%NOTE-TYPE-DEFINED" "LAYOUT-INFO"
	   "%SET-INSTANCE-LAYOUT" "DD-DEFAULT-CONSTRUCTOR" "LAYOUT-OF"
	   "%FUNCTION-SELF" "%REALPART" "STRUCTURE-CLASS-P" "DSD-INDEX"
	   "%INSTANCE-LAYOUT" "LAYOUT-HASH" "%FUNCTION-TYPE"
	   "DEFINE-FUNCTION-NAME" "LAYOUT-INHERITANCE-DEPTH"
	   "%%COMPILER-DEFSTRUCT" "%NUMERATOR" "CLASS-TYPEP"
	   "STRUCTURE-CLASS-PRINT-FUNCTION" "DSD-READ-ONLY" "LAYOUT-INHERITS"
	   "DD-LENGTH" "%CODE-ENTRY-POINTS"
	   "STRUCTURE-CLASS-MAKE-LOAD-FORM-FUN" "%DENOMINATOR"
	   "BYTE-FUNCTION-OR-CLOSURE" "MAKE-STANDARD-CLASS"
	   "BYTE-FUNCTION-NAME" "CLASS-CELL-TYPEP" "BYTE-CLOSURE"
	   "FIND-CLASS-CELL" "EXTRACT-FUNCTION-TYPE"
	   "FUNCALLABLE-STRUCTURE-CLASS"
	   "%RANDOM-DOUBLE-FLOAT" "%RANDOM-LONG-FLOAT" "%RANDOM-SINGLE-FLOAT" 
	   "RANDOM-PCL-CLASS" "BASIC-STRUCTURE-CLASS-PRINT-FUNCTION"
	   "%FUNCALLABLE-INSTANCE-INFO" "*EVAL-STACK*" "RANDOM-CHUNK"
	   "MAKE-FUNCALLABLE-STRUCTURE-CLASS" "LAYOUT-HASH-MAX"
	   "CLASS-CELL-NAME" "BUILT-IN-CLASS-DIRECT-SUPERCLASSES"
	   "INITIALIZE-BYTE-COMPILED-FUNCTION" "INITIALIZE-LAYOUT-HASH"
	   "CLASS-PCL-CLASS" "FUNCALLABLE-STRUCTURE"
	   "FUNCALLABLE-INSTANCE-FUNCTION" "%FUNCALLABLE-INSTANCE-LAYOUT"
	   "BASIC-STRUCTURE-CLASS" "BYTE-CLOSURE-DATA"
	   "BYTE-CLOSURE-FUNCTION" "BYTE-FUNCTION" "CLASS-CELL-CLASS"
	   "FUNCALLABLE-STRUCTURE-CLASS-P" "REGISTER-LAYOUT"
	   "FUNCALLABLE-INSTANCE" "RANDOM-FIXNUM-MAX" "MAKE-RANDOM-PCL-CLASS"
	   "INSTANCE-LAMBDA" "%FUNCALLABLE-INSTANCE-LEXENV" "%MAKE-SYMBOL"
	   "%FUNCALLABLE-INSTANCE-FUNCTION" "SYMBOL-HASH"

	   "MAKE-UNDEFINED-CLASS" "%COMPILER-ONLY-DEFSTRUCT"
	   "CLASS-DIRECT-SUPERCLASSES" "MAKE-LAYOUT" "SIMPLE-CONTROL-ERROR"
	   "SIMPLE-FILE-ERROR" "SIMPLE-PROGRAM-ERROR" "SIMPLE-STYLE-WARNING"
	   "SIMPLE-UNDEFINED-FUNCTION" "SIMPLE-PARSE-ERROR"
	   "BYTE-FUNCTION-TYPE" "SLOT-CLASS-PRINT-FUNCTION"
	   "REDEFINE-LAYOUT-WARNING" "SLOT-CLASS" "INSURED-FIND-CLASS"
	   "CONDITION-FUNCTION-NAME")
  #+X86
  (:export "ATOMIC-PUSH-VECTOR" "RPLACD-CONDITIONAL"
           "ATOMIC-PUSH-SYMBOL-VALUE"
           "DATA-VECTOR-SET-CONDITIONAL"
           "RPLACA-CONDITIONAL"
           "%INSTANCE-SET-CONDITIONAL"
           "SET-SYMBOL-VALUE-CONDITIONAL"
           "ATOMIC-POP-SYMBOL-VALUE"
           "ATOMIC-PUSHA"
           "ATOMIC-PUSHD"))

(dolist
    (name
     '("BRANCH" "FLUSHABLE" "SSET-ELEMENT" "SSET" "MAKE-SSET"
       "DO-ELEMENTS" "SSET-ADJOIN" "SSET-DELETE" "SSET-EMPTY"))
  (intern name "C"))

(defpackage "NEW-ASSEM"
  (:import-from "C" "BRANCH" "FLUSHABLE" "SSET-ELEMENT" "SSET" "MAKE-SSET"
		"DO-ELEMENTS" "SSET-ADJOIN" "SSET-DELETE" "SSET-EMPTY")
  (:export "EMIT-BYTE" "EMIT-SKIP" "EMIT-BACK-PATCH" "EMIT-CHOOSER"
	   "DEFINE-EMITTER" "DEFINE-INSTRUCTION" "DEFINE-INSTRUCTION-MACRO"
	   "DEF-ASSEMBLER-PARAMS" "EMIT-POSTIT"

	   "MAKE-SEGMENT" "SEGMENT-NAME" "ASSEMBLE" "ALIGN" "INST"
	   "LABEL" "LABEL-P" "GEN-LABEL" "EMIT-LABEL" "LABEL-POSITION"
	   "APPEND-SEGMENT" "FINALIZE-SEGMENT"
	   "SEGMENT-MAP-OUTPUT" "RELEASE-SEGMENT"
	   "READS" "WRITES" "SEGMENT"
	   "WITHOUT-SCHEDULING" "BRANCH" "FLUSHABLE" "VARIABLE-LENGTH"
	   "SEGMENT-COLLECT-DYNAMIC-STATISTICS"))

(defpackage "MULTIPROCESSING"
  (:use "COMMON-LISP")
  (:nicknames "MP")
  (:export "*ALL-PROCESSES*" "*CURRENT-PROCESS*" "*CURRENT-STACK-GROUP*"
	   "*INITIAL-STACK-GROUP*" "*MULTI-PROCESSING*"
	   "ALL-PROCESSES" "ATOMIC-DECF" "ATOMIC-INCF" "ATOMIC-POP"
	   "ATOMIC-PUSH" "CURRENT-PROCESS" "DESTROY-PROCESS" "DISABLE-PROCESS"
	   "ENABLE-PROCESS" "INIT-STACK-GROUPS" "LOCK" "MAKE-STACK-GROUP"
	   "MAKE-LOCK" "MAKE-PROCESS" "PROCESS-ACTIVE-P"
	   "PROCESS-ADD-ARREST-REASON" "PROCESS-ADD-RUN-REASON"
	   "PROCESS-ALIVE-P" "PROCESS-ARREST-REASONS"
	   "PROCESS-IDLE-TIME" "PROCESS-INTERRUPT" "PROCESS-NAME"
	   "PROCESS-PRESET" "PROCESS-PROPERTY-LIST"
	   "PROCESS-REAL-TIME" "PROCESS-REVOKE-ARREST-REASON"
	   "PROCESS-REVOKE-RUN-REASON" "PROCESS-RUN-REASONS" "PROCESS-RUN-TIME"
	   "PROCESS-STATE" "PROCESS-WAIT-UNTIL-FD-USABLE"
	   "PROCESS-WAIT" "PROCESS-WAIT-WITH-TIMEOUT" 
	   "PROCESS-WHOSTATE" "PROCESS-YIELD" "PROCESSP" "RESTART-PROCESS" 
	   "SHOW-PROCESSES" "STACK-GROUP-RESUME" "WITHOUT-SCHEDULING"
	   "WITH-LOCK-HELD" "WITH-TIMEOUT"))
