/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */
#ifndef _CTK_RADIO_MENU_ITEM_H_
#define _CTK_RADIO_MENU_ITEM_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define CTK_TYPE_RADIO_MENU_ITEM             (ctk_radio_menu_item_get_type ())
#define CTK_RADIO_MENU_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CTK_TYPE_RADIO_MENU_ITEM, CtkRadioMenuItem))
#define CTK_RADIO_MENU_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CTK_TYPE_RADIO_MENU_ITEM, CtkRadioMenuItemClass))
#define CTK_IS_RADIO_MENU_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CTK_TYPE_RADIO_MENU_ITEM))
#define CTK_IS_RADIO_MENU_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CTK_TYPE_RADIO_MENU_ITEM))
#define CTK_RADIO_MENU_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CTK_TYPE_RADIO_MENU_ITEM, CtkRadioMenuItemClass))

typedef struct _CtkRadioMenuItemClass CtkRadioMenuItemClass;
typedef struct _CtkRadioMenuItem CtkRadioMenuItem;
typedef struct _CtkRadioMenuItemPrivate CtkRadioMenuItemPrivate;

struct _CtkRadioMenuItemClass
{
  CtkMenuItemClass parent_class;

  /* Signals */
  void(* group_changed) (CtkRadioMenuItem *self);
};

struct _CtkRadioMenuItem
{
  CtkMenuItem parent_instance;
  CtkRadioMenuItemPrivate *priv;
  GSList *GSEAL (group);
};

CtkRadioMenuItem *ctk_radio_menu_item_new             (GSList *group);
CtkRadioMenuItem *ctk_radio_menu_item_new_with_label  (GSList *group, const gchar *label);

GType ctk_radio_menu_item_get_type (void) G_GNUC_CONST;
void ctk_radio_menu_item_set_group (CtkRadioMenuItem *menuitem, GSList *group);
GSList* ctk_radio_menu_item_get_group (CtkRadioMenuItem *menuitem);

G_END_DECLS

#endif /* _CTK_RADIO_MENU_ITEM_H_ */
